/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.guilogin.web.controller;

import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.ResourceListenerManager;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.shr.base.syssetting.core.WebComponentController;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/i18n"})
public class I18nController
extends WebComponentController {
    @RequestMapping(params={"method=geti18n"})
    public String getResource(HttpServletRequest request, HttpServletResponse response) throws SHRWebException {
        String sFileName = this.buildeParam(request);
        this.writeResponse(response, this.getResContent(sFileName, WebContextUtil.getEasContext((HttpServletRequest)request).getLocale()).toString());
        return null;
    }

    private void writeResponse(HttpServletResponse response, String result) {
        try {
            response.setContentType("text/html");
            response.getOutputStream().write(result.toString().getBytes("utf-8"));
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
    }

    private String buildeParam(HttpServletRequest request) {
        String sFileName = "";
        String res = request.getParameter("r");
        String[] resArray = null;
        if (res != null) {
            resArray = res.split(",");
        }
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String locate = "l2";
        if (ctx != null && ctx.getLocale() != null) {
            locate = ctx.getLocale().toString();
        }
        if ("l2".equals(locate)) {
            locate = "zh_CN";
        }
        if ("l3".equals(locate)) {
            locate = "zh_TW";
        }
        if (resArray != null) {
            sFileName = locate.equals("zh_CN") || locate.equals("zh_TW") ? "/" + resArray[0] + "_" + locate + ".properties" : "/" + resArray[0] + ".properties";
        }
        return sFileName;
    }

    private StringBuilder getResContentFromEAS(Locale locale, String sFileName) {
        try {
            StringBuilder resContent = new StringBuilder();
            String packageAndName = sFileName.substring(0, sFileName.length() - sFileName.lastIndexOf("/"));
            packageAndName = packageAndName.replaceAll("/", "\\\\");
            int index = packageAndName.lastIndexOf("\\");
            Map map = ResourceListenerManager.getRemoteWebResource((String)packageAndName.substring(0, index), (String)packageAndName.substring(index + 1), (Locale)locale);
            if (map != null && map.size() > 0) {
                for (String key : map.keySet()) {
                    String value = (String)map.get(key);
                    resContent.append(key + "=" + value).append("\n");
                }
                return resContent;
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder getResContent(String sFileName, Locale locale) {
        StringBuilder resContent = new StringBuilder();
        BufferedReader bufferedReader = null;
        try {
            StringBuilder res = this.getResContentFromEAS(locale, sFileName);
            if (res != null) {
                StringBuilder stringBuilder = res;
                return stringBuilder;
            }
            this.logger.error((Object)"cannot load resource from eas ");
            bufferedReader = new BufferedReader(new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(sFileName)));
            String line = null;
            while ((line = bufferedReader.readLine()) != null) {
                resContent.append(line).append("\n");
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)ex);
        }
        finally {
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (Exception exception) {}
        }
        return resContent;
    }
}

