/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.lightapp.filter;

import com.kingdee.bos.Context;
import com.kingdee.bos.GeniusBOSFactory;
import com.kingdee.shr.base.syssetting.app.osf.OSFWebUtil;
import com.kingdee.shr.base.syssetting.exception.SHRWebException;
import com.kingdee.shr.base.syssetting.util.SHRCheck;
import com.kingdee.shr.base.syssetting.web.json.JSONUtils;
import com.kingdee.shr.base.syssetting.web.util.SHRInterfaceLoginUtil;
import com.kingdee.shr.lightapp.util.McloudParamsUtil;
import com.kingdee.shr.lightapp.util.StringUtil;
import com.kingdee.shr.lightapp.wx.WXUtil;
import com.kingdee.shr.lightapp.xt.LightAppServiceFacade;
import com.kingdee.shr.lightapp.xt.XTServiceConfig;
import com.kingdee.shr.lightapp.xt.dto.XtParamsDTO;
import com.kingdee.shr.osf.SHROSFUtil;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class LightAppLoginFilter
implements Filter {
    private static final Logger logger = Logger.getLogger(LightAppLoginFilter.class);
    private XtParamsDTO xtparamsDto = null;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String eid = request.getParameter("eid");
        String openid = request.getParameter("openid");
        Context ctx = null;
        HttpSession session = httpRequest.getSession();
        String servletPath = httpRequest.getServletPath();
        if (this.isNotNull(eid) && this.isNotNull(openid)) {
            logger.info((Object)"enter from XT  for shr!");
            String ticket = request.getParameter("ticket");
            String appId = request.getParameter("appid");
            try {
                ctx = this.loginEASByXT(httpRequest, eid, openid);
                if (ctx == null) {
                    HttpServletResponse res = (HttpServletResponse)response;
                    res.sendRedirect(SHRCheck.checkUrlParamsForSendRedirect((String)("/lightapp/loginerr.jsp?appid=" + appId + "&ticket=" + ticket + "&eid=" + eid + "&openid=" + openid)));
                }
            }
            catch (Exception e) {
                logger.error((Object)"login from xt  error: ", (Throwable)e);
            }
        } else if ("/shr/msf/service.do".equals(servletPath)) {
            if (session != null && session.getAttribute("XTContext") != null) {
                ctx = (Context)session.getAttribute("XTContext");
                String serviceName = request.getParameter("serviceName");
                Map param = request.getParameterMap();
                HashMap cleanMap = new HashMap();
                for (Map.Entry entry : param.entrySet()) {
                    cleanMap.put(entry.getKey(), request.getParameter((String)entry.getKey()));
                }
                HashMap<String, Object> envContext = new HashMap<String, Object>();
                envContext.put("BOSCTX", ctx);
                envContext.put("URL", GeniusBOSFactory.getCurrentServiceEnv().get("URL"));
                GeniusBOSFactory.setEnvContext(envContext);
                Object result = SHROSFUtil.processOSF(httpRequest, (HttpServletResponse)response, serviceName, JSONUtils.convertObjectToJson((Context)ctx, cleanMap));
                try {
                    JSONUtils.writeJson((Context)ctx, (HttpServletResponse)((HttpServletResponse)response), (Object)result);
                }
                catch (SHRWebException e) {
                    logger.error((Object)"JSONUtils.writeJson  error: ", (Throwable)e);
                }
                return;
            }
        } else if ("/serverce/executeOSF".equals(servletPath)) {
            try {
                SHRInterfaceLoginUtil.login((HttpServletRequest)httpRequest, (HttpServletResponse)((HttpServletResponse)response));
                OSFWebUtil.callOSFService((HttpServletRequest)httpRequest, (HttpServletResponse)((HttpServletResponse)response));
            }
            catch (SHRWebException e) {
                logger.error((Object)"JSONUtils.writeJson  error: ", (Throwable)e);
            }
            return;
        }
        chain.doFilter(request, response);
    }

    private boolean needLoginEas(HttpSession session) {
        long oldDate;
        long nowDate;
        long valideTime;
        boolean need = true;
        if (session.getAttribute("sessionTime") != null && (valideTime = (nowDate = System.currentTimeMillis()) - (oldDate = Long.parseLong(session.getAttribute("sessionTime").toString()))) < 6600000L) {
            need = false;
        }
        if (!need) {
            if (session.getAttribute("XTContext") == null) {
                need = true;
            }
        } else {
            session.setAttribute("XTContext", null);
            session.setAttribute("openId", null);
        }
        return need;
    }

    private boolean isNotNull(String str) {
        boolean bl = true;
        if (str == null || str.length() < 1 || str.equalsIgnoreCase("null")) {
            bl = false;
        }
        return bl;
    }

    private Context loginEAS(HttpServletRequest httpRequest, String appId, String ticket) throws Exception {
        Context ctx = null;
        HttpSession session = httpRequest.getSession();
        this.xtparamsDto = McloudParamsUtil.getInstance().getXtParamsDTO(appId, ticket);
        if (this.xtparamsDto == null || this.xtparamsDto.getEid() == null || this.xtparamsDto.getOpenid() == null) {
            logger.error((Object)"LightAppLoginFilter == loginEAS== get params from mclound error!!!");
            throw new Exception("EAS_LOGIN_CODE_00005");
        }
        ctx = LightAppServiceFacade.loginEAS(httpRequest, this.xtparamsDto);
        session.setAttribute("openid", (Object)this.xtparamsDto.getOpenid());
        session.setAttribute("eid", (Object)this.xtparamsDto.getEid());
        return ctx;
    }

    private Context loginEASByWx(HttpServletRequest httpRequest, String code, String state) throws Exception {
        Context ctx = null;
        HttpSession session = httpRequest.getSession();
        this.xtparamsDto = WXUtil.getXtParamsDTO(session, code, state);
        if (this.xtparamsDto == null || this.xtparamsDto.getEid() == null || this.xtparamsDto.getOpenid() == null) {
            logger.error((Object)"LightAppLoginFilter == loginEAS== get params from wx error!!!");
            throw new Exception("EAS_LOGIN_CODE_00005");
        }
        session.setAttribute("openid", (Object)this.xtparamsDto.getOpenid());
        session.setAttribute("eid", (Object)this.xtparamsDto.getEid());
        ctx = LightAppServiceFacade.loginEAS(httpRequest, this.xtparamsDto);
        session.setAttribute("XTContext", (Object)ctx);
        session.setAttribute("sessionTime", (Object)System.currentTimeMillis());
        return ctx;
    }

    private void buildXtParamsDto4XT(String eid, String openid, String nonce, String timestamp, String opentoken, String pubaccid) {
        this.xtparamsDto = new XtParamsDTO();
        this.xtparamsDto.setEid(eid);
        this.xtparamsDto.setOpenid(openid);
        this.xtparamsDto.setOpentoken(opentoken);
        this.xtparamsDto.setNonce(nonce);
        this.xtparamsDto.setTimestamp(timestamp);
        this.xtparamsDto.setPubaccid(pubaccid);
    }

    private Context loginEASByXT(HttpServletRequest httpRequest, String eid, String openid, String nonce, String timestamp, String opentoken, String pubaccid) throws Exception {
        Context ctx = null;
        this.buildXtParamsDto4XT(eid, openid, nonce, timestamp, opentoken, pubaccid);
        if (LightAppLoginFilter.checkLinkLegal(this.xtparamsDto)) {
            ctx = LightAppServiceFacade.loginEAS(httpRequest, this.xtparamsDto);
        } else {
            logger.error((Object)"LightAppLoginFilter == loginEASByXT== can not match the key!!!");
        }
        return ctx;
    }

    private Context loginEASByXT(HttpServletRequest httpRequest, String appId, String eid, String openid) throws Exception {
        Context ctx = null;
        HttpSession session = httpRequest.getSession();
        this.xtparamsDto = McloudParamsUtil.getInstance().getXtParamsDTOByEid(appId, eid, openid);
        if (this.xtparamsDto == null || this.xtparamsDto.getEid() == null || this.xtparamsDto.getOpenid() == null) {
            logger.error((Object)"LightAppLoginFilter == loginEAS== get params from mclound error!!!");
            throw new Exception("EAS_LOGIN_CODE_00005");
        }
        session.setAttribute("openid", (Object)this.xtparamsDto.getOpenid());
        session.setAttribute("eid", (Object)this.xtparamsDto.getEid());
        ctx = LightAppServiceFacade.loginEAS(httpRequest, this.xtparamsDto);
        return ctx;
    }

    private Context loginEASByXT(HttpServletRequest httpRequest, String eid, String openid) throws Exception {
        Context ctx = null;
        HttpSession session = httpRequest.getSession();
        this.xtparamsDto = new XtParamsDTO();
        this.xtparamsDto.setEid(eid);
        this.xtparamsDto.setOpenid(openid);
        if (this.xtparamsDto == null || this.xtparamsDto.getEid() == null || this.xtparamsDto.getOpenid() == null) {
            logger.error((Object)"LightAppLoginFilter == loginEAS== get params from mclound error!!!");
            throw new Exception("EAS_LOGIN_CODE_00005");
        }
        session.setAttribute("openid", (Object)this.xtparamsDto.getOpenid());
        session.setAttribute("eid", (Object)this.xtparamsDto.getEid());
        ctx = LightAppServiceFacade.loginEAS(httpRequest, this.xtparamsDto);
        return ctx;
    }

    private Context loginSHR(ServletRequest request, ServletResponse response) {
        Context ctx = null;
        ctx = SHRInterfaceLoginUtil.login((HttpServletRequest)((HttpServletRequest)request), (HttpServletResponse)((HttpServletResponse)response));
        return ctx;
    }

    private static boolean checkLinkLegal(XtParamsDTO xtparamsDto) {
        boolean result = false;
        String pubacckey = XTServiceConfig.getInstance().getPubkeyBypubaccid(xtparamsDto.getEid(), xtparamsDto.getPubaccid());
        if (pubacckey == null) {
            logger.error((Object)"checkLinkLegal pubacckey is null");
            return result;
        }
        if (StringUtil.isNotEmpty(xtparamsDto.getEid())) {
            Object[] sourceData = new String[]{xtparamsDto.getEid(), xtparamsDto.getOpenid(), xtparamsDto.getPubaccid(), pubacckey, xtparamsDto.getNonce(), xtparamsDto.getTimestamp()};
            Arrays.sort(sourceData);
            String token = DigestUtils.shaHex((String)StringUtils.join((Object[])sourceData));
            if (xtparamsDto.getOpentoken().equals(token)) {
                result = true;
            }
        }
        return result;
    }

    public void init(FilterConfig fConfig) throws ServletException {
    }

    public void destroy() {
    }
}

