/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.encoding;

import java.io.IOException;
import java.io.Writer;
import org.apache.axis.components.encoding.AbstractXMLEncoder;
import org.apache.axis.i18n.Messages;

class UTF16Encoder
extends AbstractXMLEncoder {
    UTF16Encoder() {
    }

    public String getEncoding() {
        return "UTF-16";
    }

    public void writeEncoded(Writer writer, String xmlString) throws IOException {
        if (xmlString == null) {
            return;
        }
        int length = xmlString.length();
        int i = 0;
        while (i < length) {
            char character = xmlString.charAt(i);
            switch (character) {
                case '&': {
                    writer.write("&amp;");
                    break;
                }
                case '\"': {
                    writer.write("&quot;");
                    break;
                }
                case '<': {
                    writer.write("&lt;");
                    break;
                }
                case '>': {
                    writer.write("&gt;");
                    break;
                }
                case '\n': {
                    writer.write("\n");
                    break;
                }
                case '\r': {
                    writer.write("\r");
                    break;
                }
                case '\t': {
                    writer.write("\t");
                    break;
                }
                default: {
                    if (character < ' ') {
                        throw new IllegalArgumentException(Messages.getMessage("invalidXmlCharacter00", Integer.toHexString(character), xmlString));
                    }
                    if (character > '\uffff') {
                        writer.write(55232 + (character >> 10));
                        writer.write(0xDC00 | character & 0x3FF);
                        break;
                    }
                    writer.write(character);
                }
            }
            ++i;
        }
    }
}

