/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.components.encoding;

import java.io.IOException;
import java.io.Writer;
import org.apache.axis.components.encoding.AbstractXMLEncoder;
import org.apache.axis.i18n.Messages;

class UTF8Encoder
extends AbstractXMLEncoder {
    UTF8Encoder() {
    }

    public String getEncoding() {
        return "UTF-8";
    }

    public void writeEncoded(Writer writer, String xmlString) throws IOException {
        if (xmlString == null) {
            return;
        }
        int length = xmlString.length();
        int i = 0;
        while (i < length) {
            char character = xmlString.charAt(i);
            switch (character) {
                case '&': {
                    writer.write("&amp;");
                    break;
                }
                case '\"': {
                    writer.write("&quot;");
                    break;
                }
                case '<': {
                    writer.write("&lt;");
                    break;
                }
                case '>': {
                    writer.write("&gt;");
                    break;
                }
                case '\n': {
                    writer.write("\n");
                    break;
                }
                case '\r': {
                    writer.write("\r");
                    break;
                }
                case '\t': {
                    writer.write("\t");
                    break;
                }
                default: {
                    if (character < ' ') {
                        throw new IllegalArgumentException(Messages.getMessage("invalidXmlCharacter00", Integer.toHexString(character), xmlString));
                    }
                    if (character > '\u007f') {
                        writer.write("&#x");
                        writer.write(Integer.toHexString(character).toUpperCase());
                        writer.write(";");
                        break;
                    }
                    writer.write(character);
                }
            }
            ++i;
        }
    }
}

