/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.jmx.adaptors.mejb;

import com.apusic.jmx.adaptors.mejb.ListenerRegistrationImpl;
import com.apusic.server.Config;
import java.util.Set;
import javax.ejb.EJBException;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.j2ee.ListenerRegistration;
import javax.management.remote.JMXConnector;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class MEJB
implements SessionBean {
    private MBeanServer server;
    private JMXConnector connector;

    public void setSessionContext(SessionContext sessionContext) {
    }

    public void ejbCreate() {
        try {
            this.server = Config.getMBeanServer();
            InitialContext initialContext = new InitialContext();
            this.connector = (JMXConnector)initialContext.lookup("jmx/rmi/RMIConnector");
        }
        catch (NamingException namingException) {
            throw new EJBException((Exception)namingException);
        }
    }

    public void ejbRemove() {
        try {
            this.connector.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server = null;
        this.connector = null;
    }

    public void ejbActivate() {
    }

    public void ejbPassivate() {
    }

    public String getDefaultDomain() {
        return this.server.getDefaultDomain();
    }

    public Integer getMBeanCount() {
        return this.server.getMBeanCount();
    }

    public boolean isRegistered(ObjectName objectName) {
        return this.server.isRegistered(objectName);
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws IntrospectionException, InstanceNotFoundException, ReflectionException {
        return this.server.getMBeanInfo(objectName);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        return this.server.queryNames(objectName, queryExp);
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        return this.server.getAttribute(objectName, MEJB.capitalize(string));
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        return this.server.getAttributes(objectName, MEJB.capitalize(stringArray));
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        this.server.setAttribute(objectName, MEJB.capitalize(attribute));
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        return this.server.setAttributes(objectName, MEJB.capitalize(attributeList));
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        return this.server.invoke(objectName, string, objectArray, stringArray);
    }

    public ListenerRegistration getListenerRegistry() {
        return new ListenerRegistrationImpl(this.connector);
    }

    private static String capitalize(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        if (Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    private static String[] capitalize(String[] stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = MEJB.capitalize(stringArray[i]);
        }
        return stringArray2;
    }

    private static Attribute capitalize(Attribute attribute) {
        return new Attribute(MEJB.capitalize(attribute.getName()), attribute.getValue());
    }

    private static AttributeList capitalize(AttributeList attributeList) {
        AttributeList attributeList2 = new AttributeList(attributeList.size());
        for (Attribute attribute : attributeList) {
            attributeList2.add(MEJB.capitalize(attribute));
        }
        return attributeList2;
    }
}

