/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.easprogressbar.plaf;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;

public class KingdeeBorders {
    private static EditorBorder editorBorder = null;

    public static Border createBevelBorder(boolean isRaised, Color darkShadow, Color lightShadow) {
        return new BevelBorder(isRaised, darkShadow, lightShadow);
    }

    public static Border createEditorBorder() {
        if (editorBorder == null) {
            editorBorder = new EditorBorder();
        }
        return editorBorder;
    }

    public static class EditorBorder
    extends AbstractBorder
    implements UIResource {
        private static Color defaultColor;
        private static Color focusColor;
        private static Color disableColor;

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color borderColor = defaultColor;
            if (!c.isEnabled()) {
                borderColor = disableColor;
            }
            if (c.hasFocus()) {
                borderColor = focusColor;
            }
            g.setColor(borderColor);
            g.drawLine(0, 0, w - 1, 0);
            g.drawLine(0, 1, 0, h - 1);
            g.drawLine(1, h - 1, w - 1, h - 1);
            g.drawLine(w - 1, 1, w - 1, h - 1);
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(1, 1, 1, 1));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isOpaque(Component c) {
            return true;
        }

        static {
            focusColor = new Color(6063539);
            disableColor = defaultColor = new Color(0xB4B4B4);
        }
    }

    public static class BevelBorder
    extends AbstractBorder
    implements UIResource {
        private Color darkShadow;
        private Color lightShadow;
        private boolean isRaised;

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            g.setColor(this.isRaised ? this.lightShadow : this.darkShadow);
            g.drawLine(x, y, x + w - 1, y);
            g.drawLine(x, y + h - 1, x, y + 1);
            g.setColor(this.isRaised ? this.darkShadow : this.lightShadow);
            g.drawLine(x + 1, y + h - 1, x + w - 1, y + h - 1);
            g.drawLine(x + w - 1, y + h - 1, x + w - 1, y + 1);
        }

        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(1, 1, 1, 1));
        }

        public Insets getBorderInsets(Component c, Insets insets) {
            insets.right = 1;
            insets.bottom = 1;
            insets.left = 1;
            insets.top = 1;
            return insets;
        }

        public boolean isOpaque(Component c) {
            return true;
        }

        public BevelBorder(boolean isRaised, Color darkShadow, Color lightShadow) {
            this.isRaised = isRaised;
            this.darkShadow = darkShadow;
            this.lightShadow = lightShadow;
        }
    }
}

