/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet;

import com.kingdee.bos.autoupdate.JNLPException;
import com.kingdee.bos.autoupdate.cache.CacheException;
import com.kingdee.bos.autoupdate.dl.DownloadException;
import com.kingdee.bos.autoupdate.dl.RSDownloadListener;
import com.kingdee.bos.autoupdate.jnl.ParseException;
import com.kingdee.bos.ctrl.easprogressbar.KDProgressBar;
import com.kingdee.eas.applet.EasClientDownloaderFactory;
import com.kingdee.eas.applet.EasClientDownloaderHttpImpl;
import com.kingdee.eas.applet.EasClientUpdater;
import com.kingdee.eas.applet.IEasClientDownloader;
import com.kingdee.eas.applet.WebLoginGui;
import com.kingdee.eas.applet.resource.ResourceHelper;
import com.kingdee.eas.webutil.ConsoleLogger;
import com.kingdee.eas.webutil.JnlpUtil;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Label;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.JApplet;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import netscape.javascript.JSObject;
import sun.plugin.ClassLoaderInfo;

public class AppletEasClientDownload
extends JApplet {
    private int red = 63;
    private int green = 136;
    private int blue = 189;
    private int red_label = 255;
    private int green_label = 255;
    private int blue_label = 255;
    private int downloadedFileCount = 0;
    private JProgressBar progressBar = null;
    private Label progressLab = null;
    private int fileTotalCount = 100;
    private EasClientUpdater updater = null;
    private URL jnlpURL = null;
    private String DOWNLOAD_PROTOCOL;
    private boolean autoFullUpdate = false;
    private final String UPDATE_PROCFILE = "update.properties";
    private String ondemandjnlp = "";
    private String fulljnlp = "";
    private Thread threadStartDownload = null;
    private boolean stopDownloadFile = false;
    private int onceDownKBytes = 56;
    private int totalTryCount = 3;
    private int downloadMethod = 0;
    private String isSaveDlFile = null;
    private WebLoginGui wlg = null;
    private String guiParam = null;
    private String guiParamSeperator = null;
    public static final String DEFAULTCLIENTHOME = "c:/kingdee/eas/client";
    private String localDirName = null;

    public void init() {
        this.checkClientJreVersion();
        this.clearCache();
        this.wlg = new WebLoginGui();
        try {
            this.setUpdateLogPath();
            this.autoFullUpdate = new Boolean(this.getParameter("autoFullUpdate"));
            this.guiParam = this.getParameter("guiParam");
            this.guiParamSeperator = this.getParameter("guiParamSeperator");
            try {
                this.red = Integer.parseInt(this.getParameter("appletBgcolorRed"));
                this.green = Integer.parseInt(this.getParameter("appletBgcolorGreen"));
                this.blue = Integer.parseInt(this.getParameter("appletBgcolorBlue"));
                this.red_label = Integer.parseInt(this.getParameter("appletlabelcolorRed"));
                this.green_label = Integer.parseInt(this.getParameter("appletlabelcolorGreen"));
                this.blue_label = Integer.parseInt(this.getParameter("appletlabelcolorBlue"));
                this.onceDownKBytes = Integer.parseInt(this.getParameter("onceDownKBytes"));
                this.totalTryCount = Integer.parseInt(this.getParameter("totalTryCount"));
                this.downloadMethod = Integer.parseInt(this.getParameter("downloadMethod"));
                this.isSaveDlFile = this.getParameter("isSaveDlFile");
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            this.ondemandjnlp = this.getParameter("ondemandjnlp");
            this.fulljnlp = this.getParameter("fulljnlp");
            Color clr = new Color(this.red, this.green, this.blue);
            this.setBackground(clr);
            long start = System.currentTimeMillis();
            super.init();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().setBackground(clr);
            Thread threadDetectNewEdition = new Thread(new Runnable(){

                public void run() {
                    AppletEasClientDownload.this.updatePluginParams();
                    AppletEasClientDownload.this.preUpdate();
                    AppletEasClientDownload.this.checkDownloadFiles();
                }
            });
            threadDetectNewEdition.start();
            this.threadStartDownload = new Thread(new Runnable(){

                public void run() {
                    if (!AppletEasClientDownload.this.isStopDownloadFile()) {
                        AppletEasClientDownload.this.downloadFiles();
                    }
                }
            });
            ConsoleLogger.info("applet init, used time[" + (System.currentTimeMillis() - start) + " ms ]");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.handleException("APPLET_INIT_FAILS", e);
        }
    }

    private void checkClientJreVersion() {
        int result;
        String version = System.getProperty("java.version");
        ConsoleLogger.info("Current jre version:" + version);
        if (!version.equals("1.4.2_11") && !version.equals("1.5.0_09") && (result = JOptionPane.showConfirmDialog(this, ResourceHelper.getString("CurrentVersion") + version + ResourceHelper.getString("JREVersionError") + "\n" + ResourceHelper.getString("SelectYESResult") + "\n" + ResourceHelper.getString("SelectNoResult") + "\n" + ResourceHelper.getString("UnloadJre") + "\n" + ResourceHelper.getString("loadJre"), "", 0)) == 1) {
            try {
                JSObject win = JSObject.getWindow((Applet)this);
                win.eval("top.window.opener=null;top.window.close();");
            }
            catch (Exception e) {
                e.printStackTrace();
                ConsoleLogger.info(e.toString());
            }
        }
    }

    private String getJnlpUrl() {
        String jnlpUrl = this.getParameter("jnlpURL");
        return jnlpUrl;
    }

    private void setUpdateLogPath() {
        String easClientHome = this.getEasClientHome();
        String updateLogPath = easClientHome + "/logs";
        File file = new File(updateLogPath);
        if (!file.exists()) {
            file.mkdir();
        }
        System.setProperty("KDUpdater.config", updateLogPath);
    }

    private String getEasClientHome() {
        Preferences pref = Preferences.systemRoot().node("kingdee/eas");
        String requestHost = this.getParameter("requestHost");
        String easClientHome = null;
        if (requestHost != null && !"".equals(requestHost)) {
            easClientHome = pref.get(requestHost + "_easclienthome", null);
        }
        if (requestHost == null || "".equals(requestHost)) {
            easClientHome = pref.get("easclienthome", null);
        }
        ConsoleLogger.info("Eas client home : " + easClientHome);
        if (easClientHome == null || easClientHome.trim().length() == 0) {
            easClientHome = DEFAULTCLIENTHOME;
            pref.put("easclienthome", DEFAULTCLIENTHOME);
        }
        return easClientHome;
    }

    private void updatePluginParams() {
        long start = System.currentTimeMillis();
        File deploymentFile = new File(System.getProperty("user.home") + "\\" + "Application Data\\Sun\\Java\\Deployment\\deployment.properties");
        if (deploymentFile.exists()) {
            try {
                FileInputStream is = new FileInputStream(deploymentFile);
                Properties prop = new Properties();
                prop.load(is);
                String params = (String)prop.get("javaplugin.jre.params");
                if (params == null || params.indexOf("-Xmx") == -1) {
                    prop.put("javaplugin.jre.params", "-Xms64m -Xmx192m");
                    FileOutputStream os = new FileOutputStream(deploymentFile);
                    prop.store(os, "Kingdee modified");
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        long cost = System.currentTimeMillis() - start;
        ConsoleLogger.info("Update plugin params : " + cost + "ms!");
    }

    private void preUpdate() {
        long start = System.currentTimeMillis();
        String easClientHome = this.getEasClientHome();
        String localUpdateServerUrl = JnlpUtil.getUpdateServer(easClientHome);
        if (localUpdateServerUrl != null) {
            String remoteUpdateServerUrl = this.getJnlpUrl();
            ConsoleLogger.info("Remote update server url : " + remoteUpdateServerUrl);
            ConsoleLogger.info("Local update server url : " + localUpdateServerUrl);
            if (!remoteUpdateServerUrl.startsWith(localUpdateServerUrl)) {
                ConsoleLogger.info("Begin set updater server url!");
                int length = remoteUpdateServerUrl.length() - "eas.jnlp".length();
                String remoteUpdateServerDirUrl = remoteUpdateServerUrl.substring(0, length);
                JnlpUtil.setUpdateServer(easClientHome, remoteUpdateServerDirUrl);
                ConsoleLogger.info("End set updater server url!");
                String newUrl = JnlpUtil.getUpdateServer(easClientHome);
                ConsoleLogger.info("New client update server url : " + newUrl);
            }
        }
        this.localDirName = easClientHome;
        long cost = System.currentTimeMillis() - start;
        ConsoleLogger.info("Pre update : " + cost + "ms!");
    }

    private void checkDownloadFiles() {
        long start = System.currentTimeMillis();
        try {
            this.jnlpURL = new URL(this.getJnlpUrl());
        }
        catch (MalformedURLException e) {
            this.handleException("INVALID_URL", e);
            e.printStackTrace();
            return;
        }
        if (this.localDirName == null) {
            this.localDirName = this.getParameter("localDir");
        }
        File localDir = new File(this.localDirName);
        if (this.jnlpURL == null || localDir == null) {
            throw new IllegalArgumentException("Please set jnlpURL and localDir!");
        }
        if (!localDir.exists()) {
            localDir.mkdirs();
        }
        if (!localDir.isDirectory()) {
            throw new IllegalArgumentException("The localDir is not a directory!");
        }
        try {
            this.updater = new EasClientUpdater(this.jnlpURL.toString(), this.localDirName, "update.properties", this.ondemandjnlp, this.fulljnlp, this.getDownloadMode(), 0);
        }
        catch (DownloadException e) {
            this.handleException("EAS_JNLP_DOWNLOAD_FAILS", (Exception)((Object)e));
            e.printStackTrace();
            return;
        }
        catch (CacheException e) {
            this.handleException("INVALID_EAS_JNLP", (Exception)((Object)e));
            e.printStackTrace();
            return;
        }
        catch (ParseException e) {
            this.handleException("INVALID_EAS_JNLP", (Exception)((Object)e));
            e.printStackTrace();
            return;
        }
        this.DOWNLOAD_PROTOCOL = this.jnlpURL.getProtocol();
        this.fileTotalCount = this.updater.getUpdateFileCount();
        int resxItemsCount = 0;
        try {
            resxItemsCount = this.updater.getCacheState().getServerCacheEntryInfo().getCacheEntries().size();
        }
        catch (CacheException e) {
            this.handleException("INVALID_EAS_JNLP", (Exception)((Object)e));
            e.printStackTrace();
            return;
        }
        if (this.fileTotalCount > 0) {
            this.progressBar = new KDProgressBar(0, this.fileTotalCount);
            this.progressBar.setValue(0);
            this.progressBar.setStringPainted(true);
            this.progressBar.setString("0/" + this.fileTotalCount);
            this.progressLab = new Label("");
            this.progressLab.setForeground(new Color(this.red_label, this.green_label, this.blue_label));
            this.getContentPane().add((Component)this.progressLab, "North");
            this.getContentPane().add((Component)this.progressBar, "Center");
            this.repaint();
            this.progressBar.setMaximum(this.fileTotalCount);
        }
        if (!this.autoFullUpdate && resxItemsCount == this.fileTotalCount) {
            this.redirectForFullUpdate();
        } else {
            ConsoleLogger.info("check new version, used time[" + (System.currentTimeMillis() - start) + " ms ]");
            if (this.fileTotalCount > 0) {
                Thread threadPrompt = new Thread(new Runnable(){

                    public void run() {
                        AppletEasClientDownload.this.existNewEdition();
                    }
                });
                threadPrompt.start();
                this.downloadFiles();
            } else if (this.updater.isNeedDelete()) {
                ConsoleLogger.info("delete local unused resources:" + this.updater.getDeleteFileCount());
                try {
                    this.updater.update();
                }
                catch (JNLPException e) {
                    this.handleException("EAS_JNLP_SAVE_FAILS", (Exception)((Object)e));
                    e.printStackTrace();
                    return;
                }
                this.redirect(null);
            } else {
                ConsoleLogger.info("Open Url Connection times:" + EasClientDownloaderFactory.getDownloader(this.DOWNLOAD_PROTOCOL).getUrlConnCount());
                this.redirect(null);
            }
        }
    }

    private int getDownloadMode() {
        ClassLoader cl = ClassLoader.getSystemClassLoader();
        int result = 1;
        ConsoleLogger.info("AppletEasClientDownload classLoader :" + cl);
        boolean autoDownload = new Boolean(this.getParameter("autoDownload"));
        if (autoDownload) {
            ConsoleLogger.info("Current download style:onDemand............................");
            result = 2;
        } else {
            ConsoleLogger.info("Current download style:fullDown............................");
        }
        return result;
    }

    private void redirectForFullUpdate() {
        JSObject win = JSObject.getWindow((Applet)this);
        win.eval("confirmFullUpdate()");
    }

    public void startDownFiles() {
        this.threadStartDownload.start();
    }

    private void downloadFiles() {
        long start = System.currentTimeMillis();
        IEasClientDownloader downloader = EasClientDownloaderFactory.getDownloader(this.DOWNLOAD_PROTOCOL);
        if (downloader instanceof EasClientDownloaderHttpImpl) {
            ((EasClientDownloaderHttpImpl)downloader).setDownloadMethod(this.downloadMethod);
            ((EasClientDownloaderHttpImpl)downloader).clearUrlConnCount();
            if (this.downloadMethod == 1) {
                ((EasClientDownloaderHttpImpl)downloader).setOnceDownKBytes(this.onceDownKBytes);
                ((EasClientDownloaderHttpImpl)downloader).setTotalTryCount(this.totalTryCount);
                ((EasClientDownloaderHttpImpl)downloader).setIsSaveDlFile(this.isSaveDlFile);
            }
        }
        downloader.addRSDownloadListener(new RSDownloadListener(){

            public void beginDownload(URL url) {
                ConsoleLogger.info("URL begin downloaded: " + url);
            }

            public void downloadProgress(URL url, long length, long totalRead) {
                String fileName = url.toString();
                int idx = fileName.lastIndexOf("/");
                idx = idx == -1 ? 0 : ++idx;
                fileName = fileName.substring(idx);
                long currPercent = Math.round(new Long(totalRead).doubleValue() / new Long(length).doubleValue() * 100.0);
                if (currPercent > 100L) {
                    currPercent = 100L;
                }
                String txt = "" + fileName + " (" + currPercent + "%) ";
                AppletEasClientDownload.this.progressLab.setText(txt);
            }

            private String toBigUnitValue(long originValue) {
                String newValue = new Long(originValue).toString() + " B";
                double kunit = 1024.0;
                double munit = 1048576.0;
                if ((double)originValue >= munit) {
                    newValue = new Double((double)Math.round(new Long(originValue).doubleValue() / munit * 1000.0) / 1000.0).toString() + " MB";
                } else if ((double)originValue >= kunit) {
                    newValue = new Double((double)Math.round(new Long(originValue).doubleValue() / kunit * 1000.0) / 1000.0).toString() + " KB";
                }
                return newValue;
            }

            public void finishDownload(URL url) {
                AppletEasClientDownload.this.downloadedFileCount++;
                AppletEasClientDownload.this.progressBar.setValue(AppletEasClientDownload.this.downloadedFileCount);
                AppletEasClientDownload.this.progressBar.setString(AppletEasClientDownload.this.downloadedFileCount + "/" + AppletEasClientDownload.this.fileTotalCount);
                ConsoleLogger.info("URL downloaded: " + url + ";downloaded file count:" + AppletEasClientDownload.this.downloadedFileCount);
            }
        });
        try {
            HashMap hashMap = this.updater.update();
            ConsoleLogger.info("download files, used time[" + (System.currentTimeMillis() - start) + " ms ]");
            ConsoleLogger.info("Open Url Connection is " + downloader.getUrlConnCount());
            if (hashMap != null && hashMap.size() > 0) {
                this.redirect(hashMap);
            } else {
                this.redirect(null);
            }
        }
        catch (JNLPException e) {
            this.handleException("EAS_JNLP_SAVE_FAILS", (Exception)((Object)e));
            e.printStackTrace();
            return;
        }
    }

    private void redirect() {
        JSObject win = JSObject.getWindow((Applet)this);
        win.eval("redirect(\"\")");
    }

    private void existNewEdition() {
        JSObject win = JSObject.getWindow((Applet)this);
        win.eval("existNewEdition()");
    }

    void redirect(HashMap hashMap) {
        if (hashMap == null && this.guiParam != null) {
            this.invokeStartupGUI();
            return;
        }
        StringBuffer strErr = new StringBuffer();
        int n = 0;
        if (hashMap != null) {
            n = hashMap.size();
            Iterator i = hashMap.keySet().iterator();
            while (i.hasNext()) {
                strErr.append(i.next()).append("\\n");
            }
        }
        JSObject win = JSObject.getWindow((Applet)this);
        win.eval("redirect(" + n + ",\"" + strErr + "\",\"" + this.localDirName + "\")");
    }

    void handleException(String errMsgKey, Exception e) {
        JSObject win = JSObject.getWindow((Applet)this);
        String errMsg = this.getExcLinkStackTrace(e, "\\r\\n");
        errMsg.replace('\\', '/');
        errMsg.replace('\'', '\"');
        win.eval("handleAppletException(\"" + errMsgKey + "\",'" + errMsg + "')");
    }

    private String getExcLinkStackTrace(Throwable exc, String separator) {
        StringBuffer result = new StringBuffer();
        for (Throwable cause = exc; cause != null; cause = cause.getCause()) {
            result.append(cause.getClass().getName());
            result.append(": ");
            result.append(cause.getMessage());
            result.append(separator);
            StackTraceElement[] stackTraces = cause.getStackTrace();
            for (int i = 0; i < stackTraces.length; ++i) {
                result.append("        at: ");
                result.append(stackTraces[i].toString());
                result.append(separator);
            }
            result.append(separator);
        }
        return result.toString();
    }

    private boolean isStopDownloadFile() {
        return this.stopDownloadFile;
    }

    private void setStopDownloadFile(boolean stopDownloadThread) {
        this.stopDownloadFile = stopDownloadThread;
    }

    public void destroy() {
        super.destroy();
        ConsoleLogger.info("destory:" + this.hashCode());
        this.setStopDownloadFile(true);
        this.downloadedFileCount = 0;
        this.clearCache();
    }

    public void clearCache() {
        ConsoleLogger.info("begin to clear jar and file cache.");
        ClassLoaderInfo.clearClassLoaderCache();
        ConsoleLogger.info("finished clearing jar and file cache.");
    }

    public void invokeStartupGUI() {
        this.wlg.logingui(this.guiParam, this.guiParamSeperator);
        JSObject win = JSObject.getWindow((Applet)this);
        win.eval("closeWin()");
    }
}

