/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet;

import com.kingdee.eas.webutil.ConsoleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;

public class AppletSmartClassLoader
extends ClassLoader {
    protected HashMap classCache = new HashMap(5000);
    protected HashMap resCache = new HashMap(2000);
    protected HashMap packageCache = new HashMap(2000);
    protected HashMap jarFileCache = new HashMap(1000);
    protected boolean debug = false;
    protected HashMap packageToJarMap = new HashMap(3000);
    protected ClassLoaderListener listener = null;
    protected boolean hasCheckClassPath = false;
    protected boolean firstCall = true;
    protected ClassLoader currentClassLoader = null;

    public AppletSmartClassLoader(ClassLoader loader) {
        super(loader);
    }

    public void setClassLoaderListener(ClassLoaderListener cll) {
        if (this.listener != null) {
            return;
        }
        this.listener = cll;
        ConsoleLogger.info("[CL_INFO]  AppletSmartClassLoader Listener register successful!");
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.loadClass(className, false);
    }

    public URL getResource(String name) {
        if (name == null) {
            return null;
        }
        URL url = (URL)this.resCache.get(name);
        if (url == null && this.listener != null) {
            if (this.firstCall) {
                this.checkFirstCall();
            }
            if ((url = (URL)this.loadFromJarList(null, name)) != null) {
                this.resCache.put(name, url);
            }
        }
        return url;
    }

    public Class loadClass(String className, boolean resolve) throws ClassNotFoundException {
        Class c = null;
        if (className == null) {
            return null;
        }
        c = this.findLoadedClass(className);
        if (c == null && (c = (Class)this.classCache.get(className)) == null) {
            try {
                if (className.indexOf("com.kingdee.eas.applet.") >= 0 && className.indexOf("com.kingdee.eas.applet.framework.") < 0 || className.indexOf("com.kingdee.eas.webutil.") >= 0 || className.indexOf("com.kingdee.bos.autoupdate.") >= 0 || className.indexOf("netscape.") >= 0 || className.indexOf("org.xml.sax.") >= 0 || className.indexOf("com.sun.") >= 0 || className.indexOf("sun.") >= 0 || className.indexOf("java.") >= 0 || className.indexOf("javax.") >= 0) {
                    if (className.indexOf("com.kingdee.") >= 0) {
                        // empty if block
                    }
                    c = this.getParent().loadClass(className);
                }
            }
            catch (ClassNotFoundException cnfex) {
                // empty catch block
            }
            if (c != null) {
                this.classCache.put(className, c);
            } else if (this.listener != null) {
                String clsName;
                if (this.firstCall) {
                    this.checkFirstCall();
                }
                if ((c = (Class)this.loadFromJarList(className, clsName = className.replace('.', '/') + ".class")) != null) {
                    this.classCache.put(className, c);
                }
            }
        }
        if (c != null) {
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }
        throw new ClassNotFoundException("Class[" + className + "] not found in AppletSmartClassLoader!");
    }

    private void checkFirstCall() {
        if (this.firstCall) {
            this.debug = Boolean.getBoolean("SmartClassLoader.debug");
            System.out.println();
            System.out.println("===============================================================");
            System.out.println("        Kingdee EAS Class Loader  AppletSmartClassLoader                   ");
            System.out.println();
            System.out.println("                   Copyright (c) 2007                          ");
            System.out.println("             Kingdee Software (China) Co., Ltd.                ");
            System.out.println("===============================================================");
            System.out.println();
            ConsoleLogger.info("Parent classloader: " + this.getParent());
            try {
                Properties temp = new Properties();
                FileInputStream input = new FileInputStream(this.listener.getLocalPath() + "/classloader/pkmap.lst");
                temp.load(input);
                input.close();
                this.packageToJarMap.putAll(temp);
            }
            catch (Exception e) {
                System.err.println("[CL_ERR]   Check package.lst error[" + e.getMessage() + "]!");
                e.printStackTrace();
            }
            this.firstCall = false;
        }
    }

    protected Object loadFromJarList(String className, String resName) {
        String libList;
        String packageName = resName;
        if (resName.indexOf(47) > 0) {
            packageName = resName.substring(0, resName.lastIndexOf(47));
        }
        if ((libList = (String)this.packageToJarMap.get(packageName)) != null && libList.length() > 0) {
            String[] libs = libList.split(";");
            for (int i = 0; i < libs.length; ++i) {
                try {
                    ZipEntry clsEntry;
                    File jarUrl = (File)this.packageCache.get(libs[i]);
                    if (jarUrl == null) {
                        jarUrl = (File)this.updateResource(libs[i]);
                    }
                    if (jarUrl == null) {
                        System.err.println("[CL_ERR]   Jar file[" + libs[i] + "] not found!");
                        continue;
                    }
                    Serializable res = null;
                    JarFile jarFile = (JarFile)this.jarFileCache.get(libs[i]);
                    if (jarFile == null) {
                        try {
                            jarFile = new JarFile(jarUrl);
                            this.jarFileCache.put(libs[i], jarFile);
                        }
                        catch (ZipException e) {
                            System.err.println("[CL_ERR]   Error in opening zip file[" + libs[i] + "], download again!");
                            if (jarUrl.delete()) {
                                jarUrl = (File)this.updateResource(libs[i]);
                                jarFile = new JarFile(jarUrl);
                            }
                            System.err.println("[CL_ERR]   Error in delete zip file[" + libs[i] + "]!");
                            throw new RuntimeException("Class can load from jarfile[" + libs[i] + "], is not a jar file!", e);
                        }
                    }
                    if ((clsEntry = jarFile.getEntry(resName)) == null) continue;
                    if (className != null) {
                        InputStream clsInputStream = jarFile.getInputStream(clsEntry);
                        byte[] resBytes = this.readBytesFromInputStream(clsInputStream);
                        clsInputStream.close();
                        try {
                            this.definePackage(className, jarFile.getManifest());
                            res = this.defineClass(className, resBytes, 0, resBytes.length);
                        }
                        catch (ClassFormatError e) {
                            e.printStackTrace();
                            System.err.println("[CL_ERR]   Error in define class[" + className + "] from jar[" + libs[i] + "]!");
                        }
                    } else {
                        res = new URL("jar:file:" + jarUrl.getCanonicalPath() + "!/" + resName);
                    }
                    return res;
                }
                catch (Throwable e) {
                    System.err.println("[CL_ERR]   Load resource[" + resName + "] from jars error[" + e.getMessage() + "]!");
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    protected Object loadFromClassesDir(String className, String resName) {
        resName = "/classes/" + resName;
        try {
            Object resResult = this.updateResource(resName);
            Serializable res = null;
            if (className != null) {
                byte[] resBytes = (byte[])resResult;
                if (resBytes != null) {
                    this.definePackage(className, null);
                    res = this.defineClass(className, resBytes, 0, resBytes.length);
                }
            } else {
                res = (URL)resResult;
            }
            return res;
        }
        catch (Throwable e) {
            System.err.println("[CL_ERR]   Load resource[" + resName + "] from classes directory error[" + e.getMessage() + "]!");
            e.printStackTrace();
            return null;
        }
    }

    protected Object updateResource(String resRelativePath) {
        File localRes = new File(this.listener.getLocalPath() + resRelativePath);
        try {
            boolean needUpdate = this.listener.updateResource(resRelativePath);
            if (needUpdate) {
                Object res = null;
                if (resRelativePath.toLowerCase().endsWith(".class")) {
                    res = this.loadLocalResource(localRes);
                } else if (resRelativePath.toLowerCase().endsWith(".jar") || resRelativePath.toLowerCase().endsWith(".zip")) {
                    res = localRes;
                    this.packageCache.put(resRelativePath, res);
                } else {
                    res = localRes.toURL();
                }
                return res;
            }
            if (localRes.exists()) {
                Object res = null;
                if (resRelativePath.endsWith(".class")) {
                    FileInputStream input = new FileInputStream(localRes);
                    byte[] clsBytes = this.readBytesFromInputStream(input);
                    input.close();
                    res = clsBytes;
                } else if (resRelativePath.toLowerCase().endsWith(".jar") || resRelativePath.toLowerCase().endsWith(".zip")) {
                    res = localRes;
                    this.packageCache.put(resRelativePath, res);
                } else {
                    res = localRes.toURL();
                }
                return res;
            }
        }
        catch (Throwable e) {
            if (e instanceof ClassCircularityError) {
                System.err.println("[CL_ERR]   java.lang.ClassCircularityError: [" + e.getMessage() + "]!");
            }
            if (e instanceof LinkageError) {
                System.err.println("[CL_ERR]   java.lang.LinkageError: [" + e.getMessage() + "]!");
            }
            System.err.println("[CL_ERR]   Update resource[" + resRelativePath + "]  error[" + e.getMessage() + "]!");
            e.printStackTrace();
        }
        return null;
    }

    private byte[] loadLocalResource(File localRes) {
        try {
            FileInputStream input = new FileInputStream(localRes);
            byte[] resource = this.readBytesFromInputStream(input);
            ((InputStream)input).close();
            return resource;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public byte[] readBytesFromInputStream(InputStream input) throws IOException {
        int j;
        int l = 0;
        byte[] resBytes = new byte[1024];
        while ((j = input.read(resBytes, l, resBytes.length - l)) != -1) {
            if ((l += j) < resBytes.length) continue;
            byte[] abyte1 = new byte[l * 2];
            System.arraycopy(resBytes, 0, abyte1, 0, l);
            resBytes = abyte1;
        }
        if (l != resBytes.length) {
            byte[] abyte2 = new byte[l];
            System.arraycopy(resBytes, 0, abyte2, 0, l);
            resBytes = abyte2;
        }
        return resBytes;
    }

    protected void definePackage(String className, Manifest manifest) {
        int lastDot = className.lastIndexOf(46);
        String pkName = className;
        if (lastDot != -1) {
            pkName = className.substring(0, lastDot);
        }
        if (manifest == null || this.getPackage(pkName) != null) {
            return;
        }
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        Attributes attrs = manifest.getMainAttributes();
        if (attrs != null) {
            specTitle = attrs.getValue(Attributes.Name.SPECIFICATION_TITLE);
            specVersion = attrs.getValue(Attributes.Name.SPECIFICATION_VERSION);
            specVendor = attrs.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            implTitle = attrs.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            implVersion = attrs.getValue(Attributes.Name.SPECIFICATION_VERSION);
            implVendor = attrs.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
        }
        this.definePackage(pkName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
    }

    public ClassLoader getCurrentClassLoader() {
        return this.currentClassLoader;
    }

    public void setCurrentClassLoader(ClassLoader currentClassLoader) {
        this.currentClassLoader = currentClassLoader;
    }

    public static interface ClassLoaderListener {
        public boolean updateResource(String var1);

        public String getRemoteServer();

        public String getLocalPath();

        public HashMap getResourceMap();
    }
}

