/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet;

import com.kingdee.bos.autoupdate.cache.CacheEntryInfo;
import com.kingdee.bos.autoupdate.cache.CacheException;
import com.kingdee.bos.autoupdate.cache.JNLPCacheEntryInfo;
import com.kingdee.bos.autoupdate.jnl.ApplicationInfo;
import com.kingdee.bos.autoupdate.jnl.JARInfo;
import com.kingdee.bos.autoupdate.jnl.JREInfo;
import com.kingdee.bos.autoupdate.jnl.LaunchInfo;
import com.kingdee.bos.autoupdate.jnl.NativeLibInfo;
import com.kingdee.bos.autoupdate.jnl.PropertyInfo;
import com.kingdee.bos.autoupdate.jnl.ResourceCollection;
import com.kingdee.bos.autoupdate.jnl.ResourceInfo;
import com.kingdee.bos.autoupdate.util.URLUtil;
import com.kingdee.bos.autoupdate.xml.INode;
import com.kingdee.bos.autoupdate.xml.NodeFactory;
import com.kingdee.eas.applet.EASCacheEntryInfo;
import com.kingdee.eas.applet.EASJNLPCacheEntryInfo;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import nanoxml.XMLParseException;

public class EASJnlpCacheEntryManager {
    static final /* synthetic */ boolean $assertionsDisabled;

    public static EASJNLPCacheEntryInfo load(File baseDir) throws CacheException {
        return EASJnlpCacheEntryManager.load(baseDir, "eas.jnlp");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static EASJNLPCacheEntryInfo load(File baseDir, String jnlpFileName) throws CacheException {
        EASJNLPCacheEntryInfo eASJNLPCacheEntryInfo;
        File file = new File(baseDir, jnlpFileName);
        if (!file.exists()) {
            return null;
        }
        BufferedInputStream bos = null;
        try {
            try {
                bos = new BufferedInputStream(new FileInputStream(file));
                eASJNLPCacheEntryInfo = EASJnlpCacheEntryManager.innerLoad(bos, jnlpFileName);
                Object var6_7 = null;
            }
            catch (IOException ioe) {
                throw new CacheException((Throwable)ioe);
            }
            catch (XMLParseException pe) {
                throw new CacheException((Throwable)pe);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (bos == null) throw throwable;
                bos.close();
                throw throwable;
            }
            catch (Exception ignore) {
                throw throwable;
            }
        }
        try {}
        catch (Exception ignore) {
            // empty catch block
            return eASJNLPCacheEntryInfo;
        }
        if (bos == null) return eASJNLPCacheEntryInfo;
        bos.close();
        return eASJNLPCacheEntryInfo;
    }

    static EASJNLPCacheEntryInfo innerLoad(InputStream fis) throws CacheException {
        return EASJnlpCacheEntryManager.innerLoad(fis, "eas.jnlp");
    }

    static EASJNLPCacheEntryInfo innerLoad(InputStream fis, String jnlpFileName) throws CacheException {
        try {
            INode root = NodeFactory.build((InputStream)fis);
            if (root == null) {
                throw new CacheException("Invalidate " + jnlpFileName + " file");
            }
            EASJNLPCacheEntryInfo entry = EASJnlpCacheEntryManager.buildJnlpCacheEntry(root);
            EASJnlpCacheEntryManager.buildResources(root, entry);
            return entry;
        }
        catch (IOException ioe) {
            throw new CacheException("Invalidate " + jnlpFileName + " file", (Throwable)ioe);
        }
    }

    private static EASJNLPCacheEntryInfo buildJnlpCacheEntry(INode root) throws CacheException {
        try {
            String codebase = root.getAttribute("codebase");
            String href = root.getAttribute("href");
            String lastModified = root.getAttribute("lastModified");
            String md5Version = root.getAttribute("md5Version");
            if (!($assertionsDisabled || href != null && lastModified != null && codebase != null)) {
                throw new AssertionError();
            }
            URL codebaseURL = URLUtil.getURL(null, (String)codebase);
            return new EASJNLPCacheEntryInfo(codebaseURL, URLUtil.getURL((URL)codebaseURL, (String)href), Long.parseLong(lastModified), md5Version);
        }
        catch (MalformedURLException urle) {
            throw new CacheException("Invalidate url", (Throwable)urle);
        }
        catch (NumberFormatException nfe) {
            throw new CacheException("Invalidate node,no exists attribute lastModified or not a number.", (Throwable)nfe);
        }
    }

    private static void buildResources(INode root, EASJNLPCacheEntryInfo cache) throws CacheException {
        INode[] resources = EASJnlpCacheEntryManager.getChildNodes(root, "resources");
        int len = resources.length;
        for (int i = 0; i < len; ++i) {
            INode[] resource = resources[i].getChildNodes();
            for (int j = 0; j < resource.length; ++j) {
                cache.addCacheEntry(EASJnlpCacheEntryManager.buildResource(resource[j], cache.getCodebase()));
            }
        }
    }

    private static EASCacheEntryInfo buildResource(INode resource, URL codebase) throws CacheException {
        try {
            String href = resource.getAttribute("href");
            String lastModified = resource.getAttribute("lastModified");
            String md5Version = resource.getAttribute("md5Version");
            if (!($assertionsDisabled || href != null && lastModified != null)) {
                throw new AssertionError();
            }
            return new EASCacheEntryInfo(URLUtil.getURL((URL)codebase, (String)href), Long.parseLong(lastModified), md5Version);
        }
        catch (MalformedURLException mle) {
            throw new CacheException((Throwable)mle);
        }
        catch (NumberFormatException nfe) {
            throw new CacheException("Invalidate node,no exists attribute lastModified or not a number.", (Throwable)nfe);
        }
    }

    private static INode[] getChildNodes(INode node, String name) {
        ArrayList<INode> result = new ArrayList<INode>();
        for (INode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(name)) continue;
            result.add(child);
        }
        return result.toArray(new INode[result.size()]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void store(File baseDir, LaunchInfo jnlpLaunchInfo, JNLPCacheEntryInfo cache) throws CacheException {
        INode root = EASJnlpCacheEntryManager.createRootNode(cache);
        EASJnlpCacheEntryManager.addAppNode(root, jnlpLaunchInfo.getAppInfo());
        EASJnlpCacheEntryManager.addInfoNode(root);
        EASJnlpCacheEntryManager.addResourcesNode(root, jnlpLaunchInfo.getResources(), cache);
        OutputStreamWriter writer = null;
        try {
            try {
                String jnlpUrl = jnlpLaunchInfo.getHref().toString();
                String jnlpFileName = jnlpUrl.substring(jnlpUrl.lastIndexOf("/") + 1);
                if (jnlpFileName != null && jnlpFileName.indexOf("?") > 0) {
                    jnlpFileName = jnlpFileName.substring(0, jnlpFileName.indexOf("?"));
                }
                File file = new File(baseDir, jnlpFileName);
                writer = new FileWriter(file);
                writer.write("<?xml version=\"1.0\" encoding=\"utf-8\"?>\r\n");
                root.write((Writer)writer);
                writer.flush();
            }
            catch (IOException ioe) {
                throw new CacheException((Throwable)ioe);
            }
            Object var9_9 = null;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            try {
                if (writer == null) throw throwable;
                writer.close();
                throw throwable;
            }
            catch (Exception ignore) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Exception ignore) {}
        if (writer == null) return;
        writer.close();
        return;
    }

    private static INode createRootNode(JNLPCacheEntryInfo cache) {
        INode root = NodeFactory.createNode((String)"jnlp");
        root.setAttribute("spec", "1.0+");
        root.setAttribute("codebase", cache.getCodebase().toString());
        root.setAttribute("href", URLUtil.getRelativePath((URL)cache.getCodebase(), (URL)cache.getHref()).toString());
        root.setAttribute("lastModified", new Long(cache.lastModified()).toString());
        return root;
    }

    private static void addResourcesNode(INode root, ResourceCollection resources, JNLPCacheEntryInfo cache) {
        INode node = NodeFactory.createNode((String)"resources");
        HashMap resxMap = EASJnlpCacheEntryManager.toMap(resources.getResources());
        Iterator ite = cache.getCacheEntries().iterator();
        URL codeBase = cache.getCodebase();
        CacheEntryInfo entry = null;
        while (ite.hasNext()) {
            entry = (CacheEntryInfo)ite.next();
            EASJnlpCacheEntryManager.addResxNode(node, entry, resxMap, codeBase);
        }
        root.addChild(node);
    }

    private static HashMap toMap(ResourceInfo[] resources) {
        HashMap<String, ResourceInfo> result = new HashMap<String, ResourceInfo>();
        for (int i = 0; i < resources.length; ++i) {
            result.put(resources[i].getHref().toString(), resources[i]);
        }
        return result;
    }

    private static void addResxNode(INode root, CacheEntryInfo entry, HashMap resxMap, URL codeBase) {
        ResourceInfo resx = null;
        String href = entry.getHref().toString();
        if (resxMap.containsKey(href)) {
            resx = (ResourceInfo)resxMap.get(href);
            if (!(resx instanceof JREInfo)) {
                if (resx instanceof JARInfo) {
                    EASJnlpCacheEntryManager.addJarNode(root, entry, (JARInfo)resx, codeBase);
                } else if (resx instanceof NativeLibInfo) {
                    EASJnlpCacheEntryManager.addNativeLibNode(root, entry, (NativeLibInfo)resx, codeBase);
                } else if (resx instanceof PropertyInfo) {
                    // empty if block
                }
            }
        } else {
            System.out.println("remote eas.jnlp is not exists the URL:" + href);
        }
    }

    private static void addPropertyInfoNode(INode root, CacheEntryInfo entry) {
    }

    private static void addNativeLibNode(INode root, CacheEntryInfo entry, NativeLibInfo info, URL codeBase) {
        INode node = NodeFactory.createNode((String)"nativelib");
        node.setAttribute("href", URLUtil.getRelativePath((URL)codeBase, (URL)info.getHref()).toString());
        node.setAttribute("lastModified", new Long(entry.lastModified()).toString());
        root.addChild(node);
    }

    private static void addJarNode(INode root, CacheEntryInfo entry, JARInfo info, URL codeBase) {
        INode jarNode = NodeFactory.createNode((String)"jar");
        jarNode.setAttribute("href", URLUtil.getRelativePath((URL)codeBase, (URL)info.getHref()).toString());
        jarNode.setAttribute("lastModified", new Long(entry.lastModified()).toString());
        root.addChild(jarNode);
    }

    private static void addJreNode(INode root, CacheEntryInfo entry, JREInfo info, URL codeBase) {
        INode jreNode = NodeFactory.createNode((String)"j2se");
        jreNode.setAttribute("href", URLUtil.getRelativePath((URL)codeBase, (URL)info.getHref()).toString());
        jreNode.setAttribute("version", info.getVersion());
        jreNode.setAttribute("initial-heap-size", info.getInitialHeap());
        jreNode.setAttribute("max-heap-size", info.getMaxHeap());
        jreNode.setAttribute("lastModified", new Long(entry.lastModified()).toString());
        root.addChild(jreNode);
    }

    public static void addInfoNode(INode root) {
        INode node = NodeFactory.createNode((String)"information");
        INode titleNode = NodeFactory.createNode((String)"title");
        titleNode.setNodeValue("client-update");
        node.addChild(titleNode);
        INode vendor = NodeFactory.createNode((String)"vendor");
        vendor.setNodeValue("Kingdee");
        node.addChild(vendor);
        INode desc1 = NodeFactory.createNode((String)"description");
        desc1.setNodeValue("Client of EAS");
        node.addChild(desc1);
        INode desc2 = NodeFactory.createNode((String)"description");
        desc2.setAttribute("kind", "short");
        desc2.setNodeValue("EAS");
        node.addChild(desc2);
        INode offline = NodeFactory.createNode((String)"offline-allowed");
        node.addChild(offline);
        root.addChild(node);
    }

    public static void addAppNode(INode root, ApplicationInfo appInfo) {
        if (!$assertionsDisabled && appInfo == null) {
            throw new AssertionError();
        }
        INode appNode = NodeFactory.createNode((String)"application-desc");
        appNode.setAttribute("main-class", appInfo.getMainClass());
        String[] args = appInfo.getArguments();
        INode argsNode = null;
        for (int i = 0; i < args.length; ++i) {
            argsNode = NodeFactory.createNode((String)"argument");
            argsNode.setNodeValue(args[i]);
            appNode.addChild(argsNode);
        }
        root.addChild(appNode);
    }

    public static void main(String[] args) {
        String localDirName = "c:/kingdee/eas/client/";
        File localDir = new File(localDirName);
        EASJNLPCacheEntryInfo jnlpCache = null;
        try {
            jnlpCache = EASJnlpCacheEntryManager.load(localDir);
        }
        catch (CacheException e) {
            e.printStackTrace();
        }
        System.out.println(jnlpCache.getCodebase());
    }

    static {
        $assertionsDisabled = !EASJnlpCacheEntryManager.class.desiredAssertionStatus();
    }
}

