/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet;

import com.kingdee.bos.autoupdate.config.ConfigException;
import com.kingdee.bos.autoupdate.dl.AbstractRSDownloader;
import com.kingdee.bos.autoupdate.dl.DownloadException;
import com.kingdee.bos.autoupdate.dl.RSDownloadListener;
import com.kingdee.bos.autoupdate.util.BASE64Encoder;
import com.kingdee.eas.applet.FileAccessI;
import com.kingdee.eas.applet.IEasClientDownloader;
import com.kingdee.eas.applet.autoupdate.Logger;
import com.kingdee.eas.applet.autoupdate.NewConfigInfo;
import com.kingdee.eas.applet.autoupdate.NewConfigManager;
import com.kingdee.eas.applet.httpdownload.DownloadTask;
import com.kingdee.eas.applet.httpdownload.DownloadTaskListener;
import com.kingdee.eas.applet.httpdownload.HttpFileInfo;
import com.kingdee.eas.applet.httpdownload.HttpSiteInfo;
import com.kingdee.eas.applet.multithread.MultiThreadDownLoadImpl;
import com.kingdee.eas.applet.proxydownload.IProxyFile;
import com.kingdee.eas.applet.proxydownload.ProxyDownloadTask;
import com.kingdee.eas.applet.proxydownload.ProxyDownloadTaskListener;
import com.kingdee.eas.applet.proxydownload.ProxyFileInfo;
import com.kingdee.eas.applet.proxydownload.ProxyHttpSiteInfo;
import com.kingdee.eas.webutil.ConsoleLogger;
import com.kingdee.eas.webutil.URLUtils;
import com.twmacinta.util.MD5;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;

public class EasClientDownloaderHttpImpl
extends AbstractRSDownloader
implements IEasClientDownloader {
    private static final int KB_SIZE = 1024;
    private static final String PRAGMA = "pragma";
    private static final String NO_CACHE = "no-cache";
    private static final int FILE_LENGTH_REVISE_FACTOR = 5;
    private static EasClientDownloaderHttpImpl downloader;
    private static int urlConnCount;
    private static int totalTryCount;
    private static int onceDownKBytes;
    private static int downloadMethod;
    private static HashMap md5Version;
    private NewConfigInfo configInfo = null;
    private static int customHttp_DownLoad;
    private static int MultiThread_DownLoad;
    private static int P2P_DownLoad;
    private boolean byEof = true;
    private static String isSaveDlFile;
    private Logger logger = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    private void initProxy() {
        if (this.configInfo.isNeedProxy()) {
            if (!$assertionsDisabled && this.configInfo.getProxyPort() <= 0) {
                throw new AssertionError();
            }
            Authenticator.setDefault(new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(EasClientDownloaderHttpImpl.this.configInfo.getProxyUserName(), new String(EasClientDownloaderHttpImpl.this.configInfo.getProxyPassword()).toCharArray());
                }
            });
            System.setProperty("http.proxyType", "4");
            System.setProperty("http.proxyPort", Integer.toString(this.configInfo.getProxyPort()));
            System.setProperty("http.proxyHost", this.configInfo.getProxyServerUrl());
            System.setProperty("http.proxySet", "true");
        }
        System.setProperty("http.keepAlive", "true");
    }

    private void loadKdUpdaterConfig() {
        try {
            File configFile;
            String configDir = System.getProperty("KDUpdater.config");
            if (configDir != null && !(configFile = new File(configDir)).exists()) {
                configFile.mkdirs();
            }
            this.logger = Logger.getInstance();
            this.configInfo = NewConfigManager.load();
            this.setDownloadMethod(this.configInfo.getDownloadMethod());
            this.initProxy();
        }
        catch (ConfigException e) {
            e.printStackTrace();
        }
    }

    private EasClientDownloaderHttpImpl() {
        this.loadKdUpdaterConfig();
    }

    public static EasClientDownloaderHttpImpl getInstance() {
        if (downloader == null) {
            downloader = new EasClientDownloaderHttpImpl();
        }
        return downloader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContent(URL url) throws IOException {
        System.out.println("public InputStream getContent(URL url) throws IOException is invoke, do forget release the inputstream!");
        if (!($assertionsDisabled || url != null && "http".equalsIgnoreCase(url.getProtocol()))) {
            throw new AssertionError();
        }
        URLConnection cn = null;
        cn = this.getConnection(url, null);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new HttpInputStream(cn.getInputStream(), (HttpURLConnection)cn));
        return bufferedInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream getContent(URLConnection cn) throws IOException {
        if (!$assertionsDisabled && cn == null) {
            throw new AssertionError();
        }
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new HttpInputStream(cn.getInputStream(), (HttpURLConnection)cn));
        return bufferedInputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentLength(URL url) throws IOException {
        long l;
        if (!($assertionsDisabled || url != null && "http".equalsIgnoreCase(url.getProtocol()))) {
            throw new AssertionError();
        }
        URLConnection cn = null;
        try {
            cn = this.getConnection(url, null);
            l = cn.getContentLength();
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            block8: {
                Object var6_5 = null;
                if (!(cn instanceof HttpURLConnection)) break block8;
                try {
                    ((HttpURLConnection)cn).getInputStream().close();
                    ((HttpURLConnection)cn).getOutputStream().close();
                }
                catch (Throwable ignore) {}
            }
            throw throwable;
        }
        if (cn instanceof HttpURLConnection) {
            try {
                ((HttpURLConnection)cn).getInputStream().close();
                ((HttpURLConnection)cn).getOutputStream().close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getContentLength(URLConnection cn) throws IOException {
        if (!$assertionsDisabled && cn == null) {
            throw new AssertionError();
        }
        try {
            long l = cn.getContentLength();
            return l;
        }
        finally {
            if (cn instanceof HttpURLConnection) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long lastModified(URL url) throws IOException {
        long l;
        if (!($assertionsDisabled || url != null && "http".equalsIgnoreCase(url.getProtocol()))) {
            throw new AssertionError();
        }
        URLConnection cn = null;
        try {
            cn = this.getConnection(url, null);
            l = cn.getLastModified();
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            block8: {
                Object var6_5 = null;
                if (!(cn instanceof HttpURLConnection)) break block8;
                try {
                    ((HttpURLConnection)cn).getInputStream().close();
                    ((HttpURLConnection)cn).getOutputStream().close();
                }
                catch (Throwable ignore) {}
            }
            throw throwable;
        }
        if (cn instanceof HttpURLConnection) {
            try {
                ((HttpURLConnection)cn).getInputStream().close();
                ((HttpURLConnection)cn).getOutputStream().close();
            }
            catch (Throwable ignore) {
                // empty catch block
            }
        }
        return l;
    }

    private File getLocalFile(URL codebase, URL resource, File localFile) {
        if (!$assertionsDisabled && codebase == null) {
            throw new AssertionError();
        }
        String relativePath = this.getRelativePath(codebase, resource);
        return new File(localFile, relativePath);
    }

    protected long downloader_netFox(InputStream input, FileAccessI fileAccessI, URL resource, long totalLengthReaded, long totalLength) throws IOException {
        int nRead;
        if (!$assertionsDisabled && input == null) {
            throw new AssertionError((Object)"input stream cannot be null!");
        }
        byte[] b = new byte[1024];
        this.notifyListeners(resource, totalLength, totalLengthReaded);
        while ((nRead = input.read(b)) != -1) {
            long startWrite = System.currentTimeMillis();
            this.notifyListeners(resource, totalLength, totalLengthReaded += (long)fileAccessI.write(b, 0, nRead));
        }
        return totalLengthReaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyListeners(URL url, long length, long totalRead) {
        RSDownloadListener[] listeners = this.getRSDownloadListeners();
        int len = listeners.length;
        for (int i = 0; i < len; ++i) {
            RSDownloadListener rSDownloadListener = listeners[i];
            synchronized (rSDownloadListener) {
                if (totalRead == 0L) {
                    listeners[i].beginDownload(url);
                    listeners[i].downloadProgress(url, length, totalRead);
                } else if (totalRead == length || length == -1L) {
                    listeners[i].downloadProgress(url, length, totalRead);
                    listeners[i].finishDownload(url);
                } else {
                    listeners[i].downloadProgress(url, length, totalRead);
                }
                continue;
            }
        }
    }

    protected long downloader(URL url, long length, InputStream input, OutputStream output) throws IOException {
        if (!$assertionsDisabled && url == null) {
            throw new AssertionError((Object)"url cannot be null!");
        }
        if (!$assertionsDisabled && length <= 0L) {
            throw new AssertionError((Object)"file length must great than 0");
        }
        if (!($assertionsDisabled || output != null && input != null)) {
            throw new AssertionError((Object)"input and output stream cannot be null!");
        }
        int read = 0;
        long totalRead = 0L;
        byte[] cache = new byte[8192];
        this.notifyListeners(url, length, 0L);
        while ((read = input.read(cache)) != -1) {
            output.write(cache, 0, read);
            this.notifyListeners(url, length, totalRead += (long)read);
        }
        return totalRead;
    }

    public HashMap downloadFiles(URL codebase, URL[] serverURLs, File rootPath) {
        if (downloadMethod == 0) {
            return this.downloadFiles_GETRequest(codebase, serverURLs, rootPath);
        }
        if (downloadMethod == 2) {
            return this.downloadFiles_sigleNetFox(codebase, serverURLs, rootPath);
        }
        if (downloadMethod == customHttp_DownLoad) {
            return this.downloadFiles_customHttp(codebase, serverURLs, rootPath);
        }
        if (downloadMethod == MultiThread_DownLoad) {
            return this.downloadFiles_multiThread(codebase, serverURLs, rootPath);
        }
        if (downloadMethod == P2P_DownLoad) {
            return this.downloadFiles_p2pStyle(codebase, serverURLs, rootPath);
        }
        return this.downloadFiles_GETRequest(codebase, serverURLs, rootPath);
    }

    public HashMap downloadFiles_customHttp(URL codebase, URL[] serverURLs, final File rootPath) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        URL resource = null;
        final HashMap<String, URL> fileHash = new HashMap<String, URL>();
        try {
            URI serverURI = new URI(codebase.toString());
            HttpSiteInfo siteInfo = new HttpSiteInfo(serverURI.getScheme(), serverURI.getHost(), serverURI.getPort(), serverURI.getPath());
            ArrayList<HttpFileInfo> filesToDownload = new ArrayList<HttpFileInfo>();
            for (int i = 0; i < serverURLs.length; ++i) {
                resource = serverURLs[i];
                String fileName = this.getRelativePath(codebase, resource);
                HttpFileInfo info = new HttpFileInfo();
                info.setFileName(fileName);
                String version = (String)md5Version.get(this.getRelativePath(codebase, resource));
                info.setMd5(version);
                filesToDownload.add(info);
                fileHash.put(fileName, resource);
            }
            DownloadTask task = new DownloadTask(siteInfo, rootPath, filesToDownload);
            task.setListener(new DownloadTaskListener(){

                public void doanloadFailed(String fileName, Throwable ex) {
                    URL resource = (URL)fileHash.get(fileName);
                    EasClientDownloaderHttpImpl.this.notifyListeners(resource, -1L, -1L);
                }

                public void downloadFinish(String fileName, long size) {
                    File localFile = new File(rootPath.getAbsolutePath() + "/" + fileName);
                    URL resource = (URL)fileHash.get(fileName);
                    EasClientDownloaderHttpImpl.this.notifyListeners(resource, -1L, -1L);
                }
            });
            task.start();
            ArrayList failedList = task.getDownloadFailedFiles();
            for (int i = 0; i < failedList.size(); ++i) {
                URL resourceFail = (URL)fileHash.get(((HttpFileInfo)failedList.get(i)).getFileName());
                hashMap.put(resourceFail.toString(), "");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return hashMap;
    }

    private URL[] randomSort(URL[] serverURLs) {
        int length = serverURLs.length;
        URL temp = null;
        for (int i = 0; i < length; ++i) {
            URL firstUrl = serverURLs[(int)(Math.random() * (double)length)];
            URL secondUrl = serverURLs[(int)(Math.random() * (double)length)];
            temp = firstUrl;
            firstUrl = secondUrl;
            secondUrl = temp;
        }
        return serverURLs;
    }

    public HashMap downloadFiles_multiThread(URL codebase, URL[] serverURLs, File rootPath) {
        if (codebase == null || serverURLs == null || rootPath == null) {
            throw new NullPointerException("the parameter cannot be null!");
        }
        HashMap hashMap = new HashMap();
        URL resource = null;
        int size = serverURLs.length;
        int len = size;
        for (int i = 0; i < len; ++i) {
            resource = serverURLs[i];
            if (this.isNeedMulti(codebase, resource, rootPath)) continue;
            MultiThreadDownLoadImpl.setMd5Version(md5Version);
            RSDownloadListener[] listeners = this.getRSDownloadListeners();
            new MultiThreadDownLoadImpl(codebase, resource, rootPath, hashMap, listeners).download();
        }
        return hashMap;
    }

    private boolean isNeedMulti(URL codebase, URL resource, File rootPath) {
        if (resource.toString().indexOf("pkmap.lst") > 0 || resource.toString().indexOf("resource.lst") > 0 || resource.toString().indexOf("metasindex.jar") > 0) {
            URL[] urls = new URL[]{resource};
            this.downloadFiles_sigleNetFox(codebase, urls, rootPath);
            return true;
        }
        return false;
    }

    public HashMap downloadFiles_p2pStyle(URL codebase, URL[] serverURLs, File rootPath) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        URL resource = null;
        final HashMap<String, URL> fileHash = new HashMap<String, URL>();
        try {
            URI serverURI = new URI(codebase.toString());
            ProxyHttpSiteInfo siteInfo = new ProxyHttpSiteInfo(serverURI.getScheme(), serverURI.getHost(), serverURI.getPort(), serverURI.getPath());
            ArrayList<ProxyFileInfo> filesToDownload = new ArrayList<ProxyFileInfo>();
            int length = serverURLs.length;
            if (length > 1) {
                serverURLs = this.randomSort(serverURLs);
            }
            ProxyFileInfo fileInfo = null;
            for (int i = 0; i < serverURLs.length; ++i) {
                resource = serverURLs[i];
                String fileName = this.getRelativePath(codebase, resource);
                fileInfo = new ProxyFileInfo();
                fileInfo.setFileName(fileName);
                fileInfo.setMd5((String)md5Version.get(this.getRelativePath(codebase, resource)));
                fileInfo.setLocalFilePath(rootPath.getAbsolutePath());
                fileInfo.setResource(resource);
                filesToDownload.add(fileInfo);
                fileHash.put(fileName, resource);
            }
            ProxyDownloadTask task = new ProxyDownloadTask(siteInfo, rootPath, filesToDownload);
            task.setListener(new ProxyDownloadTaskListener(){

                public void doanloadFailed(IProxyFile proxyFile, Throwable ex) {
                    URL resource = (URL)fileHash.get(proxyFile.getFileName());
                    EasClientDownloaderHttpImpl.this.notifyListeners(resource, -1L, -1L);
                }

                public void downloadFinish(IProxyFile proxyFile, long size) {
                    URL resource = (URL)fileHash.get(proxyFile.getFileName());
                    EasClientDownloaderHttpImpl.this.notifyListeners(resource, -1L, -1L);
                }
            });
            task.start();
            ArrayList failedList = task.getDownloadFailedFiles();
            for (int i = 0; i < failedList.size(); ++i) {
                URL resourceFail = (URL)fileHash.get(((ProxyFileInfo)failedList.get(i)).getFileName());
                hashMap.put(resourceFail.toString(), "");
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap downloadFiles_sigleNetFox(URL codebase, URL[] serverURLs, File rootPath) {
        if (codebase == null || serverURLs == null || rootPath == null) {
            throw new NullPointerException("the parameter cannot be null!");
        }
        URL resource = null;
        File localFile = null;
        HashMap<String, Exception> hashMap = new HashMap<String, Exception>();
        InputStream input = null;
        long lastModified = System.currentTimeMillis();
        long totalFileSize = 0L;
        long splitterSize = 0L;
        long realSplitterFileSize = 0L;
        URLConnection cn = null;
        File tmp = null;
        long onceDownBytes = onceDownKBytes * 1024;
        long nStartPos = 0L;
        long[] nReadData = null;
        FileAccessI fileAccessI = null;
        Object version = null;
        boolean isByProxy = false;
        boolean isFirstRange = true;
        long totalLengthReaded = 0L;
        int len = serverURLs.length;
        for (int i = 0; i < len; ++i) {
            FileNotFoundException fe2222;
            long spendTime;
            Object var39_32;
            long startTime;
            block49: {
                isByProxy = false;
                isFirstRange = true;
                resource = serverURLs[i];
                localFile = this.getLocalFile(codebase, resource, rootPath);
                tmp = localFile.getParentFile();
                if (tmp != null && !tmp.exists()) {
                    tmp.mkdirs();
                }
                realSplitterFileSize = 0L;
                startTime = System.currentTimeMillis();
                cn = this.getConnection(resource, null);
                ((HttpURLConnection)cn).setRequestMethod("HEAD");
                int responseCode = ((HttpURLConnection)cn).getResponseCode();
                if (responseCode >= 400) {
                    throw new IOException("File is not access.");
                }
                lastModified = cn.getLastModified();
                totalFileSize = cn.getContentLength();
                nStartPos = 0L;
                fileAccessI = new FileAccessI(localFile.toString());
                if (fileAccessI.existsInfoFile()) {
                    nReadData = fileAccessI.read_nPos();
                    if (nReadData[0] == lastModified) {
                        nStartPos = nReadData[1];
                    } else {
                        fileAccessI.delDLFile();
                    }
                }
                realSplitterFileSize = nStartPos;
                fileAccessI.setPos(nStartPos);
                totalLengthReaded = nStartPos;
                int blockCount = 0;
                long start1 = System.currentTimeMillis();
                while (true) {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                    cn = this.getConnection(resource, null);
                    String sProperty = "bytes=" + nStartPos + "-";
                    sProperty = sProperty + (nStartPos + onceDownBytes - 1L);
                    this.logger.debug("read " + sProperty + ",resource:" + cn.getURL());
                    cn.setRequestProperty("RANGE", sProperty);
                    responseCode = ((HttpURLConnection)cn).getResponseCode();
                    if (responseCode == 416) {
                        this.logger.info("Requested Range Not Satisfiable," + sProperty + " values were greater than the file length of " + cn.getURL());
                        break;
                    }
                    input = cn.getInputStream();
                    splitterSize = this.getContentLength(cn);
                    if (isFirstRange) {
                        isByProxy = ((HttpURLConnection)cn).usingProxy();
                        this.logger.debug(" netFox download,using proxy:" + ((HttpURLConnection)cn).usingProxy());
                        isFirstRange = false;
                    }
                    if (splitterSize > 0L || splitterSize == -1L && this.isByEof()) {
                        ++blockCount;
                        if (totalFileSize == -1L) {
                            totalLengthReaded = splitterSize == -1L ? (totalLengthReaded += onceDownBytes) : (totalLengthReaded += splitterSize);
                            totalFileSize = this.reviseFileLength(splitterSize, onceDownBytes, totalLengthReaded, blockCount);
                        }
                        nStartPos = this.downloader_netFox(input, fileAccessI, resource, nStartPos, totalFileSize);
                        fileAccessI.write_nPos(lastModified, nStartPos, totalFileSize);
                        realSplitterFileSize = nStartPos;
                    }
                    if (splitterSize > 0L && splitterSize == onceDownBytes) continue;
                    if (splitterSize != -1L) break;
                    if (!this.isByEof()) break;
                }
                var39_32 = null;
                if (fileAccessI == null) break block49;
                fileAccessI.close();
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            File newFile = new File(localFile.toString() + ".dl");
            if (newFile == null || !newFile.exists()) continue;
            try {
                this.doAfterDownload_NetFox(codebase, rootPath, resource, localFile, newFile, lastModified, isByProxy, fileAccessI);
                spendTime = System.currentTimeMillis() - startTime;
            }
            catch (Exception e) {
                if (fileAccessI != null) {
                    try {
                        fileAccessI.delDLFile();
                    }
                    catch (FileNotFoundException fe2222) {
                        // empty catch block
                    }
                    fileAccessI.delInfoFile();
                }
                e.printStackTrace();
                hashMap.put(resource.toString(), e);
            }
            continue;
            {
                catch (Exception fnfe) {
                    if (fileAccessI != null) {
                        fileAccessI.close();
                    }
                    if (fileAccessI != null && fileAccessI.getDLFileSize() <= 0L) {
                        try {
                            fileAccessI.delDLFile();
                        }
                        catch (FileNotFoundException e) {
                            e.printStackTrace();
                        }
                        fileAccessI.delInfoFile();
                    }
                    fnfe.printStackTrace();
                    hashMap.put(resource.toString(), fnfe);
                    var39_32 = null;
                    if (fileAccessI != null) {
                        fileAccessI.close();
                    }
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    newFile = new File(localFile.toString() + ".dl");
                    if (newFile == null || !newFile.exists()) continue;
                    try {
                        this.doAfterDownload_NetFox(codebase, rootPath, resource, localFile, newFile, lastModified, isByProxy, fileAccessI);
                        spendTime = System.currentTimeMillis() - startTime;
                    }
                    catch (Exception e) {
                        if (fileAccessI != null) {
                            try {
                                fileAccessI.delDLFile();
                            }
                            catch (FileNotFoundException fe2222) {
                                // empty catch block
                            }
                            fileAccessI.delInfoFile();
                        }
                        e.printStackTrace();
                        hashMap.put(resource.toString(), e);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var39_32 = null;
                if (fileAccessI != null) {
                    fileAccessI.close();
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                newFile = new File(localFile.toString() + ".dl");
                if (newFile != null && newFile.exists()) {
                    try {
                        this.doAfterDownload_NetFox(codebase, rootPath, resource, localFile, newFile, lastModified, isByProxy, fileAccessI);
                        spendTime = System.currentTimeMillis() - startTime;
                    }
                    catch (Exception e) {
                        if (fileAccessI != null) {
                            try {
                                fileAccessI.delDLFile();
                            }
                            catch (FileNotFoundException fe2222) {
                                // empty catch block
                            }
                            fileAccessI.delInfoFile();
                        }
                        e.printStackTrace();
                        hashMap.put(resource.toString(), e);
                    }
                }
                throw throwable;
            }
        }
        return hashMap;
    }

    private long reviseFileLength(long realDownBytes, long onceDownBytes, long lengthReaded, int blockCount) {
        int factor = 5 - blockCount;
        if (factor < 1) {
            factor = 1;
        }
        long result = lengthReaded;
        if (realDownBytes < onceDownBytes) {
            result = lengthReaded;
        } else if (realDownBytes == onceDownBytes) {
            result = lengthReaded + onceDownBytes * (long)factor;
        }
        return result;
    }

    private void doAfterDownload_NetFox(URL codebase, File rootPath, URL resource, File localFile, File newFile, long lastModified, boolean isByProxy, FileAccessI fileAccessI) throws IOException {
        if (this.isNeedCheckMd5(localFile) && !this.checkMd5(codebase, resource, newFile)) {
            boolean md5Try;
            FileAccessI lastFileInfo = new FileAccessI(localFile.toString());
            if (lastFileInfo.existsInfoFile() && isSaveDlFile == null) {
                lastFileInfo.delDLFile();
                lastFileInfo.delInfoFile();
            }
            if (!(md5Try = this.reDownloadWithoutProxy(codebase, resource, rootPath, isByProxy))) {
                throw new IOException("MD5 check is failure.file:" + newFile);
            }
        } else {
            newFile.setLastModified(lastModified);
            boolean b = this.overwrite(localFile, newFile);
            if (b) {
                if (fileAccessI != null) {
                    fileAccessI.delInfoFile();
                }
                this.logger.info("Download  file: " + localFile.toString());
            }
        }
    }

    private boolean checkMd5(URL codebase, URL resource, File tmpFile) throws IOException {
        String tmpVersion;
        String version = (String)md5Version.get(this.getRelativePath(codebase, resource));
        if (version == null) {
            version = (String)md5Version.get("/" + this.getRelativePath(codebase, resource));
            System.out.println("@@@@@@key:" + this.getRelativePath(codebase, resource));
            if (version == null) {
                throw new IOException("remote MD5 version is null.resource:" + resource);
            }
        }
        if (version.equals(tmpVersion = MD5.asHex(MD5.getHash(tmpFile)))) {
            return true;
        }
        System.out.println("compare md5 [local:" + tmpVersion + ",remote:" + version + "] failure");
        if (resource.toString().indexOf("metasindex.jar") >= 0) {
            System.out.println("metasindex md5version check failure,but should download it....");
            return true;
        }
        return false;
    }

    private boolean reDownloadWithoutProxy(URL codebase, URL resource, File rootPath, boolean isByProxy) {
        boolean noCacheTry = false;
        boolean isNoCacheHeader = this.checkExistNoCacheHeader(resource);
        System.out.println("using proxy:" + isByProxy + ",isNoCacheHeader:" + isNoCacheHeader);
        if (isByProxy && !isNoCacheHeader) {
            noCacheTry = this.reDownloadWithNoCacheHeader(codebase, resource, rootPath);
        }
        return noCacheTry;
    }

    private boolean checkExistNoCacheHeader(URL resource) {
        String query = resource.getQuery();
        boolean noCacheHeader = NO_CACHE.equalsIgnoreCase(URLUtils.getParameter(query, PRAGMA));
        return noCacheHeader;
    }

    private boolean reDownloadWithNoCacheHeader(URL codebase, URL resource, File rootPath) {
        URL newUrl = resource;
        String query = resource.getQuery();
        query = query == null ? "?" : query + "&";
        query = query + "pragma=no-cache";
        String file = resource.getPath() + query;
        try {
            newUrl = new URL(resource, file);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        boolean result = false;
        URL[] serverURLs = new URL[]{newUrl};
        HashMap resultMap = this.downloadFiles(codebase, serverURLs, rootPath);
        if (resultMap.isEmpty()) {
            result = true;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public HashMap downloadFiles_GETRequest(URL codebase, URL[] serverURLs, File rootPath) {
        if (codebase == null || serverURLs == null || rootPath == null) {
            throw new NullPointerException("the parameter cannot be null!");
        }
        URL resource = null;
        File localFile = null;
        File newFile = null;
        HashMap<String, Exception> hashMap = new HashMap<String, Exception>();
        FilterOutputStream output = null;
        InputStream input = null;
        long lastModified = System.currentTimeMillis();
        long fileSize = 0L;
        long realFileSize = 0L;
        URLConnection cn = null;
        File tmp = null;
        boolean isByProxy = false;
        int len = serverURLs.length;
        for (int i = 0; i < len; ++i) {
            resource = serverURLs[i];
            localFile = this.getLocalFile(codebase, resource, rootPath);
            tmp = localFile.getParentFile();
            if (tmp != null && !tmp.exists()) {
                tmp.mkdirs();
            }
            realFileSize = 0L;
            newFile = new File(localFile.toString() + ".fl");
            output = new BufferedOutputStream(new FileOutputStream(newFile));
            cn = this.getConnection(resource, cn);
            input = this.getContent(cn);
            fileSize = this.getContentLength(cn);
            lastModified = cn.getLastModified();
            isByProxy = ((HttpURLConnection)cn).usingProxy();
            ConsoleLogger.info(" File size: " + fileSize + ", proxy config isNeedProxy:" + this.configInfo.isNeedProxy() + ", using proxy:" + isByProxy);
            realFileSize = this.downloader(resource, fileSize, input, output);
            ((BufferedOutputStream)output).flush();
            this.logger.info("Download  file: " + localFile.toString());
            Object var23_19 = null;
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                if (newFile == null) continue;
                this.doAfterDownload(codebase, rootPath, resource, localFile, newFile, lastModified, isByProxy);
            }
            catch (IOException e) {
                if (newFile != null) {
                    newFile.delete();
                }
                e.printStackTrace();
                hashMap.put(resource.toString(), e);
            }
            continue;
            {
                catch (Exception fnfe) {
                    if (newFile != null) {
                        newFile.delete();
                        newFile = null;
                    }
                    fnfe.printStackTrace();
                    hashMap.put(resource.toString(), fnfe);
                    var23_19 = null;
                    try {
                        if (output != null) {
                            output.close();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    try {
                        if (newFile == null) continue;
                        this.doAfterDownload(codebase, rootPath, resource, localFile, newFile, lastModified, isByProxy);
                    }
                    catch (IOException e) {
                        if (newFile != null) {
                            newFile.delete();
                        }
                        e.printStackTrace();
                        hashMap.put(resource.toString(), e);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                var23_19 = null;
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                try {
                    if (newFile != null) {
                        this.doAfterDownload(codebase, rootPath, resource, localFile, newFile, lastModified, isByProxy);
                    }
                }
                catch (IOException e) {
                    if (newFile != null) {
                        newFile.delete();
                    }
                    e.printStackTrace();
                    hashMap.put(resource.toString(), e);
                }
                throw throwable;
            }
        }
        return hashMap;
    }

    private void doAfterDownload(URL codebase, File rootPath, URL resource, File localFile, File newFile, long lastModified, boolean isByProxy) throws IOException {
        if (this.isNeedCheckMd5(localFile) && !this.checkMd5(codebase, resource, newFile)) {
            boolean md5Try = this.reDownloadWithoutProxy(codebase, resource, rootPath, isByProxy);
            if (!md5Try) {
                throw new IOException("MD5 check is failure.file:" + newFile);
            }
        } else {
            newFile.setLastModified(lastModified);
            this.overwrite(localFile, newFile);
        }
    }

    private boolean overwrite(File localFile, File newFile) throws IOException {
        boolean b;
        if (localFile.exists()) {
            boolean flag = localFile.delete();
        }
        if (!(b = newFile.renameTo(localFile)) && !(b = newFile.renameTo(localFile))) {
            throw new IOException("Rename failure:" + newFile.toString());
        }
        return b;
    }

    private boolean isNeedCheckMd5(File localFile) {
        return !localFile.toString().endsWith("datacenters.xml") && !localFile.toString().endsWith("pkmap.lst") && !localFile.toString().endsWith("resource.lst") && !localFile.toString().endsWith("jnlp") && !localFile.toString().endsWith("metasindex.jar");
    }

    private URLConnection getConnection(URL url, URLConnection oldConnection) throws IOException {
        boolean isNoCacheHeader;
        if (oldConnection != null) {
            try {
                oldConnection.getInputStream().close();
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        if (isNoCacheHeader = this.checkExistNoCacheHeader(url)) {
            url = this.removeNoCacheHeader(url);
        }
        URLConnection uc = url.openConnection();
        ++urlConnCount;
        if (this.configInfo.isNeedProxy()) {
            if (!$assertionsDisabled && this.configInfo.getProxyPort() <= 0) {
                throw new AssertionError();
            }
            uc.setRequestProperty("Proxy-Authorization", this.encodeUserNameAndPassword(this.configInfo.getProxyUserName(), this.configInfo.getProxyPassword()));
        }
        if (this.configInfo.isNeedBaseAuth()) {
            uc.setRequestProperty("Authorization", this.encodeUserNameAndPassword(this.configInfo.getBaseAuthUserName(), this.configInfo.getBaseAuthPassword()));
        }
        if (isNoCacheHeader) {
            this.addNoCacheHeader(uc);
        }
        return uc;
    }

    private URL removeNoCacheHeader(URL url) {
        URL newUrl = url;
        String query = url.getQuery();
        if (query != null) {
            query = query.replaceAll(PRAGMA + "\\=" + NO_CACHE, "");
        }
        String file = url.getPath();
        if (query != null && !"".equals(query)) {
            file = file + "?" + query;
        }
        try {
            newUrl = new URL(url, file);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return newUrl;
    }

    private void addNoCacheHeader(URLConnection uc) {
        this.addToRequestProperty(uc, PRAGMA, NO_CACHE);
        System.out.println("no-cache file:" + uc.getURL());
    }

    private URL encodeURL(URL url) throws UnsupportedEncodingException, MalformedURLException {
        String fileUrl = url.getPath();
        String tempBackslash = "-E.B.S-";
        fileUrl = fileUrl.replaceAll("/", tempBackslash);
        fileUrl = URLEncoder.encode(fileUrl, "utf-8");
        fileUrl = fileUrl.replaceAll(tempBackslash, "/");
        System.out.println("old url:" + url.getPath());
        System.out.println("encoded url:" + fileUrl);
        return new URL(url.getProtocol(), url.getHost(), url.getPort(), fileUrl);
    }

    private String encodeUserNameAndPassword(String userName, String password) {
        return "Basic " + BASE64Encoder.base64Encode((String)(userName + ":" + password));
    }

    private void addToRequestProperty(URLConnection conn, String key, String value) {
        String curvalue = conn.getRequestProperty(key);
        curvalue = curvalue == null || curvalue.trim().length() == 0 ? value : curvalue + "," + value;
        conn.setRequestProperty(key, curvalue);
    }

    public int getUrlConnCount() {
        return urlConnCount;
    }

    public void clearUrlConnCount() {
        urlConnCount = 0;
    }

    public void setTotalTryCount(int totalCount) {
        totalTryCount = totalCount;
    }

    public void setOnceDownKBytes(int onceDownKBytes) {
        EasClientDownloaderHttpImpl.onceDownKBytes = onceDownKBytes;
    }

    public void setIsSaveDlFile(String isSaveDlFile) {
        EasClientDownloaderHttpImpl.isSaveDlFile = isSaveDlFile;
    }

    public static String getIsSaveDlFile() {
        return isSaveDlFile;
    }

    public int getOnceDownBytes() {
        return onceDownKBytes;
    }

    public void setDownloadMethod(int downloadMethod) {
        EasClientDownloaderHttpImpl.downloadMethod = this.configInfo.getPriorMethod() == 0 ? this.configInfo.getDownloadMethod() : downloadMethod;
    }

    public void setMD5Version(HashMap md5Version) {
        EasClientDownloaderHttpImpl.md5Version = md5Version;
    }

    public boolean isByEof() {
        return this.byEof;
    }

    public void setByEof(boolean eof) {
        this.byEof = eof;
    }

    /*
     * Loose catch block
     */
    public void download(URL codebase, URL[] serverURLs, File rootPath) throws DownloadException {
        if (codebase == null || serverURLs == null || rootPath == null) {
            throw new NullPointerException("the parameter cannot be null!");
        }
        URL resource = null;
        File localFile = null;
        BufferedOutputStream output = null;
        InputStream input = null;
        long fileSize = 0L;
        URLConnection cn = null;
        int len = serverURLs.length;
        for (int i = 0; i < len; ++i) {
            resource = serverURLs[i];
            localFile = this.getLocalFile(codebase, resource, rootPath);
            File tmp = localFile.getParentFile();
            if (tmp != null) {
                tmp.mkdirs();
            }
            output = new BufferedOutputStream(new FileOutputStream(localFile));
            cn = this.getConnection(resource, cn);
            input = this.getContent(cn);
            fileSize = this.getContentLength(cn);
            this.download(resource, fileSize, input, output);
            output.flush();
            Object var16_13 = null;
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception ignore) {
                // empty catch block
            }
            try {
                if (input == null) continue;
                input.close();
            }
            catch (Exception ignore) {}
            continue;
            {
                catch (FileNotFoundException fnfe) {
                    if (localFile != null) {
                        localFile.delete();
                    }
                    throw new DownloadException((Throwable)fnfe);
                }
                catch (IOException ioe) {
                    if (localFile != null) {
                        localFile.delete();
                    }
                    throw new DownloadException((Throwable)ioe);
                }
            }
            catch (Throwable throwable) {
                var16_13 = null;
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                try {
                    if (input != null) {
                        input.close();
                    }
                }
                catch (Exception ignore) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    static {
        $assertionsDisabled = !EasClientDownloaderHttpImpl.class.desiredAssertionStatus();
        downloader = null;
        urlConnCount = 0;
        totalTryCount = 3;
        onceDownKBytes = 56;
        downloadMethod = 0;
        md5Version = null;
        customHttp_DownLoad = 1;
        MultiThread_DownLoad = 3;
        P2P_DownLoad = 8;
        isSaveDlFile = null;
    }

    private static class HttpInputStream
    extends InputStream {
        private final InputStream is;
        private final HttpURLConnection httpCn;

        public HttpInputStream(InputStream is, HttpURLConnection httpCn) {
            this.is = is;
            this.httpCn = httpCn;
        }

        public int available() throws IOException {
            return this.is.available();
        }

        public void close() throws IOException {
            this.is.close();
            try {
                this.httpCn.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public boolean equals(Object arg0) {
            return this.is.equals(arg0);
        }

        public int hashCode() {
            return this.is.hashCode();
        }

        public void mark(int arg0) {
            this.is.mark(arg0);
        }

        public boolean markSupported() {
            return this.is.markSupported();
        }

        public int read() throws IOException {
            return this.is.read();
        }

        public int read(byte[] arg0) throws IOException {
            return this.is.read(arg0);
        }

        public int read(byte[] arg0, int arg1, int arg2) throws IOException {
            return this.is.read(arg0, arg1, arg2);
        }

        public void reset() throws IOException {
            this.is.reset();
        }

        public long skip(long arg0) throws IOException {
            return this.is.skip(arg0);
        }

        public String toString() {
            return this.is.toString();
        }
    }
}

