/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet;

import com.kingdee.bos.autoupdate.JNLPException;
import com.kingdee.bos.autoupdate.Logger;
import com.kingdee.bos.autoupdate.cache.CacheException;
import com.kingdee.bos.autoupdate.cache.CacheUpdateListener;
import com.kingdee.bos.autoupdate.dl.DownloadException;
import com.kingdee.bos.autoupdate.jnl.ParseException;
import com.kingdee.bos.autoupdate.util.FileUtil;
import com.kingdee.bos.autoupdate.util.URLUtil;
import com.kingdee.eas.applet.EASCacheEntryInfo;
import com.kingdee.eas.applet.EasClientDownloaderFactory;
import com.kingdee.eas.applet.EasClientDownloaderHttpImpl;
import com.kingdee.eas.applet.IEasClientDownloader;
import com.kingdee.eas.applet.autoupdate.CacheStateFactory;
import com.kingdee.eas.applet.autoupdate.DownloadMode;
import com.kingdee.eas.applet.autoupdate.DownloadPhase;
import com.kingdee.eas.applet.autoupdate.ICacheState;
import com.kingdee.eas.applet.autoupdate.OnDemandUpdateStateUtil;
import com.kingdee.eas.applet.autoupdate.ResourceVerUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class EasClientUpdater {
    public static final String JNLP_VERSION_FILES_ATTRIBUTE = "jnlpVersionFiles";
    final URL jnlp;
    final File baseDir;
    private final List _listeners = new ArrayList();
    private final ICacheState cacheState;
    private static boolean isFirstDelete;
    HashMap demandVersionMap = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public EasClientUpdater(String jnlpUrl, String localPath) throws CacheException, DownloadException, ParseException {
        this(jnlpUrl, localPath, "update.properties");
    }

    public EasClientUpdater(URL jnlp, String baseDir, String modifyFileName) throws CacheException, DownloadException, ParseException {
        this(jnlp.toString(), baseDir, modifyFileName);
    }

    public EasClientUpdater(URL jnlp, File baseDir) throws CacheException, DownloadException, ParseException {
        this(jnlp, baseDir.toString(), "update.properties");
    }

    public EasClientUpdater(String jnlpUrl, String localPath, String modifyFileName) throws CacheException, DownloadException, ParseException {
        this(jnlpUrl, localPath, modifyFileName, "", "");
    }

    public EasClientUpdater(String jnlpUrl, String localPath, String modifyFileName, String ondemandjnlpF, String fulljnlpF) throws CacheException, DownloadException, ParseException {
        this(jnlpUrl, localPath, modifyFileName, ondemandjnlpF, fulljnlpF, DownloadMode.getCurrentMode(), 0);
    }

    public EasClientUpdater(String jnlpUrl, String localPath, String modifyFileName, String ondemandjnlpF, String fulljnlpF, int dlMode, int dlPhase) throws CacheException, DownloadException, ParseException {
        if (!($assertionsDisabled || jnlpUrl != null && modifyFileName != null && localPath != null)) {
            throw new AssertionError();
        }
        try {
            this.jnlp = URLUtil.getURL(null, (String)jnlpUrl);
            this.baseDir = new File(localPath);
        }
        catch (MalformedURLException mle) {
            throw new CacheException("Invalidate url " + jnlpUrl, (Throwable)mle);
        }
        DownloadMode.setCurrentMode(dlMode);
        DownloadPhase.setCurrentPhase(dlPhase);
        this.cacheState = CacheStateFactory.createCurrentCacheState(jnlpUrl, localPath, modifyFileName, ondemandjnlpF, fulljnlpF);
    }

    public ICacheState getCacheState() throws CacheException {
        return this.cacheState;
    }

    public int getUpdateFileCount() {
        return this.cacheState.getUpdatedResources().size();
    }

    public int getDeleteFileCount() {
        return this.cacheState.getDeletedResources().size();
    }

    public boolean isNeedDelete() {
        return this.cacheState.isNeedDelete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addUpdateListener(CacheUpdateListener dListener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.add(dListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CacheUpdateListener[] getUpdateListeners() {
        List list = this._listeners;
        synchronized (list) {
            return this._listeners.toArray(new CacheUpdateListener[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUpdateListener(CacheUpdateListener dListener) {
        List list = this._listeners;
        synchronized (list) {
            this._listeners.remove(dListener);
        }
    }

    public URL getJnlpCodebase() {
        return this.cacheState.getCodebase();
    }

    public synchronized HashMap update() throws JNLPException {
        HashMap hashMap = null;
        CacheUpdateListener[] listeners = this.getUpdateListeners();
        if (this.cacheState.isNeedDelete() || this.cacheState.isNeedUpdate()) {
            this.cacheState.startTrace();
        }
        if (this.cacheState.isNeedDelete()) {
            try {
                Iterator it = this.cacheState.getDeletedResources().iterator();
                EASCacheEntryInfo entry = null;
                File localFile = null;
                while (it.hasNext()) {
                    entry = (EASCacheEntryInfo)((Object)it.next());
                    localFile = new File(this.baseDir, URLUtil.getRelativePath((URL)this.cacheState.getLocalCacheEntryInfo().getCodebase(), (URL)entry.getHref()));
                    localFile.delete();
                    int len = listeners.length;
                    for (int i = 0; i < len; ++i) {
                        listeners[i].deleteResource(entry.getHref(), localFile);
                    }
                    Logger.getInstance().info((Object)("EASUpdater:Delete base cached file: " + localFile.toString()));
                }
            }
            catch (Exception ignore) {
                Logger.getInstance().info((Object)("Delete cached file,exception: " + ignore.toString()));
            }
        }
        if (this.cacheState.isNeedUpdate()) {
            Iterator itUpdated = this.cacheState.getUpdatedResources().iterator();
            ArrayList<URL> urls = new ArrayList<URL>();
            HashMap<String, String> versionMap = new HashMap<String, String>();
            EASCacheEntryInfo entryInfo = null;
            while (itUpdated.hasNext()) {
                entryInfo = (EASCacheEntryInfo)((Object)itUpdated.next());
                urls.add(entryInfo.getHref());
                Logger.getInstance().info((Object)("now  download base file " + entryInfo.getHref()));
                versionMap.put(URLUtil.getRelativePath((URL)this.cacheState.getCodebase(), (URL)entryInfo.getHref()), entryInfo.getMd5Version());
            }
            IEasClientDownloader downloader = this.initDownloader(versionMap);
            hashMap = downloader.downloadFiles(this.cacheState.getCodebase(), this.toURLs(urls), this.baseDir);
            int len = listeners.length;
            for (int i = 0; i < len; ++i) {
                listeners[i].updateResource(this.toURLs(urls), this.toFiles(urls, this.cacheState.getCodebase()));
            }
        }
        if (this.cacheState.isNeedDelete() || this.cacheState.isNeedUpdate()) {
            this.cacheState.storeCacheState(hashMap);
        }
        return hashMap;
    }

    private IEasClientDownloader initDownloader(HashMap versionMap) {
        IEasClientDownloader downloader = EasClientDownloaderFactory.getDownloader(this.jnlp.getProtocol());
        if (downloader instanceof EasClientDownloaderHttpImpl) {
            ((EasClientDownloaderHttpImpl)downloader).setMD5Version(versionMap);
        }
        return downloader;
    }

    private URL[] toURLs(List list) {
        return list.toArray(new URL[0]);
    }

    private File[] toFiles(List list, URL codebase) {
        URL[] aUrl = this.toURLs(list);
        File[] files = new File[aUrl.length];
        for (int i = 0; i < aUrl.length; ++i) {
            files[i] = new File(this.baseDir, URLUtil.getRelativePath((URL)codebase, (URL)aUrl[i]));
        }
        return files;
    }

    private void clearLocalCache() {
        if (!this.baseDir.exists()) {
            this.baseDir.mkdirs();
            return;
        }
        FileUtil.deleteFiles((File)this.baseDir, (boolean)false);
    }

    public boolean updateResource(String relativePath) {
        this.deleteOldRes();
        EASCacheEntryInfo entryInfo = this.isNeedUpdate(relativePath);
        if (entryInfo == null) {
            return false;
        }
        URL[] urls = new URL[]{entryInfo.getHref()};
        Logger.getInstance().info((Object)("now download  file: " + entryInfo.getHref()));
        this.demandVersionMap.put(URLUtil.getRelativePath((URL)this.cacheState.getCodebase(), (URL)entryInfo.getHref()), entryInfo.getMd5Version());
        IEasClientDownloader downloader = this.initDownloader(this.demandVersionMap);
        HashMap ht = downloader.downloadFiles(this.cacheState.getCodebase(), urls, this.baseDir);
        if (ht != null && ht.size() >= 1) {
            return false;
        }
        this.storeResxCasheState(entryInfo);
        this.removeUpdatedResources(entryInfo);
        return true;
    }

    public boolean updateResource(String relativePath, boolean isForce) {
        if (isForce) {
            try {
                URL res = new URL(this.cacheState.getCodebase() + relativePath);
                IEasClientDownloader downloader = EasClientDownloaderFactory.getDownloader(this.jnlp.getProtocol());
                downloader.download(this.cacheState.getCodebase(), res, this.cacheState.getBaseDir());
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public boolean updateResource(EASCacheEntryInfo entryInfo) {
        this.deleteOldRes();
        if (entryInfo == null) {
            return false;
        }
        URL[] urls = new URL[]{entryInfo.getHref()};
        Logger.getInstance().info((Object)("now download  file: " + ((Object)((Object)entryInfo)).toString()));
        this.demandVersionMap.put(URLUtil.getRelativePath((URL)this.cacheState.getCodebase(), (URL)entryInfo.getHref()), entryInfo.getMd5Version());
        IEasClientDownloader downloader = this.initDownloader(this.demandVersionMap);
        HashMap ht = downloader.downloadFiles(this.cacheState.getCodebase(), urls, this.baseDir);
        if (ht != null && ht.size() >= 1) {
            return false;
        }
        this.storeResxCasheState(entryInfo);
        this.removeUpdatedResources(entryInfo);
        return true;
    }

    private void deleteOldRes() {
        ArrayList<String> resDelete = new ArrayList<String>();
        if (isFirstDelete && this.cacheState.isNeedDelete()) {
            try {
                Iterator it = this.cacheState.getDeletedResources().iterator();
                EASCacheEntryInfo entry = null;
                CacheUpdateListener[] listeners = this.getUpdateListeners();
                File localFile = null;
                System.out.println("jnlp:" + this.jnlp.getFile());
                while (it.hasNext()) {
                    entry = (EASCacheEntryInfo)((Object)it.next());
                    String deleteHerf = URLUtil.getRelativePath((URL)this.cacheState.getLocalCacheEntryInfo().getCodebase(), (URL)entry.getHref());
                    if ((entry.getHref() == null || this.jnlp.getFile().indexOf(deleteHerf) >= 0) && !deleteHerf.equalsIgnoreCase("eas.jnlp")) continue;
                    localFile = new File(this.baseDir, deleteHerf);
                    localFile.delete();
                    int len = listeners.length;
                    for (int i = 0; i < len; ++i) {
                        listeners[i].deleteResource(entry.getHref(), localFile);
                    }
                    String seperator = "\\\\";
                    if (localFile.getAbsolutePath().startsWith(this.baseDir.toString())) {
                        int length = this.baseDir.toString().length();
                        String localName = localFile.getAbsolutePath().substring(length + 1);
                        localName = localName.replaceAll(seperator, "/");
                        resDelete.add(localName);
                        Logger.getInstance().info((Object)("Now Delete : " + localFile.toString() + "from resource.lst"));
                    }
                    Logger.getInstance().info((Object)("Delete cached file: " + localFile.toString()));
                }
                this.storeResState(resDelete, this.cacheState);
            }
            catch (Exception ignore) {
                System.out.println("Delete cached file,exception: " + ignore.toString());
            }
        }
        if (!isFirstDelete || this.cacheState.isNeedDelete() || this.cacheState.isNeedUpdate()) {
            // empty if block
        }
        isFirstDelete = false;
    }

    public EASCacheEntryInfo isNeedUpdate(String relativePath) {
        List resEntry = this.cacheState.getUpdatedResources();
        if (resEntry != null) {
            Iterator it = resEntry.iterator();
            while (it.hasNext()) {
                EASCacheEntryInfo info = (EASCacheEntryInfo)((Object)it.next());
                if (info.getHref().getPath().toString().indexOf(relativePath) < 0) continue;
                return info;
            }
        }
        return null;
    }

    public void storeResxCasheState(EASCacheEntryInfo entryInfo) {
        ResourceVerUtil.save(this.baseDir, entryInfo);
    }

    public void storeResState(List resDelete, ICacheState onDemandCacheState) {
        int index = this.jnlp.getFile().lastIndexOf("/");
        String jnlpFileName = this.baseDir.toString() + this.jnlp.getFile().substring(index);
        OnDemandUpdateStateUtil.storeResLst(this.baseDir, jnlpFileName, resDelete, onDemandCacheState);
    }

    public void removeUpdatedResources(EASCacheEntryInfo entryInfo) {
        this.cacheState.getUpdatedResources().remove((Object)entryInfo);
    }

    public static void main(String[] args) {
        URL jnlpURL = null;
        try {
            jnlpURL = new URL(args[0]);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        String localDirName = args[1];
        File localDir = new File(localDirName);
        try {
            EasClientUpdater updater = new EasClientUpdater(jnlpURL, localDir);
            updater.update();
        }
        catch (CacheException e1) {
            e1.printStackTrace();
        }
        catch (DownloadException e1) {
            e1.printStackTrace();
        }
        catch (JNLPException e) {
            e.printStackTrace();
        }
    }

    static {
        $assertionsDisabled = !EasClientUpdater.class.desiredAssertionStatus();
        isFirstDelete = true;
    }
}

