/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.autoupdate;

import com.kingdee.bos.autoupdate.cache.CacheException;
import com.kingdee.bos.autoupdate.dl.DownloadException;
import com.kingdee.bos.autoupdate.jnl.JNLParser;
import com.kingdee.bos.autoupdate.jnl.LaunchInfo;
import com.kingdee.bos.autoupdate.jnl.ParseException;
import com.kingdee.bos.autoupdate.util.URLUtil;
import com.kingdee.eas.applet.EASCacheEntryInfo;
import com.kingdee.eas.applet.EASJNLPCacheEntryInfo;
import com.kingdee.eas.applet.EASJnlpCacheEntryManager;
import com.kingdee.eas.applet.EasClientDownloaderFactory;
import com.kingdee.eas.applet.IEasClientDownloader;
import com.kingdee.eas.applet.autoupdate.AbstractCacheStateImpl;
import com.kingdee.eas.applet.autoupdate.DownloadTraceInfo;
import com.kingdee.eas.applet.autoupdate.DownloadTraceUtil;
import com.kingdee.eas.applet.autoupdate.JnlpServerCtrlParameter;
import com.kingdee.eas.applet.autoupdate.JnlpServerCtrlParamsUtils;
import com.kingdee.eas.applet.autoupdate.JnlpVersionInfo;
import com.kingdee.eas.applet.autoupdate.ResourceVerUtil;
import com.kingdee.eas.webutil.ConsoleLogger;
import com.kingdee.eas.webutil.CreateJNLPResource;
import com.kingdee.eas.webutil.FileManager;
import com.kingdee.eas.webutil.URLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CacheStateImpl
extends AbstractCacheStateImpl {
    private final IEasClientDownloader downloader;
    private LaunchInfo jnlpLaunchInfo = null;
    private String lastCacheJnlpName = "eas.jnlp";
    private String serverCacheJnlpName = "eas.jnlp";
    private String requestedJnlpName = "eas.jnlp";
    private URL kdjnlpEntriesUrl = null;
    private URL easClientCodeBase = null;
    private String localDirName;
    private File serverCacheBaseDir;
    private String lastServerCacheDir = "cache";
    private String serverJnlpVersion = "5.1.0.0";
    public static String lstJnlpVersion;
    private String localResxFilted = "/logs/,/cache/,/classloader/kdclassloader.jar,/classloader/eas.policy,onDemandTrace.properties,update.properties";
    private String relativeResxPaths = "/";
    private JnlpServerCtrlParameter ctrlParams = null;
    private DownloadTraceInfo traceInfo = null;
    private boolean isDelete = false;
    static final /* synthetic */ boolean $assertionsDisabled;

    public CacheStateImpl(String jnlpUrl, String localPath, String modifyFileName, String ondemandjnlpF, String fulljnlpF) throws CacheException, DownloadException, ParseException {
        super(jnlpUrl, localPath);
        this.initParam(jnlpUrl, localPath, modifyFileName, ondemandjnlpF, fulljnlpF);
        this.downloader = EasClientDownloaderFactory.getDownloader(this.jnlp.getProtocol());
        ConsoleLogger.info("now call CacheStateImpl.....");
        DownloadException excep = null;
        try {
            this.loadServerCache();
        }
        catch (CacheException e) {
            throw e;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (DownloadException e) {
            excep = e;
            ConsoleLogger.info("server eas.jnlp download fail.");
            this.serverCache = null;
            this.jnlpLaunchInfo = null;
        }
        this.ctrlParams = this.parseServerJnlpCtrlParam();
        if (!this.ctrlParams.isAutoUpdate()) {
            this.isNeedUpdate = false;
            this.isNeedDelete = false;
            return;
        }
        this.checkLocalCacheFile();
        this.loadLocalCache(this.lastCacheJnlpName);
        if (this.localCache == null && this.serverCache == null && excep != null) {
            throw excep;
        }
        if (this.localCache == null) {
            this.isNeedUpdate = true;
            this.isLocalNoCache = true;
            this.fetchAllResources();
        } else if (this.serverCache != null) {
            this.fetchAllResources();
            this.compare(this.localCache, this.serverCache);
            if (this.getUpdatedResources().size() > 0) {
                this.isNeedUpdate = true;
            }
            boolean jnlpCreatedByLocalScan = new Boolean(URLUtils.getParameter(this.localCache.getHref().getQuery(), "jnlpCreatedByLocalScan"));
            if (this.getDeletedResources().size() > 0 && this.isDelete) {
                this.isNeedDelete = true;
            }
        }
    }

    private JnlpServerCtrlParameter parseServerJnlpCtrlParam() {
        JnlpServerCtrlParameter params = null;
        if (this.serverCache != null) {
            params = JnlpServerCtrlParamsUtils.parse(this.serverCache.getHref());
        } else {
            params = new JnlpServerCtrlParameter();
            params.setAutoUpdate(false);
        }
        return params;
    }

    private void doVerSwitch(int maxVerCopyCount) {
        if (DownloadTraceUtil.getJnlpVersionFilesCount(this.traceInfo.getJnlpVersionFiles()) < maxVerCopyCount) {
            long startBackup = System.currentTimeMillis();
            File destDir = this.assembleBackupDir(this.baseDir, this.traceInfo.getJnlpVersion());
            try {
                FileManager.copyDir(this.baseDir, destDir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            long costBackup = System.currentTimeMillis() - startBackup;
            ConsoleLogger.info(" Backup old client to " + destDir.toString() + " spent " + costBackup + " ms.");
        }
        if (this.isExistsCurVer(this.baseDir, this.serverJnlpVersion)) {
            long startRestore = System.currentTimeMillis();
            File libDir = new File(this.baseDir, "lib");
            if (libDir.exists()) {
                libDir.delete();
            }
            File backupDir = this.assembleBackupDir(this.baseDir, this.serverJnlpVersion);
            try {
                FileManager.copyDir(backupDir, this.baseDir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            long costRestore = System.currentTimeMillis() - startRestore;
            ConsoleLogger.info(" Restore old version client from " + backupDir.toString() + " spent " + costRestore + " ms.");
            this.checkLocalCacheFile();
            this.loadLocalCache(this.lastCacheJnlpName);
            long reloadOldCache = System.currentTimeMillis() - startRestore - costRestore;
            ConsoleLogger.info(" Reload old version cache  spent " + reloadOldCache + " ms.");
        }
    }

    private void initParam(String jnlpUrl, String localPath, String modifyFileName, String ondemandjnlpF, String fulljnlpF) {
        int existQuery;
        this.localDirName = localPath;
        String easClientCodeBaseStr = jnlpUrl.substring(0, jnlpUrl.lastIndexOf("/"));
        if (easClientCodeBaseStr != null && !easClientCodeBaseStr.endsWith("/")) {
            easClientCodeBaseStr = easClientCodeBaseStr + "/";
        }
        try {
            this.easClientCodeBase = new URL(easClientCodeBaseStr);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        String jnlpFileName = jnlpUrl.substring(jnlpUrl.lastIndexOf("/") + 1);
        if (jnlpFileName != null && !"".equals(jnlpFileName)) {
            this.requestedJnlpName = jnlpFileName;
        }
        this.lastCacheJnlpName = this.requestedJnlpName.substring(0, (existQuery = this.requestedJnlpName.indexOf("?")) > -1 ? existQuery : this.requestedJnlpName.length());
        this.traceInfo = DownloadTraceUtil.load(this.baseDir, modifyFileName, this.lastCacheJnlpName);
        try {
            this.kdjnlpEntriesUrl = new URL(easClientCodeBaseStr + this.requestedJnlpName);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        ConsoleLogger.info("requestedJnlpUrl:" + this.kdjnlpEntriesUrl.toString());
        this.serverCacheBaseDir = new File(this.baseDir, this.lastServerCacheDir);
        if (!this.serverCacheBaseDir.exists()) {
            this.serverCacheBaseDir.mkdirs();
        }
    }

    private void loadServerCache() throws DownloadException, CacheException, ParseException {
        JnlpVersionInfo info;
        long start = System.currentTimeMillis();
        String serverCacheJnlpFile = this.requestedJnlpName;
        if (this.requestedJnlpName.indexOf("?") > -1) {
            serverCacheJnlpFile = this.requestedJnlpName.substring(0, this.requestedJnlpName.indexOf("?"));
        }
        if (!this.isNewestJnlp(info = this.downloadJnlpVersion())) {
            this.downloader.download(this.easClientCodeBase, this.kdjnlpEntriesUrl, this.serverCacheBaseDir);
            ConsoleLogger.info("dowoload server jnlp[" + this.kdjnlpEntriesUrl + "],spent [" + (System.currentTimeMillis() - start) + "ms]");
            this.storeJnlpVersion(info);
            if (this.requestedJnlpName != null && this.requestedJnlpName.indexOf("resource.lst") >= 0) {
                DownloadTraceUtil.storeTraceInfo(this.traceInfo);
            }
        } else {
            ConsoleLogger.info("client has the newest jnlp,so dont't need download again");
        }
        start = System.currentTimeMillis();
        try {
            this.serverCache = EASJnlpCacheEntryManager.load(this.serverCacheBaseDir, serverCacheJnlpFile);
        }
        catch (CacheException ex) {
            System.out.println("server cache file is error,redownload it ...");
            this.downloader.download(this.easClientCodeBase, this.kdjnlpEntriesUrl, this.serverCacheBaseDir);
            ConsoleLogger.info("dowoload server jnlp[" + this.kdjnlpEntriesUrl + "],spent [" + (System.currentTimeMillis() - start) + "ms]");
            this.storeJnlpVersion(info);
            if (this.requestedJnlpName != null && this.requestedJnlpName.indexOf("resource.lst") >= 0) {
                DownloadTraceUtil.storeTraceInfo(this.traceInfo);
            }
            this.serverCache = EASJnlpCacheEntryManager.load(this.serverCacheBaseDir, serverCacheJnlpFile);
        }
        ConsoleLogger.info("load server jnlp[" + serverCacheJnlpFile + "],spent [" + (System.currentTimeMillis() - start) + "ms]");
        start = System.currentTimeMillis();
        File jnlpFile = new File(this.serverCacheBaseDir, serverCacheJnlpFile);
        this.jnlpLaunchInfo = JNLParser.parse((File)jnlpFile);
        ConsoleLogger.info("parse server jnlp[" + serverCacheJnlpFile + "],spent [" + (System.currentTimeMillis() - start) + "ms]");
    }

    private JnlpVersionInfo downloadJnlpVersion() {
        JnlpVersionInfo info = new JnlpVersionInfo();
        try {
            int index;
            URL jnlpVersionURL = new URL(this.easClientCodeBase.toString() + "JnlpVersion");
            URLConnection cn = jnlpVersionURL.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(((HttpURLConnection)cn).getInputStream()));
            String fulljnlpVersionStr = in.readLine();
            String fulljnlpVersion = "";
            String ondemandJnlpVersionStr = in.readLine();
            String ondemandJnlpVersion = "";
            if (fulljnlpVersionStr != null && fulljnlpVersionStr.substring(0, index = fulljnlpVersionStr.indexOf("=")).equals("fullJnlpVersion")) {
                fulljnlpVersion = fulljnlpVersionStr.substring(index + 1);
                ConsoleLogger.info("server  fulljnlpversion [" + fulljnlpVersion + "]");
            }
            if (ondemandJnlpVersionStr != null && ondemandJnlpVersionStr.substring(0, index = ondemandJnlpVersionStr.indexOf("=")).equals("ondemandJnlpVersion")) {
                ondemandJnlpVersion = ondemandJnlpVersionStr.substring(index + 1);
                ConsoleLogger.info("server  ondemandJnlpVersion [" + ondemandJnlpVersion + "]");
            }
            info.setFulljnlpVersion(fulljnlpVersion);
            info.setOndemandJnlpVersion(ondemandJnlpVersion);
        }
        catch (IOException e) {
            ConsoleLogger.info("Local jnlpversion from remote server error!");
            e.printStackTrace();
        }
        return info;
    }

    private boolean isNewestJnlp(JnlpVersionInfo info) {
        boolean demand;
        String fulljnlpVersion = this.traceInfo.getFulljnlpversion();
        String ondemandJnlpVersion = this.traceInfo.getOndemandjnlpversion();
        boolean full = fulljnlpVersion != null && fulljnlpVersion.equals(info.getFulljnlpVersion());
        boolean bl = demand = ondemandJnlpVersion != null && ondemandJnlpVersion.equals(info.getOndemandJnlpVersion());
        return full && demand;
    }

    private void storeJnlpVersion(JnlpVersionInfo info) {
        this.traceInfo.setFulljnlpversion(info.getFulljnlpVersion());
        this.traceInfo.setOndemandjnlpversion(info.getOndemandJnlpVersion());
    }

    private void loadLocalCache(String localEasJnlpName) {
        long start = System.currentTimeMillis();
        try {
            this.localCache = EASJnlpCacheEntryManager.load(this.baseDir, localEasJnlpName);
        }
        catch (Exception e) {
            ConsoleLogger.info("Local eas.jnlp is invalid xml file!");
            e.printStackTrace();
            this.localCache = null;
        }
        ConsoleLogger.info("load local " + localEasJnlpName + ",spent [" + (System.currentTimeMillis() - start) + " ms]");
    }

    private boolean isExistsCurVer(File baseDir, String newJnlpVersion) {
        File backupDir = this.assembleBackupDir(baseDir, newJnlpVersion);
        return backupDir.exists();
    }

    private File assembleBackupDir(File dir, String versionStr) {
        String dirName = dir.getParent();
        String currentPath = dir.getName() + "_" + versionStr.replace('.', '_');
        return new File(dirName, currentPath);
    }

    private boolean isOldAutoUpdate() {
        File fl = new File(this.baseDir, this.lastCacheJnlpName);
        return this.lastCacheJnlpName.indexOf("jnlp") >= 0 && fl.exists() && fl.length() > 10240L;
    }

    private void checkLocalCacheFile() {
        this.serverCacheJnlpName = this.ctrlParams.getServerCacheJnlpName();
        this.serverJnlpVersion = this.ctrlParams.getJnlpVersion();
        String tempStr = DownloadTraceUtil.getLastestSysVersion(this.traceInfo.getJnlpVersionFiles());
        if (!"".equals(tempStr)) {
            this.lastCacheJnlpName = tempStr;
        }
        if (this.isVerSwitch(this.lastCacheJnlpName, this.serverCacheJnlpName) && this.lastCacheJnlpName.endsWith(".jnlp")) {
            this.deleteOtherJnlp(this.serverCacheJnlpName);
            ResourceVerUtil.deleteAllCacheFile(new File(this.baseDir.toString() + "/cache/"));
            this.lastCacheJnlpName = this.serverCacheJnlpName;
            lstJnlpVersion = this.serverJnlpVersion;
        }
        File fl = new File(this.baseDir, this.lastCacheJnlpName);
        if (!this.traceInfo.isDownloadCompleted() || !fl.exists()) {
            ConsoleLogger.info("continue to download jar files from last break point.");
            try {
                String lastJnlpName = this.lastCacheJnlpName;
                String jnlpStr = this.serverCache.getCodebase().toString();
                int idx = jnlpStr.lastIndexOf(47);
                if (idx > -1) {
                    jnlpStr = jnlpStr.substring(0, idx) + "/" + lastJnlpName;
                }
                long startTime = System.currentTimeMillis();
                if (this.ctrlParams.getResItemsExcluded() != null && !"".equals(this.ctrlParams.getResItemsExcluded())) {
                    this.localResxFilted = this.ctrlParams.getResItemsExcluded().replaceAll(this.ctrlParams.getSeperator(), ",");
                }
                if (this.ctrlParams.getResPaths() != null && !"".equals(this.ctrlParams.getResPaths())) {
                    this.relativeResxPaths = this.ctrlParams.getResPaths().replaceAll(this.ctrlParams.getSeperator(), ",");
                }
                new CreateJNLPResource().createLocalJNLPResource(this.localDirName, this.traceInfo.getTraceFileName(), jnlpStr, this.localResxFilted, this.relativeResxPaths);
                String newValueOfJnlpFiles = DownloadTraceUtil.refactorJnlpVersionFilesValue(this.traceInfo.getJnlpVersionFiles(), lastJnlpName);
                this.traceInfo.setJnlpVersionFiles(newValueOfJnlpFiles);
                this.traceInfo.setDownloadCompleted(true);
                if (this.serverJnlpVersion == null) {
                    this.traceInfo.setJnlpVersion(lstJnlpVersion);
                } else {
                    this.traceInfo.setJnlpVersion(this.serverJnlpVersion);
                }
                DownloadTraceUtil.storeTraceInfo(this.traceInfo);
                ConsoleLogger.info("create local JNLP resource,spent [" + (System.currentTimeMillis() - startTime) + "ms]");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isVerSwitch(String localEasJnlpName, String serverJnlpFileName) {
        boolean result = false;
        if (localEasJnlpName != null) {
            boolean bl = result = !localEasJnlpName.equalsIgnoreCase(serverJnlpFileName);
            if (System.getProperty("isDelete", "false").equalsIgnoreCase("true")) {
                this.isDelete = true;
            }
        }
        if (result) {
            this.isDelete = true;
        }
        return result;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean testConnect(URL urlConn, int timeOut) throws Exception {
        boolean result = false;
        if (urlConn == null) {
            return result;
        }
        if (timeOut < 1) {
            timeOut = 1000;
        }
        String host = urlConn.getHost();
        int port = urlConn.getPort();
        Socket testSocket = new Socket();
        InetSocketAddress inetSocketAddr = new InetSocketAddress(host, port);
        testSocket.connect(inetSocketAddr, timeOut);
        result = true;
        Object var10_8 = null;
        if (!testSocket.isConnected()) return result;
        try {
            testSocket.close();
            return result;
        }
        catch (IOException e1) {
            ConsoleLogger.info("socket close fails.");
            e1.printStackTrace();
        }
        return result;
        {
            catch (Exception e) {
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (!testSocket.isConnected()) throw throwable;
            try {
                testSocket.close();
                throw throwable;
            }
            catch (IOException e1) {
                ConsoleLogger.info("socket close fails.");
                e1.printStackTrace();
            }
            throw throwable;
        }
    }

    private void fetchAllResources() {
        this.dirtyResources.clear();
        List allCacheEntries = this.serverCache.getCacheEntries();
        this.dirtyResources.addAll(allCacheEntries);
    }

    private void appendJnlp() {
        EASCacheEntryInfo jnlpCacheEntry = new EASCacheEntryInfo(this.serverCache.getHref(), this.serverCache.lastModified());
        this.dirtyResources.add(jnlpCacheEntry);
    }

    private void compare(EASJNLPCacheEntryInfo localCache, EASJNLPCacheEntryInfo serverCache) {
        long start = System.currentTimeMillis();
        if (!($assertionsDisabled || localCache != null && serverCache != null)) {
            throw new AssertionError();
        }
        Map localResources = this.toMap(localCache);
        String[] resExclude = null;
        Iterator<Object> it = serverCache.getCacheEntries().iterator();
        EASCacheEntryInfo entry = null;
        String temp = null;
        while (it.hasNext()) {
            entry = (EASCacheEntryInfo)((Object)it.next());
            this.checkResource(localResources, entry);
        }
        if (this.ctrlParams != null) {
            resExclude = this.ctrlParams.getResItemsExcluded().replaceAll(this.ctrlParams.getSeperator(), ",").split(",");
        }
        if (!localResources.isEmpty()) {
            it = localResources.entrySet().iterator();
            EASCacheEntryInfo localEntry = null;
            while (it.hasNext()) {
                localEntry = (EASCacheEntryInfo)((Object)((Map.Entry)it.next()).getValue());
                temp = localEntry.getHref().toString();
                if (temp.equalsIgnoreCase(this.jnlp.toString())) continue;
                if (resExclude != null) {
                    boolean flag = false;
                    String resExcludeRes = null;
                    for (int i = 0; i < resExclude.length; ++i) {
                        resExcludeRes = resExclude[i];
                        if (temp.indexOf(resExcludeRes) < 0 && temp.indexOf("apploader.lst") < 0) continue;
                        flag = true;
                        break;
                    }
                    if (flag) continue;
                    this.deletedResources.add(localEntry);
                    continue;
                }
                this.deletedResources.add(localEntry);
            }
        }
        ConsoleLogger.info("compare local and server loaded jnlp,spent [" + (System.currentTimeMillis() - start) + " ms]");
    }

    private void checkResource(Map entries, EASCacheEntryInfo serverEntry) {
        String href = URLUtil.getRelativePath((URL)this.serverCache.getCodebase(), (URL)serverEntry.getHref());
        EASCacheEntryInfo entry = null;
        String version = null;
        if (entries.containsKey(href)) {
            entry = (EASCacheEntryInfo)((Object)entries.get(href));
            version = entry.getMd5Version();
            if (version == null || "".equals(version)) {
                if (entry.lastModified() == serverEntry.lastModified()) {
                    this.dirtyResources.remove((Object)serverEntry);
                }
            } else if (serverEntry.getMd5Version() == null) {
                if (entry.lastModified() == serverEntry.lastModified()) {
                    this.dirtyResources.remove((Object)serverEntry);
                }
            } else if (serverEntry.getMd5Version().equals(version)) {
                this.dirtyResources.remove((Object)serverEntry);
            }
            entries.remove(href);
        }
    }

    public LaunchInfo getJnlpLaunchInfo() {
        return this.jnlpLaunchInfo;
    }

    public EASJNLPCacheEntryInfo getServerCache() {
        return this.serverCache;
    }

    public void storeCacheState(HashMap failEntries) throws CacheException {
        String currentJnlp;
        String serverJnlpFileName = currentJnlp = this.updateLocalEntries(failEntries);
        String newValueOfJnlpFiles = DownloadTraceUtil.refactorJnlpVersionFilesValue(this.traceInfo.getJnlpVersionFiles(), serverJnlpFileName);
        if (!"".equals(newValueOfJnlpFiles)) {
            this.traceInfo.setJnlpVersionFiles(newValueOfJnlpFiles);
            this.traceInfo.setDownloadCompleted(true);
            if (this.serverJnlpVersion == null) {
                this.traceInfo.setJnlpVersion(lstJnlpVersion);
            } else {
                this.traceInfo.setJnlpVersion(this.serverJnlpVersion);
            }
            DownloadTraceUtil.storeTraceInfo(this.traceInfo);
        }
    }

    private String updateLocalEntries(HashMap failEntries) throws CacheException {
        EASJNLPCacheEntryInfo cache = this.getServerCacheEntryInfo();
        EASJNLPCacheEntryInfo tmp = null;
        if (failEntries != null && !failEntries.isEmpty()) {
            tmp = new EASJNLPCacheEntryInfo(cache.getCodebase(), cache.getHref(), cache.lastModified(), cache.getMd5Version());
            Iterator cacheIte = cache.getCacheEntries().iterator();
            EASCacheEntryInfo entry = null;
            while (cacheIte.hasNext()) {
                entry = (EASCacheEntryInfo)((Object)cacheIte.next());
                if (failEntries.containsKey(entry.getHref().toString())) continue;
                tmp.addCacheEntry(new EASCacheEntryInfo(entry.getHref(), entry.lastModified(), entry.getMd5Version()));
            }
        } else {
            tmp = cache;
        }
        return CreateJNLPResource.store(this.baseDir, this.getJnlpLaunchInfo(), tmp);
    }

    private void deleteOtherJnlp(String excludeJnlp) {
        File folder = this.baseDir;
        if (folder.isDirectory()) {
            String[] files = folder.list();
            File currentFile = null;
            String fileName = null;
            for (int i = 0; i < files.length; ++i) {
                currentFile = new File(this.baseDir, files[i]);
                fileName = currentFile.getName();
                if (!currentFile.isFile() || !fileName.endsWith(".jnlp") && !fileName.endsWith(".lst") || fileName.equalsIgnoreCase(excludeJnlp) || fileName.equalsIgnoreCase("apploader.lst")) continue;
                currentFile.delete();
                ConsoleLogger.info(" delete local other jnlp file:" + fileName);
            }
        }
    }

    public void startTrace() {
        this.traceInfo.setDownloadCompleted(false);
        DownloadTraceUtil.storeTraceInfo(this.traceInfo);
    }

    static {
        $assertionsDisabled = !CacheStateImpl.class.desiredAssertionStatus();
        lstJnlpVersion = "5.1.0.0";
    }
}

