/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.autoupdate;

import com.kingdee.eas.applet.EASCacheEntryInfo;
import com.kingdee.eas.applet.autoupdate.ResourceVerInfo;
import com.kingdee.eas.webutil.ConsoleLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ResourceVerUtil {
    public static final String Jar_NAME = "jarName";
    public static final String Last_Modify = "lastModify";
    public static final String MD5_Value = "md5";

    public static void save(File baseDir, EASCacheEntryInfo jarInfo) {
        File localDir = new File(baseDir.toString() + "/cache/");
        Properties prop = ResourceVerUtil.toProp(jarInfo);
        int index = jarInfo.getHref().getFile().lastIndexOf("/");
        String cacheFileName = jarInfo.getHref().getFile().substring(index);
        ResourceVerUtil.storeJarCacheFiles(localDir, prop, cacheFileName);
    }

    public static Properties toProp(EASCacheEntryInfo jarInfo) {
        Properties properties = new Properties();
        properties.setProperty(Jar_NAME, jarInfo.getHref().toString());
        properties.setProperty(Last_Modify, jarInfo.lastModified() + "");
        properties.setProperty(MD5_Value, jarInfo.getMd5Version());
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeJarCacheFiles(File baseDir, Properties properties, String cacheFileName) {
        if (properties == null) {
            throw new NullPointerException();
        }
        String traceFile = cacheFileName + ".trace";
        try {
            File updateFile = new File(baseDir, traceFile);
            if (updateFile.exists()) {
                updateFile.delete();
            }
            updateFile.createNewFile();
            File file = updateFile;
            synchronized (file) {
                FileOutputStream fos = new FileOutputStream(updateFile);
                properties.store(fos, null);
                fos.close();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ResourceVerInfo read(File baseDir, File cacheFile) {
        ConsoleLogger.info("load " + baseDir + "," + cacheFile.getName());
        Properties properties = null;
        properties = ResourceVerUtil.readcacheFile(baseDir, cacheFile.getName());
        String herf = properties.getProperty(Jar_NAME);
        String lastModify = properties.getProperty(Last_Modify);
        String md5 = properties.getProperty(MD5_Value);
        ResourceVerInfo info = new ResourceVerInfo();
        info.setHerf(herf);
        info.setMd5(md5);
        info.setLastModified(lastModify);
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readcacheFile(File baseDir, String updateTraceFileName) {
        File updatecacheFile = new File(baseDir, updateTraceFileName);
        Properties properties = new Properties();
        if (updatecacheFile.exists()) {
            try {
                FileInputStream inputStream = null;
                File file = updatecacheFile;
                synchronized (file) {
                    inputStream = new FileInputStream(updatecacheFile);
                }
                properties.load(inputStream);
                inputStream.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return properties;
    }

    public static List readAll(File baseDir) {
        File[] cacheFile;
        ArrayList<ResourceVerInfo> list = new ArrayList<ResourceVerInfo>();
        if (baseDir.isDirectory() && (cacheFile = baseDir.listFiles()) != null && cacheFile.length > 0) {
            int length = cacheFile.length;
            for (int i = 0; i < length; ++i) {
                ResourceVerInfo resVerINfo;
                File cacheTrace = cacheFile[i];
                if (!cacheTrace.getName().endsWith(".trace") || (resVerINfo = ResourceVerUtil.read(baseDir, cacheTrace)).getHerf() == null || resVerINfo.getLastModified() == null || resVerINfo.getMd5() == null) continue;
                list.add(resVerINfo);
            }
        }
        return list;
    }

    public static void deleteAllCacheFile(File baseDir) {
        File[] cacheFile;
        if (baseDir != null && baseDir.isDirectory() && (cacheFile = baseDir.listFiles()) != null && cacheFile.length > 0) {
            int length = cacheFile.length;
            for (int i = 0; i < length; ++i) {
                if (!cacheFile[i].getName().endsWith(".trace")) continue;
                cacheFile[i].delete();
            }
        }
    }
}

