/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.framework;

import com.kingdee.bos.autoupdate.JNLPException;
import com.kingdee.bos.autoupdate.cache.CacheException;
import com.kingdee.bos.autoupdate.dl.DownloadException;
import com.kingdee.bos.autoupdate.jnl.JARInfo;
import com.kingdee.bos.autoupdate.jnl.JNLParser;
import com.kingdee.bos.autoupdate.jnl.LaunchInfo;
import com.kingdee.bos.autoupdate.jnl.ParseException;
import com.kingdee.bos.autoupdate.jnl.ResourceInfo;
import com.kingdee.bos.autoupdate.util.URLUtil;
import com.kingdee.eas.applet.AppletSmartClassLoader;
import com.kingdee.eas.applet.EasClientUpdater;
import com.kingdee.eas.applet.framework.AppletRuningException;
import com.kingdee.eas.applet.framework.AppletThreadServiceAdapter;
import com.kingdee.eas.applet.framework.EmbedUIAppletContainer;
import com.kingdee.eas.applet.framework.NoIdleThreadException;
import com.kingdee.eas.applet.framework.ThreadManager;
import com.kingdee.eas.applet.framework.ThreadService;
import com.kingdee.eas.webutil.ConsoleLogger;
import com.kingdee.eas.webutil.VMoptions;
import java.applet.Applet;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.prefs.Preferences;
import javax.swing.JApplet;
import netscape.javascript.JSObject;
import sun.plugin.security.PluginClassLoader;

public class LazyLoadJarsManager
extends AppletThreadServiceAdapter {
    private ClassLoader cl = ClassLoader.getSystemClassLoader();
    private Thread lazyLoadJarThread = null;
    private int maxThreadCount = 1;
    private String lazyLoadLocalJars;
    private String jsEventAfterLazyLoaded;
    private JApplet applet = null;
    private EmbedUIAppletContainer container = null;
    private File localDir = null;
    private static final String DEFAULT_JNLP = "resource.lst";
    private String jnlpURLStr = "resource.lst";
    private String resxURLStr = "resource.lst";
    private static final String JNLP_UPDATE_TRACE_FILE = "update.properties";
    private static final String JNLP_OnDemand_UPDATE_TRACE_FILE = "onDemandTrace.properties";
    private String jarPathIncluded = "c:/kingdee/eas/client/lib/";
    private URL[] localJarUrls = null;
    private EasClientUpdater updater = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public LazyLoadJarsManager(EmbedUIAppletContainer container, File baseDir) {
        this.applet = container.getApplet();
        this.container = container;
        this.localDir = baseDir;
    }

    private String getEasClientHome() {
        Preferences pref = Preferences.systemRoot().node("kingdee/eas");
        String requestHost = this.applet.getParameter("requestHost");
        String easClientHome = null;
        if (requestHost != null && !"".equals(requestHost)) {
            easClientHome = pref.get(requestHost + "_easclienthome", null);
        }
        if (requestHost == null || "".equals(requestHost)) {
            easClientHome = pref.get("easclienthome", null);
        }
        if (easClientHome == null) {
            easClientHome = "c:/kingdee/eas/client";
        }
        return easClientHome;
    }

    protected void autoUpdate() throws AppletRuningException {
        long start = System.currentTimeMillis();
        try {
            String localDirName = this.getEasClientHome();
            this.localDir = new File(localDirName);
            this.initJnlpURLStr(this.localDir);
            URL jnlpURL = new URL(this.getJnlpURLStr());
            if (jnlpURL == null || this.localDir == null) {
                throw new IllegalArgumentException("Please set jnlpURL and localDir!");
            }
            if (!this.localDir.exists()) {
                this.localDir.mkdirs();
            }
            if (!this.localDir.isDirectory()) {
                throw new IllegalArgumentException("The localDir is not a directory!");
            }
            File log4j = new File(this.localDir, "logs");
            if (!log4j.exists()) {
                log4j.mkdirs();
            }
            System.setProperty("EAS_HOME", this.localDir.getParent().toString());
            System.setProperty("EAS_SERVER", this.applet.getParameter("appserver"));
            String _fileServerUrl = this.applet.getParameter("fileServerUrl");
            if (_fileServerUrl == null || _fileServerUrl.equals("")) {
                String strJnlpURL = jnlpURL.toString();
                int index = strJnlpURL.lastIndexOf("/");
                _fileServerUrl = strJnlpURL.substring(0, index);
            }
            System.setProperty("UPDATE_SERVER", _fileServerUrl);
            System.setProperty("java.library.path", this.localDir.toString() + "\\" + "deploy\\client\\javalib");
            VMoptions vm = new VMoptions();
            vm.initSystemPor();
            LaunchInfo launchInfo = this.getLaunchInfo(this.localDir);
            this.localJarUrls = this.getResources(this.localDir, launchInfo);
            this.jarPathIncluded = localDirName + "/lib/";
        }
        catch (MalformedURLException e) {
            throw new AppletRuningException(AppletRuningException.INVALID_URL, e);
        }
        catch (JNLPException e) {
            throw new AppletRuningException(AppletRuningException.INVALID_EAS_JNLP, e);
        }
        long cost = System.currentTimeMillis() - start;
        ConsoleLogger.info("Auto update : " + cost + "ms!");
    }

    private LaunchInfo getLaunchInfo(File baseDir) throws ParseException {
        String jnlpFileName = this.getJnlpURLStr();
        if (jnlpFileName != null) {
            int idxQ;
            int idx = jnlpFileName.lastIndexOf("/");
            if (idx > -1 && (idxQ = (jnlpFileName = jnlpFileName.substring(idx)).indexOf("?")) > -1) {
                jnlpFileName = jnlpFileName.substring(0, idxQ);
            }
        } else {
            jnlpFileName = "eas.jnlp";
        }
        File jnlpFile = new File(baseDir, jnlpFileName);
        return JNLParser.parse((File)jnlpFile);
    }

    private URL[] getResources(File localDir, LaunchInfo launchInfo) throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>();
        File tmp = null;
        ResourceInfo resource = null;
        ResourceInfo[] resources = launchInfo.getResources().getResources();
        int len = resources.length;
        for (int i = 0; i < len; ++i) {
            resource = resources[i];
            if (!(resource instanceof JARInfo)) continue;
            tmp = new File(localDir, URLUtil.getRelativePath((URL)launchInfo.getCodebase(), (URL)resource.getHref()));
            urls.add(tmp.toURL());
        }
        return urls.toArray(new URL[0]);
    }

    private String getJnlpUrl() {
        String jnlpUrl = this.applet.getParameter("jnlpURL");
        return jnlpUrl;
    }

    private void initJnlpURLStr(File baseDir) {
        String jnlpUpdateTraceFile;
        String jnlpURLPrefix = this.getJnlpUrl();
        int idx = jnlpURLPrefix.lastIndexOf("/");
        if (idx > -1) {
            jnlpURLPrefix = jnlpURLPrefix.substring(0, idx);
        }
        if (!jnlpURLPrefix.endsWith("/")) {
            jnlpURLPrefix = jnlpURLPrefix + "/";
        }
        if ((jnlpUpdateTraceFile = this.applet.getParameter("jnlpUpdateTraceFile")) == null || "".equals(jnlpUpdateTraceFile)) {
            jnlpUpdateTraceFile = this.isOnDemandStyle() ? JNLP_UPDATE_TRACE_FILE : JNLP_OnDemand_UPDATE_TRACE_FILE;
        }
        Properties props = this.readUpdatePropertiesFile(baseDir, jnlpUpdateTraceFile);
        String jnlpFiles = props.getProperty("jnlpVersionFiles", DEFAULT_JNLP);
        String[] jnlpFile = jnlpFiles.split(",");
        this.jnlpURLStr = jnlpURLPrefix + jnlpFile[jnlpFile.length - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Properties readUpdatePropertiesFile(File baseDir, String updateTraceFileName) {
        File updatePropertiesFile = new File(baseDir, updateTraceFileName);
        Properties properties = new Properties();
        if (updatePropertiesFile.exists()) {
            try {
                FileInputStream inputStream = null;
                LazyLoadJarsManager lazyLoadJarsManager = this;
                synchronized (lazyLoadJarsManager) {
                    inputStream = new FileInputStream(updatePropertiesFile);
                }
                properties.load(inputStream);
                inputStream.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return properties;
    }

    private String getJnlpURLStr() {
        return this.jnlpURLStr;
    }

    private boolean isOnDemandStyle() {
        return this.cl instanceof AppletSmartClassLoader;
    }

    protected void initClassLoader() {
        long start = System.currentTimeMillis();
        ConsoleLogger.info("CurrentClassLoader: " + this.getClass().getClassLoader());
        ConsoleLogger.info("SystemClassLoader: " + this.cl.getClass().getName());
        if (!(this.cl instanceof AppletSmartClassLoader)) {
            this.cl = this.applet.getClass().getClassLoader();
            this.cl = new AppletSmartClassLoader(this.cl);
        }
        String jnlpURL = this.getJnlpUrl();
        final HashMap md5Version = new HashMap();
        URL url = null;
        URL resxURL = null;
        try {
            url = new URL(jnlpURL);
            resxURL = new URL(url, this.resxURLStr);
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        try {
            this.updater = new EasClientUpdater(resxURL.toString(), this.localDir.toString(), JNLP_OnDemand_UPDATE_TRACE_FILE, "", "", 2, 1);
        }
        catch (DownloadException e) {
            this.container.handleException("EAS_JNLP_DOWNLOAD_FAILS", (Exception)((Object)e));
            e.printStackTrace();
            return;
        }
        catch (CacheException e) {
            this.container.handleException("INVALID_EAS_JNLP", (Exception)((Object)e));
            e.printStackTrace();
            return;
        }
        catch (ParseException e) {
            this.container.handleException("INVALID_EAS_JNLP", (Exception)((Object)e));
            e.printStackTrace();
            return;
        }
        AppletSmartClassLoader loader = (AppletSmartClassLoader)this.cl;
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        loader.setCurrentClassLoader(this.getClass().getClassLoader());
        AppletSmartClassLoader.ClassLoaderListener cll = new AppletSmartClassLoader.ClassLoaderListener(){
            String localHome;
            String remoteHome;
            {
                this.localHome = LazyLoadJarsManager.this.localDir.toString();
                this.remoteHome = System.getProperty("UPDATE_SERVER");
            }

            public String getLocalPath() {
                return this.localHome;
            }

            public String getRemoteServer() {
                return this.remoteHome;
            }

            public HashMap getResourceMap() {
                return md5Version;
            }

            public boolean updateResource(String relativePath) {
                return LazyLoadJarsManager.this.updater.updateResource(relativePath);
            }
        };
        loader.setClassLoaderListener(cll);
        long cost = System.currentTimeMillis() - start;
        ConsoleLogger.info("Init Smartclassloader : " + cost + "ms!");
    }

    private boolean isJarIncluded(URL url) {
        boolean result = false;
        if (url != null) {
            if (url.toString().indexOf(this.jarPathIncluded) > -1) {
                result = true;
            } else {
                ConsoleLogger.info("local jar :" + url.toString() + ",jarPathIncluded=" + this.jarPathIncluded);
                result = false;
            }
        }
        return result;
    }

    protected String getRelativePath(URL codebase, URL resource) {
        if (!$assertionsDisabled && codebase == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && resource == null) {
            throw new AssertionError();
        }
        String codebasePath = codebase.getPath();
        String resourcePath = resource.getPath();
        if (codebasePath.length() == 0) {
            return resourcePath;
        }
        if (resourcePath.startsWith(codebasePath)) {
            return "/" + resourcePath.substring(codebasePath.length());
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("invalidate codebase[" + codebasePath + "] and resource[" + resourcePath + "]"));
        }
        return null;
    }

    public void lazyLoadLocalJar_performed(String jars, String jsEvent) throws NoIdleThreadException {
        this.lazyLoadJarThread = ThreadManager.getInstance(this);
        this.lazyLoadLocalJars = jars;
        this.jsEventAfterLazyLoaded = jsEvent;
        try {
            System.out.println("start lazy load local jar thread:" + ((ThreadService)this.lazyLoadJarThread).getCurrentThreadKey());
            this.lazyLoadJarThread.start();
        }
        catch (IllegalThreadStateException e) {
            e.printStackTrace();
            ConsoleLogger.info(" lazy load jar thread [" + ((ThreadService)this.lazyLoadJarThread).getCurrentThreadKey() + "] is started.");
            throw e;
        }
    }

    void lazyLoadLocalJar() {
        if (this.lazyLoadLocalJars == null) {
            ConsoleLogger.info("localJars is null.");
            return;
        }
        PluginClassLoader pcl = (PluginClassLoader)this.getClass().getClassLoader();
        String[] localJars = this.lazyLoadLocalJars.split(",");
        for (int i = 0; i < localJars.length; ++i) {
            File jarFile = new File(this.localDir, localJars[i]);
            JSObject win = JSObject.getWindow((Applet)this.applet);
            if (jarFile.exists()) {
                try {
                    pcl.addLocalJar(jarFile.toURL());
                    ConsoleLogger.info("loaded local jar:" + jarFile.toURL());
                    if (this.jsEventAfterLazyLoaded == null || "".equals(this.jsEventAfterLazyLoaded)) continue;
                    win.eval(this.jsEventAfterLazyLoaded + "(true)");
                }
                catch (MalformedURLException e) {
                    if (this.jsEventAfterLazyLoaded != null && !"".equals(this.jsEventAfterLazyLoaded)) {
                        win.eval(this.jsEventAfterLazyLoaded + "(false)");
                    }
                    ConsoleLogger.info("invalid url:" + jarFile);
                    e.printStackTrace();
                }
                continue;
            }
            if (this.jsEventAfterLazyLoaded == null || "".equals(this.jsEventAfterLazyLoaded)) continue;
            win.eval(this.jsEventAfterLazyLoaded + "(false)");
        }
    }

    public void run() {
        this.lazyLoadLocalJar();
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public void destory() {
        ThreadManager.destroy(this);
        this.applet = null;
        this.jsEventAfterLazyLoaded = null;
        if (this.lazyLoadJarThread != null) {
            this.lazyLoadJarThread = null;
        }
        this.lazyLoadLocalJars = null;
        this.localDir = null;
    }

    static {
        $assertionsDisabled = !LazyLoadJarsManager.class.desiredAssertionStatus();
    }
}

