/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.framework;

import com.kingdee.eas.applet.IJSParameterProvider;
import com.kingdee.eas.applet.JSParameterProviderFactory;
import com.kingdee.eas.applet.framework.AppletThreadServiceAdapter;
import com.kingdee.eas.applet.framework.EmbedUIAppletContainer;
import com.kingdee.eas.applet.framework.NoIdleThreadException;
import com.kingdee.eas.applet.framework.ThreadManager;
import com.kingdee.eas.applet.framework.ThreadService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.JApplet;

public class ShowUIManager
extends AppletThreadServiceAdapter {
    private ClassLoader cl = this.getClass().getClassLoader();
    private String exceptKey = "";
    private Class serviceProviderClass = null;
    private Object serviceProvider = null;
    private IJSParameterProvider jsParameterProvider = null;
    private Timer timer = null;
    private EmbedUIAppletContainer container = null;
    private boolean timerScheduleModel = false;
    private Thread showUIThread = null;
    private int maxThreadCount = 1;

    public ShowUIManager(EmbedUIAppletContainer container, boolean _timerScheduleModel) {
        this.container = container;
        try {
            this.initServiceProvider();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (this.exceptKey == null || "".equals(this.exceptKey)) {
                this.exceptKey = "APPLET_INIT_FAILS";
            }
            this.handleException(this.exceptKey, e);
        }
        this.initJSParameterProvider();
        this.timerScheduleModel = _timerScheduleModel;
        if (this.isTimerScheduleModel()) {
            this.initTimer();
        }
        try {
            this.showUIThread = ThreadManager.getInstance(this);
        }
        catch (NoIdleThreadException e) {
            e.printStackTrace();
        }
    }

    public void initServiceProvider() throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchMethodException {
        System.out.println("Init service provider AppletManagerProxy start ");
        long start = System.currentTimeMillis();
        try {
            this.serviceProviderClass = this.cl.loadClass("com.kingdee.eas.base.uiframe.client.AppletManagerProxy");
            System.out.println("LoadClass serviceProvider :" + (System.currentTimeMillis() - start) + "ms");
            long start2 = System.currentTimeMillis();
            this.serviceProvider = this.serviceProviderClass.newInstance();
            System.out.println("NewInstance serviceProvider :" + (System.currentTimeMillis() - start2) + "ms");
            this.invokeService("init", new Class[]{JApplet.class, String.class}, new Object[]{this.container.getApplet(), this.getParameter("appserver")});
        }
        catch (ClassNotFoundException e) {
            this.exceptKey = "INVALID_SERVICE_PROVIDER";
            throw e;
        }
        catch (InstantiationException e) {
            this.exceptKey = "INVALID_SERVICE_PROVIDER";
            throw e;
        }
        catch (IllegalAccessException e) {
            this.exceptKey = "INVALID_SERVICE_PROVIDER";
            throw e;
        }
        long cost = System.currentTimeMillis() - start;
        System.out.println("Init service provider end : " + cost + "ms!");
    }

    private String getParameter(String param) {
        return this.container.getApplet().getParameter(param);
    }

    private void initJSParameterProvider() {
        long start = System.currentTimeMillis();
        this.jsParameterProvider = JSParameterProviderFactory.createJSParameterProvider((String)this.getParameter("JSParameterProvider"), (JApplet)this.container.getApplet());
        long cost = System.currentTimeMillis() - start;
        System.out.println("Init js parameter provider : " + cost + "ms!");
    }

    private void initTimer() {
        this.timer = new Timer();
        this.timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                1 var1_1 = this;
                synchronized (var1_1) {
                    ShowUIManager.this.showUI();
                }
            }
        }, 200L, 200L);
    }

    public void showUI_performed() throws NoIdleThreadException {
        this.showUIThread = ThreadManager.getInstance(this);
        try {
            System.out.println("start show ui thread:" + ((ThreadService)this.showUIThread).getCurrentThreadKey());
            this.showUIThread.start();
        }
        catch (IllegalThreadStateException e) {
            System.out.println("show ui thread[" + ((ThreadService)this.showUIThread).getCurrentThreadKey() + "] is started.");
            throw e;
        }
    }

    private void showUI() {
        if (this.jsParameterProvider.getInvokeMethod() != null && !"".equals(this.jsParameterProvider.getInvokeMethod())) {
            Object result = this.invokeService(this.jsParameterProvider.getInvokeMethod(), this.jsParameterProvider.getInvokeParameterTypes(), this.jsParameterProvider.getInvokeParameterValues());
            this.jsParameterProvider.setReturnValue(result);
            this.jsParameterProvider.consume();
        }
    }

    Object invokeService(String methodName, Class[] paramTypes, Object[] paramValues) {
        try {
            long start = System.currentTimeMillis();
            Method method = this.serviceProviderClass.getMethod(methodName, paramTypes);
            Object result = method.invoke(this.serviceProvider, paramValues);
            long cost = System.currentTimeMillis() - start;
            System.out.println("Invoke service " + methodName + " : " + cost + "ms!");
            return result;
        }
        catch (SecurityException e) {
            this.handleException("ACTION_PEFORM_FAILS", e);
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            this.handleException("ACTION_PEFORM_FAILS", e);
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            this.handleException("ACTION_PEFORM_FAILS", e);
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            this.handleException("ACTION_PEFORM_FAILS", e);
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            this.handleException("ACTION_PEFORM_FAILS", e);
            e.printStackTrace();
        }
        return null;
    }

    private void handleException(String msgKey, Exception e) {
        this.container.handleException(msgKey, e);
    }

    public void cancel() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void run() {
        this.showUI();
    }

    public boolean isTimerScheduleModel() {
        return this.timerScheduleModel;
    }

    public int getMaxThreadCount() {
        return this.maxThreadCount;
    }

    public void setParams(HashMap params) {
        this.jsParameterProvider.setParams(params);
    }

    public HashMap getParams() {
        return this.jsParameterProvider.getParams();
    }

    public void destory() {
        ThreadManager.destroy(this);
        this.container = null;
        this.cl = null;
        this.jsParameterProvider = null;
        this.serviceProvider = null;
        this.serviceProviderClass = null;
        this.showUIThread = null;
        if (this.timer != null) {
            this.cancel();
        }
    }
}

