/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.httpdownload;

import com.kingdee.eas.applet.httpdownload.DMConfig;
import com.kingdee.eas.applet.httpdownload.DownloadTask;
import com.kingdee.eas.applet.httpdownload.DownloadWorker;
import com.kingdee.eas.applet.httpdownload.HttpFileInfo;
import com.kingdee.eas.applet.httpdownload.util.ObjectFIFO;
import com.kingdee.eas.applet.httpdownload.util.ThreadPool;
import java.util.ArrayList;

final class DownloadManager
extends Thread {
    private static final DownloadManager instance = new DownloadManager();
    private DMConfig downloadConfig;
    private ThreadPool threadPool;
    private ObjectFIFO downloadWorkers = new ObjectFIFO(10000);

    private DownloadManager() {
        this.downloadConfig = DMConfig.getConfig();
        this.threadPool = new ThreadPool(this.downloadConfig.getTotalDownloadThreads());
        this.setName("DownloadMangerThread");
        this.start();
    }

    public static DownloadManager getInstance() {
        return instance;
    }

    DMConfig getDownloadManagerConfig() {
        return this.downloadConfig;
    }

    void runTask(DownloadTask task) throws InterruptedException {
        ArrayList list = task.getFilesToDownload();
        int filesCount = list.size();
        if (filesCount > 0) {
            for (int i = 0; i < filesCount; ++i) {
                HttpFileInfo fileToDownload = (HttpFileInfo)list.get(i);
                this.downloadWorkers.add(new DownloadWorker(task, fileToDownload));
            }
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.threadPool.execute((DownloadWorker)this.downloadWorkers.remove());
                }
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                continue;
            }
            break;
        }
    }
}

