/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.httpdownload;

import com.kingdee.eas.applet.httpdownload.DownloadManager;
import com.kingdee.eas.applet.httpdownload.DownloadTaskListener;
import com.kingdee.eas.applet.httpdownload.HttpFileInfo;
import com.kingdee.eas.applet.httpdownload.HttpSiteInfo;
import java.io.File;
import java.util.ArrayList;

public class DownloadTask {
    private int workerCount;
    private HttpSiteInfo siteInfo;
    private File localPath;
    private ArrayList fileDownloadFailed = new ArrayList();
    private DownloadTaskListener listener;
    private long downloadBytes = 0L;

    public DownloadTask(HttpSiteInfo httpSite, File localRoot, String filepath) {
        this.workerCount = 1;
        this.siteInfo = httpSite;
        this.localPath = localRoot;
        this.fileDownloadFailed.add(filepath);
    }

    public DownloadTask(HttpSiteInfo httpSite, File localRoot, String[] filepath) {
        this.workerCount = filepath.length;
        this.siteInfo = httpSite;
        this.localPath = localRoot;
        for (int i = 0; i < filepath.length; ++i) {
            this.fileDownloadFailed.add(filepath[i]);
        }
    }

    public DownloadTask(HttpSiteInfo httpSite, File localRoot, ArrayList fileList) {
        this.workerCount = fileList.size();
        this.siteInfo = httpSite;
        this.localPath = localRoot;
        this.fileDownloadFailed.addAll(fileList);
    }

    public void setListener(DownloadTaskListener dtl) {
        this.listener = dtl;
    }

    public void start() throws InterruptedException {
        if (this.workerCount > 0) {
            DownloadManager.getInstance().runTask(this);
        }
    }

    public HttpSiteInfo getSiteInfo() {
        return this.siteInfo;
    }

    public File getLocalPath() {
        return this.localPath;
    }

    ArrayList getFilesToDownload() {
        ArrayList list = new ArrayList(this.fileDownloadFailed.size());
        list.addAll(this.fileDownloadFailed);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void downloadFailed(String fileName, Throwable ex) {
        try {
            --this.workerCount;
            this.listener.doanloadFailed(fileName, ex);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void downloadSuccess(HttpFileInfo info, long dBytes) {
        try {
            --this.workerCount;
            this.downloadBytes += dBytes;
            this.fileDownloadFailed.remove(info);
            this.listener.downloadFinish(info.getFileName(), dBytes);
        }
        catch (Throwable e) {
        }
        finally {
            this.notifyAll();
        }
    }

    public void waitUntilTaskFinish() throws InterruptedException {
        while (this.workerCount > 0) {
            this.wait();
        }
    }

    public synchronized ArrayList getDownloadFailedFiles() throws InterruptedException {
        this.waitUntilTaskFinish();
        return this.fileDownloadFailed;
    }

    public synchronized long getDownloadBytes() throws InterruptedException {
        this.waitUntilTaskFinish();
        return this.downloadBytes;
    }
}

