/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.httpdownload.util;

public final class DebugLogger {
    public static final int LOG_LEVEL_TRACE = -2;
    public static final int LOG_LEVEL_DEBUG = -1;
    public static final int LOG_LEVEL_INFO = 0;
    public static final int LOG_LEVEL_WARN = 1;
    public static final int LOG_LEVEL_ERR = 2;
    private String logName = "HttpDownloader";
    private int logLevel = 2;
    private static DebugLogger instance = new DebugLogger();

    private DebugLogger() {
        this.setLogLevel(System.getProperty("HttpDownloaderLog", "info"));
    }

    public static DebugLogger getDebugLogger() {
        return instance;
    }

    public void setLogLevel(String level) {
        this.logLevel = "trace".equalsIgnoreCase(level) ? -2 : ("debug".equalsIgnoreCase(level) ? -1 : ("info".equalsIgnoreCase(level) ? 0 : ("warn".equalsIgnoreCase(level) ? 1 : 2)));
    }

    public int getLogLevel() {
        return this.logLevel;
    }

    public String getLogName() {
        return this.logName;
    }

    public void setLogName(String logName) {
        this.logName = logName;
    }

    public void trace(String msg) {
        this.trace(msg, null);
    }

    public void trace(String msg, Throwable err) {
        if (this.logLevel <= -2) {
            this.log("[TRACE]", msg, err);
        }
    }

    public void debug(String msg) {
        this.debug(msg, null);
    }

    public void debug(String msg, Throwable err) {
        if (this.logLevel <= -1) {
            this.log("[DEBUG]", msg, err);
        }
    }

    public void info(String msg) {
        this.info(msg, null);
    }

    public void info(String msg, Throwable err) {
        if (this.logLevel <= 0) {
            this.log("[INFO ]", msg, err);
        }
    }

    public void warn(String msg) {
        this.warn(msg, null);
    }

    public void warn(String msg, Throwable err) {
        if (this.logLevel <= 1) {
            this.log("[WARN ]", msg, err);
        }
    }

    public void error(String msg) {
        this.error(msg, null);
    }

    public void error(String msg, Throwable err) {
        if (this.logLevel <= 2) {
            this.log("[ERROR]", msg, err);
        }
    }

    private void log(String level, String msg, Throwable error) {
        StringBuffer buf = new StringBuffer("[").append(System.currentTimeMillis()).append("]").append(level).append("[").append(this.logName).append("]").append(" ");
        buf.append(msg);
        System.out.println(buf.toString());
        if (error != null) {
            error.printStackTrace(System.out);
        }
    }
}

