/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.multithread;

import com.kingdee.bos.autoupdate.dl.RSDownloadListener;
import com.kingdee.eas.applet.EasClientDownloaderFactory;
import com.kingdee.eas.applet.EasClientDownloaderHttpImpl;
import com.kingdee.eas.applet.IEasClientDownloader;
import com.kingdee.eas.applet.autoupdate.Logger;
import com.kingdee.eas.applet.multithread.DownBytesContainer;
import com.kingdee.eas.applet.multithread.IFileSizeRange;
import com.kingdee.eas.applet.multithread.IMultiDownloader;
import com.kingdee.eas.applet.multithread.SingleThreadDownloadThread;
import com.kingdee.eas.applet.multithread.SingleThreadFileAccessInfo;
import com.kingdee.eas.applet.multithread.WriteFileThread;
import com.kingdee.eas.webutil.URLUtils;
import com.twmacinta.util.MD5;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;

public class MultiThreadDownLoadImpl
implements IMultiDownloader {
    private Logger logger = Logger.getInstance();
    private static final String PRAGMA = "pragma";
    private static final String NO_CACHE = "no-cache";
    URL codebase = null;
    URL resource = null;
    String fileName = null;
    File localFile = null;
    File rootPath = null;
    InputStream input = null;
    long lastModified = System.currentTimeMillis();
    long totalFileSize = 0L;
    int threadNum = 10;
    long[] eachThreadLength;
    HashMap hashMap = null;
    String currentFileThreadName;
    long startPos = 0L;
    long endPos = 0L;
    boolean isByProxy = false;
    boolean isFirstRange = true;
    long totalLengthReaded = 0L;
    private static HashMap md5Version;
    RSDownloadListener[] listeners;
    static final /* synthetic */ boolean $assertionsDisabled;

    public MultiThreadDownLoadImpl(URL codebase, URL urlFile, File localFileAddress, HashMap hashMap, RSDownloadListener[] listeners) {
        this.resource = urlFile;
        this.rootPath = localFileAddress;
        this.hashMap = hashMap;
        this.codebase = codebase;
        this.listeners = listeners;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        File tmp = null;
        HttpURLConnection cn = null;
        try {
            cn = (HttpURLConnection)this.resource.openConnection();
            if (this.isFirstRange) {
                this.isByProxy = cn.usingProxy();
                this.logger.debug(" netFox download,using proxy:" + cn.usingProxy());
                this.isFirstRange = false;
            }
            try {
                cn.setRequestMethod("HEAD");
                String sProperty = "bytes=0-";
                cn.setRequestProperty("RANGE", sProperty);
                int responseCode = cn.getResponseCode();
                this.totalFileSize = cn.getContentLength();
                this.lastModified = cn.getLastModified();
                if (IFileSizeRange.Small_size.Contains(this.totalFileSize)) {
                    this.threadNum = IFileSizeRange.Small_size.getThreadNum();
                } else if (IFileSizeRange.Medium_size.Contains(this.totalFileSize)) {
                    this.threadNum = IFileSizeRange.Medium_size.getThreadNum();
                } else if (IFileSizeRange.Large_size.Contains(this.totalFileSize)) {
                    this.threadNum = IFileSizeRange.Large_size.getThreadNum();
                }
                if (responseCode != 206) {
                    System.out.println("This is the ResponseCode:" + responseCode + " So The Server don't apply to download by MultiThread..");
                    this.threadNum = 1;
                }
            }
            catch (IOException e) {
                this.threadNum = 1;
                e.printStackTrace();
            }
        }
        catch (IOException e) {
        }
        finally {
            try {
                cn.getInputStream().close();
            }
            catch (Throwable e) {}
        }
        this.localFile = this.getLocalFile(this.codebase, this.resource, this.rootPath);
        tmp = this.localFile.getParentFile();
        while (tmp != null && !tmp.exists()) {
            tmp.mkdirs();
        }
        this.eachThreadLength = new long[this.threadNum];
        this.initEachThreadLength();
    }

    private void initEachThreadLength() {
        long l = this.totalFileSize / (long)this.threadNum;
        for (int i = 0; i < this.threadNum; ++i) {
            this.eachThreadLength[i] = i == this.threadNum - 1 ? this.totalFileSize - (long)i * l : l;
        }
    }

    protected String getRelativePath(URL codebase, URL resource) {
        if (!$assertionsDisabled && codebase == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && resource == null) {
            throw new AssertionError();
        }
        String codebasePath = codebase.getPath();
        String resourcePath = resource.getPath();
        if (codebasePath.length() == 0) {
            return resourcePath;
        }
        if (resourcePath.startsWith(codebasePath)) {
            return resourcePath.substring(codebasePath.length());
        }
        if (!$assertionsDisabled) {
            throw new AssertionError((Object)("invalidate codebase[" + codebasePath + "] and resource[" + resourcePath + "]"));
        }
        return null;
    }

    private File getLocalFile(URL codebase, URL resource, File localFile) {
        if (!$assertionsDisabled && codebase == null) {
            throw new AssertionError();
        }
        String relativePath = this.getRelativePath(codebase, resource);
        return new File(localFile, relativePath);
    }

    public void download() {
        int i;
        this.init();
        long startTime = System.currentTimeMillis();
        this.fileName = this.localFile.getName();
        RandomAccessFile oSavedFile = null;
        try {
            oSavedFile = new RandomAccessFile(this.localFile.toString() + ".dl", "rw");
        }
        catch (FileNotFoundException e1) {
            e1.printStackTrace();
        }
        DownBytesContainer container = new DownBytesContainer();
        SingleThreadDownloadThread[] thread = new SingleThreadDownloadThread[this.threadNum + 1];
        for (i = 1; i <= this.threadNum; ++i) {
            if (i > 1) {
                this.startPos += this.eachThreadLength[i - 2];
            }
            this.endPos = this.startPos + this.eachThreadLength[i - 1];
            this.currentFileThreadName = this.fileName + ".part" + i;
            thread[i] = new SingleThreadDownloadThread(this, container, this.resource, this.startPos, this.endPos, this.currentFileThreadName, i, this.localFile.toString());
            thread[i].start();
        }
        for (i = 1; i <= this.threadNum; ++i) {
            try {
                thread[i].join();
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        try {
            long start = System.currentTimeMillis();
            WriteFileThread writeThread = new WriteFileThread(container, oSavedFile, this.localFile.toString(), this.totalFileSize);
            writeThread.start();
            writeThread.join();
            File newFile = new File(this.localFile.toString() + ".dl");
            this.doAfterDownload_multiThread(newFile, null);
        }
        catch (Exception e) {
            this.deleteDownInfo();
            this.hashMap.put(this.resource.toString(), e);
            e.printStackTrace();
        }
        long spendTime = System.currentTimeMillis() - startTime;
        if (spendTime > 0L) {
            System.out.println("&&&&&&&&&now the file " + this.fileName + " has downloaded compeletd!user time " + spendTime + ".ms,current threadnum " + this.threadNum + ",file size:" + this.totalFileSize + ",downSpeed:" + this.totalFileSize / spendTime + "kb/s");
        }
    }

    private void deleteDownInfo() {
        SingleThreadFileAccessInfo singleInfo = null;
        for (int i = 1; i <= this.threadNum; ++i) {
            try {
                singleInfo = new SingleThreadFileAccessInfo(this.localFile.toString(), i);
                if (singleInfo == null) continue;
                try {
                    singleInfo.delDLFile();
                }
                catch (FileNotFoundException fe) {
                    // empty catch block
                }
                singleInfo.delInfoFile();
                continue;
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
    }

    public void doAfterDownload_multiThread(File newFile, SingleThreadFileAccessInfo singleAccessInfo) throws IOException {
        if (this.isNeedCheckMd5(this.localFile) && !this.checkMd5(this.codebase, this.resource, newFile)) {
            boolean md5Try;
            SingleThreadFileAccessInfo lastFileInfo = new SingleThreadFileAccessInfo(this.localFile.toString(), 0);
            IEasClientDownloader downloader = EasClientDownloaderFactory.getDownloader("http");
            String isSaveDlFile = null;
            if (downloader instanceof EasClientDownloaderHttpImpl) {
                EasClientDownloaderHttpImpl cfr_ignored_0 = (EasClientDownloaderHttpImpl)downloader;
                isSaveDlFile = EasClientDownloaderHttpImpl.getIsSaveDlFile();
            }
            if (lastFileInfo.existsInfoFile() && isSaveDlFile == null) {
                lastFileInfo.delDLFile();
                lastFileInfo.delInfoFile();
            }
            if (!(md5Try = this.reDownloadWithoutProxy(this.codebase, this.resource, this.rootPath, this.isByProxy))) {
                if (downloader instanceof EasClientDownloaderHttpImpl) {
                    URL[] serverURLs = new URL[]{this.resource};
                    HashMap htMap = ((EasClientDownloaderHttpImpl)downloader).downloadFiles_sigleNetFox(this.codebase, serverURLs, this.rootPath);
                    this.hashMap.putAll(htMap);
                }
                System.out.println("current file " + this.resource + "download by multiThread faliure,now download by single thread");
            }
        } else {
            newFile.setLastModified(this.lastModified);
            boolean b = this.overwrite(this.localFile, newFile);
            if (b) {
                this.deleteDownInfo();
                this.logger.info("Download  file: " + this.localFile.toString());
            }
        }
    }

    private boolean isNeedCheckMd5(File localFile) {
        return !localFile.toString().endsWith("datacenters.xml") && !localFile.toString().endsWith("pkmap.lst") && !localFile.toString().endsWith("resource.lst") && !localFile.toString().endsWith("jnlp") && !localFile.toString().endsWith("metasindex.jar");
    }

    private boolean reDownloadWithoutProxy(URL codebase, URL resource, File rootPath, boolean isByProxy) {
        boolean noCacheTry = false;
        boolean isNoCacheHeader = this.checkExistNoCacheHeader(resource);
        System.out.println("using proxy:" + isByProxy + ",isNoCacheHeader:" + isNoCacheHeader);
        if (isByProxy && !isNoCacheHeader) {
            noCacheTry = this.reDownloadWithNoCacheHeader(codebase, resource, rootPath);
        }
        return noCacheTry;
    }

    private boolean reDownloadWithNoCacheHeader(URL codebase, URL resource, File rootPath) {
        URL newUrl = resource;
        String query = resource.getQuery();
        query = query == null ? "?" : query + "&";
        query = query + "pragma=no-cache";
        String file = resource.getPath() + query;
        try {
            newUrl = new URL(resource, file);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        boolean result = false;
        URL[] serverURLs = new URL[]{newUrl};
        HashMap resultMap = new HashMap();
        IEasClientDownloader downloader = EasClientDownloaderFactory.getDownloader("http");
        if (downloader instanceof EasClientDownloaderHttpImpl) {
            resultMap = ((EasClientDownloaderHttpImpl)downloader).downloadFiles(codebase, serverURLs, rootPath);
        }
        if (resultMap.isEmpty()) {
            result = true;
        }
        return result;
    }

    private boolean checkExistNoCacheHeader(URL resource) {
        String query = resource.getQuery();
        boolean noCacheHeader = NO_CACHE.equalsIgnoreCase(URLUtils.getParameter(query, PRAGMA));
        return noCacheHeader;
    }

    private boolean checkMd5(URL codebase, URL resource, File tmpFile) throws IOException {
        String version = (String)md5Version.get(this.getRelativePath(codebase, resource));
        if (version == null) {
            throw new IOException("remote MD5 version is null.resource:" + resource);
        }
        String tmpVersion = MD5.asHex(MD5.getHash(tmpFile));
        if (version.equals(tmpVersion)) {
            return true;
        }
        System.out.println("multiThread compare md5 [local:" + tmpVersion + ",remote:" + version + "] failure");
        return false;
    }

    private boolean overwrite(File localFile, File newFile) throws IOException {
        boolean b;
        if (localFile.exists()) {
            localFile.delete();
        }
        if (!(b = newFile.renameTo(localFile)) && !(b = newFile.renameTo(localFile))) {
            throw new IOException("Rename failure:" + newFile.toString());
        }
        return b;
    }

    public void run() {
        this.download();
    }

    public synchronized void setHasDownloadLength(long n) {
        this.totalLengthReaded += n;
        this.notifyListeners(this.resource, this.totalFileSize, this.totalLengthReaded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyListeners(URL url, long length, long totalRead) {
        int len = this.listeners.length;
        for (int i = 0; i < len; ++i) {
            RSDownloadListener rSDownloadListener = this.listeners[i];
            synchronized (rSDownloadListener) {
                if (totalRead == 0L) {
                    this.listeners[i].beginDownload(url);
                    this.listeners[i].downloadProgress(url, length, totalRead);
                } else if (totalRead == length || length == -1L) {
                    this.listeners[i].downloadProgress(url, length, totalRead);
                    this.listeners[i].finishDownload(url);
                } else {
                    this.listeners[i].downloadProgress(url, length, totalRead);
                }
                continue;
            }
        }
    }

    public static HashMap getMd5Version() {
        return md5Version;
    }

    public static void setMd5Version(HashMap md5Version) {
        MultiThreadDownLoadImpl.md5Version = md5Version;
    }

    static {
        $assertionsDisabled = !MultiThreadDownLoadImpl.class.desiredAssertionStatus();
        md5Version = null;
    }
}

