/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.multithread;

import com.kingdee.eas.applet.autoupdate.Logger;
import com.kingdee.eas.applet.multithread.DownLoadBytes;
import com.kingdee.eas.applet.multithread.IBytesContainer;
import com.kingdee.eas.applet.multithread.IMultiDownloader;
import com.kingdee.eas.applet.multithread.SingleThreadFileAccessInfo;
import com.kingdee.eas.webutil.URLUtils;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public class SingleThreadDownloadThread
extends Thread {
    private Logger logger = Logger.getInstance();
    private static int onceDownKBytes = 256;
    private static final int KB_SIZE = 1024;
    long onceDownBytes = onceDownKBytes * 1024;
    private static final String PRAGMA = "pragma";
    private static final String NO_CACHE = "no-cache";
    long startPos;
    long endPos;
    String currentFileThreadName;
    URL resource;
    int currentThread;
    String fileName = null;
    IMultiDownloader parentThread = null;
    IBytesContainer container = null;

    public SingleThreadDownloadThread(IMultiDownloader parentThread, IBytesContainer container, URL resource, long startPos, long endPos, String currentFileThreadName, int currentThread, String fileName) {
        this.resource = resource;
        this.container = container;
        this.startPos = startPos;
        this.endPos = endPos;
        this.currentFileThreadName = currentFileThreadName;
        this.currentThread = currentThread;
        this.fileName = fileName;
        this.parentThread = parentThread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block26: {
            SingleThreadFileAccessInfo singleInfo;
            InputStream input;
            long start;
            block25: {
                start = System.currentTimeMillis();
                long TotalSize = this.endPos - this.startPos;
                long downSize = 0L;
                input = null;
                long downStartPos = this.startPos;
                long[] nReadData = null;
                singleInfo = null;
                URLConnection cn = this.resource.openConnection();
                long lastModified = cn.getLastModified();
                int responseCode = ((HttpURLConnection)cn).getResponseCode();
                if (responseCode >= 400) {
                    throw new IOException("File is not access,resource is ===" + this.resource + ",responseCode is" + responseCode);
                }
                try {
                    cn.getInputStream().close();
                }
                catch (Throwable ex) {
                    // empty catch block
                }
                singleInfo = new SingleThreadFileAccessInfo(this.fileName, this.currentThread);
                if (singleInfo.existsInfoFile()) {
                    nReadData = singleInfo.read_nPos();
                    if (nReadData[0] == lastModified) {
                        downStartPos = nReadData[1];
                        System.out.println("Now start download file " + this.fileName + "from last breakpoint....");
                    } else {
                        singleInfo.delDLFile();
                    }
                }
                downSize = downStartPos - this.startPos;
                long startSecond = System.currentTimeMillis();
                long spendSecond = System.currentTimeMillis() - startSecond;
                long start1 = System.currentTimeMillis();
                while (downSize < TotalSize) {
                    byte[] bt;
                    int nRead;
                    String sProperty = "bytes=" + downStartPos + "-";
                    sProperty = sProperty + (downStartPos + this.onceDownBytes - 1L);
                    this.logger.debug("read " + sProperty + ",resource:" + cn.getURL());
                    cn = this.getConnection(this.resource);
                    cn.setRequestProperty("RANGE", sProperty);
                    responseCode = ((HttpURLConnection)cn).getResponseCode();
                    if (responseCode == 416) {
                        this.logger.info("Requested Range Not Satisfiable," + sProperty + " values were greater than the file length of " + cn.getURL());
                    }
                    input = cn.getInputStream();
                    while ((nRead = input.read(bt = new byte[262144])) != -1 && downSize < TotalSize) {
                        if ((downSize += (long)nRead) > TotalSize) {
                            downSize -= (long)nRead;
                            nRead = (int)(TotalSize - downSize);
                            downSize += (long)nRead;
                        }
                        DownLoadBytes bytes = new DownLoadBytes(bt, nRead, downStartPos, this.currentThread, lastModified, TotalSize);
                        this.container.putDownBytes(bytes);
                        downStartPos += (long)nRead;
                        this.parentThread.setHasDownloadLength(nRead);
                    }
                    try {
                        cn.getInputStream().close();
                    }
                    catch (Throwable ex) {}
                }
                Object var27_22 = null;
                if (input == null) break block25;
                try {
                    input.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            long spend = System.currentTimeMillis() - start;
            {
                break block26;
                catch (IOException e) {
                    if (singleInfo != null && singleInfo.getDLFileSize() <= 0L) {
                        try {
                            singleInfo.delDLFile();
                        }
                        catch (FileNotFoundException ex) {
                            ex.printStackTrace();
                        }
                        singleInfo.delInfoFile();
                    }
                    e.printStackTrace();
                    Object var27_23 = null;
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e2) {
                            // empty catch block
                        }
                    }
                    spend = System.currentTimeMillis() - start;
                }
            }
            catch (Throwable throwable) {
                Object var27_24 = null;
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                spend = System.currentTimeMillis() - start;
                throw throwable;
            }
        }
    }

    private void closeStream(InputStream input) {
        if (input != null) {
            try {
                input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private URLConnection getConnection(URL url) throws IOException {
        boolean isNoCacheHeader = this.checkExistNoCacheHeader(url);
        if (isNoCacheHeader) {
            url = this.removeNoCacheHeader(url);
        }
        URLConnection uc = url.openConnection();
        if (isNoCacheHeader) {
            this.addNoCacheHeader(uc);
        }
        return uc;
    }

    private void addNoCacheHeader(URLConnection uc) {
        this.addToRequestProperty(uc, PRAGMA, NO_CACHE);
        this.addToRequestProperty(uc, "KeepAlive", "true");
        System.out.println("no-cache file:" + uc.getURL());
    }

    private URL removeNoCacheHeader(URL url) {
        URL newUrl = url;
        String query = url.getQuery();
        if (query != null) {
            query = query.replaceAll(PRAGMA + "\\=" + NO_CACHE, "");
        }
        String file = url.getPath();
        if (query != null && !"".equals(query)) {
            file = file + "?" + query;
        }
        try {
            newUrl = new URL(url, file);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return newUrl;
    }

    private void addToRequestProperty(URLConnection conn, String key, String value) {
        String curvalue = conn.getRequestProperty(key);
        curvalue = curvalue == null || curvalue.trim().length() == 0 ? value : curvalue + "," + value;
        conn.setRequestProperty(key, curvalue);
    }

    private boolean checkExistNoCacheHeader(URL resource) {
        String query = resource.getQuery();
        boolean noCacheHeader = NO_CACHE.equalsIgnoreCase(URLUtils.getParameter(query, PRAGMA));
        return noCacheHeader;
    }
}

