/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.proxydownload;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;

public class DownloadProxy {
    public static final int DEFAULT_PORT = 11999;
    public static final String MD5 = "md5";
    public static String defaultProxyServer = "127.0.0.1:11999";

    public static URLConnection downloadFile(String proxyServer, String url, String fileName, String localPath, String md5) throws IOException {
        if (proxyServer == null) {
            proxyServer = defaultProxyServer;
        }
        if (url.toLowerCase().startsWith("http://")) {
            url = url.substring(7);
        }
        url = "http://" + proxyServer + "/" + url;
        URL u = new URL(url);
        URLConnection cn = u.openConnection();
        cn.addRequestProperty("localPath", localPath);
        cn.addRequestProperty("msgVersion", "1.0");
        cn.addRequestProperty("fileName", fileName);
        cn.addRequestProperty("isSelf", "true");
        if (md5 != null && md5.length() > 0) {
            cn.addRequestProperty(MD5, md5.toLowerCase());
        }
        cn.connect();
        return cn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveStreamToFile(InputStream in, File file) throws IOException {
        try {
            file.delete();
            file.getParentFile().mkdirs();
            FileOutputStream out = new FileOutputStream(file);
            try {
                int len;
                byte[] buf = new byte[4096];
                while ((len = in.read(buf)) > 0) {
                    out.write(buf, 0, len);
                }
            }
            finally {
                out.close();
            }
        }
        finally {
            in.close();
        }
    }

    public static InetAddress getFirstNonLoopbackAddress() {
        try {
            Enumeration<NetworkInterface> ne = NetworkInterface.getNetworkInterfaces();
            while (ne.hasMoreElements()) {
                NetworkInterface nif = ne.nextElement();
                Enumeration<InetAddress> ae = nif.getInetAddresses();
                while (ae.hasMoreElements()) {
                    InetAddress addr = ae.nextElement();
                    if (addr.isLoopbackAddress()) continue;
                    return addr;
                }
            }
            return InetAddress.getLocalHost();
        }
        catch (IOException ioe) {
            throw new Error("Network error", ioe);
        }
    }
}

