/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.proxydownload;

import com.kingdee.eas.applet.proxydownload.IProxyFile;
import com.kingdee.eas.applet.proxydownload.ProxyDownloadManager;
import com.kingdee.eas.applet.proxydownload.ProxyDownloadTaskListener;
import com.kingdee.eas.applet.proxydownload.ProxyHttpSiteInfo;
import java.io.File;
import java.util.ArrayList;

public class ProxyDownloadTask {
    private int workerCount;
    private ProxyHttpSiteInfo siteInfo;
    private File localPath;
    private ArrayList fileDownloadFailed = new ArrayList();
    private ProxyDownloadTaskListener listener;
    private long downloadBytes = 0L;

    public ProxyDownloadTask(ProxyHttpSiteInfo httpSite, File localRoot, ArrayList fileList) {
        this.workerCount = fileList.size();
        this.siteInfo = httpSite;
        this.localPath = localRoot;
        this.fileDownloadFailed.addAll(fileList);
    }

    public void setListener(ProxyDownloadTaskListener dtl) {
        this.listener = dtl;
    }

    public void start() throws InterruptedException {
        if (this.workerCount > 0) {
            ProxyDownloadManager.getInstance().runTask(this);
        }
    }

    public ProxyHttpSiteInfo getSiteInfo() {
        return this.siteInfo;
    }

    public File getLocalPath() {
        return this.localPath;
    }

    ArrayList getFilesToDownload() {
        ArrayList list = new ArrayList(this.fileDownloadFailed.size());
        list.addAll(this.fileDownloadFailed);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void downloadFailed(IProxyFile proxyfile, Throwable ex) {
        try {
            --this.workerCount;
            this.listener.doanloadFailed(proxyfile, ex);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void downloadSuccess(IProxyFile proxyfile) {
        try {
            --this.workerCount;
            ++this.downloadBytes;
            this.fileDownloadFailed.remove(proxyfile);
            this.listener.downloadFinish(proxyfile, 1L);
        }
        catch (Throwable throwable) {
        }
        finally {
            this.notifyAll();
        }
    }

    public void waitUntilTaskFinish() throws InterruptedException {
        while (this.workerCount > 0) {
            this.wait();
        }
    }

    public synchronized ArrayList getDownloadFailedFiles() throws InterruptedException {
        this.waitUntilTaskFinish();
        return this.fileDownloadFailed;
    }

    public synchronized long getDownloadBytes() throws InterruptedException {
        this.waitUntilTaskFinish();
        return this.downloadBytes;
    }
}

