/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.proxydownload;

import com.kingdee.eas.applet.httpdownload.util.NamedRunnable;
import com.kingdee.eas.applet.proxydownload.DownloadProxy;
import com.kingdee.eas.applet.proxydownload.ProxyDownloadTask;
import com.kingdee.eas.applet.proxydownload.ProxyFileInfo;
import com.kingdee.eas.applet.proxydownload.httpDownloadWorker;
import com.twmacinta.util.MD5;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;

public class ProxyDownloadWorker
implements NamedRunnable {
    private ProxyDownloadTask task;
    private ProxyFileInfo relativeFileInfo;

    public ProxyDownloadWorker(ProxyDownloadTask dTask, ProxyFileInfo file) {
        this.task = dTask;
        this.relativeFileInfo = file;
    }

    public String getName() {
        return this.relativeFileInfo.getFileName();
    }

    public void run() {
        try {
            String url = this.relativeFileInfo.getResource().toString();
            String md5 = this.relativeFileInfo.getMd5();
            System.out.println("download file " + url);
            System.out.println("md5=" + md5);
            URLConnection cn = DownloadProxy.downloadFile(null, url, this.relativeFileInfo.getFileName(), this.relativeFileInfo.getLocalFilePath(), md5);
            String httpRes = cn.getHeaderField(0);
            if (httpRes != null && httpRes.indexOf("200") > 0) {
                String md5Res = MD5.asHex(MD5.getHash(new File(this.relativeFileInfo.getLocalFilePath() + "/" + this.relativeFileInfo.getFileName())));
                if (!md5Res.equals(md5)) {
                    System.out.println("compare md5 [local:" + md5Res + ",remote:" + md5 + "] failure");
                    throw new IOException("compare md5 error by proxy");
                }
            } else {
                throw new IOException("download by proxy error");
            }
            System.out.println("**********download file " + this.relativeFileInfo.getFileName() + " by proxy finished**********");
            this.task.downloadSuccess(this.relativeFileInfo);
        }
        catch (IOException ex) {
            System.out.println("now download from proxy error,msg:" + ex.toString());
            System.out.println("now turn to http download........................");
            httpDownloadWorker worker = new httpDownloadWorker(this.task, this.relativeFileInfo);
            worker.execute();
        }
        catch (Throwable e) {
            this.task.downloadFailed(this.relativeFileInfo, e);
            e.printStackTrace();
        }
    }
}

