/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.applet.proxydownload;

import com.kingdee.bos.autoupdate.util.BASE64Encoder;
import com.kingdee.eas.applet.httpdownload.Proxy;
import com.kingdee.eas.applet.httpdownload.util.DebugLogger;
import com.kingdee.eas.applet.httpdownload.util.LimitedInputStream;
import com.kingdee.eas.applet.proxydownload.IProxyFile;
import com.kingdee.eas.applet.proxydownload.ProxyDownloadManager;
import com.kingdee.eas.applet.proxydownload.ProxyDownloadTask;
import com.kingdee.eas.applet.proxydownload.ProxyFileInfo;
import com.kingdee.eas.applet.proxydownload.ProxyHttpSiteInfo;
import com.twmacinta.util.MD5;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;

public class httpDownloadWorker {
    private ProxyDownloadTask task;
    private IProxyFile relativeFile;
    private String fileName;

    public httpDownloadWorker(ProxyDownloadTask dTask, IProxyFile file) {
        this.task = dTask;
        this.relativeFile = file;
        this.fileName = file.getFileName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long downloadFile() {
        File localDirRoot = this.task.getLocalPath();
        ProxyHttpSiteInfo server = this.task.getSiteInfo();
        File destFile = new File(localDirRoot.getAbsolutePath() + "/" + this.fileName);
        if (!destFile.getParentFile().exists()) {
            boolean flag = destFile.getParentFile().mkdirs();
            for (int n = 0; !flag && n < 3 && !destFile.getParentFile().exists(); ++n) {
                flag = destFile.getParentFile().mkdirs();
            }
            if (!flag) {
                System.out.println("create new directoy error....");
            }
        }
        File downloadTemp = new File(localDirRoot.getAbsolutePath() + "/" + this.fileName + ".tmp");
        String fileToDownload = server.getRootContentPath() + this.fileName;
        try {
            boolean downloadFailed = false;
            long hasDownloaded = 0L;
            long downloadSize = 0L;
            int retryTimes = ProxyDownloadManager.getInstance().getDownloadManagerConfig().getDownloadRetries();
            for (int i = 1; i < retryTimes; ++i) {
                RandomAccessFile tmpFile = new RandomAccessFile(downloadTemp, "rw");
                try {
                    Socket clientSocket = this.getHttpSocket();
                    Properties requetProps = new Properties();
                    hasDownloaded = tmpFile.length();
                    if (hasDownloaded > 0L) {
                        DebugLogger.getDebugLogger().info("Continue download file[" + fileToDownload + "] from break point [" + hasDownloaded + "]......");
                        tmpFile.seek(hasDownloaded - 1L);
                        requetProps.setProperty("Range", "bytes=" + (hasDownloaded - 1L) + "-");
                    }
                    this.sendRequest(clientSocket, requetProps, fileToDownload, true);
                    InputStream is = this.getHttpInputStream(clientSocket);
                    byte[] buf = new byte[1536];
                    BufferedInputStream bufInput = new BufferedInputStream(is);
                    int ret = 0;
                    while ((ret = bufInput.read(buf, 0, buf.length)) != -1) {
                        tmpFile.write(buf, 0, ret);
                        hasDownloaded += (long)ret;
                        downloadSize += (long)ret;
                    }
                    is.close();
                    downloadFailed = false;
                    clientSocket.close();
                    break;
                }
                catch (SocketTimeoutException ste) {
                    DebugLogger.getDebugLogger().error("Socket timeout, retry [" + i + "] ......");
                    downloadFailed = true;
                    continue;
                }
                finally {
                    tmpFile.close();
                }
            }
            if (!downloadFailed) {
                boolean b;
                if (destFile.exists()) {
                    destFile.delete();
                }
                String tmpVersion = MD5.asHex(MD5.getHash(downloadTemp));
                String version = ((ProxyFileInfo)this.relativeFile).getMd5();
                if (!version.equals(tmpVersion)) {
                    System.out.println("compare md5 [local:" + tmpVersion + ",remote:" + version + "] failure");
                    if (this.fileName.indexOf("metasindex.jar") >= 0) {
                        System.out.println("metasindex md5version check failure,but should download it....");
                    } else {
                        throw new IOException("md5 check failure:" + this.fileName);
                    }
                }
                if (!(b = downloadTemp.renameTo(destFile))) {
                    throw new IOException("Rename failure:" + destFile);
                }
            } else {
                downloadTemp.delete();
                throw new RuntimeException("socket timeout Exception");
            }
            return downloadSize;
        }
        catch (IOException ex) {
            downloadTemp.delete();
            throw new RuntimeException("IO Exception " + ex.getMessage() + "[" + downloadTemp.getAbsolutePath() + "]", ex);
        }
        catch (Throwable e) {
            e.printStackTrace();
            throw new RuntimeException("IO Exception " + e.getMessage() + "[" + downloadTemp.getAbsolutePath() + "]", e);
        }
    }

    private Socket getHttpSocket() throws IOException {
        ProxyHttpSiteInfo server = this.task.getSiteInfo();
        Socket socket = new Socket();
        socket.setKeepAlive(false);
        socket.setReceiveBufferSize(65535);
        socket.setSendBufferSize(65535);
        socket.setSoLinger(false, 1);
        socket.setSoTimeout(5000);
        socket.setTcpNoDelay(false);
        socket.setTrafficClass(8);
        try {
            if (server.getProxyInfo().getProxyType() == 0) {
                socket.connect(new InetSocketAddress(server.getAddress(), server.getPort()));
            } else {
                Proxy proxyInfo = server.getProxyInfo();
                socket.connect(new InetSocketAddress(proxyInfo.getProxyHost(), proxyInfo.getProxyPort()));
            }
        }
        catch (ConnectException ce) {
            if (ce.getMessage().indexOf("timed out") > 0) {
                throw new SocketTimeoutException("connect to [" + server.getAddress() + ":" + server.getPort() + "] timed out!");
            }
            throw ce;
        }
        return socket;
    }

    private InputStream getHttpInputStream(Socket httpSocket) throws IOException {
        byte[] buffer = new byte[2048];
        BufferedInputStream input = new BufferedInputStream(httpSocket.getInputStream());
        String line = this.readLine(input, buffer);
        StringTokenizer tokens = new StringTokenizer(line);
        tokens.nextToken();
        String statusCode = tokens.nextToken();
        String statusMsg = tokens.nextToken("\n\r");
        if (!"200".equals(statusCode) && !"206".equals(statusCode)) {
            throw new IOException("Unexpected Response from Server[" + statusCode + "] : " + statusMsg);
        }
        int contentLength = -1;
        while ((line = this.readLine(input, buffer)) != null && !"".equals(line)) {
            if (!(line = line.toLowerCase()).startsWith("content-length:")) continue;
            contentLength = Integer.parseInt(line.substring("content-length:".length()).trim());
        }
        InputStream result = contentLength == -1 ? input : new LimitedInputStream(input, contentLength);
        return result;
    }

    private String readLine(InputStream pIn, byte[] pBuffer) throws IOException {
        int next;
        int count = 0;
        while ((next = pIn.read()) >= 0 && next != 10) {
            if (next != 13) {
                pBuffer[count++] = (byte)next;
            }
            if (count < pBuffer.length) continue;
            throw new IOException("HTTP Header too long");
        }
        return new String(pBuffer, 0, count);
    }

    private void sendRequest(final Socket clientSocket, Properties requetProps, String url, boolean useHttpV11) {
        ProxyHttpSiteInfo server = this.task.getSiteInfo();
        Proxy proxyInfo = server.getProxyInfo();
        try {
            OutputStream output = clientSocket.getOutputStream();
            BufferedOutputStream bufOut = new BufferedOutputStream(output){

                public void close() throws IOException {
                    this.flush();
                    clientSocket.shutdownOutput();
                }
            };
            if (proxyInfo.getProxyType() == 1) {
                try {
                    bufOut.write(this.toHTTPBytes("CONNECT " + proxyInfo.getProxyHost() + ":" + proxyInfo.getProxyPort() + " HTTP/1.1\r\n"));
                    if (proxyInfo.isNeedAuth()) {
                        String password = proxyInfo.getProxyUser() + ":" + proxyInfo.getProxyPassword();
                        String encodedPassword = BASE64Encoder.base64Encode((String)password);
                        this.sendHeader(bufOut, "Proxy-Authorization", encodedPassword);
                    }
                    bufOut.write(this.toHTTPBytes("\r\n"));
                    bufOut.flush();
                    InputStream input = this.getHttpInputStream(clientSocket);
                    while (input.read() > -1) {
                        input.read();
                    }
                }
                catch (IOException e) {
                    DebugLogger.getDebugLogger().error("Connect to proxy[" + proxyInfo.getProxyHost() + ":" + proxyInfo.getProxyPort() + "] failed!", e);
                    throw new RuntimeException("Connect to proxy[" + proxyInfo.getProxyHost() + ":" + proxyInfo.getProxyPort() + "] failed!", e);
                }
            }
            if (useHttpV11) {
                bufOut.write(this.toHTTPBytes("GET " + url + " HTTP/1.1\r\n"));
            } else {
                bufOut.write(this.toHTTPBytes("GET " + url + " HTTP/1.0\r\n"));
            }
            this.sendHeader(bufOut, "Accept", "*/*");
            this.sendHeader(bufOut, "User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0)");
            this.sendHeader(bufOut, "Host", server.getAddress() + ":" + server.getPort());
            this.sendHeader(bufOut, "Connection", "close");
            Enumeration<Object> propsEN = requetProps.keys();
            while (propsEN.hasMoreElements()) {
                String propsName = (String)propsEN.nextElement();
                String value = requetProps.getProperty(propsName);
                this.sendHeader(bufOut, propsName, value);
            }
            bufOut.write(this.toHTTPBytes("\r\n"));
            bufOut.flush();
            clientSocket.shutdownOutput();
        }
        catch (Throwable ex) {
            throw new RuntimeException("Send request to url[" + url + "] failed, " + ex.getMessage(), ex);
        }
    }

    private byte[] toHTTPBytes(String pValue) throws UnsupportedEncodingException {
        return pValue.getBytes("US-ASCII");
    }

    private void sendHeader(OutputStream pOut, String pKey, String pValue) throws IOException {
        pOut.write(this.toHTTPBytes(pKey + ": " + pValue + "\r\n"));
    }

    public void execute() {
        try {
            long startTime = System.currentTimeMillis();
            long downloadSize = this.downloadFile();
            long fileDownloadElapseTime = System.currentTimeMillis() - startTime;
            fileDownloadElapseTime = fileDownloadElapseTime > 0L ? fileDownloadElapseTime : 1L;
            System.out.println("--------------download file " + this.fileName + "by custhttp style finished-------------------");
            DebugLogger.getDebugLogger().info("[Time:" + fileDownloadElapseTime + "ms] download file[" + this.fileName + "], downloadSize[" + downloadSize + "] speed[" + downloadSize * 1000L / (fileDownloadElapseTime * 1024L) + "KB/s]");
            this.task.downloadSuccess(this.relativeFile);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            this.task.downloadFailed(this.relativeFile, ex);
        }
    }
}

