/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.webutil;

import com.kingdee.bos.autoupdate.cache.LocalCachedEntryManager;
import com.kingdee.bos.autoupdate.xml.INode;
import com.kingdee.bos.autoupdate.xml.NodeFactory;
import com.twmacinta.util.MD5;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;

public class JnlpUtil {
    private static final String JAR_TAG = "jar";
    private static final String JAR_EXT_NAME = ".jar";
    private static final String NATIVELIB_TAG = "nativelib";
    private static final String LINE_SEPERATOR = "\r\n";
    static final /* synthetic */ boolean $assertionsDisabled;

    public static HashMap getFileLists(String path, String extName) throws Exception {
        if (path == null || "".equals(path)) {
            throw new Exception("[EAS Portal] path is null.");
        }
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        File folder = new File(path);
        File currentFile = null;
        String fileName = null;
        String[] files = null;
        String file = null;
        String version = null;
        if (folder.isDirectory()) {
            files = folder.list();
            for (int i = 0; i < files.length; ++i) {
                file = path + files[i];
                currentFile = new File(file);
                if (currentFile.isDirectory()) {
                    hashMap.putAll(JnlpUtil.getFileLists(file, extName));
                    continue;
                }
                if (!currentFile.isFile()) continue;
                if (currentFile.length() == 0L) {
                    currentFile.delete();
                    continue;
                }
                fileName = currentFile.getName();
                version = MD5.asHex(MD5.getHash(currentFile));
                if (extName != null && fileName.endsWith(extName) || fileName.endsWith(".dl") || fileName.endsWith(".info")) continue;
                hashMap.put(file, version);
            }
        }
        return hashMap;
    }

    public static void buildJnlpFile(String baseDir, String[] resources) {
        StringBuffer result = new StringBuffer();
        long createTime = System.currentTimeMillis();
        result.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        result.append(LINE_SEPERATOR);
        result.append("<jnlp spec=\"1.0+\" codebase=\"");
        result.append("http://127.0.0.1:6888/easWebClient/");
        result.append("\" href=\"eas.jnlp\" lastModified='" + createTime + "'>");
        result.append(LINE_SEPERATOR);
        result.append("\t<application-desc main-class=\"com.kingdee.eas.base.uiframe.client.LoginFrame\"/>");
        result.append(LINE_SEPERATOR);
        result.append("\t<information>");
        result.append(LINE_SEPERATOR);
        result.append("\t\t<title>client-update</title>");
        result.append(LINE_SEPERATOR);
        result.append("\t\t<vendor>Kingdee</vendor>");
        result.append(LINE_SEPERATOR);
        result.append("\t\t<description>Client of EAS4.1</description>");
        result.append(LINE_SEPERATOR);
        result.append("\t\t<description kind=\"short\">EAS4.1</description>");
        result.append(LINE_SEPERATOR);
        result.append("\t\t<offline-allowed/>");
        result.append(LINE_SEPERATOR);
        result.append("\t</information>");
        result.append(LINE_SEPERATOR);
        result.append("\t<resources>");
        result.append(LINE_SEPERATOR);
        File baseDirFile = new File(baseDir);
        if (baseDirFile.exists() && baseDirFile.isDirectory()) {
            for (int i = 0; i < resources.length; ++i) {
                File resourceFile = new File(baseDirFile, resources[i]);
                JnlpUtil.appendJnlpResources(result, baseDirFile, resourceFile);
            }
        }
        result.append("\t</resources>");
        result.append(LINE_SEPERATOR);
        result.append("</jnlp>");
        File jnlpFile = new File(baseDirFile, "eas.jnlp");
        try {
            FileWriter writer = new FileWriter(jnlpFile);
            writer.write(result.toString());
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void appendJnlpResources(StringBuffer sb, File baseDir, File file) {
        if (file.exists()) {
            if (file.isFile()) {
                String tag = NATIVELIB_TAG;
                if (file.getName().endsWith(JAR_EXT_NAME)) {
                    tag = JAR_TAG;
                }
                sb.append("\t\t<");
                sb.append(tag);
                sb.append(" href='");
                sb.append(JnlpUtil.getRelativePathName(baseDir, file));
                sb.append("'");
                long lastModified = file.lastModified();
                sb.append(" lastModified='" + lastModified + "'");
                sb.append("/>");
                sb.append(LINE_SEPERATOR);
            } else {
                File[] childFile = file.listFiles();
                for (int i = 0; i < childFile.length; ++i) {
                    JnlpUtil.appendJnlpResources(sb, baseDir, childFile[i]);
                }
            }
        }
    }

    private static String getRelativePathName(File baseDir, File file) {
        return file.toString().substring(baseDir.toString().length() + 1).replace('\\', '/');
    }

    public static void buildEntriesFile(String baseDir) throws Exception {
        String jnlpPath = baseDir + "\\eas.jnlp";
        String localPath = baseDir;
        File entriesFile = new File(baseDir, "kdjnlp.entries");
        if (entriesFile.exists()) {
            entriesFile.delete();
        }
        String[] args = new String[]{jnlpPath, localPath};
        LocalCachedEntryManager.main((String[])args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void setUpdateServer(String baseDir, String updateServerUrl) {
        block17: {
            File file = new File(baseDir, "kdjnlp.entries");
            if (!file.exists()) {
                System.out.println("Cann't find kdjnlp.entries file!");
                return;
            }
            BufferedInputStream bos = null;
            INode root = null;
            try {
                bos = new BufferedInputStream(new FileInputStream(file));
                root = NodeFactory.build((InputStream)bos);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (root == null) {
                System.out.println("Invalidate kdjnlp.entries file");
                return;
            }
            if (!$assertionsDisabled && !"localCache".equals(root.getNodeName())) {
                throw new AssertionError();
            }
            root.setAttribute("codebase", updateServerUrl);
            FileWriter writer = null;
            writer = new FileWriter(file);
            root.write((Writer)writer);
            writer.flush();
            Object var8_8 = null;
            try {
                if (writer != null) {
                    writer.close();
                }
                break block17;
            }
            catch (Exception ignore) {
                ignore.printStackTrace();
            }
            break block17;
            {
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    Object var8_9 = null;
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (Exception ignore) {
                        ignore.printStackTrace();
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (Exception ignore) {
                    ignore.printStackTrace();
                }
                throw throwable;
            }
        }
    }

    public static String getUpdateServer(String baseDir) {
        File file = new File(baseDir, "kdjnlp.entries");
        if (!file.exists()) {
            System.out.println("Cann't find kdjnlp.entries file!");
            return null;
        }
        BufferedInputStream bos = null;
        INode root = null;
        try {
            bos = new BufferedInputStream(new FileInputStream(file));
            root = NodeFactory.build((InputStream)bos);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (root == null) {
            System.out.println("Invalidate kdjnlp.entries file");
            return null;
        }
        if (!$assertionsDisabled && !"localCache".equals(root.getNodeName())) {
            throw new AssertionError();
        }
        return root.getAttribute("codebase");
    }

    public static void main(String[] args) {
        if (args == null || args.length <= 1) {
            System.out.println("Argument error!");
            return;
        }
        String type = args[0];
        if ("jnlp".equals(type)) {
            if (args.length <= 2) {
                System.out.println("Argument error!");
                return;
            }
            String baseDirName = args[1];
            String resourceFileName = args[2];
            File resourceCfgFile = new File(baseDirName, resourceFileName);
            JnlpUtil.buildJnlpFile(baseDirName, JnlpUtil.readSimpleConfigFile(resourceCfgFile));
        } else if ("entries".equals(type)) {
            String baseDirName = args[1];
            try {
                JnlpUtil.buildEntriesFile(baseDirName);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("update".equals(type)) {
            String baseDirName = args[1];
            String updateServerUrl = args[2];
            JnlpUtil.setUpdateServer(baseDirName, updateServerUrl);
        } else {
            System.out.println("Argument error!");
        }
    }

    private static String[] readSimpleConfigFile(File file) {
        ArrayList<String> result = new ArrayList<String>();
        if (file != null && file.exists() && file.isFile()) {
            try {
                FileReader fileReader = new FileReader(file);
                BufferedReader br = new BufferedReader(fileReader);
                String line = br.readLine();
                while (line != null) {
                    if (!line.startsWith("#") && line.trim().length() != 0) {
                        result.add(line);
                    }
                    line = br.readLine();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        Object[] array = result.toArray();
        String[] resources = new String[array.length];
        for (int i = 0; i < array.length; ++i) {
            resources[i] = (String)array[i];
        }
        return resources;
    }

    static {
        $assertionsDisabled = !JnlpUtil.class.desiredAssertionStatus();
    }
}

