/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.autoupdate.jnl;

import com.kingdee.bos.autoupdate.jnl.ApplicationInfo;
import com.kingdee.bos.autoupdate.jnl.JARInfo;
import com.kingdee.bos.autoupdate.jnl.JREInfo;
import com.kingdee.bos.autoupdate.jnl.LaunchInfo;
import com.kingdee.bos.autoupdate.jnl.NativeLibInfo;
import com.kingdee.bos.autoupdate.jnl.ParseException;
import com.kingdee.bos.autoupdate.jnl.PropertyInfo;
import com.kingdee.bos.autoupdate.jnl.ResourceCollection;
import com.kingdee.bos.autoupdate.util.URLUtil;
import com.kingdee.bos.autoupdate.xml.INode;
import com.kingdee.bos.autoupdate.xml.NodeFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import nanoxml.XMLParseException;

public final class JNLParser {
    public static LaunchInfo parse(InputStream is) throws ParseException {
        try {
            INode root = NodeFactory.build(is);
            return JNLParser.buildLaunch(root);
        }
        catch (IOException ioe) {
            throw new ParseException(ioe);
        }
        catch (XMLParseException pe) {
            throw new ParseException(pe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LaunchInfo parse(File file) throws ParseException {
        LaunchInfo launchInfo;
        BufferedInputStream bis = null;
        try {
            try {
                bis = new BufferedInputStream(new FileInputStream(file));
                launchInfo = JNLParser.parse(bis);
                Object var4_4 = null;
            }
            catch (IOException ioe) {
                throw new ParseException(ioe);
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            try {
                if (bis == null) throw throwable;
                bis.close();
                throw throwable;
            }
            catch (IOException ignore) {
                throw throwable;
            }
        }
        try {}
        catch (IOException ignore) {
            // empty catch block
            return launchInfo;
        }
        if (bis == null) return launchInfo;
        bis.close();
        return launchInfo;
    }

    private static LaunchInfo buildLaunch(INode root) throws ParseException, MalformedURLException {
        if (root == null || !root.getNodeName().equals("jnlp")) {
            throw new ParseException("Invalidate jnlp file");
        }
        URL codebase = JNLParser.addSlash(JNLParser.getURL(root, "codebase", null));
        URL href = JNLParser.getURL(root, "href", codebase);
        ResourceCollection resources = JNLParser.buildResources(root, codebase, false);
        ApplicationInfo appInfo = JNLParser.buildApplication(root);
        return new LaunchInfo(codebase, href, appInfo, resources);
    }

    private static ResourceCollection buildResources(INode root, URL codebase, boolean isInJ2SE) throws ParseException, MalformedURLException {
        ResourceCollection result = new ResourceCollection();
        INode[] resources = JNLParser.getChildNodes(root, "resources");
        if (resources.length == 0 && !isInJ2SE) {
            throw new ParseException("JNLP file must have resource!");
        }
        for (int i = 0; i < resources.length; ++i) {
            JNLParser.buildResourceInfo(result, resources[i], codebase);
        }
        return result;
    }

    private static void buildResourceInfo(ResourceCollection resources, INode node, URL codebase) throws MalformedURLException, ParseException {
        for (INode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name = child.getNodeName();
            if ("j2se".equals(name)) {
                resources.addResourceInfo(JNLParser.getJRE(child, codebase));
            }
            if ("jar".equals(name)) {
                JARInfo jar = JNLParser.getJAR(child, codebase);
                resources.addResourceInfo(jar);
            }
            if ("nativelib".equals(name)) {
                NativeLibInfo lib = JNLParser.getNativeLib(child, codebase);
                resources.addResourceInfo(lib);
            }
            if (!"property".equals(name)) continue;
            resources.addResourceInfo(JNLParser.getProperty(child));
        }
    }

    private static JREInfo getJRE(INode node, URL codebase) throws MalformedURLException, ParseException {
        String version = JNLParser.getAttribute(node, "version", null);
        URL href = JNLParser.getURL(node, "href", codebase);
        String initialHeap = JNLParser.getAttribute(node, "initial-heap-size", null);
        String maxHeap = JNLParser.getAttribute(node, "max-heap-size", null);
        ResourceCollection resources = JNLParser.buildResources(node, codebase, true);
        return new JREInfo(version, href, initialHeap, maxHeap, resources);
    }

    private static JARInfo getJAR(INode node, URL codebase) throws MalformedURLException, ParseException {
        URL href = JNLParser.getURL(node, "href", codebase);
        return new JARInfo(href);
    }

    private static NativeLibInfo getNativeLib(INode node, URL codebase) throws MalformedURLException, ParseException {
        URL href = JNLParser.getURL(node, "href", codebase);
        return new NativeLibInfo(href);
    }

    private static PropertyInfo getProperty(INode node) throws ParseException {
        String name = JNLParser.getAttribute(node, "name", null);
        String value = JNLParser.getAttribute(node, "value", "");
        if (JNLParser.isEmpty(name) || JNLParser.isEmpty(value)) {
            throw new ParseException("property's name and value cannot be null!");
        }
        return new PropertyInfo(name, value);
    }

    private static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    private static ApplicationInfo buildApplication(INode parent) throws ParseException {
        INode[] nodes = JNLParser.getChildNodes(parent, "application-desc");
        if (nodes == null || nodes.length != 1) {
            throw new ParseException("JNLP file must define one application");
        }
        INode node = nodes[0];
        String main = JNLParser.getAttribute(node, "main-class", null);
        ArrayList<String> argsList = new ArrayList<String>();
        INode[] args = JNLParser.getChildNodes(node, "argument");
        String arg = null;
        for (int i = 0; i < args.length; ++i) {
            arg = args[i].getNodeValue();
            if (JNLParser.isEmpty(arg)) {
                throw new ParseException("Applicatin's argument cannoe be empty!");
            }
            argsList.add(args[i].getNodeValue());
        }
        String[] argStrings = argsList.toArray(new String[argsList.size()]);
        return new ApplicationInfo(main, argStrings);
    }

    private static String getAttribute(INode node, String name, String defaultValue) {
        String result = node.getAttribute(name);
        if (result == null || result.length() == 0) {
            return defaultValue;
        }
        return result;
    }

    private static INode[] getChildNodes(INode node, String name) {
        ArrayList<INode> result = new ArrayList<INode>();
        for (INode child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!child.getNodeName().equals(name)) continue;
            result.add(child);
        }
        return result.toArray(new INode[result.size()]);
    }

    private static URL getURL(INode root, String attrName, URL base) throws ParseException, MalformedURLException {
        String url = root.getAttribute(attrName);
        if (url == null) {
            return null;
        }
        return URLUtil.getURL(base, url);
    }

    private static URL addSlash(URL source) {
        if (source == null) {
            return null;
        }
        if (!source.toString().endsWith("/")) {
            try {
                source = new URL(source.toString() + "/");
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return source;
    }
}

