/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.bos.jdbc.base;

import com.apusic.bos.jdbc.base.BaseImplConnection;
import java.sql.SQLException;
import java.util.Vector;

public final class BaseConnectionPool {
    private static String footprint = "$Revision:   1.5  $";
    Vector physicalConnectionPool = new Vector();

    protected void add(BaseImplConnection baseimplconnection) {
        this.physicalConnectionPool.addElement(baseimplconnection);
    }

    public void close() {
        int i = this.physicalConnectionPool.size();
        for (int j = 0; j < i; ++j) {
            BaseImplConnection baseimplconnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(j);
            if (baseimplconnection.getReferenceCount() != 0) continue;
            try {
                baseimplconnection.close();
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    protected int count() {
        return this.physicalConnectionPool.size();
    }

    protected int countActiveConnections() {
        int i = 0;
        int j = this.physicalConnectionPool.size();
        for (int k = 0; k < j; ++k) {
            BaseImplConnection baseimplconnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(k);
            if (baseimplconnection.getReferenceCount() <= 0) continue;
            ++i;
        }
        return i;
    }

    protected int countUseableConnections(int i) {
        int j = 0;
        int k = this.physicalConnectionPool.size();
        for (int l = 0; l < k; ++l) {
            BaseImplConnection baseimplconnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(l);
            if (baseimplconnection.getReferenceCount() >= i) continue;
            ++j;
        }
        return j;
    }

    protected void finalize() {
        this.close();
    }

    protected BaseImplConnection getUseableConnection(int i) {
        BaseImplConnection baseimplconnection = null;
        int j = this.physicalConnectionPool.size();
        for (int k = 0; k < j && (baseimplconnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(k)).getReferenceCount() >= i; ++k) {
        }
        return baseimplconnection;
    }

    public void reset() throws SQLException {
        int i = this.physicalConnectionPool.size();
        for (int j = 0; j < i; ++j) {
            BaseImplConnection baseimplconnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(j);
            baseimplconnection.reset();
        }
    }

    public void setCatalog(String s) throws SQLException {
        int i = this.physicalConnectionPool.size();
        for (int j = 0; j < i; ++j) {
            BaseImplConnection baseimplconnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(j);
            baseimplconnection.setCatalog(s);
        }
    }

    public void setTransactionIsolation(int i) throws SQLException {
        int j = this.physicalConnectionPool.size();
        for (int k = 0; k < j; ++k) {
            BaseImplConnection baseimplconnection = (BaseImplConnection)this.physicalConnectionPool.elementAt(k);
            baseimplconnection.setTransactionIsolation(i);
        }
    }
}

