/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.bos.jdbc.base;

import com.apusic.bos.jdbc.base.BaseCharacterStreamWrapper;
import com.apusic.bos.jdbc.base.BaseExceptions;
import com.apusic.bos.jdbc.base.BaseInputStreamWrapper;
import com.apusic.bos.util.UtilASCIIInputStreamToCharacterReader;
import com.apusic.bos.util.UtilBinaryToASCIIInputStream;
import com.apusic.bos.util.UtilDataConversions;
import com.apusic.bos.util.UtilDebug;
import com.apusic.bos.util.UtilStringFunctions;
import com.apusic.bos.util.UtilUCS2InputStreamToCharacterReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;

public class BaseData {
    private static String footprint = "$Revision:   1.47.1.1  $";
    public static final int UNKNOWN_DATA_OBJECT = 1000;
    public static final int BYTE = 1001;
    public static final int BYTE_ARRAY = 1002;
    public static final int SHORT = 1003;
    public static final int INTEGER = 1004;
    public static final int LONG = 1005;
    public static final int FLOAT = 1006;
    public static final int DOUBLE = 1007;
    public static final int BIGDECIMAL = 1008;
    public static final int BOOLEAN = 1009;
    public static final int STRING = 1010;
    public static final int DATE = 1011;
    public static final int TIME = 1012;
    public static final int TIMESTAMP = 1013;
    public static final int BINARYINPUTSTREAM = 1014;
    public static final int ASCIIINPUTSTREAM = 1015;
    public static final int UTF8INPUTSTREAM = 1016;
    public static final int UCS2INPUTSTREAM = 1017;
    public static final int CHARACTERSTREAMREADER = 1018;
    public static final int NULL = 1019;
    public int type;
    public Object data;

    BaseData() {
    }

    public BaseData(int i, Object obj) {
        this.setData(i, obj);
    }

    public BaseData(Object obj) {
        this.setData(obj);
    }

    public static int compare(BaseData basedata, BaseData basedata1, int i, BaseExceptions baseexceptions) throws SQLException {
        int j = 0;
        Object obj = basedata.getData(i, baseexceptions);
        Object obj1 = basedata1.getData(i, baseexceptions);
        switch (i) {
            default: {
                break;
            }
            case 1010: {
                String s = (String)obj;
                String s1 = (String)obj1;
                j = UtilStringFunctions.CompareStrings(s, s1);
                break;
            }
            case 1004: {
                int k = (Integer)obj;
                int l = (Integer)obj1;
                if (k > l) {
                    j = 1;
                    break;
                }
                if (k < l) {
                    j = -1;
                    break;
                }
                j = 0;
                break;
            }
            case 1003: {
                short word0 = (Short)obj;
                short word1 = (Short)obj1;
                if (word0 > word1) {
                    j = 1;
                    break;
                }
                if (word0 < word1) {
                    j = -1;
                    break;
                }
                j = 0;
                break;
            }
            case 1009: {
                boolean flag = (Boolean)obj;
                boolean flag1 = (Boolean)obj1;
                if (flag && !flag1) {
                    j = 1;
                    break;
                }
                if (!flag && flag1) {
                    j = -1;
                    break;
                }
                j = 0;
                break;
            }
        }
        return j;
    }

    public static Object convert(Object obj, int i, int j, BaseExceptions baseexceptions) throws SQLException {
        Object obj1 = null;
        if (i == 1011 && obj == null) {
            return null;
        }
        if (i != 1019 && obj == null) {
            throw baseexceptions.getException(6026);
        }
        switch (j) {
            case 1001: {
                obj1 = BaseData.convertToByte(obj, i, baseexceptions);
                break;
            }
            case 1002: {
                obj1 = BaseData.convertToByteArray(obj, i, baseexceptions);
                break;
            }
            case 1003: {
                obj1 = BaseData.convertToShort(obj, i, baseexceptions);
                break;
            }
            case 1004: {
                obj1 = BaseData.convertToInteger(obj, i, baseexceptions);
                break;
            }
            case 1005: {
                obj1 = BaseData.convertToLong(obj, i, baseexceptions);
                break;
            }
            case 1006: {
                obj1 = BaseData.convertToFloat(obj, i, baseexceptions);
                break;
            }
            case 1007: {
                obj1 = BaseData.convertToDouble(obj, i, baseexceptions);
                break;
            }
            case 1008: {
                obj1 = BaseData.convertToBigDecimal(obj, i, baseexceptions);
                break;
            }
            case 1009: {
                obj1 = BaseData.convertToBoolean(obj, i, baseexceptions);
                break;
            }
            case 1010: {
                obj1 = BaseData.convertToString(obj, i, baseexceptions);
                break;
            }
            case 1011: {
                obj1 = BaseData.convertToDate(obj, i, baseexceptions);
                break;
            }
            case 1012: {
                obj1 = BaseData.convertToTime(obj, i, baseexceptions);
                break;
            }
            case 1013: {
                obj1 = BaseData.convertToTimestamp(obj, i, baseexceptions);
                break;
            }
            case 1014: {
                obj1 = BaseData.convertToBinaryInputStream(obj, i, baseexceptions);
                break;
            }
            case 1015: {
                obj1 = BaseData.convertToASCIIInputStream(obj, i, baseexceptions);
                break;
            }
            case 1016: {
                obj1 = BaseData.convertToUTF8InputStream(obj, i, baseexceptions);
                break;
            }
            case 1017: {
                obj1 = BaseData.convertToUCS2InputStream(obj, i, baseexceptions);
                break;
            }
            case 1018: {
                obj1 = BaseData.convertToCharacterStreamReader(obj, i, baseexceptions);
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
        }
        return obj1;
    }

    public static InputStream convertToASCIIInputStream(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        InputStream obj1 = null;
        switch (i) {
            case 1015: {
                obj1 = (InputStream)obj;
                break;
            }
            case 1014: {
                obj1 = new UtilBinaryToASCIIInputStream((InputStream)obj);
                break;
            }
            case 1002: {
                obj1 = new UtilBinaryToASCIIInputStream(new ByteArrayInputStream((byte[])obj));
                break;
            }
            case 1010: {
                obj1 = UtilDataConversions.stringToASCIIInputStream((String)obj);
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
            case 1019: 
        }
        if (obj1 != null && !(obj1 instanceof BaseInputStreamWrapper)) {
            obj1 = new BaseInputStreamWrapper(obj1, -1, baseexceptions);
        }
        return obj1;
    }

    public static BigDecimal convertToBigDecimal(Object obj, int i, int j, BaseExceptions baseexceptions) throws SQLException {
        BigDecimal bigdecimal = BaseData.convertToBigDecimal(obj, i, baseexceptions);
        bigdecimal.setScale(j, 4);
        return bigdecimal;
    }

    public static BigDecimal convertToBigDecimal(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        BigDecimal bigdecimal = null;
        switch (i) {
            case 1001: {
                bigdecimal = new BigDecimal(((Byte)obj).toString());
                break;
            }
            case 1019: {
                break;
            }
            case 1015: 
            case 1017: {
                String s = BaseData.convertToString(obj, i, baseexceptions);
                bigdecimal = new BigDecimal(s.trim());
                break;
            }
            case 1010: {
                bigdecimal = new BigDecimal(((String)obj).trim());
                break;
            }
            case 1003: 
            case 1004: 
            case 1005: {
                bigdecimal = new BigDecimal(obj.toString());
                break;
            }
            case 1007: {
                bigdecimal = new BigDecimal((Double)obj);
                break;
            }
            case 1006: {
                bigdecimal = new BigDecimal(((Float)obj).doubleValue());
                break;
            }
            case 1008: {
                bigdecimal = (BigDecimal)obj;
                break;
            }
            case 1009: {
                if (((Boolean)obj).booleanValue()) {
                    bigdecimal = new BigDecimal(1.0);
                    break;
                }
                bigdecimal = new BigDecimal(0.0);
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
        }
        return bigdecimal;
    }

    public static InputStream convertToBinaryInputStream(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        InputStream obj1 = null;
        switch (i) {
            case 1014: {
                obj1 = (InputStream)obj;
                break;
            }
            case 1002: {
                obj1 = new ByteArrayInputStream((byte[])obj);
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
            case 1019: 
        }
        if (obj1 != null && !(obj1 instanceof BaseInputStreamWrapper)) {
            obj1 = new BaseInputStreamWrapper(obj1, -1, baseexceptions);
        }
        return obj1;
    }

    public static Boolean convertToBoolean(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        boolean flag = false;
        switch (i) {
            case 1001: {
                flag = (Byte)obj != 0;
                break;
            }
            case 1019: {
                break;
            }
            case 1003: {
                flag = (Short)obj != 0;
                break;
            }
            case 1004: {
                flag = (Integer)obj != 0;
                break;
            }
            case 1005: {
                flag = (Long)obj != 0L;
                break;
            }
            case 1006: {
                flag = (double)((Float)obj).floatValue() != 0.0;
                break;
            }
            case 1007: {
                flag = (Double)obj != 0.0;
                break;
            }
            case 1008: {
                flag = ((BigDecimal)obj).doubleValue() != 0.0;
                break;
            }
            case 1009: {
                return (Boolean)obj;
            }
            case 1010: 
            case 1015: 
            case 1017: {
                String s;
                if (i == 1010) {
                    s = ((String)obj).trim();
                } else {
                    String s1 = BaseData.convertToString(obj, i, baseexceptions);
                    s = s1.trim();
                }
                if (s.equalsIgnoreCase("true") || s.equalsIgnoreCase("1")) {
                    flag = true;
                    break;
                }
                if (s.equalsIgnoreCase("false") || s.equalsIgnoreCase("0")) {
                    flag = false;
                    break;
                }
                String[] as = new String[]{new String(String.valueOf(String.valueOf(new StringBuffer("Error converting the string '").append((String)obj).append("' to boolean."))))};
                throw baseexceptions.getException(6002, as);
            }
            default: {
                throw baseexceptions.getException(6009);
            }
        }
        return new Boolean(flag);
    }

    public static Byte convertToByte(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        byte byte0 = 0;
        switch (i) {
            case 1001: {
                byte0 = (Byte)obj;
                break;
            }
            case 1019: {
                break;
            }
            case 1003: {
                byte0 = ((Short)obj).byteValue();
                break;
            }
            case 1004: {
                byte0 = ((Integer)obj).byteValue();
                break;
            }
            case 1005: {
                byte0 = ((Long)obj).byteValue();
                break;
            }
            case 1006: {
                byte0 = ((Float)obj).byteValue();
                break;
            }
            case 1007: {
                byte0 = ((Double)obj).byteValue();
                break;
            }
            case 1008: {
                Integer integer = new Integer(((BigDecimal)obj).intValue());
                byte0 = integer.byteValue();
                break;
            }
            case 1009: {
                if (((Boolean)obj).booleanValue()) {
                    byte0 = 1;
                    break;
                }
                byte0 = 0;
                break;
            }
            case 1015: 
            case 1017: {
                String s = BaseData.convertToString(obj, i, baseexceptions);
                byte0 = Byte.parseByte(s.trim());
                break;
            }
            case 1010: {
                byte0 = Byte.parseByte(((String)obj).trim());
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
        }
        return new Byte(byte0);
    }

    public static byte[] convertToByteArray(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        byte[] abyte0 = null;
        switch (i) {
            case 1010: {
                abyte0 = BaseData.stringToBytes((String)obj, baseexceptions);
                break;
            }
            case 1019: {
                break;
            }
            case 1002: {
                abyte0 = (byte[])obj;
                break;
            }
            case 1018: {
                String s = BaseData.convertToString(obj, i, baseexceptions);
                abyte0 = BaseData.stringToBytes(s, baseexceptions);
                break;
            }
            case 1014: {
                ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
                byte[] abyte1 = new byte[1024];
                boolean flag = false;
                while (!flag) {
                    int j;
                    try {
                        j = ((InputStream)obj).read(abyte1, 0, abyte1.length);
                    }
                    catch (IOException ioexception) {
                        throw baseexceptions.getException(ioexception);
                    }
                    if (j == -1) {
                        flag = true;
                        try {
                            ((InputStream)obj).close();
                            continue;
                        }
                        catch (IOException ioexception1) {
                            throw baseexceptions.getException(ioexception1);
                        }
                    }
                    if (j == -2) {
                        throw baseexceptions.getException(6032);
                    }
                    bytearrayoutputstream.write(abyte1, 0, j);
                }
                abyte0 = bytearrayoutputstream.toByteArray();
                break;
            }
            case 1015: 
            case 1017: {
                String s1 = BaseData.convertToString(obj, i, baseexceptions);
                abyte0 = BaseData.stringToBytes(s1, baseexceptions);
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
        }
        return abyte0;
    }

    public static Reader convertToCharacterStreamReader(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        Reader obj1;
        block9: {
            obj1 = null;
            switch (i) {
                case 1010: {
                    obj1 = new StringReader((String)obj);
                    break;
                }
                case 1015: {
                    obj1 = new UtilASCIIInputStreamToCharacterReader((InputStream)obj);
                    break;
                }
                case 1002: {
                    String s = UtilDataConversions.bytesToString((byte[])obj, ((byte[])obj).length);
                    obj1 = new StringReader(s);
                    break;
                }
                case 1014: {
                    UtilBinaryToASCIIInputStream utilbinarytoasciiinputstream = new UtilBinaryToASCIIInputStream((InputStream)obj);
                    obj1 = new UtilASCIIInputStreamToCharacterReader(utilbinarytoasciiinputstream);
                    break;
                }
                case 1017: {
                    obj1 = new UtilUCS2InputStreamToCharacterReader((InputStream)obj);
                    break;
                }
                case 1018: {
                    obj1 = (Reader)obj;
                    break;
                }
                default: {
                    throw baseexceptions.getException(6009);
                }
                case 1019: {
                    break;
                }
            }
            if (obj1 == null || obj1 instanceof BaseCharacterStreamWrapper) break block9;
            obj1 = new BaseCharacterStreamWrapper(obj1, -1, baseexceptions);
        }
        return obj1;
    }

    public static Date convertToDate(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        Date date = null;
        switch (i) {
            case 1015: 
            case 1017: {
                String s = BaseData.convertToString(obj, i, baseexceptions);
                date = Date.valueOf(s.trim());
                break;
            }
            case 1010: {
                date = Date.valueOf(((String)obj).trim());
                break;
            }
            case 1013: {
                Timestamp timestamp = (Timestamp)obj;
                date = new Date(timestamp.getYear(), timestamp.getMonth(), timestamp.getDate());
                break;
            }
            case 1011: {
                date = (Date)obj;
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
            case 1019: {
                break;
            }
        }
        return date;
    }

    public static Double convertToDouble(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        double d = 0.0;
        switch (i) {
            case 1001: {
                d = ((Byte)obj).doubleValue();
                break;
            }
            case 1019: {
                break;
            }
            case 1003: {
                d = ((Short)obj).doubleValue();
                break;
            }
            case 1004: {
                d = ((Integer)obj).doubleValue();
                break;
            }
            case 1005: {
                d = ((Long)obj).doubleValue();
                break;
            }
            case 1006: {
                d = ((Float)obj).doubleValue();
                break;
            }
            case 1007: {
                return (Double)obj;
            }
            case 1008: {
                d = ((BigDecimal)obj).doubleValue();
                break;
            }
            case 1009: {
                if (((Boolean)obj).booleanValue()) {
                    d = 1.0;
                    break;
                }
                d = 0.0;
                break;
            }
            case 1015: 
            case 1017: {
                String s = BaseData.convertToString(obj, i, baseexceptions);
                d = Double.valueOf(s.trim());
                break;
            }
            case 1010: {
                d = Double.valueOf(((String)obj).trim());
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
        }
        return new Double(d);
    }

    public static Float convertToFloat(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        float f = 0.0f;
        switch (i) {
            case 1001: {
                f = ((Byte)obj).floatValue();
                break;
            }
            case 1019: {
                break;
            }
            case 1003: {
                f = ((Short)obj).floatValue();
                break;
            }
            case 1004: {
                f = ((Integer)obj).floatValue();
                break;
            }
            case 1005: {
                f = ((Long)obj).floatValue();
                break;
            }
            case 1006: {
                return (Float)obj;
            }
            case 1007: {
                f = ((Double)obj).floatValue();
                break;
            }
            case 1008: {
                f = ((BigDecimal)obj).floatValue();
                break;
            }
            case 1009: {
                if (((Boolean)obj).booleanValue()) {
                    f = 1.0f;
                    break;
                }
                f = 0.0f;
                break;
            }
            case 1015: 
            case 1017: {
                String s = BaseData.convertToString(obj, i, baseexceptions);
                f = Float.valueOf(s.trim()).floatValue();
                break;
            }
            case 1010: {
                f = Float.valueOf(((String)obj).trim()).floatValue();
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
        }
        return new Float(f);
    }

    public static Integer convertToInteger(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        int j = 0;
        switch (i) {
            case 1001: {
                j = ((Byte)obj).byteValue();
                break;
            }
            case 1019: {
                break;
            }
            case 1003: {
                j = ((Short)obj).intValue();
                break;
            }
            case 1004: {
                return (Integer)obj;
            }
            case 1005: {
                j = ((Long)obj).intValue();
                break;
            }
            case 1006: {
                j = ((Float)obj).intValue();
                break;
            }
            case 1007: {
                j = ((Double)obj).intValue();
                break;
            }
            case 1008: {
                j = ((BigDecimal)obj).intValue();
                break;
            }
            case 1009: {
                if (((Boolean)obj).booleanValue()) {
                    j = 1;
                    break;
                }
                j = 0;
                break;
            }
            case 1015: 
            case 1017: {
                String s = BaseData.convertToString(obj, i, baseexceptions);
                j = Integer.parseInt(s.trim());
                break;
            }
            case 1010: {
                j = Integer.parseInt(((String)obj).trim());
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
        }
        return new Integer(j);
    }

    public static Long convertToLong(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        long l = 0L;
        switch (i) {
            case 1001: {
                l = ((Byte)obj).byteValue();
                break;
            }
            case 1019: {
                break;
            }
            case 1003: {
                l = ((Short)obj).longValue();
                break;
            }
            case 1004: {
                l = ((Integer)obj).longValue();
                break;
            }
            case 1005: {
                return (Long)obj;
            }
            case 1006: {
                l = ((Float)obj).longValue();
                break;
            }
            case 1007: {
                l = ((Double)obj).longValue();
                break;
            }
            case 1008: {
                l = ((BigDecimal)obj).longValue();
                break;
            }
            case 1009: {
                if (((Boolean)obj).booleanValue()) {
                    l = 1L;
                    break;
                }
                l = 0L;
                break;
            }
            case 1015: 
            case 1017: {
                String s = BaseData.convertToString(obj, i, baseexceptions);
                l = Long.parseLong(s.trim());
                break;
            }
            case 1010: {
                l = Long.parseLong(((String)obj).trim());
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
        }
        return new Long(l);
    }

    public static Short convertToShort(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        short word0 = 0;
        switch (i) {
            case 1001: {
                word0 = ((Byte)obj).byteValue();
                break;
            }
            case 1019: {
                break;
            }
            case 1003: {
                return (Short)obj;
            }
            case 1004: {
                word0 = ((Integer)obj).shortValue();
                break;
            }
            case 1005: {
                word0 = ((Long)obj).shortValue();
                break;
            }
            case 1006: {
                word0 = ((Float)obj).shortValue();
                break;
            }
            case 1007: {
                word0 = ((Double)obj).shortValue();
                break;
            }
            case 1008: {
                Integer integer = new Integer(((BigDecimal)obj).intValue());
                word0 = integer.shortValue();
                break;
            }
            case 1009: {
                if (((Boolean)obj).booleanValue()) {
                    word0 = 1;
                    break;
                }
                word0 = 0;
                break;
            }
            case 1015: 
            case 1017: {
                String s = BaseData.convertToString(obj, i, baseexceptions);
                word0 = Short.parseShort(s.trim());
                break;
            }
            case 1010: {
                word0 = Short.parseShort(((String)obj).trim());
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
        }
        return new Short(word0);
    }

    public static String convertToString(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        String s = null;
        switch (i) {
            case 1002: {
                s = UtilDataConversions.bytesToString((byte[])obj, ((byte[])obj).length);
                break;
            }
            case 1019: {
                break;
            }
            case 1014: {
                byte[] abyte0 = BaseData.convertToByteArray(obj, i, baseexceptions);
                s = UtilDataConversions.bytesToString(abyte0, abyte0.length);
                break;
            }
            case 1015: 
            case 1017: {
                int j = -1;
                if (obj instanceof BaseInputStreamWrapper) {
                    j = ((BaseInputStreamWrapper)obj).numTotalBytesInStream;
                }
                if (j == -1) {
                    j = 10240;
                }
                StringBuffer stringbuffer1 = new StringBuffer(j);
                boolean flag1 = false;
                byte[] abyte1 = new byte[j];
                boolean flag3 = false;
                while (!flag3) {
                    int l;
                    try {
                        l = ((InputStream)obj).read(abyte1, 0, abyte1.length);
                    }
                    catch (IOException ioexception2) {
                        throw baseexceptions.getException(ioexception2);
                    }
                    if (l == -1) {
                        flag3 = true;
                        try {
                            ((InputStream)obj).close();
                            continue;
                        }
                        catch (IOException ioexception3) {
                            throw baseexceptions.getException(ioexception3);
                        }
                    }
                    if (l == -2) {
                        throw baseexceptions.getException(6032);
                    }
                    if (i == 1015) {
                        stringbuffer1.append(UtilDataConversions.ASCIIBytesToString(abyte1, l));
                        continue;
                    }
                    stringbuffer1.append(UtilDataConversions.UCS2BytesToString(abyte1, l));
                }
                s = stringbuffer1.toString();
                break;
            }
            case 1018: {
                StringBuffer stringbuffer = new StringBuffer();
                boolean flag = false;
                char[] ac = new char[1024];
                boolean flag2 = false;
                while (!flag2) {
                    int k;
                    try {
                        k = ((Reader)obj).read(ac, 0, ac.length);
                    }
                    catch (IOException ioexception) {
                        throw baseexceptions.getException(ioexception);
                    }
                    if (k == -1) {
                        flag2 = true;
                        try {
                            ((Reader)obj).close();
                            continue;
                        }
                        catch (IOException ioexception1) {
                            throw baseexceptions.getException(ioexception1);
                        }
                    }
                    if (k == -2) {
                        throw baseexceptions.getException(6032);
                    }
                    stringbuffer.append(ac, 0, k);
                }
                s = stringbuffer.toString();
                break;
            }
            case 1016: {
                throw baseexceptions.getException(6009);
            }
            case 1010: {
                return (String)obj;
            }
            default: {
                s = obj.toString();
                break;
            }
        }
        return s;
    }

    public static Time convertToTime(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        Time time = null;
        switch (i) {
            case 1015: 
            case 1017: {
                String s = BaseData.convertToString(obj, i, baseexceptions);
                time = Time.valueOf(s.trim());
                break;
            }
            case 1010: {
                time = Time.valueOf(((String)obj).trim());
                break;
            }
            case 1012: {
                time = (Time)obj;
                break;
            }
            case 1013: {
                Timestamp timestamp = (Timestamp)obj;
                time = new Time(timestamp.getHours(), timestamp.getMinutes(), timestamp.getSeconds());
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
            case 1019: {
                break;
            }
        }
        return time;
    }

    public static Timestamp convertToTimestamp(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        Timestamp timestamp = null;
        switch (i) {
            case 1015: 
            case 1017: {
                String s = BaseData.convertToString(obj, i, baseexceptions);
                timestamp = Timestamp.valueOf(s.trim());
                break;
            }
            case 1019: {
                break;
            }
            case 1010: {
                timestamp = Timestamp.valueOf(((String)obj).trim());
                break;
            }
            case 1011: 
            case 1012: {
                if (obj == null) break;
                Calendar calendar = Calendar.getInstance();
                if (i == 1012) {
                    calendar.setTime((Time)obj);
                } else {
                    calendar.setTime((Date)obj);
                }
                timestamp = new Timestamp(calendar.getTime().getTime());
                break;
            }
            case 1013: {
                timestamp = (Timestamp)obj;
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
        }
        return timestamp;
    }

    public static InputStream convertToUCS2InputStream(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        InputStream obj1 = null;
        switch (i) {
            case 1017: {
                obj1 = (InputStream)obj;
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
            case 1019: 
        }
        if (obj1 != null && !(obj1 instanceof BaseInputStreamWrapper)) {
            obj1 = new BaseInputStreamWrapper(obj1, -1, baseexceptions);
        }
        return obj1;
    }

    public static InputStream convertToUTF8InputStream(Object obj, int i, BaseExceptions baseexceptions) throws SQLException {
        InputStream obj1 = null;
        switch (i) {
            case 1016: {
                obj1 = (InputStream)obj;
                break;
            }
            default: {
                throw baseexceptions.getException(6009);
            }
            case 1019: 
        }
        if (obj1 != null && !(obj1 instanceof BaseInputStreamWrapper)) {
            obj1 = new BaseInputStreamWrapper(obj1, -1, baseexceptions);
        }
        return obj1;
    }

    public Object getData(int i, int j, BaseExceptions baseexceptions) throws SQLException {
        Object obj = this.getData(i, baseexceptions);
        if (obj instanceof BigDecimal) {
            obj = ((BigDecimal)obj).setScale(j, 4);
        }
        return obj;
    }

    public Object getData(int i, BaseExceptions baseexceptions) throws SQLException {
        Object obj = null;
        try {
            obj = BaseData.convert(this.data, this.type, i, baseexceptions);
        }
        catch (Exception exception) {
            if (exception.getClass().getName().compareTo("java.sql.SQLException") != 0) {
                SQLException sqlexception = new SQLException(exception.getClass().getName());
                throw baseexceptions.getException(sqlexception, 6025);
            }
            throw (SQLException)exception;
        }
        return obj;
    }

    public static int getJavaObjectType(Object obj) {
        int c = 1000;
        if (obj == null) {
            c = 1019;
        } else {
            String s = obj.getClass().getName();
            if (s.equals("java.lang.Integer")) {
                c = 1004;
            } else if (s.equals("java.lang.Byte")) {
                c = 1001;
            } else if (s.equals("[B")) {
                c = 1002;
            } else if (s.equals("java.lang.Short")) {
                c = 1003;
            } else if (s.equals("java.lang.Long")) {
                c = 1005;
            } else if (s.equals("java.lang.Float")) {
                c = 1006;
            } else if (s.equals("java.lang.Double")) {
                c = 1007;
            } else if (s.equals("java.math.BigDecimal")) {
                c = 1008;
            } else if (s.equals("java.lang.Boolean")) {
                c = 1009;
            } else if (s.equals("java.lang.String")) {
                c = 1010;
            } else if (s.equals("java.sql.Date")) {
                c = 1011;
            } else if (s.equals("java.sql.Time")) {
                c = 1012;
            } else if (s.equals("java.sql.Timestamp")) {
                c = 1013;
            } else {
                UtilDebug.assert("Unable to autodetect data type.", false);
            }
        }
        return c;
    }

    public Object getLongData(int i, Object obj, BaseExceptions baseexceptions) throws SQLException {
        Object obj1 = this.getData(i, baseexceptions);
        if (obj1 instanceof BaseInputStreamWrapper) {
            ((BaseInputStreamWrapper)obj1).setSynchronizer(obj);
        } else if (obj1 instanceof BaseCharacterStreamWrapper) {
            ((BaseCharacterStreamWrapper)obj1).setSynchronizer(obj);
        }
        return obj1;
    }

    public static boolean isInputStream(int i) {
        switch (i) {
            case 1014: 
            case 1015: 
            case 1016: 
            case 1017: {
                return true;
            }
        }
        return false;
    }

    static int mapJDBCTypeToJavaObjectType(int i) {
        int c = 0;
        switch (i) {
            case -1: 
            case 1: 
            case 12: {
                c = 1010;
                break;
            }
            case 2: 
            case 3: {
                c = 1008;
                break;
            }
            case -7: {
                c = 1009;
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                c = 1004;
                break;
            }
            case -5: {
                c = 1005;
                break;
            }
            case 7: {
                c = 1006;
                break;
            }
            case 6: 
            case 8: {
                c = 1007;
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                c = 1002;
                break;
            }
            case 91: {
                c = 1011;
                break;
            }
            case 92: {
                c = 1012;
                break;
            }
            case 93: {
                c = 1013;
                break;
            }
            case 0: {
                c = 1019;
            }
        }
        return c;
    }

    static String mapJDBCTypeToJavaObjectTypeName(int i) {
        String s = null;
        switch (i) {
            case -1: 
            case 1: 
            case 12: {
                s = "java.lang.String";
                break;
            }
            case 2: 
            case 3: {
                s = "java.math.BigDecimal";
                break;
            }
            case -7: {
                s = "java.lang.Boolean";
                break;
            }
            case -6: 
            case 4: 
            case 5: {
                s = "java.lang.Integer";
                break;
            }
            case -5: {
                s = "java.lang.Long";
                break;
            }
            case 7: {
                s = "java.lang.Float";
                break;
            }
            case 6: 
            case 8: {
                s = "java.lang.Double";
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                s = "byte[]";
                break;
            }
            case 91: {
                s = "java.sql.Date";
                break;
            }
            case 92: {
                s = "java.sql.Time";
                break;
            }
            case 93: {
                s = "java.sql.Timestamp";
                break;
            }
            case 2005: {
                s = "java.sql.Clob";
                break;
            }
            case 2004: {
                s = "java.sql.Blob";
                break;
            }
            case 2003: {
                s = "java.sql.Array";
                break;
            }
            case 2006: {
                s = "java.sql.Ref";
                break;
            }
            case 2002: {
                s = "java.sql.Struct";
                break;
            }
            default: {
                s = "";
            }
        }
        return s;
    }

    public void setData(int i, Object obj) {
        this.type = i;
        this.data = obj;
    }

    public void setData(Object obj) {
        this.type = BaseData.getJavaObjectType(obj);
        this.data = obj;
    }

    public static byte[] stringToBytes(String s, BaseExceptions baseexceptions) throws SQLException {
        int i = s.length();
        if (i % 2 != 0) {
            throw baseexceptions.getException(6033);
        }
        byte[] abyte0 = new byte[i / 2];
        boolean flag = true;
        for (int j = 0; j < i; ++j) {
            byte byte0;
            char c = s.charAt(j);
            if (c >= '0' && c <= '9') {
                byte0 = (byte)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                byte0 = (byte)(c - 97 + 10);
            } else if (c >= 'A' && c <= 'F') {
                byte0 = (byte)(c - 65 + 10);
            } else {
                throw baseexceptions.getException(6033);
            }
            if (flag) {
                abyte0[j / 2] = (byte)(byte0 << 4);
                flag = false;
                continue;
            }
            int n = j / 2;
            abyte0[n] = (byte)(abyte0[n] + byte0);
            flag = true;
        }
        return abyte0;
    }

    public static void truncate(BaseData basedata, int i, BaseExceptions baseexceptions) {
        if (basedata.data == null || i == 0) {
            return;
        }
        switch (basedata.type) {
            default: {
                break;
            }
            case 1010: {
                String s = (String)basedata.data;
                if (s == null || s.length() <= i) break;
                s = s.substring(0, i);
                basedata.data = s;
                break;
            }
            case 1014: 
            case 1015: 
            case 1016: 
            case 1017: {
                InputStream inputstream = (InputStream)basedata.data;
                if (!(inputstream instanceof BaseInputStreamWrapper)) {
                    basedata.data = new BaseInputStreamWrapper(inputstream, -1, baseexceptions);
                }
                BaseInputStreamWrapper baseinputstreamwrapper = (BaseInputStreamWrapper)basedata.data;
                baseinputstreamwrapper.maxBytesToReturn = i;
                break;
            }
            case 1002: {
                byte[] abyte0 = (byte[])basedata.data;
                if (abyte0 == null || abyte0.length <= i) break;
                byte[] abyte1 = new byte[i];
                System.arraycopy(abyte0, 0, abyte1, 0, i);
                basedata.data = abyte1;
                break;
            }
        }
    }

    static {
        UNKNOWN_DATA_OBJECT = 1000;
        BYTE = 1001;
        BYTE_ARRAY = 1002;
        SHORT = 1003;
        INTEGER = 1004;
        LONG = 1005;
        FLOAT = 1006;
        DOUBLE = 1007;
        BIGDECIMAL = 1008;
        BOOLEAN = 1009;
        STRING = 1010;
        DATE = 1011;
        TIME = 1012;
        TIMESTAMP = 1013;
        BINARYINPUTSTREAM = 1014;
        ASCIIINPUTSTREAM = 1015;
        UTF8INPUTSTREAM = 1016;
        UCS2INPUTSTREAM = 1017;
        CHARACTERSTREAMREADER = 1018;
        NULL = 1019;
    }
}

