/*
 * Decompiled with CFR 0.152.
 */
package com.apusic.bos.jdbc.base;

import com.apusic.bos.jdbc.base.BaseClassUtility;
import com.apusic.bos.jdbc.base.BaseConnection;
import com.apusic.bos.jdbc.base.BaseConnectionProperties;
import com.apusic.bos.jdbc.base.BaseDatabaseMetaData;
import com.apusic.bos.jdbc.base.BaseExceptions;
import com.apusic.bos.jdbc.base.BaseMessages;
import com.apusic.bos.jdbc.base.BaseURLParser;
import com.apusic.bos.util.UtilDebug;
import com.apusic.bos.util.UtilDummyPrintWriter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;

public abstract class BaseDriver
implements Driver {
    private static String footprint = "$Revision:   1.19  $";
    public UtilDebug debug;
    public BaseExceptions exceptions;

    public final boolean acceptsURL(String url) throws SQLException {
        this.setupExceptionHandling();
        BaseURLParser baseurlparser = new BaseURLParser();
        return baseurlparser.parse(BaseClassUtility.getRootName(this), url, false, null);
    }

    public final Connection connect(String s, Properties properties) throws SQLException {
        this.setupExceptionHandling();
        BaseConnection baseconnection = BaseClassUtility.getConnection(this);
        BaseConnectionProperties baseconnectionproperties = new BaseConnectionProperties();
        BaseURLParser baseurlparser = new BaseURLParser();
        baseconnectionproperties.putDefaults(baseconnection.getPropertyInfo());
        baseconnectionproperties.put("loginTimeout", String.valueOf(DriverManager.getLoginTimeout()));
        String s1 = BaseClassUtility.getRootName(this);
        if (baseurlparser.parse(s1, s, true, baseconnectionproperties)) {
            if (properties != null) {
                baseconnectionproperties.putUserSpecifed(properties);
            }
            try {
                this.debug = BaseDriver.setupDebugging(baseconnectionproperties);
                baseconnection.open(baseconnectionproperties, this.exceptions, this.debug);
            }
            catch (SQLException sqlexception) {
                baseconnection = null;
                throw sqlexception;
            }
        } else {
            if (baseurlparser.parse(s1, s, false, null)) {
                throw this.exceptions.getException(6031);
            }
            baseconnection = null;
        }
        return baseconnection;
    }

    protected static void dumpDriverInfo(BaseDriver basedriver) {
        try {
            BaseMessages basemessages = new BaseMessages(BaseClassUtility.getRootName(basedriver));
            String[] as = new String[]{new BaseDatabaseMetaData().getDriverVersion()};
            System.out.flush();
            System.out.println(basemessages.getMessage(6017, as, false));
        }
        catch (Exception exception) {
            System.err.println(exception.getMessage());
        }
    }

    public final int getMajorVersion() {
        return 2;
    }

    public final int getMinorVersion() {
        return 0;
    }

    public final DriverPropertyInfo[] getPropertyInfo(String s, Properties properties) throws SQLException {
        this.setupExceptionHandling();
        DriverPropertyInfo[] adriverpropertyinfo = null;
        BaseURLParser baseurlparser = new BaseURLParser();
        if (baseurlparser.parse(BaseClassUtility.getRootName(this), s, true, null)) {
            BaseConnection baseconnection = BaseClassUtility.getConnection(this);
            adriverpropertyinfo = baseconnection.getPropertyInfo().get();
        }
        return adriverpropertyinfo;
    }

    public final boolean jdbcCompliant() {
        return true;
    }

    protected static void registerDriver(BaseDriver basedriver) {
        try {
            DriverManager.registerDriver(basedriver);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static UtilDebug setupDebugging(BaseConnectionProperties baseconnectionproperties) {
        UtilDebug utildebug = new UtilDebug();
        try {
            String s = baseconnectionproperties.get("debug_to_standard_out");
            boolean _tmp = s != null && s.equalsIgnoreCase("true");
            utildebug.setPrintWriter(new UtilDummyPrintWriter());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return utildebug;
    }

    private void setupExceptionHandling() throws SQLException {
        if (this.exceptions == null) {
            this.exceptions = new BaseExceptions(BaseClassUtility.getRootName(this));
        }
    }
}

