/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.dial;

import com.kingdee.bos.ctrl.swing.dial.DialElement;
import com.kingdee.bos.ctrl.swing.dial.DialGraduator;
import com.kingdee.bos.ctrl.swing.dial.DialNeedle;
import com.kingdee.bos.ctrl.swing.dial.DialTickValueGenerator;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.text.Format;
import java.util.NoSuchElementException;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DialScale
implements DialElement {
    protected String caption = "";
    protected Paint captionPaint = Color.YELLOW;
    protected Paint ticksPaint = Color.MAGENTA;
    protected Paint labelPaint = Color.WHITE;
    protected Paint arcPaint = Color.CYAN;
    protected boolean clockwise = true;
    protected int maximumAngle;
    protected int minimumAngle;
    protected Object maximumValue;
    protected Object minimumValue;
    private boolean dirty = false;
    protected boolean tickLabelVisible = true;
    protected Point axle;
    protected int radius;
    public static final int DEFAULTLENGTH = 7;
    protected int tickLength = 7;
    protected Format tickLabelFormat;
    protected DialGraduator graduator;
    protected DialTickValueGenerator generator;
    protected DataChangeHandler dataHandler;
    protected DialNeedle needle;

    public DialScale() {
        this.init();
    }

    public DialScale(Point pt, int r) {
        this();
        this.setAxle(pt);
        this.setRadius(r);
    }

    public DialScale(Point pt, int r, int minAngle, int arcAngle) {
        this(pt, r);
        this.setMinimumAngle(minAngle);
        this.setMaximumAngle(minAngle + arcAngle);
    }

    public DialScale(Point pt, int r, int minAngle, int arcAngle, Object minValue, Object maxValue) {
        this(pt, r, minAngle, arcAngle);
        this.setMinimumValue(minValue);
        this.setMaximumValue(maxValue);
    }

    public DialScale(Point pt, int r, int minAngle, int arcAngle, boolean cw) {
        this(pt, r, minAngle, arcAngle);
        this.setClockWise(cw);
    }

    public DialScale(Point pt, int r, int minAngle, int arcAngle, Object minValue, Object maxValue, boolean cw) {
        this(pt, r, minAngle, arcAngle, minValue, maxValue);
        this.setClockWise(cw);
    }

    protected void init() {
        this.graduator = this.createGraduator();
        this.generator = this.createGenerator();
    }

    protected DialGraduator createGraduator() {
        return new DialGraduator();
    }

    protected DialTickValueGenerator createGenerator() {
        return new DefaultDialTickValueGenerator();
    }

    public Point getAxle() {
        return this.axle;
    }

    public void setAxle(Point point2D) {
        this.axle = point2D;
    }

    public DialGraduator getGraduator() {
        return this.graduator;
    }

    public void setGraduator(DialGraduator gr) {
        this.graduator = gr;
    }

    public double getAngle(Object value) {
        if (this.graduator == null) {
            return 0.0;
        }
        double ret = this.graduator.getAngle(value);
        ret += (double)this.getMinimumAngle();
        if (!this.isClockWise()) {
            ret = DialUtils.geomToCW(ret);
        }
        return ret;
    }

    public void install(DialNeedle ndl) {
        this.needle = ndl;
        if (this.dataHandler == null) {
            this.dataHandler = new DataChangeHandler();
        }
        this.needle.addChangeListener(this.dataHandler);
    }

    public void dismiss() {
        if (this.dataHandler == null) {
            return;
        }
        this.needle.removeChangeListener(this.dataHandler);
    }

    public void update() {
    }

    public void draw(Graphics g, Rectangle area, JComponent c) {
        int start = this.getMinimumAngle();
        int arc = this.getMaximumAngle() - start;
        if (this.isDirty()) {
            this.graduator.setParameters(this.getMinimumValue(), this.getMaximumValue(), arc);
            this.generator.setParameters(this.getMinimumValue(), this.getMaximumValue());
            this.setDirty(false);
        }
        Graphics2D g2 = (Graphics2D)g;
        this.drawArcs(g2, start, arc, c);
        this.drawTicks(g2, start, arc, c);
        this.drawCaption(g2, this.getAxle().x, this.getAxle().y);
    }

    protected void drawTicks(Graphics2D g2, double amin, double as, JComponent c) {
        AffineTransform oldTrans = g2.getTransform();
        AffineTransform t = new AffineTransform();
        Paint old = g2.getPaint();
        Format ft = this.getTickLabelFormat();
        double angle = 0.0;
        String label = "";
        int SQUARE = 90;
        FontMetrics fm = g2.getFontMetrics();
        int w = 0;
        int h = fm.getAscent() - fm.getLeading();
        boolean tickLeading = true;
        int tickLen = this.getTickLength();
        while (this.generator.hasNext()) {
            Object val = this.generator.next();
            angle = this.getAngle(val) - 90.0;
            t.setToRotation(Math.toRadians(angle), this.getAxle().x, this.getAxle().y);
            g2.setPaint(this.getTicksPaint());
            g2.transform(t);
            g2.drawLine(this.getAxle().x, this.getAxle().y - this.getRadius() + 1, this.getAxle().x, this.getAxle().y - this.getRadius() + tickLen);
            if (this.isTickLabelVisible()) {
                g2.setPaint(this.getTickLabelPaint());
                label = ft != null ? ft.format(val) : val.toString();
                w = fm.stringWidth(label);
                g2.drawString(label, this.getAxle().x - w / 2, this.getAxle().y - this.getRadius() + tickLen + h);
            }
            g2.setTransform(oldTrans);
        }
        g2.setPaint(old);
        g2.setTransform(oldTrans);
    }

    protected void drawArcs(Graphics2D g2, double start, double arc, JComponent c) {
        int r = this.getRadius();
        int x = this.getAxle().x;
        int y = this.getAxle().y;
        Paint old = g2.getPaint();
        g2.setPaint(this.getArcPaint());
        if (this.isClockWise()) {
            g2.drawArc(x - r, y - r, 2 * r, 2 * r, (int)DialUtils.cwToGeom(start, arc), (int)arc);
        } else {
            g2.drawArc(x - r, y - r, 2 * r, 2 * r, (int)start, (int)arc);
        }
        g2.setPaint(old);
    }

    protected void drawCaption(Graphics2D g2, int x, int y) {
        String cap = this.getCaption();
        if (cap != null) {
            g2.setPaint(this.getCaptionPaint());
            g2.drawString(this.getCaption(), x - 8, y - 8);
        }
    }

    public int getRadius() {
        return this.radius;
    }

    public void setRadius(int r) {
        this.radius = r;
    }

    public Object getMaximumValue() {
        return this.maximumValue;
    }

    public void setMaximumValue(Object maxValue) {
        this.maximumValue = maxValue;
        this.setDirty(true);
    }

    public Object getMinimumValue() {
        return this.minimumValue;
    }

    public void setMinimumValue(Object minValue) {
        this.minimumValue = minValue;
        this.setDirty(true);
    }

    public int getMaximumAngle() {
        return this.maximumAngle;
    }

    public void setMaximumAngle(int maxAngle) {
        this.maximumAngle = maxAngle;
        this.setDirty(true);
    }

    public int getMinimumAngle() {
        return this.minimumAngle;
    }

    public void setMinimumAngle(int minAngle) {
        this.minimumAngle = minAngle;
        this.setDirty(true);
    }

    protected boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean b) {
        this.dirty = b;
    }

    public void setClockWise(boolean cw) {
        if (this.clockwise != cw) {
            this.clockwise = cw;
        }
    }

    public boolean isClockWise() {
        return this.clockwise;
    }

    public String getCaption() {
        return this.caption;
    }

    public void setCaption(String str) {
        this.caption = str != null ? str : "";
    }

    public Paint getCaptionPaint() {
        return this.captionPaint;
    }

    public void setCaptionPaint(Paint paint) {
        this.captionPaint = paint;
    }

    public Paint getTicksPaint() {
        return this.ticksPaint;
    }

    public void setTicksPaint(Paint paint) {
        this.ticksPaint = paint;
    }

    public Paint getTickLabelPaint() {
        return this.labelPaint;
    }

    public void setTickLabelPaint(Paint paint) {
        this.labelPaint = paint;
    }

    public void setTickLabelFormat(Format f) {
        this.tickLabelFormat = f;
    }

    public Format getTickLabelFormat() {
        return this.tickLabelFormat;
    }

    public int getTickLength() {
        return this.tickLength;
    }

    public void setTickLength(int i) {
        this.tickLength = i;
    }

    public boolean isTickLabelVisible() {
        return this.tickLabelVisible;
    }

    public void setTickLabelVisible(boolean b) {
        this.tickLabelVisible = b;
    }

    public DialTickValueGenerator getGenerator() {
        return this.generator;
    }

    public void setGenerator(DefaultDialTickValueGenerator generator) {
        this.generator = generator;
    }

    public Paint getArcPaint() {
        return this.arcPaint;
    }

    public void setArcPaint(Paint paint) {
        this.arcPaint = paint;
    }

    protected static class DataChangeHandler
    implements ChangeListener {
        protected DataChangeHandler() {
        }

        public void stateChanged(ChangeEvent e) {
        }
    }

    public static final class DialUtils {
        protected static final double HALFCIRCLE = 180.0;
        protected static final double FULLCIRCLE = 360.0;

        public static double cwToGeom(double start, double arc) {
            return 180.0 - start - arc;
        }

        public static double geomToCW(double start, double arc) {
            return 180.0 - start - arc;
        }

        public static double cwToGeom(double angle) {
            return 180.0 - angle;
        }

        public static double geomToCW(double angle) {
            return 180.0 - angle;
        }
    }

    protected static class DefaultDialTickValueGenerator
    implements DialTickValueGenerator {
        protected int minimum;
        protected int maximum;
        protected int cur;
        protected int step = 20;

        protected DefaultDialTickValueGenerator() {
        }

        public boolean hasNext() {
            if (this.cur + this.step <= this.maximum) {
                return true;
            }
            this.initCurrentValue();
            return false;
        }

        public Object next() {
            this.cur += this.step;
            if (this.cur > this.maximum) {
                throw new NoSuchElementException();
            }
            return new Integer(this.cur);
        }

        public void setParameters(Object min, Object max) {
            this.setMinimum(min);
            this.setMaximum(max);
        }

        public void setMaximum(Object max) {
            if (max instanceof Number) {
                this.maximum = ((Number)max).intValue();
            }
        }

        public void setMinimum(Object min) {
            if (min instanceof Number) {
                this.minimum = ((Number)min).intValue();
                this.initCurrentValue();
            }
        }

        protected void initCurrentValue() {
            int min = this.minimum;
            int i = min % this.step;
            this.cur = i != 0 ? min - i : min - this.step;
        }
    }
}

