/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.ctrl.swing.dial;

import com.kingdee.bos.ctrl.swing.dial.DialNeedle;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import javax.swing.JComponent;

public class KpiNeedle
extends DialNeedle {
    protected static final double NEEDLE_RADIUS = 0.8153846153846154;
    protected static final double NEEDLE_TOP_W = 0.04615384615384615;
    protected static final double NEEDLE_BOTTOM_W = 0.12307692307692308;
    protected static final double AXLE_RADIUS = 0.06923076923076923;
    protected static final Color NEEDLE_BACK = Color.GRAY;
    protected static final Color NEEDLE_FORE = Color.WHITE;
    private Paint borderPaint = NEEDLE_BACK;
    private Paint fillPaint = NEEDLE_FORE;

    public KpiNeedle() {
    }

    public KpiNeedle(Point o, int r) {
        super(o, r);
    }

    public void draw(Graphics g, Rectangle area, JComponent c) {
        double r;
        double panRadius = area.width / 2;
        if (panRadius < 3.0) {
            panRadius = 3.0;
        }
        if ((r = 0.8153846153846154 * panRadius) < 3.0) {
            r = 3.0;
        }
        double botw = 0.12307692307692308 * panRadius;
        double BOTW_MIN = 3.0;
        double axleRadius = 0.06923076923076923 * panRadius;
        if (axleRadius < 3.0) {
            axleRadius = 3.0;
        }
        double x0 = (double)area.x + panRadius;
        double y0 = (double)area.y + panRadius;
        double angle = this.getAngle();
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform old = null;
        old = g2.getTransform();
        g2.rotate(StrictMath.toRadians(angle), x0, y0);
        RectangularShape needleShape = null;
        Ellipse2D.Double axleShape = null;
        axleShape = new Ellipse2D.Double(x0 - axleRadius, y0 - axleRadius, 2.0 * axleRadius, 2.0 * axleRadius);
        needleShape = botw < 3.0 ? new Rectangle2D.Double(x0 - r, y0 - 0.5, r, 1.0) : new Arc2D.Double(x0 - r, y0 - botw / 2.0, 4.0 * r, botw, 120.0, 120.0, 1);
        g2.setPaint(this.getBorderPaint());
        g2.fill(axleShape);
        g2.fill(needleShape);
        axleShape = new Ellipse2D.Double(x0 - axleRadius + 1.0, y0 - axleRadius + 1.0, 2.0 * axleRadius - 2.0, 2.0 * axleRadius - 2.0);
        needleShape = botw < 3.0 ? new Rectangle2D.Double(x0 - r, y0 - 0.5, r, 1.0) : new Arc2D.Double(x0 - r + 1.0, y0 - botw / 2.0 + 1.0, 4.0 * r - 2.0, botw - 2.0, 120.0, 120.0, 1);
        g2.setPaint(this.getFillPaint());
        g2.fill(axleShape);
        if (botw < 3.0) {
            g2.draw(needleShape);
        } else {
            g2.fill(needleShape);
        }
        if (old != null) {
            g2.setTransform(old);
        }
    }

    public Paint getBorderPaint() {
        return this.borderPaint;
    }

    public Paint getFillPaint() {
        return this.fillPaint;
    }

    public void setBorderPaint(Paint paint) {
        this.borderPaint = paint;
    }

    public void setFillPaint(Paint paint) {
        this.fillPaint = paint;
    }
}

