/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.controls;

import com.kingdee.bos.web.anole.controls.ComboBoxEditor;
import com.kingdee.bos.web.anole.controls.ComboBoxModel;
import com.kingdee.bos.web.anole.controls.DefaultComboBoxModel;
import com.kingdee.bos.web.anole.controls.ItemSelectable;
import com.kingdee.bos.web.anole.controls.KDComponent;
import com.kingdee.bos.web.anole.controls.MutableComboBoxModel;
import com.kingdee.bos.web.anole.event.ActionEvent;
import com.kingdee.bos.web.anole.event.ActionListener;
import com.kingdee.bos.web.anole.event.ItemEvent;
import com.kingdee.bos.web.anole.event.ItemListener;
import com.kingdee.bos.web.anole.event.ListDataEvent;
import com.kingdee.bos.web.anole.event.ListDataListener;
import com.kingdee.bos.web.anole.plaf.ComboBoxUI;
import com.kingdee.bos.web.anole.runtime.MobileCapabilities;
import com.kingdee.bos.web.anole.runtime.RequestOptions;
import com.kingdee.bos.web.anole.utils.CharsetConvertor;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;

public class KDComboBox
extends KDComponent
implements ItemSelectable,
ListDataListener,
ActionListener,
Accessible {
    private static final String uiClassID = "ComboBoxUI";
    protected ComboBoxModel dataModel;
    protected ComboBoxEditor editor;
    protected int maximumRowCount = 8;
    protected boolean isEditable = false;
    protected String actionCommand = "comboBoxChanged";
    protected Object selectedItemReminder = null;
    private Object prototypeDisplayValue;
    private boolean firingActionEvent = false;
    private boolean selectingItem = false;
    private PropertyChangeListener actionPropertyChangeListener;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public KDComboBox(ComboBoxModel aModel) {
        this.setModel(aModel);
        this.init();
    }

    public KDComboBox(Object[] items) {
        this.setModel(new DefaultComboBoxModel(items));
        this.init();
    }

    public KDComboBox(Vector items) {
        this.setModel(new DefaultComboBoxModel(items));
        this.init();
    }

    public KDComboBox() {
        this.setModel(new DefaultComboBoxModel());
        this.init();
    }

    public int getLength() {
        int imax = 0;
        int icount = this.getModel().getSize();
        int i = 0;
        while (i < icount) {
            int inow = this.getModel().getElementAt(i).toString().length();
            if (inow > imax) {
                imax = inow;
            }
            ++i;
        }
        return imax / 2;
    }

    private void init() {
    }

    public void setUI(ComboBoxUI ui) {
        super.setUI(ui);
    }

    public void updateUI() {
        this.setUI((ComboBoxUI)this.UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public ComboBoxUI getUI() {
        return (ComboBoxUI)this.ui;
    }

    public void setModel(ComboBoxModel aModel) {
        ComboBoxModel oldModel = this.dataModel;
        if (oldModel != null) {
            oldModel.removeListDataListener(this);
        }
        this.dataModel = aModel;
        this.dataModel.addListDataListener(this);
        this.selectedItemReminder = this.dataModel.getSelectedItem();
        this.firePropertyChange("model", oldModel, this.dataModel);
    }

    public ComboBoxModel getModel() {
        return this.dataModel;
    }

    public void setEditable(boolean aFlag) {
        boolean oldFlag = this.isEditable;
        this.isEditable = aFlag;
        this.firePropertyChange("editable", oldFlag, this.isEditable);
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setMaximumRowCount(int count) {
        int oldCount = this.maximumRowCount;
        this.maximumRowCount = count;
        this.firePropertyChange("maximumRowCount", oldCount, this.maximumRowCount);
    }

    public int getMaximumRowCount() {
        return this.maximumRowCount;
    }

    public void setEditor(ComboBoxEditor anEditor) {
        ComboBoxEditor oldEditor = this.editor;
        if (this.editor != null) {
            this.editor.removeActionListener(this);
        }
        this.editor = anEditor;
        if (this.editor != null) {
            this.editor.addActionListener(this);
        }
        this.firePropertyChange("editor", oldEditor, this.editor);
    }

    public ComboBoxEditor getEditor() {
        return this.editor;
    }

    public void setSelectedItem(Object anObject) {
        Object oldSelection = this.selectedItemReminder;
        if (oldSelection == null || !oldSelection.equals(anObject)) {
            if (anObject != null && !this.isEditable()) {
                boolean found = false;
                int i = 0;
                while (i < this.dataModel.getSize()) {
                    if (anObject.equals(this.dataModel.getElementAt(i))) {
                        found = true;
                        break;
                    }
                    ++i;
                }
                if (!found) {
                    return;
                }
            }
            this.selectingItem = true;
            this.dataModel.setSelectedItem(anObject);
            this.selectingItem = false;
            if (this.selectedItemReminder != this.dataModel.getSelectedItem()) {
                this.selectedItemChanged();
            }
        }
        this.fireActionEvent();
    }

    public Object getSelectedItem() {
        return this.dataModel.getSelectedItem();
    }

    public void setSelectedIndex(int anIndex) {
        int size = this.dataModel.getSize();
        if (anIndex == -1) {
            this.setSelectedItem(null);
        } else {
            if (anIndex < -1 || anIndex >= size) {
                throw new IllegalArgumentException("setSelectedIndex: " + anIndex + " out of bounds");
            }
            this.setSelectedItem(this.dataModel.getElementAt(anIndex));
        }
    }

    public int getSelectedIndex() {
        Object sObject = this.dataModel.getSelectedItem();
        int i = 0;
        int c = this.dataModel.getSize();
        while (i < c) {
            Object obj = this.dataModel.getElementAt(i);
            if (obj != null && obj.equals(sObject)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void addItem(Object anObject) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).addElement(anObject);
    }

    public void insertItemAt(Object anObject, int index) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).insertElementAt(anObject, index);
    }

    public void removeItem(Object anObject) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElement(anObject);
    }

    public void removeItemAt(int anIndex) {
        this.checkMutableComboBoxModel();
        ((MutableComboBoxModel)this.dataModel).removeElementAt(anIndex);
    }

    public void removeAllItems() {
        this.checkMutableComboBoxModel();
        MutableComboBoxModel model = (MutableComboBoxModel)this.dataModel;
        int size = model.getSize();
        if (model instanceof DefaultComboBoxModel) {
            ((DefaultComboBoxModel)model).removeAllElements();
        } else {
            int i = 0;
            while (i < size) {
                Object element = model.getElementAt(0);
                model.removeElement(element);
                ++i;
            }
        }
        this.selectedItemReminder = null;
        if (this.isEditable()) {
            this.editor.setItem(null);
        }
    }

    void checkMutableComboBoxModel() {
        if (!(this.dataModel instanceof MutableComboBoxModel)) {
            throw new RuntimeException("Cannot use this method with a non-Mutable data model.");
        }
    }

    public void addItemListener(ItemListener aListener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.kingdee.bos.web.anole.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.addListener(clazz, aListener);
    }

    public void removeItemListener(ItemListener aListener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.kingdee.bos.web.anole.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.removeListener(clazz, aListener);
    }

    public ItemListener[] getItemListeners() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.kingdee.bos.web.anole.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ItemListener[])this.listenerList.getListeners(clazz);
    }

    public void addActionListener(ActionListener l) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.kingdee.bos.web.anole.event.ActionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.addListener(clazz, l);
    }

    public void setActionCommand(String aCommand) {
        this.actionCommand = aCommand;
    }

    public String getActionCommand() {
        return this.actionCommand;
    }

    private boolean isListener(Class c, ActionListener a) {
        boolean isListener = false;
        int ltsc = this.listenerList.getListenerCount(c);
        if (ltsc > 0) {
            isListener = true;
        }
        return isListener;
    }

    protected void fireItemStateChanged(ItemEvent e) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.kingdee.bos.web.anole.event.ItemListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EventListener[] listeners = this.listenerList.getListeners(clazz);
        int i = listeners.length - 1;
        while (i >= 0) {
            ((ItemListener)listeners[i]).itemStateChanged(e);
            --i;
        }
    }

    protected void fireActionEvent() {
        if (!this.firingActionEvent) {
            this.firingActionEvent = true;
            ActionEvent e = null;
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.kingdee.bos.web.anole.event.ActionListener");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            EventListener[] listeners = this.listenerList.getListeners(clazz);
            int i = listeners.length - 1;
            while (i >= 0) {
                if (e == null) {
                    e = new ActionEvent(this, 1001, this.getActionCommand(), 0L, 0);
                }
                ((ActionListener)listeners[i]).actionPerformed(e);
                --i;
            }
            this.firingActionEvent = false;
        }
    }

    protected void selectedItemChanged() {
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 2));
        }
        this.selectedItemReminder = this.dataModel.getSelectedItem();
        if (this.selectedItemReminder != null) {
            this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 1));
        }
    }

    public Object[] getSelectedObjects() {
        Object selectedObject = this.getSelectedItem();
        if (selectedObject == null) {
            return new Object[0];
        }
        Object[] result = new Object[]{selectedObject};
        return result;
    }

    public void actionPerformed(ActionEvent e) {
        Object newItem = this.getEditor().getItem();
        this.getModel().setSelectedItem(newItem);
        String oldCommand = this.getActionCommand();
        this.setActionCommand("comboBoxEdited");
        this.fireActionEvent();
        this.setActionCommand(oldCommand);
    }

    public void contentsChanged(ListDataEvent e) {
        Object oldSelection = this.selectedItemReminder;
        Object newSelection = this.dataModel.getSelectedItem();
        if (oldSelection == null || !oldSelection.equals(newSelection)) {
            this.selectedItemChanged();
            if (!this.selectingItem) {
                this.fireActionEvent();
            }
        }
    }

    public void intervalAdded(ListDataEvent e) {
        if (this.selectedItemReminder != this.dataModel.getSelectedItem()) {
            this.selectedItemChanged();
        }
    }

    public void intervalRemoved(ListDataEvent e) {
        this.contentsChanged(e);
    }

    public void setEnabled(boolean b) {
        super.setEnabled(b);
        this.firePropertyChange("enabled", !this.isEnabled(), this.isEnabled());
    }

    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        anEditor.setItem(anItem);
    }

    public int getItemCount() {
        return this.dataModel.getSize();
    }

    public Object getItemAt(int index) {
        return this.dataModel.getElementAt(index);
    }

    public void updateContent(RequestOptions opt) {
        super.updateContent(opt);
        String strText = opt.getParameter(this.getIdentifier());
        if (strText != null) {
            MobileCapabilities mobileCaps;
            String charset = this.getAppInstance().getLocaleInfo().getCharset();
            int iChildrenCount = this.getModel().getSize();
            if (strText != null) {
                strText = CharsetConvertor.convertEncoding(strText, charset);
                int i = 0;
                while (i < iChildrenCount) {
                    String strValue = this.getModel().getElementAt(i).toString();
                    if (strValue.equals(strText)) {
                        this.setSelectedIndex(i);
                        break;
                    }
                    ++i;
                }
            }
            if (this.getAppInstance().getBrowserCaps().isMobileDevice() && (mobileCaps = (MobileCapabilities)this.getAppInstance().getBrowserCaps()).getPlatform().equals("UP")) {
                int index = Integer.parseInt(strText) - 1;
                this.setSelectedIndex(index);
            }
        }
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }
}

