/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.controls;

import com.kingdee.bos.web.anole.controls.KDComponent;
import com.kingdee.bos.web.anole.event.EventListenerList;
import com.kingdee.bos.web.anole.event.HierarchyListener;
import com.kingdee.bos.web.anole.layout.LayoutManager;
import com.kingdee.bos.web.anole.layout.LayoutManager2;
import com.kingdee.bos.web.anole.runtime.Application;
import com.kingdee.bos.web.anole.runtime.RequestOptions;
import com.kingdee.bos.web.anole.style.Color;
import com.kingdee.bos.web.anole.style.Dimension;
import com.kingdee.bos.web.anole.style.Insets;
import com.kingdee.bos.web.anole.style.Rectangle;
import com.kingdee.bos.web.anole.utils.Uuid;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KDContainer {
    public static final Color DEFAULT_BACKGROUND = Color.WHITE;
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Font DEFAULT_FONT = new Font("\u5b8b\u4f53", 0, 12);
    public static final String BACKGROUND_CHANGED_PROPERTY = "background";
    public static final String ENABLED_CHANGED_PROPERTY = "enabled";
    public static final String FONT_CHANGED_PROPERTY = "font";
    public static final String FOREGROUND_CHANGED_PROPERTY = "foreground";
    public static final String IDENTIFIER_CHANGED_PROPERTY = "identifier";
    public static final String LOCALE_CHANGED_PROPERTY = "locale";
    public static final String MODEL_CHANGED_PROPERTY = "model";
    public static final String UPDATE_PROPERTY = "update";
    public static final String VISIBLE_CHANGED_PROPERTY = "visible";
    public static final String HEIGHT_CHANGED_PROPERTY = "height";
    public static final String WIDTH_CHANGED_PROPERTY = "width";
    public static final int DEFAULT_WIDHT = 100;
    public static final int DEFAULT_HEIGHT = 20;
    private static final int END_OF_ARRAY = -1;
    private static final int CHILD_LIST_CAPACITY = 3;
    private static final String CHILDREN_CHANGED_PROPERTY = "children";
    private static final KDComponent[] EMPTY_COMPONENT_ARRAY = new KDComponent[0];
    private static final int FLAG_ENABLED = 1;
    private static final int FLAG_VISIBLE = 2;
    private int flags = 3;
    private Color foreground = DEFAULT_FOREGROUND;
    private Color background = null;
    private Font font = DEFAULT_FONT;
    private List children = null;
    private Map childrenMap = null;
    private KDContainer parent = null;
    private String identifier = null;
    private LayoutManager layoutMgr = null;
    protected EventListenerList listenerList = new EventListenerList();
    static final Object LOCK = new Object();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private int x = 0;
    private int y = 0;
    private int width = 100;
    private int height = 20;
    protected Application appInstance = null;
    static /* synthetic */ Class class$0;

    public KDContainer() {
        this.setIdentifier(this.genrateCtlName());
    }

    public int getHeight() {
        return this.height;
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int newValue) {
        int oldValue = this.height;
        this.height = newValue;
        this.firePropertyChange(HEIGHT_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setWidth(int newValue) {
        int oldValue = this.width;
        this.width = newValue;
        this.firePropertyChange(WIDTH_CHANGED_PROPERTY, oldValue, newValue);
    }

    public void setSize(Dimension newSize) {
        this.setWidth(newSize.getWidth());
        this.setHeight(newSize.getHeight());
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color newValue) {
        Color oldValue = this.background;
        this.background = newValue;
        this.firePropertyChange(BACKGROUND_CHANGED_PROPERTY, oldValue, newValue);
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color newValue) {
        Color oldValue = this.foreground;
        this.foreground = newValue;
        this.firePropertyChange(FOREGROUND_CHANGED_PROPERTY, oldValue, newValue);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font newValue) {
        Font oldValue = this.font;
        this.font = newValue;
        this.firePropertyChange(FONT_CHANGED_PROPERTY, oldValue, newValue);
    }

    public KDContainer getParent() {
        return this.parent;
    }

    public void setParent(KDContainer parent) {
        this.parent = parent;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(String identifier) {
        this.identifier = identifier;
    }

    public boolean isEnabled() {
        return (1 & this.flags) != 0;
    }

    public void setEnabled(boolean newValue) {
        boolean oldValue;
        boolean bl = oldValue = (1 & this.flags) != 0;
        if (oldValue != newValue) {
            this.flags ^= 1;
        }
        this.firePropertyChange(ENABLED_CHANGED_PROPERTY, oldValue, newValue);
    }

    public boolean isShowing() {
        return this.isRecursivelyVisible();
    }

    public boolean isVisible() {
        return (2 & this.flags) != 0;
    }

    boolean isRecursivelyVisible() {
        return this.isVisible() && (this.parent == null || this.parent.isRecursivelyVisible());
    }

    public Rectangle getBounds() {
        return this.bounds();
    }

    public Rectangle bounds() {
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public void setBounds(Rectangle rect) {
        this.x = rect.getX();
        this.y = rect.getY();
        this.width = rect.getWidth();
        this.height = rect.getHeight();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public boolean inside(int x, int y) {
        return x >= 0 && x < this.width && y >= 0 && y < this.height;
    }

    public void add(KDComponent c) {
        this.add(c, null, -1);
    }

    public void add(KDComponent c, Object constraints) {
        this.add(c, constraints, -1);
    }

    public void add(KDComponent c, Object constraints, int n) {
        if (c.getParent() != null) {
            c.getParent().remove(c);
        }
        this.addToList(c, n);
        this.addToMap(c);
        this.addToLayout(c, constraints);
        int changeFlags = 1;
        this.firePropertyChange(CHILDREN_CHANGED_PROPERTY, null, c);
        if (changeFlags != 0) {
            c.processHierarchyEvent(changeFlags, c, c.getParent());
        }
    }

    public void remove(KDComponent c) {
        if (this.children == null || !this.children.contains(c)) {
            return;
        }
        int changeFlags = 1;
        KDContainer oldParent = c.getParent();
        this.children.remove(c);
        this.childrenMap.remove(c.getIdentifier());
        if (this.layoutMgr != null) {
            this.layoutMgr.removeLayoutComponent(c);
        }
        c.setParent(null);
        this.firePropertyChange(CHILDREN_CHANGED_PROPERTY, c, null);
        c.processHierarchyEvent(changeFlags, c, oldParent);
    }

    public void remove(int n) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException();
        }
        this.remove(this.getComponent(n));
    }

    public void removeAll() {
        if (this.children != null) {
            while (this.children.size() > 0) {
                KDComponent c = (KDComponent)this.children.get(this.children.size() - 1);
                this.remove(c);
            }
            this.children = null;
        }
    }

    public void update() {
    }

    public void updateContent(RequestOptions opt) {
    }

    public Application getAppInstance() {
        if (this.getParent() == null) {
            return null;
        }
        return this.getParent().getAppInstance();
    }

    public Map getChildrenMap() {
        if (this.childrenMap == null) {
            this.childrenMap = new HashMap();
        }
        return this.childrenMap;
    }

    public KDComponent getComponent(int n) {
        if (this.children == null) {
            throw new IndexOutOfBoundsException();
        }
        return (KDComponent)this.children.get(n);
    }

    public int getComponentCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public KDComponent[] getComponents() {
        if (this.children == null) {
            return EMPTY_COMPONENT_ARRAY;
        }
        return this.children.toArray(new KDComponent[this.children.size()]);
    }

    public Insets getInsets() {
        return this.loadInserts();
    }

    public LayoutManager getLayout() {
        return this.layoutMgr;
    }

    public void setLayout(LayoutManager mgr) {
        this.layoutMgr = mgr;
    }

    public Dimension getPreferredSize() {
        return null;
    }

    public Dimension getMinimumSize() {
        return null;
    }

    public Dimension getMaximumSize() {
        return null;
    }

    public final Object getTreeLock() {
        return LOCK;
    }

    public void validate() {
    }

    public void doLayout() {
        this.layout();
    }

    public void layout() {
        LayoutManager layoutMgr = this.layoutMgr;
        if (layoutMgr != null) {
            layoutMgr.layoutContainer(this);
        }
    }

    public void addHierarchyListener(HierarchyListener l) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.kingdee.bos.web.anole.event.HierarchyListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.addListener(clazz, l);
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
    }

    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, new Float(oldValue), new Float(newValue));
    }

    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        this.propertyChangeSupport.firePropertyChange(propertyName, new Long(oldValue), new Long(newValue));
    }

    public void invalidate() {
    }

    private Insets loadInserts() {
        Insets ins = new Insets(0, 0, 0, 0);
        if (this.parent != null) {
            Insets pIns = this.parent.getInsets();
            ins.setLeft(pIns.getLeft() + this.x);
            ins.setTop(pIns.getTop() + this.y);
        }
        return ins;
    }

    private void addToMap(KDComponent c) {
        if (this.childrenMap == null) {
            this.childrenMap = new HashMap();
        }
        this.childrenMap.put(c.getIdentifier(), c);
        if (this.parent != null) {
            this.parent.getChildrenMap().put(c.getIdentifier(), c);
        }
    }

    private void addToList(KDComponent c, int n) {
        if (this.children == null) {
            this.children = new ArrayList(3);
        }
        c.setParent(this);
        if (n == -1) {
            this.children.add(c);
        } else {
            this.children.add(n, c);
        }
    }

    private void addToLayout(KDComponent c, Object constraints) {
        if (this.layoutMgr != null) {
            if (this.layoutMgr instanceof LayoutManager2) {
                ((LayoutManager2)this.layoutMgr).addLayoutComponent(c, constraints);
            } else if (constraints instanceof String) {
                this.layoutMgr.addLayoutComponent((String)constraints, c);
            }
        }
    }

    private String genrateCtlName() {
        String strName = Uuid.create().toString();
        strName = strName.replaceAll("-", "");
        strName = "C" + strName.substring(20, 28);
        return strName;
    }
}

