/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.controls;

import com.kingdee.bos.web.anole.controls.AbstractListModel;
import com.kingdee.bos.web.anole.controls.DefaultListSelectionModel;
import com.kingdee.bos.web.anole.controls.KDComponent;
import com.kingdee.bos.web.anole.controls.ListModel;
import com.kingdee.bos.web.anole.controls.ListSelectionModel;
import com.kingdee.bos.web.anole.event.ListSelectionEvent;
import com.kingdee.bos.web.anole.event.ListSelectionListener;
import com.kingdee.bos.web.anole.plaf.ListUI;
import com.kingdee.bos.web.anole.style.Color;
import java.io.Serializable;
import java.util.EventListener;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;

public class KDList
extends KDComponent
implements Accessible {
    private static final String uiClassID = "ListUI";
    public static final int VERTICAL = 0;
    public static final int VERTICAL_WRAP = 1;
    public static final int HORIZONTAL_WRAP = 2;
    private int fixedCellWidth = -1;
    private int fixedCellHeight = -1;
    private int horizontalScrollIncrement = -1;
    private Object prototypeCellValue;
    private int visibleRowCount = 5;
    private Color selectionForeground;
    private Color selectionBackground;
    private boolean dragEnabled;
    private ListSelectionModel selectionModel;
    private ListModel dataModel;
    private ListSelectionListener selectionListener;
    private int layoutOrientation;
    static /* synthetic */ Class class$0;

    public KDList(ListModel dataModel) {
        if (dataModel == null) {
            throw new IllegalArgumentException("dataModel must be non null");
        }
        this.layoutOrientation = 0;
        this.dataModel = dataModel;
        this.selectionModel = this.createSelectionModel();
    }

    public KDList(final Object[] listData) {
        this(new AbstractListModel(){

            public int getSize() {
                return listData.length;
            }

            public Object getElementAt(int i) {
                return listData[i];
            }
        });
    }

    public KDList(final Vector listData) {
        this(new AbstractListModel(){

            public int getSize() {
                return listData.size();
            }

            public Object getElementAt(int i) {
                return listData.elementAt(i);
            }
        });
    }

    public KDList() {
        this(new AbstractListModel(){

            public int getSize() {
                return 0;
            }

            public Object getElementAt(int i) {
                return "No Data Model";
            }
        });
    }

    public int getLength() {
        int imax = 0;
        int icount = this.getModel().getSize();
        int i = 0;
        while (i < icount) {
            int inow = ((String)this.getModel().getElementAt(i)).length();
            if (inow > imax) {
                imax = inow;
            }
            ++i;
        }
        return imax;
    }

    public ListUI getUI() {
        return (ListUI)this.ui;
    }

    public void updateUI() {
        this.setUI((ListUI)this.UIManager.getUI(this));
        this.invalidate();
    }

    public String getUIClassID() {
        return uiClassID;
    }

    public int getFixedCellWidth() {
        return this.fixedCellWidth;
    }

    public void setFixedCellHeight(int height) {
        int oldValue = this.fixedCellHeight;
        this.fixedCellHeight = height;
        this.firePropertyChange("fixedCellHeight", oldValue, this.fixedCellHeight);
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public void setSelectionForeground(Color selectionForeground) {
        Color oldValue = this.selectionForeground;
        this.selectionForeground = selectionForeground;
        this.firePropertyChange("selectionForeground", oldValue, selectionForeground);
    }

    public Color getSelectionBackground() {
        return this.selectionBackground;
    }

    public void setSelectionBackground(Color selectionBackground) {
        Color oldValue = this.selectionBackground;
        this.selectionBackground = selectionBackground;
        this.firePropertyChange("selectionBackground", oldValue, selectionBackground);
    }

    public int getVisibleRowCount() {
        return this.visibleRowCount;
    }

    public void setVisibleRowCount(int visibleRowCount) {
        int oldValue = this.visibleRowCount;
        this.visibleRowCount = Math.max(0, visibleRowCount);
        this.firePropertyChange("visibleRowCount", oldValue, visibleRowCount);
    }

    public void setLayoutOrientation(int layoutOrientation) {
        int oldValue = this.layoutOrientation;
        switch (layoutOrientation) {
            case 0: 
            case 1: 
            case 2: {
                this.layoutOrientation = layoutOrientation;
                this.firePropertyChange("layoutOrientation", oldValue, layoutOrientation);
                break;
            }
            default: {
                throw new IllegalArgumentException("layoutOrientation must be one of: VERTICAL, HORIZONTAL_WRAP or VERTICAL_WRAP");
            }
        }
    }

    public int getFirstVisibleIndex() {
        return 0;
    }

    public int getLastVisibleIndex() {
        return this.getModel().getSize();
    }

    public void ensureIndexIsVisible(int index) {
    }

    public void setDragEnabled(boolean b) {
    }

    public boolean getDragEnabled() {
        return this.dragEnabled;
    }

    public ListModel getModel() {
        return this.dataModel;
    }

    public void setModel(ListModel model) {
        if (model == null) {
            throw new IllegalArgumentException("model must be non null");
        }
        ListModel oldValue = this.dataModel;
        this.dataModel = model;
        this.firePropertyChange("model", oldValue, this.dataModel);
        this.clearSelection();
    }

    public void setListData(final Object[] listData) {
        this.setModel(new AbstractListModel(){

            public int getSize() {
                return listData.length;
            }

            public Object getElementAt(int i) {
                return listData[i];
            }
        });
    }

    public void setListData(final Vector listData) {
        this.setModel(new AbstractListModel(){

            public int getSize() {
                return listData.size();
            }

            public Object getElementAt(int i) {
                return listData.elementAt(i);
            }
        });
    }

    protected ListSelectionModel createSelectionModel() {
        return new DefaultListSelectionModel();
    }

    public ListSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    protected void fireSelectionValueChanged(int firstIndex, int lastIndex, boolean isAdjusting) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.kingdee.bos.web.anole.event.ListSelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EventListener[] listeners = this.listenerList.getListeners(clazz);
        ListSelectionEvent e = null;
        int i = listeners.length - 1;
        while (i >= 0) {
            if (e == null) {
                e = new ListSelectionEvent(this, firstIndex, lastIndex, isAdjusting);
            }
            ((ListSelectionListener)listeners[i]).valueChanged(e);
            --i;
        }
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        Class<?> clazz;
        if (this.selectionListener == null) {
            this.selectionListener = new ListSelectionHandler();
            this.getSelectionModel().addListSelectionListener(this.selectionListener);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("com.kingdee.bos.web.anole.event.ListSelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.addListener(clazz, listener);
    }

    public void removeListSelectionListener(ListSelectionListener listener) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.kingdee.bos.web.anole.event.ListSelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.listenerList.removeListener(clazz, listener);
    }

    public ListSelectionListener[] getListSelectionListeners() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.kingdee.bos.web.anole.event.ListSelectionListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (ListSelectionListener[])this.listenerList.getListeners(clazz);
    }

    public void setSelectionModel(ListSelectionModel selectionModel) {
        if (selectionModel == null) {
            throw new IllegalArgumentException("selectionModel must be non null");
        }
        if (this.selectionListener != null) {
            this.selectionModel.removeListSelectionListener(this.selectionListener);
            selectionModel.addListSelectionListener(this.selectionListener);
        }
        ListSelectionModel oldValue = this.selectionModel;
        this.selectionModel = selectionModel;
        this.firePropertyChange("selectionModel", oldValue, selectionModel);
    }

    public void setSelectionMode(int selectionMode) {
        this.getSelectionModel().setSelectionMode(selectionMode);
    }

    public int getSelectionMode() {
        return this.getSelectionModel().getSelectionMode();
    }

    public int getAnchorSelectionIndex() {
        return this.getSelectionModel().getAnchorSelectionIndex();
    }

    public int getLeadSelectionIndex() {
        return this.getSelectionModel().getLeadSelectionIndex();
    }

    public int getMinSelectionIndex() {
        return this.getSelectionModel().getMinSelectionIndex();
    }

    public int getMaxSelectionIndex() {
        return this.getSelectionModel().getMaxSelectionIndex();
    }

    public boolean isSelectedIndex(int index) {
        return this.getSelectionModel().isSelectedIndex(index);
    }

    public boolean isSelectionEmpty() {
        return this.getSelectionModel().isSelectionEmpty();
    }

    public void clearSelection() {
        this.getSelectionModel().clearSelection();
    }

    public void setSelectionInterval(int anchor, int lead) {
        this.getSelectionModel().setSelectionInterval(anchor, lead);
    }

    public void addSelectionInterval(int anchor, int lead) {
        this.getSelectionModel().addSelectionInterval(anchor, lead);
    }

    public void removeSelectionInterval(int index0, int index1) {
        this.getSelectionModel().removeSelectionInterval(index0, index1);
    }

    public void setValueIsAdjusting(boolean b) {
        this.getSelectionModel().setValueIsAdjusting(b);
    }

    public boolean getValueIsAdjusting() {
        return this.getSelectionModel().getValueIsAdjusting();
    }

    public int[] getSelectedIndices() {
        ListSelectionModel sm = this.getSelectionModel();
        int iMin = sm.getMinSelectionIndex();
        int iMax = sm.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0) {
            return new int[0];
        }
        int[] rvTmp = new int[1 + (iMax - iMin)];
        int n = 0;
        int i = iMin;
        while (i <= iMax) {
            if (sm.isSelectedIndex(i)) {
                rvTmp[n++] = i;
            }
            ++i;
        }
        int[] rv = new int[n];
        System.arraycopy(rvTmp, 0, rv, 0, n);
        return rv;
    }

    public void setSelectedIndex(int index) {
        this.getSelectionModel().setSelectionInterval(index, index);
    }

    public void setSelectedIndices(int[] indices) {
        ListSelectionModel sm = this.getSelectionModel();
        sm.clearSelection();
        int i = 0;
        while (i < indices.length) {
            sm.addSelectionInterval(indices[i], indices[i]);
            ++i;
        }
    }

    public Object[] getSelectedValues() {
        ListSelectionModel sm = this.getSelectionModel();
        ListModel dm = this.getModel();
        int iMin = sm.getMinSelectionIndex();
        int iMax = sm.getMaxSelectionIndex();
        if (iMin < 0 || iMax < 0) {
            return new Object[0];
        }
        Object[] rvTmp = new Object[1 + (iMax - iMin)];
        int n = 0;
        int i = iMin;
        while (i <= iMax) {
            if (sm.isSelectedIndex(i)) {
                rvTmp[n++] = dm.getElementAt(i);
            }
            ++i;
        }
        Object[] rv = new Object[n];
        System.arraycopy(rvTmp, 0, rv, 0, n);
        return rv;
    }

    public int getSelectedIndex() {
        return this.getMinSelectionIndex();
    }

    public Object getSelectedValue() {
        int i = this.getMinSelectionIndex();
        return i == -1 ? null : this.getModel().getElementAt(i);
    }

    public void setSelectedValue(Object anObject, boolean shouldScroll) {
        if (anObject == null) {
            this.setSelectedIndex(-1);
        } else if (!anObject.equals(this.getSelectedValue())) {
            ListModel dm = this.getModel();
            int i = 0;
            int c = dm.getSize();
            while (i < c) {
                if (anObject.equals(dm.getElementAt(i))) {
                    this.setSelectedIndex(i);
                    if (shouldScroll) {
                        this.ensureIndexIsVisible(i);
                    }
                    return;
                }
                ++i;
            }
            this.setSelectedIndex(-1);
        }
    }

    protected String paramString() {
        String selectionForegroundString = this.selectionForeground != null ? this.selectionForeground.toString() : "";
        String selectionBackgroundString = this.selectionBackground != null ? this.selectionBackground.toString() : "";
        return "fixedCellHeight=" + this.fixedCellHeight + ",fixedCellWidth=" + this.fixedCellWidth + ",horizontalScrollIncrement=" + this.horizontalScrollIncrement + ",selectionBackground=" + selectionBackgroundString + ",selectionForeground=" + selectionForegroundString + ",visibleRowCount=" + this.visibleRowCount + ",layoutOrientation=" + this.layoutOrientation;
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    private class ListSelectionHandler
    implements ListSelectionListener,
    Serializable {
        private static final long serialVersionUID = 1L;

        ListSelectionHandler() {
        }

        public void valueChanged(ListSelectionEvent e) {
            KDList.this.fireSelectionValueChanged(e.getFirstIndex(), e.getLastIndex(), e.getValueIsAdjusting());
        }
    }
}

