/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.image;

import com.kingdee.bos.web.anole.controls.KDComponent;
import com.kingdee.bos.web.anole.image.Icon;
import com.kingdee.bos.web.anole.image.ImageManager;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.Serializable;
import java.net.URL;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;

public class ImageIcon
implements Icon,
Serializable,
Accessible {
    private static final long serialVersionUID = 1L;
    private transient String filename;
    private transient URL location;
    transient Image image;
    transient int loadStatus = 0;
    private int width = -1;
    private int height = -1;
    private String description = null;

    public ImageIcon(String filename) {
        this(filename, filename);
    }

    public ImageIcon(URL location) {
        this(location, location.toExternalForm());
    }

    public ImageIcon(String filename, String description) {
        this.image = Toolkit.getDefaultToolkit().getImage(filename);
        if (this.image == null) {
            return;
        }
        this.filename = filename;
        this.description = description;
        this.loadImage(this.image);
    }

    public ImageIcon(URL location, String description) {
        this.image = Toolkit.getDefaultToolkit().getImage(location);
        if (this.image == null) {
            return;
        }
        description = description.replaceAll("/", "");
        description = description.substring(description.length() - 10, description.length());
        this.location = location;
        this.description = description;
        this.loadImage(this.image);
    }

    public ImageIcon(Image image, String description) {
        this.image = image;
        this.description = description;
        this.loadImage(image);
    }

    public ImageIcon(Image image) {
        this.image = image;
        Object o = image.getProperty("comment", null);
        if (o instanceof String) {
            this.description = (String)o;
        }
        this.loadImage(image);
    }

    public ImageIcon(byte[] imageData, String description) {
        this.image = Toolkit.getDefaultToolkit().createImage(imageData);
        if (this.image == null) {
            return;
        }
        this.description = description;
        this.loadImage(this.image);
    }

    public ImageIcon(byte[] imageData) {
        this.image = Toolkit.getDefaultToolkit().createImage(imageData);
        if (this.image == null) {
            return;
        }
        Object o = this.image.getProperty("comment", null);
        if (o instanceof String) {
            this.description = (String)o;
        }
        this.loadImage(this.image);
    }

    public String getDescription() {
        return this.formatDesc(this.description);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image = image;
        this.loadImage(image);
    }

    public String toString() {
        if (this.description != null) {
            return this.description;
        }
        return super.toString();
    }

    public void paintIcon(KDComponent c, int x, int y) {
    }

    public int getIconWidth() {
        return this.width;
    }

    public int getIconHeight() {
        return this.height;
    }

    public AccessibleContext getAccessibleContext() {
        return null;
    }

    private void loadImage(Image image) {
        this.width = image.getWidth(null);
        this.height = image.getHeight(null);
        if (!ImageManager.contains(this.description)) {
            ImageManager.putImageIcon(this);
        }
    }

    private String formatDesc(String desc) {
        String strDesc = desc.replace(File.separatorChar, 'a');
        strDesc = strDesc.replaceAll(":", "");
        strDesc = strDesc.replaceAll("\\.", "b");
        return strDesc;
    }
}

