/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.bos.web.anole.runtime;

import com.kingdee.bos.web.anole.controls.KDFrame;
import com.kingdee.bos.web.anole.controls.KDLabel;
import com.kingdee.bos.web.anole.controls.KDPanel;
import com.kingdee.bos.web.anole.layout.GridLayout;
import com.kingdee.bos.web.anole.utils.AnoleResourceBundle;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;

public class ReportFrame
extends KDFrame {
    public static int ERROR_CODE_UNKOWN = -1;
    public static int ERROR_CODE_404 = 404;
    public static int ERROR_CODE_500 = 500;
    public static int ERROR_CODE_600 = 600;
    public static int ERROR_CODE_601 = 601;
    private static Map errorMap = null;
    private KDPanel contentPanel = null;
    private KDLabel lblInfo = null;
    private KDLabel lblErrorCode = null;
    private int errorCode = ERROR_CODE_UNKOWN;
    private ResourceBundle myResources = null;

    public ReportFrame(int code) {
        this.errorCode = code;
        this.myResources = AnoleResourceBundle.getInstance();
        this.initialize();
    }

    private void initialize() {
        this.initErrorMap();
        this.setSize(300, 200);
        this.setTitle(this.myResources.getString("reporttitle"));
        this.setContentPane(this.getKDContentPane());
    }

    private KDPanel getKDContentPane() {
        if (this.contentPanel == null) {
            this.contentPanel = new KDPanel();
            this.contentPanel.setLayout(new GridLayout(2, 2));
            this.contentPanel.add(this.getKDLabelErrorCode());
            this.contentPanel.add(new KDLabel());
            this.contentPanel.add(new KDLabel());
            this.contentPanel.add(this.getKDLabelInfo());
        }
        return this.contentPanel;
    }

    private KDLabel getKDLabelErrorCode() {
        if (this.lblErrorCode == null) {
            this.lblErrorCode = new KDLabel();
            this.lblErrorCode.setText(this.getErrorCodeStr());
        }
        return this.lblErrorCode;
    }

    private KDLabel getKDLabelInfo() {
        if (this.lblInfo == null) {
            this.lblInfo = new KDLabel();
            this.lblInfo.setText(this.getErrorDescription());
        }
        return this.lblInfo;
    }

    private String getErrorDescription() {
        Object o = errorMap.get(String.valueOf(this.errorCode));
        if (o != null) {
            return (String)o;
        }
        return "Undefined error!";
    }

    private String getErrorCodeStr() {
        String strError = String.valueOf(String.valueOf(this.errorCode)) + this.myResources.getString("error");
        return strError;
    }

    private void initErrorMap() {
        if (errorMap == null) {
            errorMap = new HashMap();
            errorMap.put(String.valueOf(ERROR_CODE_404), this.myResources.getString("filenotfound"));
            errorMap.put(String.valueOf(ERROR_CODE_500), this.myResources.getString("servererror"));
            errorMap.put(String.valueOf(ERROR_CODE_600), this.myResources.getString("noframe"));
            errorMap.put(String.valueOf(ERROR_CODE_601), this.myResources.getString("noinitframe"));
        }
    }
}

