/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis.utils;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.axis.InternalException;

public class StringUtils {
    public static final String[] EMPTY_STRING_ARRAY = new String[0];

    private StringUtils() {
    }

    /*
     * Unable to fully structure code
     */
    public static boolean startsWithIgnoreWhitespaces(String prefix, String string) {
        index1 = 0;
        index2 = 0;
        length1 = prefix.length();
        length2 = string.length();
        ch1 = 32;
        ch2 = 32;
        ** GOTO lbl27
        {
            ++index1;
            do {
                if (index1 >= length1) ** GOTO lbl17
                v0 = prefix.charAt(index1);
                ch1 = v0;
                if (Character.isWhitespace(v0)) continue block0;
                if (true) ** GOTO lbl17
                do {
                    ++index2;
lbl17:
                    // 3 sources

                    if (index2 >= length2) break;
                    v1 = string.charAt(index2);
                    ch2 = v1;
                } while (Character.isWhitespace(v1));
                if (index1 == length1 && index2 == length2) {
                    return true;
                }
                if (ch1 != ch2) {
                    return false;
                }
                ++index1;
                ++index2;
lbl27:
                // 2 sources

            } while (index1 < length1 && index2 < length2);
        }
        return index1 >= length1 || index2 < length2;
    }

    public static String[] split(String str, char separatorChar) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        int start = 0;
        boolean match = false;
        while (i < len) {
            if (str.charAt(i) == separatorChar) {
                if (match) {
                    list.add(str.substring(start, i));
                    match = false;
                }
                start = ++i;
                continue;
            }
            match = true;
            ++i;
        }
        if (match) {
            list.add(str.substring(start, i));
        }
        return list.toArray(new String[list.size()]);
    }

    public static boolean isEmpty(String str) {
        return str == null || str.length() == 0;
    }

    public static String strip(String str) {
        return StringUtils.strip(str, null);
    }

    public static String strip(String str, String stripChars) {
        if (str == null) {
            return str;
        }
        int len = str.length();
        if (len == 0) {
            return str;
        }
        int start = StringUtils.getStripStart(str, stripChars);
        if (start == len) {
            return "";
        }
        int end = StringUtils.getStripEnd(str, stripChars);
        return start == 0 && end == len ? str : str.substring(start, end);
    }

    public static String stripStart(String str, String stripChars) {
        int start = StringUtils.getStripStart(str, stripChars);
        return start <= 0 ? str : str.substring(start);
    }

    /*
     * Unable to fully structure code
     */
    private static int getStripStart(String str, String stripChars) {
        block4: {
            block3: {
                if (str == null || (strLen = str.length()) == 0) {
                    return -1;
                }
                start = 0;
                if (stripChars != null) break block3;
                while (start != strLen && Character.isWhitespace(str.charAt(start))) {
                    ++start;
                }
                break block4;
            }
            if (stripChars.length() != 0) ** GOTO lbl13
            return start;
lbl-1000:
            // 1 sources

            {
                ++start;
lbl13:
                // 2 sources

                ** while (start != strLen && stripChars.indexOf((int)str.charAt((int)start)) != -1)
            }
        }
        return start;
    }

    public static String stripEnd(String str, String stripChars) {
        int end = StringUtils.getStripEnd(str, stripChars);
        return end < 0 ? str : str.substring(0, end);
    }

    /*
     * Unable to fully structure code
     */
    private static int getStripEnd(String str, String stripChars) {
        block4: {
            block3: {
                if (str == null || (end = str.length()) == 0) {
                    return -1;
                }
                if (stripChars != null) break block3;
                while (end != 0 && Character.isWhitespace(str.charAt(end - 1))) {
                    --end;
                }
                break block4;
            }
            if (stripChars.length() != 0) ** GOTO lbl12
            return end;
lbl-1000:
            // 1 sources

            {
                --end;
lbl12:
                // 2 sources

                ** while (end != 0 && stripChars.indexOf((int)str.charAt((int)(end - 1))) != -1)
            }
        }
        return end;
    }

    public static String escapeNumericChar(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length());
            StringUtils.escapeNumericChar(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public static void escapeNumericChar(Writer out, String str) throws IOException {
        if (str == null) {
            return;
        }
        int length = str.length();
        int i = 0;
        while (i < length) {
            char character = str.charAt(i);
            if (character > '\u007f') {
                out.write("&#x");
                out.write(Integer.toHexString(character).toUpperCase());
                out.write(";");
            } else {
                out.write(character);
            }
            ++i;
        }
    }

    public static String unescapeNumericChar(String str) {
        if (str == null) {
            return null;
        }
        try {
            StringWriter writer = new StringWriter(str.length());
            StringUtils.unescapeNumericChar(writer, str);
            return writer.toString();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return null;
        }
    }

    public static void unescapeNumericChar(Writer out, String str) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("The Writer must not be null");
        }
        if (str == null) {
            return;
        }
        int sz = str.length();
        StringBuffer unicode = new StringBuffer(4);
        StringBuffer escapes = new StringBuffer(3);
        boolean inUnicode = false;
        int i = 0;
        while (i < sz) {
            char ch = str.charAt(i);
            if (inUnicode) {
                unicode.append(ch);
                if (unicode.length() == 4) {
                    try {
                        int value = Integer.parseInt(unicode.toString(), 16);
                        out.write((char)value);
                        unicode.setLength(0);
                        ++i;
                        inUnicode = false;
                    }
                    catch (NumberFormatException nfe) {
                        throw new InternalException(nfe);
                    }
                }
            } else if (ch == '&') {
                if (i + 7 <= sz) {
                    escapes.append(ch);
                    escapes.append(str.charAt(i + 1));
                    escapes.append(str.charAt(i + 2));
                    if (escapes.toString().equals("&#x") && str.charAt(i + 7) == ';') {
                        inUnicode = true;
                    } else {
                        out.write(escapes.toString());
                    }
                    escapes.setLength(0);
                    i += 2;
                } else {
                    out.write(ch);
                }
            } else {
                out.write(ch);
            }
            ++i;
        }
    }
}

