/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitFactory;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.utils.BgCodeNumberNHelper;
import com.kingdee.eas.ma.mbg.BgFormEntryInfo;
import com.kingdee.eas.ma.mbg.BgFormFactory;
import com.kingdee.eas.ma.mbg.BgFormInfo;
import com.kingdee.eas.ma.mbg.BgSchemeFactory;
import com.kingdee.eas.ma.mbg.BgSchemeInfo;
import com.kingdee.eas.ma.mbg.BgTemplateFactory;
import com.kingdee.eas.ma.mbg.BgTemplateInfo;
import com.kingdee.eas.ma.mbg.BgViewDimensionFactory;
import com.kingdee.eas.ma.mbg.BgViewDimensionInfo;
import com.kingdee.eas.ma.mbg.BgViewFacadeFactory;
import com.kingdee.eas.ma.mbg.DimensionException;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.IBgForm;
import com.kingdee.eas.ma.mbg.MBGFormFacadeFactory;
import com.kingdee.eas.ma.mbg.TemplateFacadeFactory;
import com.kingdee.eas.ma.mbg.common.BgCalcuteColumn;
import com.kingdee.eas.ma.mbg.common.BgDescriptionColumn;
import com.kingdee.eas.ma.mbg.common.BgDimensionInfo;
import com.kingdee.eas.ma.mbg.common.BgDimensionManagerImpl;
import com.kingdee.eas.ma.mbg.common.BgDimensionMember;
import com.kingdee.eas.ma.mbg.common.BgNViewDataInfo;
import com.kingdee.eas.ma.mbg.common.IBgDimensionManager;
import com.kingdee.eas.ma.mbg.common.IMbgSheetManager;
import com.kingdee.eas.ma.mbg.common.IMbgViewManager;
import com.kingdee.eas.ma.mbg.common.MBgTemplateHelper;
import com.kingdee.eas.ma.mbg.common.MbgXMLParser;
import com.kingdee.eas.ma.mbg.dimension.DimensionConstants;
import com.kingdee.eas.ma.mbg.utils.BgNFSHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import com.kingdee.util.db.SQLUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BgDimensionEditImpl {
    private final Context ctx;
    private IMbgViewManager iMbgViewManager = null;
    private IBgForm iBgForm = null;

    public BgDimensionEditImpl(Context ctx) {
        this.ctx = ctx;
    }

    private IBgForm getBizInterface() throws BOSException {
        if (this.iBgForm == null) {
            this.iBgForm = BgFormFactory.getLocalInstance((Context)this.ctx);
        }
        return this.iBgForm;
    }

    private SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = BgNFSHelper.getSelectors();
        sic.add("versionNo");
        sic.add("entries.id");
        sic.add("entries.bgformid");
        sic.add("entries.dimensionData");
        sic.add("entries.dimensionStyle");
        return sic;
    }

    public Object getParameter() {
        return null;
    }

    private Map<String, Object> getInfoMap(Object dataInfo) {
        if (!(dataInfo instanceof CoreBaseInfo)) {
            return null;
        }
        CoreBaseInfo info = (CoreBaseInfo)dataInfo;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", info.get("id").toString());
        map.put("number", info.get("number"));
        map.put("name", info.get("name"));
        return map;
    }

    public Object edit(Object parameter) throws Exception {
        BgFormEntryInfo obj;
        if (!(parameter instanceof Map)) {
            return null;
        }
        Map pMap = (Map)parameter;
        String id = (String)pMap.get("id");
        String period = (String)pMap.get("period");
        BgFormInfo bgFormInfo = this.getBizInterface().getBgFormInfo((IObjectPK)new ObjectUuidPK(id), this.getSelectors());
        if (bgFormInfo.getEntries() == null) {
            throw new Exception();
        }
        FullOrgUnitInfo orgUnitInfo = bgFormInfo.getOrgUnit();
        MbgXMLParser parser = new MbgXMLParser();
        byte[] dataBytes = null;
        byte[] styleBytes = null;
        if (bgFormInfo.getEntries() != null && (obj = bgFormInfo.getEntries().get(0)) instanceof BgFormEntryInfo) {
            dataBytes = obj.getDimensionData();
            styleBytes = obj.getDimensionStyle();
            this.iMbgViewManager = parser.parse(dataBytes, styleBytes);
        }
        this.iMbgViewManager = MBGFormFacadeFactory.getLocalInstance((Context)this.ctx).loadViewManager(id, this.iMbgViewManager);
        HashMap dimensionManagers = new HashMap();
        ArrayList<IBgDimensionManager> dimensionList = new ArrayList<IBgDimensionManager>();
        for (int index = 0; index < this.iMbgViewManager.getSheetManagers().size(); ++index) {
            dimensionList.add(((IMbgSheetManager)this.iMbgViewManager.getSheetManagers().get(index)).getDimensionManager());
        }
        dimensionManagers.put(orgUnitInfo.getId().toString(), dimensionList);
        Map data = MBGFormFacadeFactory.getLocalInstance((Context)this.ctx).queryViewData(id, dimensionManagers, DimensionConstants.BUDGET_TYPE, false);
        HashMap<String, Map> rs = new HashMap<String, Map>();
        rs.put("data", data);
        rs.put("bgForm", this.getInfoMap(bgFormInfo));
        rs.put("scheme", this.getInfoMap(bgFormInfo.getBgScheme()));
        rs.put("template", this.getInfoMap(bgFormInfo.getBgTemplate()));
        rs.put("orgunit", this.getInfoMap(bgFormInfo.getOrgUnit()));
        rs.put("currency", this.getInfoMap(bgFormInfo.getCurrency()));
        rs.put("period", this.getInfoMap(bgFormInfo.getBgPeriod()));
        rs.put("defaultMeasure", (Map)this.iMbgViewManager.getDefaultMeasureUnit());
        rs.put("measureMap", this.iMbgViewManager.getMeasureMap());
        HashMap<Object, Object> bookMap = new HashMap<Object, Object>();
        this.getBook(this.iMbgViewManager, bgFormInfo, bookMap);
        rs.put("book", bookMap);
        FullOrgUnitInfo companyInfo = bgFormInfo.getCompany();
        HashMap<String, String> comMap = new HashMap<String, String>();
        comMap.put("id", companyInfo.getId().toString());
        comMap.put("number", companyInfo.getNumber());
        comMap.put("name", companyInfo.getName());
        rs.put("company", comMap);
        return rs;
    }

    private Map<?, ?> getBook(IMbgViewManager iMbgViewManager, BgFormInfo bgFormInfo, Map<Object, Object> bookMap) {
        if (iMbgViewManager == null || bgFormInfo == null || bookMap == null) {
            return null;
        }
        List m = iMbgViewManager.getSheetManagers();
        IMbgSheetManager iManager = null;
        BgDimensionManagerImpl dimensionManager = null;
        Map sheetMap = null;
        for (int index = 0; index < m.size(); ++index) {
            iManager = (IMbgSheetManager)m.get(index);
            dimensionManager = (BgDimensionManagerImpl)iManager.getDimensionManager();
            sheetMap = this.getSheet(dimensionManager, bgFormInfo);
            sheetMap.put("sheetName", iManager.getSheetName());
            sheetMap.put("sheetIndex", iManager.getSheetIndex());
            bookMap.put(iManager.getSheetIndex(), sheetMap);
        }
        bookMap.put("size", m.size());
        return bookMap;
    }

    private Map getSheet(BgDimensionManagerImpl dimensionManager, BgFormInfo bgFormInfo) {
        List descriptionCol;
        if (dimensionManager == null || bgFormInfo == null) {
            return null;
        }
        HashMap<String, Map> sheetMap = new HashMap<String, Map>();
        sheetMap.put("viewDimension", this.getDimension(dimensionManager.getViewDisplayDimension(), bgFormInfo));
        sheetMap.put("pageDimension", this.getDimension(dimensionManager.getPageDisplayDimension(), bgFormInfo));
        sheetMap.put("rowDimension", this.getDimension(dimensionManager.getRowDisplayDimension(), bgFormInfo));
        sheetMap.put("colDimension", this.getDimension(dimensionManager.getColDisplayDimension(), bgFormInfo));
        HashMap<String, Object> tem = null;
        List calcuteColumn = dimensionManager.getCalcuteCol();
        if (calcuteColumn != null && !calcuteColumn.isEmpty()) {
            BgCalcuteColumn calcuteC = null;
            HashMap<Object, Serializable> calcuteMap = new HashMap<Object, Serializable>();
            for (int index = 0; index < calcuteColumn.size(); ++index) {
                calcuteC = (BgCalcuteColumn)calcuteColumn.get(index);
                tem = new HashMap<String, Object>();
                tem.put("index", calcuteC.getIndex());
                tem.put("formula", calcuteC.getFormula());
                tem.put("columnName", calcuteC.getAlias());
                calcuteMap.put(index, tem);
            }
            calcuteMap.put("size", Integer.valueOf(calcuteColumn.size()));
            sheetMap.put("calcuteColumn", calcuteMap);
        }
        if ((descriptionCol = dimensionManager.getDescriptionCol()) != null && !descriptionCol.isEmpty()) {
            HashMap<Object, Serializable> descriptionMap = new HashMap<Object, Serializable>();
            BgDescriptionColumn descriptionColumn = null;
            for (int index = 0; index < descriptionCol.size(); ++index) {
                descriptionColumn = (BgDescriptionColumn)descriptionCol.get(index);
                tem = new HashMap();
                tem.put("index", descriptionColumn.getIndex());
                tem.put("columnName", descriptionColumn.getAlias());
                tem.put("dimension", this.getDimension(descriptionColumn.getDimensions(), null));
                descriptionMap.put(index, tem);
            }
            descriptionMap.put("size", Integer.valueOf(descriptionCol.size()));
            sheetMap.put("descriptionColumn", descriptionMap);
        }
        return sheetMap;
    }

    private Map getDimension(List list, BgFormInfo bgFormInfo) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        BgDimensionInfo dInfo = null;
        HashMap<Object, Serializable> rs = new HashMap<Object, Serializable>();
        HashMap<String, Object> temp = null;
        for (int index = 0; index < list.size(); ++index) {
            dInfo = (BgDimensionInfo)list.get(index);
            temp = new HashMap<String, Object>();
            temp.put("name", dInfo.getName());
            temp.put("number", dInfo.getNumber());
            temp.put("attribute", dInfo.getAttributeNumber());
            temp.put("member", this.getDimensionMember(dInfo.getMember()));
            temp.put("value", dInfo.getValue());
            rs.put(index, temp);
        }
        rs.put("size", Integer.valueOf(list.size()));
        return rs;
    }

    private Map getDimensionMember(List list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        HashMap<Object, Serializable> m = new HashMap<Object, Serializable>();
        HashMap<String, Object> tem = null;
        BgDimensionMember member = null;
        for (int index = 0; index < list.size(); ++index) {
            tem = new HashMap<String, Object>();
            member = (BgDimensionMember)list.get(index);
            tem.put("attribute", member.getAttribute());
            tem.put("name", member.getName());
            tem.put("number", member.getNumber());
            tem.put("type", member.getType());
            tem.put("srcNumber", member.getSrcNumber());
            tem.put("level", member.getLevel());
            tem.put("isAllowEdit", member.isAllowEdit());
            tem.put("isLegal", member.isLegal());
            m.put(index, tem);
        }
        m.put("size", Integer.valueOf(list.size()));
        return m;
    }

    private SelectorItemCollection getDefSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        return sic;
    }

    private CostCenterOrgUnitInfo getOrgUnit(String id) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        SelectorItemCollection sic = this.getDefSelector();
        sic.add("isCompanyOrgUnit");
        return CostCenterOrgUnitFactory.getLocalInstance((Context)this.ctx).getCostCenterOrgUnitInfo((IObjectPK)new ObjectUuidPK(id), sic);
    }

    private BgSchemeInfo getScheme(String id, String orgId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        String billId = null;
        String sql = "SELECT FID FROM T_MBG_BGSCHEME WHERE FROOTID=(SELECT FROOTID FROM T_MBG_BGSCHEME WHERE FID=?) AND FORGUNITID=?";
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            pmst = conn.prepareStatement(sql);
            pmst.setString(1, id);
            pmst.setString(2, orgId);
            rs = pmst.executeQuery();
            if (rs.next()) {
                billId = rs.getString("FID");
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        if (StringUtils.isEmpty((String)billId)) {
            return null;
        }
        SelectorItemCollection sic = this.getDefSelector();
        sic.add("dateFrom");
        return BgSchemeFactory.getLocalInstance((Context)this.ctx).getBgSchemeInfo((IObjectPK)new ObjectUuidPK(billId), sic);
    }

    private BgTemplateInfo getTemplate(String id, String orgId) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)id) || StringUtils.isEmpty((String)orgId)) {
            return null;
        }
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        String billId = null;
        String sql = "SELECT FID FROM T_MBG_BGTEMPLATE WHERE FROOTID=(SELECT FROOTID FROM T_MBG_BGTEMPLATE WHERE FID=?) AND FORGUNITID=?";
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            pmst = conn.prepareStatement(sql);
            pmst.setString(1, id);
            pmst.setString(2, orgId);
            rs = pmst.executeQuery();
            if (rs.next()) {
                billId = rs.getString("FID");
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        if (StringUtils.isEmpty((String)billId)) {
            return null;
        }
        SelectorItemCollection sic = this.getDefSelector();
        sic.add("data");
        sic.add("formType");
        sic.add("defaultMeasureUnit");
        sic.add("lastUpdateTime");
        return BgTemplateFactory.getLocalInstance((Context)this.ctx).getBgTemplateInfo((IObjectPK)new ObjectUuidPK(billId), sic);
    }

    private CurrencyInfo getCurrency(String id) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        return CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyInfo((IObjectPK)new ObjectUuidPK(id), this.getDefSelector());
    }

    private BgPeriodInfo getPeriod(String id) throws EASBizException, BOSException {
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        SelectorItemCollection sic = this.getDefSelector();
        sic.add("year");
        sic.add("periodType");
        sic.add("longNumber");
        sic.add("showLevel");
        return BgPeriodFactory.getLocalInstance((Context)this.ctx).getBgPeriodInfo((IObjectPK)new ObjectUuidPK(id), sic);
    }

    protected CompanyOrgUnitInfo getCompanyByOrgUnit(OrgUnitInfo orgUnitInfo) throws Exception {
        if (orgUnitInfo.isIsCompanyOrgUnit()) {
            return CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgUnitInfo.getId()), this.getCompanySelectors());
        }
        OrgUnitInfo parent = NewOrgViewFacadeFactory.getLocalInstance((Context)this.ctx).getParent(orgUnitInfo.getId().toString(), OrgViewType.COSTCENTER);
        if (parent != null) {
            return this.getCompanyByOrgUnit(parent);
        }
        return null;
    }

    protected SelectorItemCollection getCompanySelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("name");
        sic.add("number");
        sic.add("isBizUnit");
        sic.add("baseCurrency.id");
        sic.add("baseCurrency.number");
        sic.add("accountPeriodType.id");
        return sic;
    }

    private Set<String> getOrgIdsForCreateForm(String schemeId, String templateId) throws Exception {
        HashSet<String> tem;
        HashSet<String> addOrgIds;
        HashSet<String> id;
        ResultSet rs;
        PreparedStatement pmst;
        Connection conn;
        block11: {
            String orgId;
            String sqlTem;
            block10: {
                if (StringUtils.isEmpty((String)schemeId) || StringUtils.isEmpty((String)templateId)) {
                    return null;
                }
                conn = null;
                pmst = null;
                rs = null;
                String sqlSch = "SELECT FORGUNITID FROM T_MBG_BGSCHEME WHERE FROOTID=(SELECT FROOTID FROM T_MBG_BGSCHEME WHERE FID=?) ";
                sqlTem = "SELECT FORGUNITID FROM T_MBG_BGTEMPLATE WHERE FROOTID=(SELECT FROOTID FROM T_MBG_BGTEMPLATE WHERE FID=?) ";
                id = new HashSet<String>();
                orgId = null;
                addOrgIds = new HashSet<String>();
                conn = EJBFactory.getConnection((Context)this.ctx);
                pmst = conn.prepareStatement(sqlSch);
                pmst.setString(1, schemeId);
                rs = pmst.executeQuery();
                while (rs.next()) {
                    orgId = rs.getString("FORGUNITID");
                    id.add(orgId);
                }
                if (!id.isEmpty()) break block10;
                Set<String> set = null;
                SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
                return set;
            }
            pmst = conn.prepareStatement(sqlTem);
            pmst.setString(1, templateId);
            rs = pmst.executeQuery();
            tem = new HashSet<String>();
            while (rs.next()) {
                orgId = rs.getString("FORGUNITID");
                tem.add(orgId);
            }
            if (!tem.isEmpty()) break block11;
            Set<String> set = null;
            SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
            return set;
        }
        try {
            for (String orgId : tem) {
                if (!id.contains(orgId)) continue;
                addOrgIds.add(orgId);
            }
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        return addOrgIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object add(Object parameter) {
        if (!(parameter instanceof Map)) {
            return null;
        }
        Map p = (Map)parameter;
        Connection conn = null;
        PreparedStatement pmst = null;
        ResultSet rs = null;
        boolean isExist = false;
        String billId = null;
        HashMap<String, Object> m = new HashMap<String, Object>();
        String orgUnitId = (String)p.get("orgUnit");
        String addOrgId = (String)p.get("addOrgId");
        String schemeId = (String)p.get("scheme");
        String templateId = (String)p.get("template");
        String currencyId = (String)p.get("currency");
        String measure = (String)p.get("measure");
        String beginPeriod = (String)p.get("beginPeriod");
        String endPeriod = (String)p.get("endPeriod");
        String operator = (String)p.get("operator");
        try {
            Set<String> needAddOrgs = this.getOrgIdsForCreateForm(schemeId, templateId);
            if (needAddOrgs == null || needAddOrgs.isEmpty()) {
                Object var19_20 = null;
                return var19_20;
            }
            IBgPeriod iPeriod = BgPeriodFactory.getLocalInstance((Context)this.ctx);
            MeasureUnitInfo measureInfo = MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measure), this.getDefSelector());
            BgPeriodInfo beginPeriodInfo = this.getPeriod(beginPeriod);
            BgPeriodInfo endPeriodInfo = this.getPeriod(endPeriod);
            BgPeriodInfo yearPeriodInfo = iPeriod.getBgPeriodCollection("select id,number,name where year=" + beginPeriodInfo.getYear() + " and periodType=1").get(0);
            CurrencyInfo currencyInfo = this.getCurrency(currencyId);
            CostCenterOrgUnitInfo orgUnitInfo = null;
            BgTemplateInfo templateInfo = null;
            BgSchemeInfo schemeInfo = null;
            conn = EJBFactory.getConnection((Context)this.ctx);
            String addID = null;
            for (String currOrgId : needAddOrgs) {
                isExist = false;
                orgUnitInfo = this.getOrgUnit(currOrgId);
                templateInfo = this.getTemplate(templateId, orgUnitInfo.getId().toString());
                if (templateInfo.getFormType().getValue() != 4) continue;
                schemeInfo = this.getScheme(schemeId, orgUnitInfo.getId().toString());
                String sql = "select FID from T_MBG_BgForm where FOrgUnitId = ? and FBgSchemeId = ? and FBgTemplateId = ? and FBgPeriodId = ? and FCurrencyId = ?";
                pmst = conn.prepareStatement(sql);
                pmst.setString(1, orgUnitInfo.getId().toString());
                pmst.setString(2, schemeInfo.getId().toString());
                pmst.setString(3, templateInfo.getId().toString());
                pmst.setString(4, yearPeriodInfo.getId().toString());
                pmst.setString(5, currencyInfo.getId().toString());
                rs = pmst.executeQuery();
                if (rs.next()) {
                    if (orgUnitId.equals(currOrgId)) {
                        billId = rs.getString("FID");
                    }
                    isExist = true;
                }
                if (isExist) continue;
                BgFormInfo formInfo = new BgFormInfo();
                BOSUuid id = BOSUuid.create((BOSObjectType)formInfo.getBOSType());
                formInfo.setId(id);
                formInfo.setData(templateInfo.getData());
                formInfo.setTemplateLastUpdateTime(templateInfo.getLastUpdateTime());
                BgCodeNumberNHelper.applyNumber((Context)this.ctx, (IObjectValue)formInfo, (String)orgUnitInfo.getId().toString(), (String)"sourceType");
                BgCodeNumberNHelper.applyNumber((Context)this.ctx, (IObjectValue)formInfo, (String)orgUnitInfo.getId().toString(), (String)"sourceType", (String)"name");
                if (StringUtils.isEmpty((String)formInfo.getName())) {
                    formInfo.setName(orgUnitInfo.getName() + "_" + yearPeriodInfo.getName() + "_" + templateInfo.getName());
                }
                if (StringUtils.isEmpty((String)formInfo.getNumber())) {
                    formInfo.setNumber("EBR_" + orgUnitInfo.getNumber() + "_" + yearPeriodInfo.getNumber() + new Date().getTime());
                }
                FullOrgUnitInfo fullOrg = new FullOrgUnitInfo();
                fullOrg.setId(orgUnitInfo.getId());
                fullOrg.setNumber(orgUnitInfo.getNumber());
                fullOrg.setName(orgUnitInfo.getName());
                formInfo.setOrgUnit(fullOrg);
                formInfo.setCreator(ContextUtil.getCurrentUserInfo((Context)this.ctx));
                formInfo.setCurrency(currencyInfo);
                formInfo.setBgScheme(schemeInfo);
                formInfo.setBgPeriod(yearPeriodInfo);
                formInfo.setBgTemplate(templateInfo);
                formInfo.setMeasureUnit(measureInfo);
                addID = BgViewFacadeFactory.getLocalInstance((Context)this.ctx).addNewViewInfo(formInfo, false);
                if (!orgUnitId.equals(currOrgId)) continue;
                billId = addID;
            }
            m.put("isSuccess", true);
            m.put("information", billId);
            EntityViewInfo view = new EntityViewInfo("select ID,NUMBER,NAME,showLevel WHERE LONGNUMBER>='" + beginPeriodInfo.getLongNumber() + "' AND LONGNUMBER<='" + endPeriodInfo.getLongNumber() + "' AND PERIODTYPE=" + beginPeriodInfo.getPeriodType().getValue() + " ORDER BY LONGNUMBER");
            BgPeriodCollection periodColls = iPeriod.getBgPeriodCollection(view);
            if (periodColls != null && !periodColls.isEmpty()) {
                HashMap<Object, Serializable> periodMap = new HashMap<Object, Serializable>();
                HashMap<String, String> tem = null;
                BgPeriodInfo pi = null;
                for (int index = 0; index < periodColls.size(); ++index) {
                    pi = periodColls.get(index);
                    tem = new HashMap<String, String>();
                    tem.put("id", pi.getId().toString());
                    tem.put("name", pi.getName());
                    tem.put("number", pi.getNumber());
                    tem.put("longNumber", pi.getLongNumber());
                    periodMap.put(index, tem);
                }
                periodMap.put("size", Integer.valueOf(periodColls.size()));
                m.put("filterPeriod", periodMap);
            }
            SQLUtils.cleanup(rs, (Statement)pmst, (Connection)conn);
        }
        catch (Exception e) {
            m.put("isSuccess", false);
            m.put("information", e.getMessage());
        }
        finally {
            SQLUtils.cleanup(rs, pmst, conn);
        }
        return m;
    }

    private void addMemeber(BgDimensionManagerImpl dimManagerImpl, BgPeriodCollection periodColls, String dimensionType, BigDecimal bigDecimal) throws BOSException {
        if (dimManagerImpl == null) {
            return;
        }
        List pageList = dimManagerImpl.getPageDisplayDimension();
        List rowList = dimManagerImpl.getRowDisplayDimension();
        List colList = dimManagerImpl.getColDisplayDimension();
        this.searchDimension(pageList, periodColls, dimensionType, bigDecimal);
        this.searchDimension(rowList, periodColls, dimensionType, bigDecimal);
        this.searchDimension(colList, periodColls, dimensionType, bigDecimal);
    }

    private void searchDimension(List list, BgPeriodCollection periodColls, String dimensionType, BigDecimal bigDecimal) throws BOSException {
        if (list == null || list == null || StringUtils.isEmpty((String)dimensionType)) {
            return;
        }
        for (int index = 0; index < list.size(); ++index) {
            BgDimensionInfo dimensionInfo = (BgDimensionInfo)list.get(index);
            if (!dimensionType.equals(dimensionInfo.getNumber())) continue;
            this.insertMember(dimensionInfo, periodColls, bigDecimal);
        }
    }

    private void insertMember(BgDimensionInfo dimensionInfo, BgPeriodCollection periodColls, BigDecimal bigDecimal) throws BOSException {
        if (dimensionInfo == null || periodColls == null || periodColls.isEmpty()) {
            return;
        }
        List oldMembers = dimensionInfo.getMember();
        ArrayList<BgDimensionMember> curMembers = new ArrayList<BgDimensionMember>();
        BgPeriodInfo pInfo = null;
        BgDimensionMember member = null;
        for (int index = 0; index < periodColls.size(); ++index) {
            pInfo = periodColls.get(index);
            member = new BgDimensionMember(dimensionInfo.getNumber(), dimensionInfo.getAttribute(), pInfo.getName(), pInfo.getNumber());
            member.setSortValue((Comparable)Integer.valueOf(pInfo.getShowLevel()));
            curMembers.add(member);
        }
        HashSet srcNumbers = new HashSet();
        MBgTemplateHelper.collectDimensionSrcNums(curMembers, srcNumbers);
        MBgTemplateHelper.collectDimensionSrcNums((List)oldMembers, srcNumbers);
        Map dimensionSrcMap = MBgTemplateHelper.queryDimensionSrc((BgDimensionInfo)dimensionInfo, srcNumbers);
        List<BgDimensionMember> newMembers = this.getNewMembersByOrder(curMembers, oldMembers, dimensionSrcMap, bigDecimal);
        dimensionInfo.getMember().clear();
        dimensionInfo.getMember().addAll(newMembers);
        try {
            dimensionInfo.setValue(dimensionInfo.unParseMember());
        }
        catch (DimensionException e) {
            e.printStackTrace();
        }
    }

    private List<BgDimensionMember> getNewMembersByOrder(List<BgDimensionMember> curMembers, List<BgDimensionMember> oldMembers, Map<String, DimensionSourceInfo> dimensionSrcMap, BigDecimal versionNo) {
        int i;
        ArrayList<BgDimensionMember> newMembers = new ArrayList<BgDimensionMember>();
        HashMap<String, BgDimensionMember> oldMemberMap = new HashMap<String, BgDimensionMember>();
        if (oldMembers != null) {
            for (int i2 = 0; i2 < oldMembers.size(); ++i2) {
                oldMemberMap.put(MBgTemplateHelper.getDimensionMemeberSign((BgDimensionMember)oldMembers.get(i2)), oldMembers.get(i2));
            }
        }
        HashSet<String> curMemberSign = new HashSet<String>();
        if (curMembers != null) {
            for (i = 0; i < curMembers.size(); ++i) {
                newMembers.add(curMembers.get(i));
                if (!oldMemberMap.keySet().contains(MBgTemplateHelper.getDimensionMemeberSign((BgDimensionMember)curMembers.get(i)))) {
                    curMembers.get(i).setVersion(versionNo);
                } else {
                    curMembers.get(i).setVersion(((BgDimensionMember)oldMemberMap.get(MBgTemplateHelper.getDimensionMemeberSign((BgDimensionMember)curMembers.get(i)))).getVersion());
                }
                curMemberSign.add(MBgTemplateHelper.getDimensionMemeberSign((BgDimensionMember)curMembers.get(i)));
            }
        }
        if (oldMembers != null) {
            for (i = 0; i < oldMembers.size(); ++i) {
                if (curMemberSign.contains(MBgTemplateHelper.getDimensionMemeberSign((BgDimensionMember)oldMembers.get(i))) || oldMembers.get(i).getVersion().compareTo(versionNo) >= 0) continue;
                MBgTemplateHelper.insertNewMemberByOrder(newMembers, (BgDimensionMember)oldMembers.get(i), dimensionSrcMap);
            }
        }
        Collections.sort(newMembers, new MemberSort());
        return newMembers;
    }

    public Object save(Object parameter) throws BOSException {
        if (!(parameter instanceof Map)) {
            return null;
        }
        Map p = (Map)parameter;
        String state = (String)p.get("operatorState");
        String billId = (String)p.get("billId");
        String currency = (String)p.get("currency");
        String template = (String)p.get("template");
        String scheme = (String)p.get("scheme");
        String period = (String)p.get("period");
        String orgunit = (String)p.get("orgunit");
        String modifyData = (String)p.get("modifyData");
        if (StringUtils.isEmpty((String)modifyData)) {
            return null;
        }
        if ("ADDNEW".equals(state)) {
            // empty if block
        }
        HashMap<String, BigDecimal> keyValue = new HashMap<String, BigDecimal>();
        HashMap<String, String> keyFID = new HashMap<String, String>();
        HashMap<String, Integer> cantEditData = new HashMap<String, Integer>();
        HashMap addData = new HashMap();
        String[] datas = modifyData.split("@");
        HashSet<String> orgIds = new HashSet<String>();
        for (int i = 0; i < datas.length; ++i) {
            String[] data = datas[i].split("!");
            orgIds.add(data[0]);
            keyValue.put(data[0] + "!" + data[1], new BigDecimal(data[2]));
        }
        Connection conn = null;
        PreparedStatement pmst = null;
        Statement mt = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            sql.append("SELECT da.FID id , da.FORGUNITID orgId, da.FFORMULA formula ,da.FDATASTATE dataState");
            sql.append(" FROM T_MBG_BGDATA da");
            sql.append(" LEFT JOIN T_MBG_BGDATAENTRY en ON en.FBGDATAID=da.FID");
            sql.append(" WHERE en.FBGFORMID=? AND da.FORGUNITID IN (");
            Iterator it = orgIds.iterator();
            while (it.hasNext()) {
                sql.append("'").append((String)it.next()).append("',");
            }
            sql.deleteCharAt(sql.length() - 1);
            sql.append(")");
            sql.append(" AND da.FBGSCHEMEROOTID IN (SELECT FROOTID FROM T_MBG_BGSCHEME WHERE FID=?)");
            pmst = conn.prepareStatement(sql.toString());
            pmst.setString(1, billId);
            pmst.setString(2, scheme);
            rs = pmst.executeQuery();
            int dataState = 0;
            while (rs.next()) {
                dataState = rs.getInt("dataState");
                if (dataState == 1) {
                    keyFID.put(rs.getString("orgId") + "!" + rs.getString("formula"), rs.getString("ID"));
                    continue;
                }
                cantEditData.put(rs.getString("orgId") + "!" + rs.getString("formula"), dataState);
            }
            mt = conn.createStatement();
            int index = 0;
            for (String key : keyValue.keySet()) {
                if (keyFID.containsKey(key)) {
                    mt.addBatch("UPDATE T_MBG_BGDATA SET FBGVALUE=" + keyValue.get(key) + " WHERE FID='" + (String)keyFID.get(key) + "'");
                    if (++index < 200) continue;
                    mt.executeBatch();
                    index = 0;
                    continue;
                }
                String orgid = key.split("!")[0];
                String formula = key.split("!")[1];
                if (!addData.containsKey(orgid)) {
                    addData.put(orgid, new HashMap());
                }
                ((Map)addData.get(orgid)).put(formula, this.getDataInfoOfAdd(formula, (BigDecimal)keyValue.get(key), scheme));
            }
            if (index > 0) {
                mt.executeBatch();
            }
            MBGFormFacadeFactory.getLocalInstance((Context)this.ctx).saveBgData(billId, addData);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, pmst, (Connection)conn);
                SQLUtils.cleanup(mt);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)pmst, (Connection)conn);
        SQLUtils.cleanup((Statement)mt);
        return null;
    }

    private BgNViewDataInfo getDataInfoOfAdd(String formula, BigDecimal value, String schemeId) {
        if (StringUtils.isEmpty((String)formula) || StringUtils.isEmpty((String)schemeId) || value == null) {
            return null;
        }
        BgNViewDataInfo info = new BgNViewDataInfo();
        String[] para = BgNFSHelper.parseFormulaPara((String)formula);
        info.setBgItemNumber(para[0].replaceAll("\"", ""));
        info.setBgPeriodNumber(para[1].replaceAll("\"", ""));
        info.setBgElementNumber(para[2].replaceAll("\"", ""));
        info.setCurrencyNumber(para[5].replaceAll("\"", ""));
        info.setBgSchemeId(schemeId);
        info.setBudgetValue(value);
        return info;
    }

    public Object getInitData(Object parameter) throws Exception {
        if (!(parameter instanceof Map)) {
            return null;
        }
        Map p = (Map)parameter;
        boolean isModify = true;
        HashMap<String, Serializable> rs = new HashMap<String, Serializable>();
        CostCenterOrgUnitInfo orgUnitInfo = this.getOrgUnit(p.get("orgUnit").toString());
        BgTemplateInfo templateInfo = this.getTemplate(p.get("template").toString(), p.get("orgUnit").toString());
        MeasureUnitInfo measureInfo = templateInfo.getDefaultMeasureUnit();
        if (templateInfo.getFormType().getValue() != 4) {
            return null;
        }
        BgViewDimensionInfo viewDimensionInfo = (BgViewDimensionInfo)BgViewDimensionFactory.getLocalInstance((Context)this.ctx).getDimensionByTemplate(templateInfo.getId().toString());
        IMbgViewManager iMbgViewManager = new MbgXMLParser().parse(viewDimensionInfo.getData());
        IMbgViewManager mbgViewManager = TemplateFacadeFactory.getLocalInstance((Context)this.ctx).loadViewManager(orgUnitInfo.getId().toString(), iMbgViewManager);
        List sheetManagers = mbgViewManager.getSheetManagers();
        if (sheetManagers == null || sheetManagers.isEmpty()) {
            return null;
        }
        Boolean isOrgMuil = true;
        IMbgSheetManager manager = null;
        IBgDimensionManager dimManager = null;
        List dimList = null;
        List memberList = null;
        BgDimensionInfo dimInfo = null;
        BgDimensionMember member = null;
        String currencyNumber = null;
        for (int i = 0; i < sheetManagers.size(); ++i) {
            int index;
            manager = (IMbgSheetManager)sheetManagers.get(i);
            dimManager = manager.getDimensionManager();
            dimList = dimManager.getViewDimension();
            if (dimList != null && !dimList.isEmpty()) {
                for (index = 0; index < dimList.size(); ++index) {
                    dimInfo = (BgDimensionInfo)dimList.get(index);
                    if (!"BG_Organization".equals(dimInfo.getNumber())) continue;
                    isOrgMuil = false;
                }
            }
            if ((dimList = dimManager.getPageDimension()) == null || dimList.isEmpty()) continue;
            for (index = 0; index < dimList.size(); ++index) {
                dimInfo = (BgDimensionInfo)dimList.get(index);
                if (!"BG_Currency".equals(dimInfo.getNumber()) || StringUtils.isEmpty((String)dimInfo.getValue()) || (memberList = dimInfo.getMember()) == null || memberList.isEmpty()) continue;
                for (int j = 0; j < memberList.size(); ++j) {
                    member = (BgDimensionMember)memberList.get(j);
                    if (!"BG_Currency".equals(member.getType())) continue;
                    currencyNumber = member.getNumber();
                }
            }
        }
        CurrencyInfo currencyInfo = null;
        if (StringUtils.isEmpty(currencyNumber)) {
            CompanyOrgUnitInfo companyInfo = this.getCompanyByOrgUnit((OrgUnitInfo)orgUnitInfo);
            currencyInfo = this.getCurrency(companyInfo.getBaseCurrency().getId().toString());
        } else {
            EntityViewInfo view = new EntityViewInfo();
            view.setSelector(this.getDefSelector());
            view.setFilter(new FilterInfo());
            view.getFilter().getFilterItems().add(new FilterItemInfo("number", currencyNumber, CompareType.EQUALS));
            currencyInfo = CurrencyFactory.getLocalInstance((Context)this.ctx).getCurrencyCollection(view).get(0);
        }
        HashMap<String, String> tem = null;
        tem = new HashMap<String, String>();
        tem.put("id", currencyInfo.getId().toString());
        tem.put("number", currencyInfo.getNumber());
        tem.put("name", currencyInfo.getName());
        rs.put("defaultCurrencyInfo", tem);
        rs.put("isOrgMuil", isOrgMuil);
        String measuer = "measure";
        if (measureInfo != null) {
            HashMap<String, String> measureMap = new HashMap<String, String>();
            measureInfo = MeasureUnitFactory.getLocalInstance((Context)this.ctx).getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(measureInfo.getId().toString()), this.getDefSelector());
            measureMap.put("id", measureInfo.getId().toString());
            measureMap.put("number", measureInfo.getNumber());
            measureMap.put("name", measureInfo.getName());
            rs.put("measure", measureMap);
        } else {
            rs.put("measure", null);
        }
        rs.put("isModify", Boolean.valueOf(isModify));
        return rs;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MemberSort
    implements Comparator<BgDimensionMember> {
        MemberSort() {
        }

        @Override
        public int compare(BgDimensionMember o1, BgDimensionMember o2) {
            int v2;
            int v1 = Integer.valueOf(o1.getSortValue().toString());
            if (v1 > (v2 = Integer.valueOf(o2.getSortValue().toString()).intValue())) {
                return 1;
            }
            if (v1 < v2) {
                return -1;
            }
            return 0;
        }
    }
}

