/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.ma.mbg.impl;

import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.EntityExecutorFactory;
import com.kingdee.bos.dao.query.IDataProvider;
import com.kingdee.bos.event.util.DBUtils;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CostCenterOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.framework.util.EntityUtility;
import com.kingdee.eas.ma.base.BgPeriodCollection;
import com.kingdee.eas.ma.base.BgPeriodFactory;
import com.kingdee.eas.ma.base.BgPeriodInfo;
import com.kingdee.eas.ma.base.IBgPeriod;
import com.kingdee.eas.ma.base.MetaDataFacadeFactory;
import com.kingdee.eas.ma.base.app.utils.MbgSqlHelper;
import com.kingdee.eas.ma.mbg.DimensionExpressionCollection;
import com.kingdee.eas.ma.mbg.DimensionExpressionFactory;
import com.kingdee.eas.ma.mbg.DimensionExpressionInfo;
import com.kingdee.eas.ma.mbg.DimensionFactory;
import com.kingdee.eas.ma.mbg.DimensionInfo;
import com.kingdee.eas.ma.mbg.DimensionPropSrcCollection;
import com.kingdee.eas.ma.mbg.DimensionPropSrcInfo;
import com.kingdee.eas.ma.mbg.DimensionSourceCollection;
import com.kingdee.eas.ma.mbg.DimensionSourceFactory;
import com.kingdee.eas.ma.mbg.DimensionSourceInfo;
import com.kingdee.eas.ma.mbg.IDimension;
import com.kingdee.eas.ma.mbg.IDimensionExpression;
import com.kingdee.eas.ma.mbg.utils.DimensionFilterHelper;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BgDimensionManagerWebImpl {
    public static final String FIELD_QUERY = "queryType";
    public static final String TYPE_PERIOD = "PERIOD";
    public static final String TYPE_ORGUNIT = "ORGUNIT";
    public static final String QUERY_ACCTITEM = "ACCTITEM";
    public static final String QUERY_PAYTYPE = "PAYTYPE";
    public static final String QUERY_PROJECT = "PROJECT";
    private final Context ctx;
    private IDimension iDimension;
    private CostCenterOrgUnitInfo currCostCenter;
    private CompanyOrgUnitInfo currCompany;
    private String currOrgId;

    public BgDimensionManagerWebImpl(Context ctx) {
        this.ctx = ctx;
        this.currCostCenter = ContextUtil.getCurrentCostUnit((Context)ctx);
        this.currCompany = ContextUtil.getCurrentFIUnit((Context)ctx);
        OrgUnitCollection orgCol = null;
        try {
            orgCol = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getToUnit(this.currCostCenter.getId().toString(), 5, 1);
        }
        catch (Exception e) {
            orgCol = null;
        }
        this.currOrgId = this.currCompany != null ? this.currCompany.getId().toString() : (orgCol != null && !orgCol.isEmpty() ? orgCol.get(0).getId().toString() : this.currCostCenter.getId().toString());
    }

    public Object getParameter() {
        return null;
    }

    public Map<String, Object> getDimensionData(Object parameter) {
        if (!(parameter instanceof Map)) {
            return null;
        }
        Map p = (Map)parameter;
        HashMap<String, Object> rs = new HashMap<String, Object>();
        try {
            rs.put("data", this.getBgDimData(p));
            rs.put("success", Boolean.TRUE);
        }
        catch (Exception e) {
            rs.put("success", Boolean.FALSE);
            rs.put("message", e.getMessage());
        }
        return rs;
    }

    private Map<String, Object> getBgDimData(Map p) throws Exception {
        int i;
        String col;
        String queryType = (String)p.get(FIELD_QUERY);
        boolean isEnable = false;
        if (QUERY_PROJECT.equals(queryType)) {
            isEnable = this.getProjectDimIsEnable();
        } else {
            this.setBgIndexDimSrcFlag(queryType);
        }
        DimensionSourceInfo source = this.getDimensionSourceInfo(queryType);
        Map propMap = this.loadPropMap(source.getProperties());
        boolean existLevel = false;
        boolean existLongNumber = false;
        for (int i2 = 0; i2 < source.getProperties().size(); ++i2) {
            DimensionPropSrcInfo propSrc = (DimensionPropSrcInfo)propMap.get(i2);
            if (propSrc.getDimSrcPropName().equals("level")) {
                existLevel = true;
            }
            if (!propSrc.getDimSrcPropName().equals("longNumber")) continue;
            existLongNumber = true;
        }
        DimensionFilterHelper helper = DimensionFilterHelper.getLocaleIntance((Context)this.ctx, (DimensionSourceInfo)source, (String)this.currCostCenter.getId().toString());
        ArrayList<String> lst = new ArrayList<String>();
        lst.add("periodAlgorithm");
        lst.add("polymerizeAlgorithm");
        lst.add("formula");
        EntityViewInfo evi = new EntityViewInfo();
        evi.getSelector().add("id");
        for (int i3 = 0; i3 < source.getProperties().size(); ++i3) {
            col = source.getProperties().get(i3).getDimSrcPropName();
            if (lst.contains(source.getProperties().get(i3).getDimSrcPropName())) continue;
            evi.getSelector().add(col);
        }
        EntityObjectInfo entity = null;
        boolean isTreeBase = false;
        if (source.getSrcType().getValue() == 0) {
            entity = EntityUtility.getBOSEntity((Context)this.ctx, (BOSObjectType)BOSObjectType.create((String)source.getSrcID()));
            isTreeBase = DimensionFilterHelper.getLocaleIntance((Context)this.ctx, (DimensionSourceInfo)source, null).isTreeBase();
            if (isTreeBase) {
                if (!existLevel) {
                    evi.getSelector().add("level");
                }
                if (!existLongNumber) {
                    evi.getSelector().add("longNumber");
                }
            }
        }
        IDataProvider mainExec = null;
        if (source.getSrcType().getValue() == 0) {
            mainExec = EntityExecutorFactory.getLocalInstance((Context)this.ctx, (IMetaDataPK)MetaDataPK.create((String)entity.getFullName()));
            if (source.getSrcID().equals("9DA99826")) {
                evi.getSelector().add("parent.id");
                evi.getSelector().add("parent.DC");
            } else if (source.getSrcID().equals("DADE05EE")) {
                // empty if block
            }
        }
        evi.setFilter(helper.getFilter());
        if (QUERY_ACCTITEM.equals(queryType)) {
            String sql = "select fid from t_bd_accounttype where fproperty='4'";
            evi.getFilter().getFilterItems().add(new FilterItemInfo("accountTypeID.id", (Object)sql, CompareType.INNER));
            evi.getFilter().setMaskString("#0 and #1 and #2 and #3");
        }
        SorterItemInfo sort = new SorterItemInfo("number");
        sort.setSortType(SortType.ASCEND);
        evi.getSorter().add(sort);
        mainExec.setObjectView(evi);
        mainExec.option().isAutoTranslateEnum = true;
        mainExec.openQuery();
        mainExec.option().pageCount = 1000;
        IRowSet rs = mainExec.executeQuery();
        HashMap<String, Object> map = new HashMap<String, Object>();
        HashMap<String, Object> tem = null;
        int index = 0;
        SelectorItemCollection sic = evi.getSelector();
        HashMap<String, String> cancelMap = new HashMap<String, String>();
        IDimensionExpression dimExpress = DimensionExpressionFactory.getLocalInstance((Context)this.ctx);
        DimensionExpressionCollection calCol = dimExpress.getDimensionExpressionCollection("select number where isFreezed = 1 and dimSrc.id='" + source.getId().toString() + "'");
        if (calCol != null && !calCol.isEmpty()) {
            for (i = 0; i < calCol.size(); ++i) {
                cancelMap.put(calCol.get(i).getNumber(), "");
            }
        }
        while (rs.next()) {
            tem = new HashMap<String, Object>();
            for (i = 0; i < sic.size(); ++i) {
                col = sic.get(i).getPropertyName();
                tem.put(col, rs.getString(col));
            }
            if (cancelMap.containsKey(tem.get("number"))) {
                tem.put("isEnable", false);
            } else {
                tem.put("isEnable", true);
            }
            map.put((String)((Object)Integer.valueOf(index)), tem);
            ++index;
        }
        if (QUERY_PROJECT.equals(queryType)) {
            map.put("isEnable", isEnable);
        }
        map.put("size", index);
        return map;
    }

    private Map loadPropMap(DimensionPropSrcCollection propColl) {
        HashMap<Integer, DimensionPropSrcInfo> propMap = new HashMap<Integer, DimensionPropSrcInfo>();
        for (int i = 0; i < propColl.size(); ++i) {
            DimensionPropSrcInfo propSrc = propColl.get(i);
            propMap.put(propSrc.getOrder(), propSrc);
        }
        return propMap;
    }

    private IDimension getDimensionInteface() throws Exception {
        if (this.iDimension == null) {
            this.iDimension = DimensionFactory.getLocalInstance((Context)this.ctx);
        }
        return this.iDimension;
    }

    private SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("id");
        sic.add("number");
        sic.add("name");
        return sic;
    }

    public Object getPeriodGroup() throws Exception {
        HashSet<Integer> set = new HashSet<Integer>();
        set.add(new Integer(1));
        set.add(new Integer(8));
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", set, CompareType.INCLUDE));
        SorterItemCollection sorts = view.getSorter();
        SorterItemInfo sort = new SorterItemInfo("year");
        sort.setSortType(SortType.DESCEND);
        sorts.add(sort);
        view.setFilter(filter);
        BgPeriodCollection data = BgPeriodFactory.getLocalInstance((Context)this.ctx).getBgPeriodCollection(view);
        return this.getPeriod(data);
    }

    private Object getPeriod(Object data) {
        int i;
        BgPeriodCollection colls = (BgPeriodCollection)data;
        HashMap<String, String> periodMap = null;
        HashMap<Object, Serializable> map = new HashMap<Object, Serializable>();
        int len = colls.size();
        for (i = 0; i < len; ++i) {
            periodMap = new HashMap<String, String>();
            periodMap.put("name", colls.get(i).getName());
            periodMap.put("longNumber", colls.get(i).getLongNumber());
            periodMap.put("number", colls.get(i).getNumber());
            map.put(i, periodMap);
        }
        map.put("length", Integer.valueOf(i));
        return map;
    }

    public Object getPeriodDataByGroup(Object parameter) throws Exception {
        if (!(parameter instanceof Map)) {
            return null;
        }
        String id = (String)((Map)parameter).get("id");
        if (StringUtils.isEmpty((String)id)) {
            return null;
        }
        IBgPeriod iBgPeriod = BgPeriodFactory.getLocalInstance((Context)this.ctx);
        SelectorItemCollection sic = this.getSelector();
        sic.add("longNumber");
        sic.add("periodType");
        BgPeriodInfo info = iBgPeriod.getBgPeriodInfo((IObjectPK)new ObjectUuidPK(id), sic);
        if (info == null) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)info.getLongNumber(), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(info.getLongNumber() + "!%"), CompareType.LIKE));
        filter.setMaskString("#0 or #1 ");
        view.getSorter().add(new SorterItemInfo("showLevel"));
        view.getSorter().add(new SorterItemInfo("longnumber"));
        SorterItemInfo sort = new SorterItemInfo("number");
        sort.setSortType(SortType.ASCEND);
        view.getSorter().add(sort);
        view.setFilter(filter);
        return BgPeriodFactory.getLocalInstance((Context)this.ctx).getBgPeriodCollection(view);
    }

    public Object getOrgunitDimensionData() throws Exception {
        String treeid = NewOrgViewHelper.convert2TreeId((OrgViewType)OrgViewType.COSTCENTER);
        FullOrgUnitCollection orgColl = (FullOrgUnitCollection)MetaDataFacadeFactory.getLocalInstance((Context)this.ctx).getAuthorizedOrg(treeid);
        Object data = this.getOrg(orgColl);
        return data;
    }

    private Object getOrg(FullOrgUnitCollection orgColl) {
        int index;
        HashMap<String, Object> orgMap = null;
        HashMap<Object, Serializable> map = new HashMap<Object, Serializable>();
        FullOrgUnitInfo info = null;
        int len = orgColl.size();
        for (index = 0; index < len; ++index) {
            info = orgColl.get(index);
            orgMap = new HashMap<String, Object>();
            orgMap.put("name", info.getName());
            orgMap.put("level", info.getLevel());
            orgMap.put("number", info.getNumber());
            orgMap.put("simpleName", info.getSimpleName());
            orgMap.put("parent", info.getParent());
            orgMap.put("desc", info.getDescription());
            orgMap.put("id", info.getId());
            orgMap.put("bosType", info.getBOSType());
            orgMap.put("orgType", info.getOrgTypeStr());
            map.put(index, orgMap);
        }
        map.put("length", Integer.valueOf(index));
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setBgIndexDimSrcFlag(String queryType) throws Exception {
        String sql = "update t_mbg_dimsrc set fiswebselect=? where fsrcid=?";
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<Object[]> paramList = new ArrayList<Object[]>();
        Object[] param1 = new Object[2];
        Object[] param2 = new Object[2];
        if (QUERY_ACCTITEM.equals(queryType)) {
            param1[0] = 1;
            param1[1] = "9DA99826";
            paramList.add(param1);
            param2[0] = 0;
            param2[1] = "78E4BC94";
            paramList.add(param2);
        } else {
            param1[0] = 0;
            param1[1] = "9DA99826";
            paramList.add(param1);
            param2[0] = 1;
            param2[1] = "78E4BC94";
            paramList.add(param2);
        }
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            MbgSqlHelper.executeBatch((Connection)conn, (String)sql, paramList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtils.cleanup(rs, stmt, (Connection)conn);
        }
    }

    private boolean getProjectDimIsEnable() throws Exception {
        boolean projectIsEnable = false;
        DimensionInfo info = DimensionFactory.getLocalInstance((Context)this.ctx).getDimensionInfo((IObjectPK)new ObjectUuidPK("GjMAAAAAUglJf4co"));
        if (info.isIsEnabled()) {
            projectIsEnable = true;
        }
        return projectIsEnable;
    }

    public void setProjectDim(Map<String, Object> parameter) throws Exception {
        if (parameter == null) {
            return;
        }
        boolean isCancel = false;
        String isEnable = (String)parameter.get("isEnable");
        if ("true".equals(isEnable)) {
            isCancel = true;
        }
        ArrayList<String> idLst = new ArrayList<String>();
        idLst.add("GjMAAAAAUglJf4co");
        DimensionFactory.getLocalInstance((Context)this.ctx).effective(idLst, isCancel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSubjectData(Map p) throws Exception {
        String subject = "SUBJECT";
        String sql = "select fsrcid from t_mbg_dimsrc where fiswebselect=1";
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            conn = EJBFactory.getConnection((Context)this.ctx);
            stmt = conn.prepareStatement(sql);
            rs = stmt.executeQuery();
            while (rs.next()) {
                String srcId = rs.getString("fsrcid");
                if (!"78E4BC94".equals(srcId)) continue;
                subject = "COSTYPE";
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                DBUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
            DBUtils.cleanup(rs, (Statement)stmt, (Connection)conn);
        }
        DBUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        return subject;
    }

    public Map<String, Object> setMemberCancel(Map<String, Object> parameter) throws Exception {
        AccountViewCollection col;
        if (parameter == null) {
            return null;
        }
        String number = (String)parameter.get("number");
        String memberId = (String)parameter.get("memberId");
        String queryType = (String)parameter.get(FIELD_QUERY);
        String isEnable = (String)parameter.get("isEnable");
        boolean isFreezed = false;
        if ("false".equals(isEnable)) {
            isFreezed = true;
        }
        DimensionSourceInfo source = this.getDimensionSourceInfo(queryType);
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList<DimensionExpressionInfo> childMemList = new ArrayList<DimensionExpressionInfo>();
        DimensionExpressionInfo info = new DimensionExpressionInfo();
        info.setNumber(number);
        childMemList.add(info);
        if (QUERY_ACCTITEM.equals(queryType) && (col = AccountViewFactory.getLocalInstance((Context)this.ctx).getChildrenList((IObjectPK)new ObjectUuidPK(memberId), (IObjectPK)new ObjectUuidPK(this.currOrgId))) != null && col.size() > 0) {
            for (int i = 0; i < col.size(); ++i) {
                DimensionExpressionInfo childInfo = new DimensionExpressionInfo();
                childInfo.setNumber(number);
                childMemList.add(childInfo);
            }
        }
        DimensionFactory.getLocalInstance((Context)this.ctx).effectiveProp(source.getId().toString(), childMemList, isFreezed);
        resultMap.put("data", childMemList);
        return resultMap;
    }

    public DimensionSourceInfo getDimensionSourceInfo(String queryType) throws Exception {
        EntityViewInfo view = new EntityViewInfo();
        view.setFilter(new FilterInfo());
        if (QUERY_ACCTITEM.equals(queryType)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("srcID", (Object)"9DA99826", CompareType.EQUALS));
        } else if (QUERY_PAYTYPE.equals(queryType)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("srcID", (Object)"78E4BC94", CompareType.EQUALS));
        } else if (QUERY_PROJECT.equals(queryType)) {
            view.getFilter().getFilterItems().add(new FilterItemInfo("srcID", (Object)"DADE05EE", CompareType.EQUALS));
        }
        DimensionSourceCollection colls = DimensionSourceFactory.getLocalInstance((Context)this.ctx).getDimensionSourceCollection(view);
        if (colls == null || colls.isEmpty()) {
            return null;
        }
        DimensionSourceInfo source = colls.get(0);
        return source;
    }
}

