/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bizframework.bsf.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.FullOrgUnitCollection;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.ISaleOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.ITransportOrgUnit;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.SaleOrgUnitCollection;
import com.kingdee.eas.basedata.org.SaleOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.TransportOrgUnitCollection;
import com.kingdee.eas.basedata.org.TransportOrgUnitFactory;
import com.kingdee.eas.bizframework.bsf.IBaseService;
import com.kingdee.eas.common.EASBizException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.bizframework.bsf.IBaseService"})
public class BaseService
extends BusinessServices
implements IBaseService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.arap.impl.PermissionService");

    public BaseService(Context context) {
        super(context);
    }

    @Override
    public OrgUnitInfo[] getAuthorizedBizOrgUnits(int orgType, String permissionItem) throws EASBizException, BOSException {
        OrgUnitCollection collection = this.getAuthOrgByPermItem(OrgType.getEnum((int)orgType), permissionItem);
        if (collection == null || collection.size() == 0) {
            return new OrgUnitInfo[0];
        }
        LinkedHashSet<String> keys = new LinkedHashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            keys.add(collection.get(i).getId().toString());
        }
        OrgUnitInfo[] results = this.getOrgUnitInfosByType(keys, orgType);
        OrgUnitInfo orgInfo = (OrgUnitInfo)this.getContext().get((Object)OrgType.getEnum((int)orgType));
        int findIndex = 0;
        for (int i = 0; i < results.length; ++i) {
            if (i == 0 || !results[i].getId().equals((Object)orgInfo.getId())) continue;
            findIndex = i;
            break;
        }
        if (findIndex > 0) {
            OrgUnitInfo tempOrg = results[findIndex];
            for (int i = findIndex; i > 0; --i) {
                results[i] = results[i - 1];
            }
            results[0] = tempOrg;
        }
        return results;
    }

    protected OrgUnitCollection getAuthOrgByPermItem(OrgType orgType, String permItem) throws BOSException, EASBizException {
        FullOrgUnitInfo fullInfo = null;
        OrgUnitCollection collection = new OrgUnitCollection();
        IPermission permission = PermissionFactory.getLocalInstance((Context)this.getContext());
        if (orgType == null) {
            return null;
        }
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgType)orgType));
        FullOrgUnitCollection result = permission.getAuthorizedOrg(this.getContext().getCaller(), orgType, (IObjectPK)treePK, permItem);
        for (int i = 0; i < result.size(); ++i) {
            fullInfo = result.get(i);
            collection.add((OrgUnitInfo)fullInfo);
        }
        return collection;
    }

    @Override
    public OrgUnitInfo[] getOrgUnitInfosByType(Set<String> keys, int orgTypeValue) throws BOSException, EASBizException {
        OrgType orgType = OrgType.getEnum((int)orgTypeValue);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", keys, CompareType.INCLUDE));
        if (!orgType.equals((Object)OrgType.Admin)) {
            filter.getFilterItems().add(new FilterItemInfo("isBizUnit", (Object)new Boolean(true), CompareType.EQUALS));
        }
        SorterItemCollection sortCol = new SorterItemCollection();
        sortCol.add(new SorterItemInfo("number"));
        view.setSorter(sortCol);
        view.setFilter(filter);
        view.setSelector(this.getOrgInfoSelector(orgType));
        Context ctx = this.getContext();
        OrgUnitInfo[] results = null;
        try {
            switch (orgType.getValue()) {
                case 0: {
                    IAdminOrgUnit iAdmin = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
                    AdminOrgUnitCollection collection = iAdmin.getAdminOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 1: {
                    ICompanyOrgUnit iCompany = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                    view.getSelector().add(new SelectorItemInfo("baseCurrency.precision"));
                    CompanyOrgUnitCollection collection = iCompany.getCompanyOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 2: {
                    ISaleOrgUnit iSale = SaleOrgUnitFactory.getLocalInstance((Context)ctx);
                    SaleOrgUnitCollection collection = iSale.getSaleOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 3: {
                    IPurchaseOrgUnit iPurchase = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
                    PurchaseOrgUnitCollection collection = iPurchase.getPurchaseOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 4: {
                    IStorageOrgUnit iStorage = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
                    StorageOrgUnitCollection collection = iStorage.getStorageOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
                case 24: {
                    ITransportOrgUnit iTransport = TransportOrgUnitFactory.getLocalInstance((Context)ctx);
                    TransportOrgUnitCollection collection = iTransport.getTransportOrgUnitCollection(view);
                    if (collection == null || collection.size() <= 0) break;
                    results = new OrgUnitInfo[collection.size()];
                    for (int i = 0; i < collection.size(); ++i) {
                        results[i] = collection.get(i);
                    }
                    break;
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        return results;
    }

    public SelectorItemCollection getOrgInfoSelector(OrgType orgType) {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("number"));
        selector.add(new SelectorItemInfo("name"));
        selector.add(new SelectorItemInfo("CU.id"));
        selector.add(new SelectorItemInfo("isCU"));
        selector.add(new SelectorItemInfo("isBizUnit"));
        selector.add(new SelectorItemInfo("isSaleOrgUnit"));
        selector.add(new SelectorItemInfo("isAdminOrgUnit"));
        selector.add(new SelectorItemInfo("isPurchaseOrgUnit"));
        selector.add(new SelectorItemInfo("isStorageOrgUnit"));
        selector.add(new SelectorItemInfo("isCompanyOrgUnit"));
        selector.add(new SelectorItemInfo("isTransportOrgUnit"));
        selector.add(new SelectorItemInfo("isFreeze"));
        selector.add(new SelectorItemInfo("isGrouping"));
        selector.add(new SelectorItemInfo("isCostOrgUnit"));
        selector.add(new SelectorItemInfo("isStart"));
        selector.add(new SelectorItemInfo("code"));
        selector.add(new SelectorItemInfo("orgTypeStr"));
        if (orgType.getValue() == 1) {
            selector.add(new SelectorItemInfo("baseCurrency.id"));
            selector.add(new SelectorItemInfo("baseCurrency.name"));
            selector.add(new SelectorItemInfo("baseCurrency.number"));
            selector.add(new SelectorItemInfo("accountTable.id"));
            selector.add(new SelectorItemInfo("accountTable.name"));
            selector.add(new SelectorItemInfo("accountTable.number"));
            selector.add(new SelectorItemInfo("accountPeriodType.id"));
            selector.add(new SelectorItemInfo("accountPeriodType.name"));
            selector.add(new SelectorItemInfo("accountPeriodType.number"));
        }
        return selector;
    }

    @Override
    public String getParamValue(String orgId, String paramNumber) throws EASBizException, BOSException {
        IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)this.getContext());
        ObjectUuidPK orgUnitPK = new ObjectUuidPK(orgId);
        return paramControl.getParamValue((IObjectPK)orgUnitPK, paramNumber);
    }
}

