/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bizframework.bsf.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodFactory;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.assistant.SystemStatusCtrolUtils;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.bizframework.bsf.FICenterBaseService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.util.EASCommonResource;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

@Component(value={"com.kingdee.eas.bizframework.bsf.FICenterBaseService"})
public class FICenterBaseServiceImpl
extends BusinessServices
implements FICenterBaseService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.vc.bsf.impl.FICenterBaseServiceImpl");

    public FICenterBaseServiceImpl(Context context) {
        super(context);
    }

    public PeriodInfo getCurrentPeriodInfo(String companyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyOrgUnitInfo = new CompanyOrgUnitInfo();
        companyOrgUnitInfo.setId(BOSUuid.read((String)companyId));
        return SystemStatusCtrolUtils.getCurrentPeriod((Context)this.getContext(), (SystemEnum)SystemEnum.GENERALLEDGER, (CompanyOrgUnitInfo)companyOrgUnitInfo);
    }

    public List getPeriodList(String companyId) throws EASBizException, BOSException {
        CompanyOrgUnitInfo companyOrgUnitInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo("select accountPeriodType.id where id = '" + companyId + "'");
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("periodYear"));
        selector.add(new SelectorItemInfo("periodNumber"));
        selector.add(new SelectorItemInfo("number"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("periodType", (Object)companyOrgUnitInfo.getAccountPeriodType().getId().toString(), CompareType.EQUALS));
        SorterItemCollection sortCol = new SorterItemCollection();
        SorterItemInfo sorterItem = new SorterItemInfo("number");
        sorterItem.setSortType(SortType.DESCEND);
        sortCol.add(sorterItem);
        view.setSelector(selector);
        view.setFilter(filter);
        view.setSorter(sortCol);
        PeriodCollection periodCollection = PeriodFactory.getLocalInstance((Context)this.getContext()).getPeriodCollection(view);
        ArrayList result = new ArrayList();
        Iterator it = periodCollection.iterator();
        while (it.hasNext()) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            PeriodInfo periodInfo = (PeriodInfo)it.next();
            String alias = this.getPeriodString(periodInfo);
            map.put("alias", alias);
            map.put("value", periodInfo.getNumber());
            result.add(map);
        }
        return result;
    }

    private String getPeriodString(PeriodInfo periodInfo) throws EASBizException, BOSException {
        String resFullName = "com.kingdee.eas.basedata.assistant.PeriodResource";
        String s = EASCommonResource.getString((String)resFullName, (String)"periodformat", (Locale)this.getContext().getLocale());
        MessageFormat mf = new MessageFormat(s);
        String result = mf.format(new String[]{new Integer(periodInfo.getPeriodYear()).toString(), new Integer(periodInfo.getPeriodNumber()).toString()});
        if (periodInfo.isIsAdjustPeriod()) {
            result = result + "(" + EASCommonResource.getString((String)resFullName, (String)"PeriodAdjuxt", (Locale)this.getContext().getLocale()) + ")";
        }
        return result;
    }

    public Map getPeriodData(String companyId) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        List periods = this.getPeriodList(companyId);
        result.put("periods", periods);
        PeriodInfo periodInfo = this.getCurrentPeriodInfo(companyId);
        if (periodInfo != null) {
            HashMap<String, Object> current = new HashMap<String, Object>();
            String alias = this.getPeriodString(periodInfo);
            current.put("alias", alias);
            current.put("value", periodInfo.getNumber());
            result.put("current", current);
        }
        return result;
    }

    public CompanyOrgUnitCollection getFuncPermissionOrgUnitCollection(String permissionItem) throws EASBizException, BOSException {
        String userId = this.getContext().getCaller().toString();
        String permItemId = this.getFuncPermissionId(permissionItem);
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT cp.fid as FID ");
        sql.append(this.getCompanyFilterSQL(userId, permItemId, true, null, null, true));
        IRowSet rowSet = DbUtil.executeQuery((Context)this.getContext(), (String)sql.toString());
        HashSet<String> idSet = new HashSet<String>();
        try {
            while (rowSet.next()) {
                idSet.add(rowSet.getString("FID"));
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        CompanyOrgUnitCollection result = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitCollection(view);
        OrgUnitInfo orgInfo = (OrgUnitInfo)this.getContext().get((Object)OrgType.getEnum((int)OrgType.Company.getValue()));
        for (int i = 0; i < result.size(); ++i) {
            if (orgInfo == null || !orgInfo.getId().equals((Object)result.get(i).getId())) continue;
            CompanyOrgUnitInfo newCompany = new CompanyOrgUnitInfo();
            CompanyOrgUnitInfo companyFst = result.get(0);
            CompanyOrgUnitInfo companyTmp = result.get(i);
            result.set(0, newCompany);
            result.set(i, companyFst);
            result.set(0, companyTmp);
        }
        return result;
    }

    private String getFuncPermissionId(String permissionItem) throws EASBizException, BOSException {
        String permItemId = "";
        String permSql = "select FID from t_pm_permitem where fnumber = '" + permissionItem + "'";
        IRowSet rs = DbUtil.executeQuery((Context)this.getContext(), (String)permSql);
        try {
            if (rs.next()) {
                permItemId = rs.getString("FID");
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        return permItemId;
    }

    private String getCompanyFilterSQL(String userId, String permssiomId, boolean isFunPerm, CompanyOrgUnitInfo root, String periodTypeID, boolean onlyLeaf) {
        StringBuffer sql = new StringBuffer();
        sql.append(" from t_bd_systemstatusctrol ssc ");
        sql.append(" inner join t_bd_systemstatus ss on ss.fid = ssc.fsystemstatusid and ss.fname = ").append(6);
        sql.append(" inner join t_org_company cp on cp.fid = ssc.fcompanyid ");
        if (!onlyLeaf) {
            sql.append(" inner join t_org_company pcp on charindex(pcp.flongnumber||'!', cp.flongnumber) = 1 or pcp.fid = cp.fid ");
        }
        sql.append(" where ssc.fstartperiodid is not null ");
        sql.append(" and cp.fisbizunit = 1 ");
        sql.append(" and cp.faccounttableid is not null ");
        if (periodTypeID != null) {
            sql.append(" and cp.faccountperiodid = '").append(periodTypeID).append("'");
        }
        if (root != null && !onlyLeaf) {
            sql.append(" and (pcp.flongnumber like '").append(root.getLongNumber()).append("!%' or pcp.fid = '").append(root.getId().toString()).append("')");
        } else if (root != null && onlyLeaf) {
            sql.append(" and (cp.flongnumber like '").append(root.getLongNumber()).append("!%' or cp.fid = '").append(root.getId().toString()).append("')");
        }
        if (isFunPerm && !StringUtils.isEmpty((String)permssiomId)) {
            sql.append(" and cp.fid in (").append(FICenterBaseServiceImpl.getOrgPermissonSQL(userId, permssiomId)).append(")");
        }
        return sql.toString();
    }

    public static String getOrgPermissonSQL(String userId, String permssiomId) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT UserOrgPerm.FOrgID FOrgID ");
        sql.append(" FROM T_PM_UserOrgPerm UserOrgPerm WHERE UserOrgPerm.FOwner = '").append(userId).append("'");
        sql.append(" AND UserOrgPerm.FPermItemID = '").append(permssiomId).append("'");
        sql.append(" UNION ALL");
        sql.append(" SELECT UserRoleOrg.FOrgID AS FOrgID FROM T_PM_RolePerm RolePerm ");
        sql.append(" INNER JOIN T_PM_UserRoleOrg UserRoleOrg ON  RolePerm.FRoleID = UserRoleOrg.FRoleID");
        sql.append(" WHERE UserRoleOrg.FUserID = '").append(userId).append("'");
        sql.append(" AND RolePerm.FPermItemID = '").append(permssiomId).append("'");
        return sql.toString();
    }
}

