/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.bizframework.bsf.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.json.JSONUtils;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.IQuerySolution;
import com.kingdee.eas.base.commonquery.QueryPanelCollection;
import com.kingdee.eas.base.commonquery.QueryPanelInfo;
import com.kingdee.eas.base.commonquery.QueryPanelTypeEnum;
import com.kingdee.eas.base.commonquery.QuerySolutionCollection;
import com.kingdee.eas.base.commonquery.QuerySolutionFactory;
import com.kingdee.eas.base.commonquery.QuerySolutionInfo;
import com.kingdee.eas.base.commonquery.ShareTypeEnum;
import com.kingdee.eas.base.commonquery.SolutionTypeEnum;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.bizframework.bsf.SolutionSetService;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.bizframework.bsf.SolutionSetService"})
public class SolutionSetServiceImpl
extends BusinessServices
implements SolutionSetService {
    public static final String FILTER_PANEL_CLASS_NAME = "com.kingdee.eas.base.commonquery.client.CommonFilterPanel";

    public SolutionSetServiceImpl(Context context) {
        super(context);
    }

    @Override
    public List<Object> getSolutionList(String orgid, String parentuiname) throws EASBizException, BOSException {
        ArrayList<Object> solutions = new ArrayList<Object>();
        BOSUuid orgID = BOSUuid.read((String)orgid);
        String parentPageName = parentuiname;
        try {
            EntityViewInfo viewInfo = this.getQuerySolutionViewInfo(parentPageName, orgID);
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)this.getContext());
            QuerySolutionCollection solutionCol = iSolution.getQuerySolutionCollection(viewInfo);
            for (int i = 0; i < solutionCol.size(); ++i) {
                QuerySolutionInfo info = solutionCol.get(i);
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("id", info.getId().toString());
                data.put("name", info.get("name"));
                data.put("defaultView", info.isIsUserDefaultSolu());
                if (info.isIsUserDefaultSolu()) {
                    data.put("name", "(\u9ed8\u8ba4)" + info.get("name"));
                    solutions.add(0, data);
                    continue;
                }
                solutions.add(data);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return solutions;
    }

    @Override
    public Map<String, Object> getSolution(String solutionId) throws EASBizException, BOSException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (solutionId == null || solutionId.trim().length() == 0) {
            return data;
        }
        Context ctx = this.getContext();
        String customerParams = "";
        QuerySolutionInfo solutionInfo = null;
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)this.getContext());
        solutionInfo = iQuerySolution.getQuerySolutionInfo((IObjectPK)new ObjectUuidPK(solutionId));
        QueryPanelCollection queryPanels = solutionInfo.getQueryPanelInfo();
        for (int i0 = 0; i0 < queryPanels.size(); ++i0) {
            QueryPanelInfo info = queryPanels.get(i0);
            customerParams = info.getCustomerParams();
        }
        CustomerParams cp = CustomerParams.getCustomerParams2((String)customerParams);
        HashMap searchFilter = cp.getCustomerParamsHashMap();
        this.afterGetSolution(searchFilter);
        data.put("searchFilter", searchFilter);
        data.put("defaultView", solutionInfo.isIsUserDefaultSolu());
        data.put("solutionName", solutionInfo.getName(ctx.getLocale()));
        data.put("solutionid", solutionInfo.getId().toString());
        return data;
    }

    @Override
    public Map<String, Object> saveSolution(String companyId, String solutionname, boolean isdefault, String parentuiname, String filer) throws EASBizException, BOSException {
        Context ctx = this.getContext();
        HashMap searchFilter = JSONUtils.convertJsonToObject((Context)ctx, (String)filer);
        searchFilter.put("companyId", companyId);
        String viewId = "";
        String parentPageName = parentuiname;
        QuerySolutionInfo solutionInfo = this.getSameNameSolution(solutionname, parentPageName, companyId);
        HashMap<String, Object> results = new HashMap<String, Object>();
        if (solutionInfo != null) {
            viewId = solutionInfo.getId().toString();
            this.editSolution(viewId, parentPageName, solutionname, searchFilter, isdefault, companyId);
            results.put("oprSta", "update");
        } else {
            viewId = this.addSolution(solutionname, parentPageName, searchFilter, isdefault, companyId);
            results.put("oprSta", "addnew");
        }
        results.put("viewId", viewId);
        return results;
    }

    private QuerySolutionInfo getSameNameSolution(String solutionName, String parentPageName, String orgID) throws EASBizException, BOSException {
        Context ctx = this.getContext();
        try {
            IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)ctx);
            return iQuerySolution.getOwnerSolutionByName(orgID, this.getQueryPk(), parentPageName, this.getShareType(), solutionName);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private boolean editSolution(String solutionID, String parentPageName, String solutionName, Map searchFilter, boolean isdefault, String orgID) throws EASBizException, BOSException {
        try {
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)this.getContext());
            ObjectUuidPK pk = new ObjectUuidPK(BOSUuid.read((String)solutionID));
            QuerySolutionInfo solutionInfo = iSolution.getQuerySolutionInfo((IObjectPK)pk);
            solutionInfo.setShareType(this.getShareType());
            solutionInfo.setIsUserDefaultSolu(isdefault);
            QueryPanelCollection queryPanelCol = this.getQueryPanelCollection(searchFilter);
            solutionInfo.getQueryPanelInfo().clear();
            solutionInfo.getQueryPanelInfo().addCollection(queryPanelCol);
            solutionInfo.setRowCount(-1);
            if (isdefault) {
                this.updateOtherUserDefault(orgID, solutionID, parentPageName);
            } else {
                List<Object> list = this.getSolutionList(orgID, parentPageName);
                if (list == null || list.size() == 0) {
                    solutionInfo.setIsUserDefaultSolu(true);
                }
            }
            iSolution.update((IObjectPK)pk, (CoreBaseInfo)solutionInfo);
            return true;
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private String addSolution(String solutionName, String parentPageName, Map searchFilter, boolean isdefault, String orgid) throws EASBizException, BOSException {
        try {
            Context ctx = this.getContext();
            QuerySolutionInfo solutionInfo = new QuerySolutionInfo();
            solutionInfo.setName(solutionName);
            solutionInfo.setName(solutionName, new Locale("l1"));
            solutionInfo.setName(solutionName, new Locale("l3"));
            solutionInfo.setOrgID(BOSUuid.read((String)orgid));
            solutionInfo.setQueryObjectName(this.getQueryPk());
            solutionInfo.setShareType(this.getShareType());
            solutionInfo.setSolutionType(SolutionTypeEnum.CUSTOMER_SOLUTION);
            solutionInfo.setParentUIName(parentPageName);
            solutionInfo.setIsUserDefaultSolu(isdefault);
            solutionInfo.setOwner(ContextUtil.getCurrentUserInfo((Context)ctx).getId());
            QueryPanelCollection queryPanelCol = this.getQueryPanelCollection(searchFilter);
            solutionInfo.getQueryPanelInfo().addCollection(queryPanelCol);
            solutionInfo.setRowCount(-1);
            if (isdefault) {
                this.updateOtherUserDefault(orgid, "", parentPageName);
            } else {
                List<Object> list = this.getSolutionList(orgid, parentPageName);
                if (list == null || list.size() == 0) {
                    solutionInfo.setIsUserDefaultSolu(true);
                }
            }
            IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)this.getContext());
            IObjectPK pk = iSolution.addnew((CoreBaseInfo)solutionInfo);
            solutionInfo.setId(BOSUuid.read((String)pk.toString()));
            return solutionInfo.getId().toString();
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void updateOtherUserDefault(String orgID, String currentSolutionID, String parentUIName) throws BOSException, EASBizException {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)this.getContext());
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        FilterItemInfo parentUIFilterItem = new FilterItemInfo("parentUIName", (Object)parentUIName);
        FilterItemInfo isUserDefaultFilterItem = new FilterItemInfo("isUserDefaultSolu", (Object)true);
        FilterItemInfo orgFilterItem = new FilterItemInfo("orgID", (Object)orgID);
        filterInfo.getFilterItems().add(parentUIFilterItem);
        filterInfo.getFilterItems().add(isUserDefaultFilterItem);
        filterInfo.getFilterItems().add(orgFilterItem);
        String maskString = " #0 and #1 and #2 ";
        filterInfo.setMaskString(maskString);
        evi.setFilter(filterInfo);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("isUserDefaultSolu"));
        selector.add(new SelectorItemInfo("id"));
        evi.setSelector(selector);
        QuerySolutionCollection querySolutionCollection = iQuerySolution.getQuerySolutionCollection(evi);
        QuerySolutionInfo querySolutionInfoOld = null;
        SelectorItemCollection updateSelector = new SelectorItemCollection();
        updateSelector.add(new SelectorItemInfo("isUserDefaultSolu"));
        int size = querySolutionCollection.size();
        for (int i = 0; i < size; ++i) {
            querySolutionInfoOld = querySolutionCollection.get(i);
            if (querySolutionInfoOld.getId().toString().equals(currentSolutionID)) continue;
            querySolutionInfoOld.setIsUserDefaultSolu(false);
            iQuerySolution.updatePartial((CoreBaseInfo)querySolutionInfoOld, updateSelector);
        }
    }

    private void setDefaultSolution(String orgID, String parentUIName) throws BOSException, EASBizException {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)this.getContext());
        EntityViewInfo viewInfo = this.getQuerySolutionViewInfo(parentUIName, BOSUuid.read((String)orgID));
        IQuerySolution iSolution = QuerySolutionFactory.getLocalInstance((Context)this.getContext());
        QuerySolutionCollection solutionCol = iSolution.getQuerySolutionCollection(viewInfo);
        if (solutionCol != null && solutionCol.size() > 0) {
            int size = solutionCol.size();
            for (int i = 0; i < size; ++i) {
                QuerySolutionInfo info = solutionCol.get(i);
                if (!info.isIsUserDefaultSolu()) continue;
                return;
            }
            QuerySolutionInfo querySolutionInfoOld = solutionCol.get(0);
            querySolutionInfoOld.setIsUserDefaultSolu(true);
            SelectorItemCollection updateSelector = new SelectorItemCollection();
            updateSelector.add(new SelectorItemInfo("isUserDefaultSolu"));
            iQuerySolution.updatePartial((CoreBaseInfo)querySolutionInfoOld, updateSelector);
        }
    }

    private QueryPanelCollection getQueryPanelCollection(Map searchFilter) throws EASBizException, BOSException {
        this.beforeSaveSolution(searchFilter);
        QueryPanelInfo queryPanelInfo = new QueryPanelInfo();
        queryPanelInfo.setPanelClassName(FILTER_PANEL_CLASS_NAME);
        FilterInfo filter = new FilterInfo();
        queryPanelInfo.setFilterInfo(filter.toString());
        queryPanelInfo.setSorterInfo(null);
        queryPanelInfo.setParam(null);
        queryPanelInfo.setPanelName("\u7b80\u5355");
        queryPanelInfo.setQueryPanelType(QueryPanelTypeEnum.CUSTOMER_PANEL);
        String customerParams = "";
        if (searchFilter != null) {
            Set keys = searchFilter.keySet();
            Collection values = searchFilter.values();
            if (keys.size() > 0) {
                try {
                    customerParams = XMLBean.CreateXMLStrRecursion(keys, values);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        queryPanelInfo.setCustomerParams(customerParams);
        QueryPanelCollection queryPanelCol = new QueryPanelCollection();
        queryPanelCol.add(queryPanelInfo);
        return queryPanelCol;
    }

    @Override
    public Map<String, Object> copySolution(String companyId, String solutionname, boolean isdefault, String parentuiname, String orgs, String filer) throws EASBizException, BOSException {
        String[] ids = orgs.split(",");
        if (ids.length <= 0) {
            return new HashMap<String, Object>();
        }
        this.saveSolution(companyId, solutionname, isdefault, parentuiname, filer);
        int size = ids.length;
        for (int i = 0; i < size; ++i) {
            this.checkBeforeCopy(companyId, solutionname, isdefault, parentuiname, filer);
            this.saveSolution(ids[i], solutionname, isdefault, parentuiname, filer);
        }
        return null;
    }

    public EntityViewInfo getQuerySolutionViewInfo(String parentPageName, BOSUuid orgID) throws EASBizException, BOSException {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("queryObjectName", (Object)this.getQueryPk()));
        filter.getFilterItems().add(new FilterItemInfo("parentUIName", (Object)parentPageName));
        filter.getFilterItems().add(new FilterItemInfo("orgID", (Object)orgID));
        filter.getFilterItems().add(new FilterItemInfo("shareType", (Object)this.getShareType().getValue()));
        if (ShareTypeEnum.USER_LEVEL.equals((Object)this.getShareType())) {
            FilterItemInfo filterItemInfo = new FilterItemInfo("owner", (Object)this.getCurrentUserId(this.getContext()).toString());
            filter.getFilterItems().add(filterItemInfo);
            filter.setMaskString(" #0 AND #1 AND #2 AND #3 AND #4  ");
        } else {
            filter.setMaskString(" #0 AND #1 AND #2 AND #3 ");
        }
        viewInfo.setFilter(filter);
        SorterItemCollection sortCol = new SorterItemCollection();
        sortCol.add(new SorterItemInfo("name"));
        viewInfo.setSorter(sortCol);
        viewInfo.getSelector().addObjectCollection((IObjectCollection)SolutionSetServiceImpl.getSelectorItemCollection());
        return viewInfo;
    }

    private static SelectorItemCollection getSelectorItemCollection() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.*"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.id"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.queryPanelType"));
        sic.add(new SelectorItemInfo("QueryPanelInfo.panelClassName"));
        return sic;
    }

    @Override
    public void removeSolution(String companyId, String parentuiname, String solutionId) throws EASBizException, BOSException {
        IQuerySolution iQuerySolution = QuerySolutionFactory.getLocalInstance((Context)this.getContext());
        iQuerySolution.delete((IObjectPK)new ObjectUuidPK(solutionId));
        this.setDefaultSolution(companyId, parentuiname);
    }

    public BOSUuid getCurrentUserId(Context ctx) {
        return ContextUtil.getCurrentUserInfo((Context)ctx).getId();
    }

    public ShareTypeEnum getShareType() {
        return ShareTypeEnum.ORG_LEVEL;
    }

    public void afterGetSolution(Map searchFilter) throws EASBizException, BOSException {
    }

    public void beforeSaveSolution(Map searchFilter) throws EASBizException, BOSException {
    }

    public void checkBeforeCopy(String companyId, String solutionname, boolean isdefault, String parentuiname, String filer) throws EASBizException, BOSException {
    }

    public String getQueryPk() {
        return null;
    }
}

