/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.Domain;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.cdo.ICommonDataObject;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.AccountStandardInfo;
import com.kingdee.eas.cp.bc.CreditControlSTDAssignFactory;
import com.kingdee.eas.cp.bc.CreditControlSTDAssignInfo;
import com.kingdee.eas.cp.bc.CreditControlSTDCollection;
import com.kingdee.eas.cp.bc.CreditControlSTDEntryCollection;
import com.kingdee.eas.cp.bc.CreditControlSTDEntryFactory;
import com.kingdee.eas.cp.bc.CreditControlSTDEntryInfo;
import com.kingdee.eas.cp.bc.CreditControlSTDFactory;
import com.kingdee.eas.cp.bc.CreditControlSTDInfo;
import com.kingdee.eas.cp.bc.EnableStateEnum;
import com.kingdee.eas.cp.bc.ExpenseCommenFacadeFactory;
import com.kingdee.eas.cp.bc.ExpenseTypeSubjectMappingInfo;
import com.kingdee.eas.cp.bc.ICreditControlSTDAssign;
import com.kingdee.eas.cp.bc.ICreditControlSTDEntry;
import com.kingdee.eas.cp.bc.app.creditcontrol.util.CreditControlUtil;
import com.kingdee.eas.cp.bc.services.IBizBaseDataService;
import com.kingdee.eas.cp.bc.services.util.CommonDataUtils;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.cp.bc.services.IBizBaseDataService"})
@Description(value="")
public class BizBaseDataService
extends BusinessServices
implements IBizBaseDataService {
    private Context context;

    public BizBaseDataService(Context context) {
        super(context);
        this.context = context;
    }

    @Override
    public IObjectValue buildModel(IObjectValue object) throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getContext().get((Object)"CompanyInfo");
        Map initData = new HashMap<String, Object>();
        DataBaseInfo dataBaseInfo = (DataBaseInfo)object;
        if (dataBaseInfo instanceof ExpenseTypeSubjectMappingInfo) {
            ((ExpenseTypeSubjectMappingInfo)dataBaseInfo).setCompany(company);
            String accountTypeFilter = this.getAccountTypeFilter(company);
            initData.put("accountTypeFilter", accountTypeFilter);
        } else if (dataBaseInfo instanceof CreditControlSTDInfo) {
            List<String> adminIds = CommonDataUtils.getChildAdminIds(this.getContext());
            initData.put("adminIds", adminIds);
            CompanyOrgUnitInfo companOrgInfo = new CompanyOrgUnitInfo();
            companOrgInfo.setId(company.getId());
            ((CreditControlSTDInfo)dataBaseInfo).setCompany(companOrgInfo);
        } else if (dataBaseInfo instanceof AccountStandardInfo) {
            Domain cpbcDomain = Domain.getInstance((String)"eas-cp-bc", null);
            CompanyOrgUnitInfo companOrgInfo = new CompanyOrgUnitInfo();
            companOrgInfo.setId(company.getId());
            CompanyOrgUnitInfo companyInfo = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo("select id, baseCurrency.id, baseCurrency.number, baseCurrency.name where id = '" + companOrgInfo.getId().toString() + "'");
            ((AccountStandardInfo)dataBaseInfo).setCompany(companOrgInfo);
            ((AccountStandardInfo)dataBaseInfo).setEffectiveDate(new Date());
            ((AccountStandardInfo)dataBaseInfo).setState(EnableStateEnum.ENABLE);
            ((AccountStandardInfo)dataBaseInfo).setEffectiveDate(new Date());
            ((AccountStandardInfo)dataBaseInfo).setCurrencyType(companyInfo.getBaseCurrency());
            initData = (Map)cpbcDomain.invokeService(this.getContext(), "AccountStandardService", "getFilterInfoData", new Object[0]);
            ArrayList<String> param = new ArrayList<String>();
            param.add("CP026");
            Map params = ExpenseCommenFacadeFactory.getLocalInstance((Context)this.getContext()).getParams(param);
            initData.putAll(params);
        }
        dataBaseInfo.put("initData", initData);
        return dataBaseInfo;
    }

    protected String getAccountTypeFilter(CompanyOrgUnitInfo company) {
        FilterInfo filter = new FilterInfo();
        FilterItemCollection fic = filter.getFilterItems();
        fic.add(new FilterItemInfo("companyID.id", (Object)company.getId().toString()));
        if (company.getAccountTable() != null) {
            fic.add(new FilterItemInfo("accountTableID.id", (Object)company.getAccountTable().getId().toString()));
            filter.setMaskString("#0 and #1");
        } else {
            filter.setMaskString("#0 ");
        }
        return filter.toString();
    }

    @Override
    public String getAccountFilter() throws BOSException, EASBizException {
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)this.getContext().get((Object)"CompanyInfo");
        String filterStr = this.getAccountTypeFilter(company);
        return filterStr;
    }

    @Override
    public List<String> getCityName(List<String> travelAreaIds) throws BOSException, SQLException {
        ArrayList<String> result = new ArrayList<String>();
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.TravelAreaWithEntryQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.context, (IMetaDataPK)queryPK);
        for (String id : travelAreaIds) {
            FilterInfo filterInfo = new FilterInfo();
            FilterItemCollection filterItemCollection = filterInfo.getFilterItems();
            filterItemCollection.add(new FilterItemInfo("id", (Object)id));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(filterInfo);
            exec.setObjectView(entityViewInfo);
            IRowSet rowSet = exec.executeQuery();
            StringBuffer cityName = new StringBuffer();
            while (rowSet.next()) {
                cityName.append((String)rowSet.getObject("city.name"));
                cityName.append("\u3001");
            }
            result.add(cityName.toString().replaceAll("\u3001$", ""));
        }
        return result;
    }

    @Override
    public List<Map> getCityList(String travelAreaId) throws BOSException, SQLException {
        ArrayList<Map> cityList = new ArrayList<Map>();
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.TravelAreaWithEntryQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.context, (IMetaDataPK)queryPK);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItemCollection = filterInfo.getFilterItems();
        filterItemCollection.add(new FilterItemInfo("id", (Object)travelAreaId));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        exec.setObjectView(entityViewInfo);
        IRowSet rowSet = exec.executeQuery();
        while (rowSet.next()) {
            HashMap<String, String> city = new HashMap<String, String>();
            city.put("name", (String)rowSet.getObject("city.name"));
            city.put("id", (String)rowSet.getObject("city.id"));
            cityList.add(city);
        }
        return cityList;
    }

    private Set<String> getCreditControlSTDAssignCompanyIds(Set<String> creditControlSTDIds) throws BOSException, EASBizException, SQLException {
        if (creditControlSTDIds == null || creditControlSTDIds.size() == 0) {
            return null;
        }
        HashSet<String> creditCSTDAssignCompanyIds = new HashSet<String>();
        MetaDataPK queryPK = MetaDataPK.create((String)"com.kingdee.eas.cp.bc.app.CreditControlSTDAssignQuery");
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)this.context, (IMetaDataPK)queryPK);
        FilterInfo filterInfo = new FilterInfo();
        FilterItemCollection filterItemCollection = filterInfo.getFilterItems();
        filterItemCollection.add(new FilterItemInfo("creditControlSTD.id", creditControlSTDIds, CompareType.INCLUDE));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        exec.setObjectView(entityViewInfo);
        IRowSet result = exec.executeQuery();
        while (result.next()) {
            String companyOrgUnitId = (String)result.getObject("companyOrgUnit.id");
            creditCSTDAssignCompanyIds.add(companyOrgUnitId);
        }
        return creditCSTDAssignCompanyIds;
    }

    @Override
    public Map<String, Object> initCreditControlSTDView(String creditControlSTDId) throws BOSException, EASBizException, SQLException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtils.isEmpty((String)creditControlSTDId)) {
            return resultMap;
        }
        HashSet<String> personIds = new HashSet<String>();
        ICreditControlSTDEntry creditControlSTDEntryFactory = CreditControlSTDEntryFactory.getLocalInstance((Context)this.getContext());
        String queryOql = "select person.id where parent.id = '" + creditControlSTDId + "'";
        CreditControlSTDEntryCollection creditControlSTDEntryCollection = creditControlSTDEntryFactory.getCreditControlSTDEntryCollection(queryOql);
        for (int i = 0; i < creditControlSTDEntryCollection.size(); ++i) {
            personIds.add(creditControlSTDEntryCollection.get(i).getPerson().getId().toString());
        }
        List<String> adminIds = CommonDataUtils.getChildAdminIds(this.getContext());
        resultMap.put("adminIds", adminIds);
        resultMap.put("creditCSTDAssignPersonIds", personIds);
        HashSet<String> creditControlSTDIds = new HashSet<String>();
        creditControlSTDIds.add(creditControlSTDId);
        Set<String> creditControlSTDAssignCompanyIds = this.getCreditControlSTDAssignCompanyIds(creditControlSTDIds);
        resultMap.put("creditCSTDAssignCompanyIds", new ArrayList<String>(creditControlSTDAssignCompanyIds));
        resultMap.put("orgFilterIds", CommonDataUtils.getChildCompanyOrg(this.getContext()));
        return resultMap;
    }

    @Override
    public Map<String, Object> initCreditControlSTDAssign(List<String> creditControlStdIds) throws BOSException, EASBizException, SQLException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (creditControlStdIds == null || creditControlStdIds.size() == 0) {
            return resultMap;
        }
        Set<String> assignCompanys = this.getCreditControlSTDAssignCompanyIds(new HashSet<String>(creditControlStdIds));
        resultMap.put("assignCompanys", new ArrayList<String>(assignCompanys));
        resultMap.put("companyFilter", CommonDataUtils.getChildCompanyOrg(this.getContext()));
        return resultMap;
    }

    @Override
    public List<Map<String, Object>> saveCreditControlSTDAssign(List<Map<String, Object>> creditControlSTDs, List<Map<String, Object>> companyOrgUnits) throws BOSException, EASBizException, SQLException {
        ArrayList<Map<String, Object>> errorList = new ArrayList<Map<String, Object>>();
        ICreditControlSTDAssign creditControlSTDAssignFactory = CreditControlSTDAssignFactory.getLocalInstance((Context)this.context);
        Set<String> companyIdList = this.getListMapIds(companyOrgUnits);
        Set<String> creditControlStIds = this.getListMapIds(creditControlSTDs);
        CoreBaseCollection creditControlSTAssignCollection = new CoreBaseCollection();
        int is = creditControlSTDs.size();
        for (int i = 0; i < is; ++i) {
            Map<String, Object> creditControlSTD = creditControlSTDs.get(i);
            String reimburseLevel = (String)creditControlSTD.get("reimburseLV.id");
            String creditControlSTId = (String)creditControlSTD.get("id");
            String creditControlSTName = (String)creditControlSTD.get("name");
            CreditControlSTDInfo creditControlSTInfo = new CreditControlSTDInfo();
            creditControlSTInfo.setId(BOSUuid.read((String)creditControlSTId));
            FilterInfo queryExistFilter = new FilterInfo();
            queryExistFilter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", companyIdList, CompareType.INCLUDE));
            queryExistFilter.getFilterItems().add(new FilterItemInfo("creditControlSTD.reimburseLV.id", (Object)reimburseLevel));
            queryExistFilter.getFilterItems().add(new FilterItemInfo("creditControlSTD.id", (Object)creditControlSTId, CompareType.NOTEQUALS));
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("companyOrgUnit.id"));
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            entityViewInfo.setFilter(queryExistFilter);
            entityViewInfo.setSelector(selector);
            CoreBaseCollection existAssignCompany = creditControlSTDAssignFactory.getCollection(entityViewInfo);
            Set<String> existCompanyIds = CommonDataUtils.getPropIds((AbstractObjectCollection)existAssignCompany, "companyOrgUnit");
            ArrayList<String> errorCompanyList = new ArrayList<String>();
            int js = companyOrgUnits.size();
            for (int j = 0; j < js; ++j) {
                String companyId = (String)companyOrgUnits.get(j).get("id");
                if (existCompanyIds.contains(companyId)) {
                    String companyName = (String)companyOrgUnits.get(j).get("name");
                    errorCompanyList.add(companyName);
                } else {
                    CreditControlSTDAssignInfo creditControlSTAssignInfo = new CreditControlSTDAssignInfo();
                    creditControlSTAssignInfo.setCreditControlSTD(creditControlSTInfo);
                    CompanyOrgUnitInfo assignCompany = new CompanyOrgUnitInfo();
                    assignCompany.setId(BOSUuid.read((String)companyId));
                    creditControlSTAssignInfo.setCompanyOrgUnit(assignCompany);
                    creditControlSTAssignCollection.add((CoreBaseInfo)creditControlSTAssignInfo);
                }
                if (errorCompanyList.size() == 0) continue;
                HashMap<String, Object> errorMap = new HashMap<String, Object>();
                errorMap.put("creditControlStName", creditControlSTName);
                errorMap.put("companyList", errorCompanyList);
                errorList.add(errorMap);
            }
        }
        FilterInfo delFilterInfo = new FilterInfo();
        delFilterInfo.getFilterItems().add(new FilterItemInfo("creditControlSTD.id", creditControlStIds, CompareType.INCLUDE));
        creditControlSTDAssignFactory.delete(delFilterInfo);
        if (creditControlSTAssignCollection.size() != 0) {
            creditControlSTDAssignFactory.addnewBatchData(creditControlSTAssignCollection);
        }
        return errorList;
    }

    @Override
    public Map<String, Object> saveCreditControlSTDAssignPerson(Map<String, Object> creditControlStandard, List<Map<String, Object>> persons) throws BOSException, EASBizException, SQLException {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (creditControlStandard == null) {
            return resultMap;
        }
        ICreditControlSTDEntry creditControlStEntryFactory = CreditControlSTDEntryFactory.getLocalInstance((Context)this.getContext());
        Set<String> assignPersonIds = this.getListMapIds(persons);
        String creditControlStandardId = (String)creditControlStandard.get("id");
        FilterInfo queryExistFilter = new FilterInfo();
        queryExistFilter.getFilterItems().add(new FilterItemInfo("person.id", assignPersonIds, CompareType.INCLUDE));
        queryExistFilter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)creditControlStandardId, CompareType.NOTEQUALS));
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("person.id"));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(queryExistFilter);
        entityViewInfo.setSelector(selector);
        CreditControlSTDEntryCollection creditControlSTDEntryCollection = creditControlStEntryFactory.getCreditControlSTDEntryCollection(entityViewInfo);
        Set<String> existAssignPersonIds = CommonDataUtils.getPropIds((AbstractObjectCollection)creditControlSTDEntryCollection, "person");
        CreditControlSTDInfo creditControlStInfo = new CreditControlSTDInfo();
        creditControlStInfo.setId(BOSUuid.read((String)creditControlStandardId));
        CoreBaseCollection assignPersons = new CoreBaseCollection();
        ArrayList<PersonInfo> savedPersons = new ArrayList<PersonInfo>();
        ArrayList<String> unAssignPersons = new ArrayList<String>();
        int is = persons.size();
        for (int i = 0; i < is; ++i) {
            String personId = (String)persons.get(i).get("id");
            if (existAssignPersonIds.contains(personId)) {
                String personName = (String)persons.get(i).get("name");
                unAssignPersons.add(personName);
                continue;
            }
            CreditControlSTDEntryInfo assignPerson = new CreditControlSTDEntryInfo();
            PersonInfo person = new PersonInfo();
            person.setId(BOSUuid.read((String)personId));
            assignPerson.setPerson(person);
            assignPerson.setParent(creditControlStInfo);
            assignPersons.add((CoreBaseInfo)assignPerson);
            savedPersons.add(person);
        }
        FilterInfo delFilterInfo = new FilterInfo();
        delFilterInfo.getFilterItems().add(new FilterItemInfo("parent.id", (Object)creditControlStandardId));
        creditControlStEntryFactory.delete(delFilterInfo);
        if (assignPersons.size() != 0) {
            creditControlStEntryFactory.addnewBatchData(assignPersons);
        }
        resultMap.put("assignPersons", savedPersons);
        resultMap.put("unAssignPersons", unAssignPersons);
        return resultMap;
    }

    @Override
    public void cancelCreditControlSTDAssign(String type, String creditControlSTDId, String assignId) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        if ("company".equals(type)) {
            ICreditControlSTDAssign creditControlSTDASSignFactory = CreditControlSTDAssignFactory.getLocalInstance((Context)this.getContext());
            filterInfo.getFilterItems().add(new FilterItemInfo("creditControlSTD", (Object)creditControlSTDId));
            filterInfo.getFilterItems().add(new FilterItemInfo("companyOrgUnit", (Object)assignId));
            filterInfo.setMaskString("#0 and #1");
            creditControlSTDASSignFactory.delete(filterInfo);
        } else if ("person".equals(type)) {
            ICreditControlSTDEntry creditControlSTDEntryFactory = CreditControlSTDEntryFactory.getLocalInstance((Context)this.context);
            filterInfo.getFilterItems().add(new FilterItemInfo("parent", (Object)creditControlSTDId));
            filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)assignId));
            filterInfo.setMaskString("#0 and #1");
            creditControlSTDEntryFactory.delete(filterInfo);
        }
    }

    @Override
    public Map getCreditControlsByreimburseLVOrPerson(String companyId, String reimburseLevelId, String personIds, String billId) throws BOSException, EASBizException {
        CreditControlSTDCollection con;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (companyId != null && reimburseLevelId != null) {
            con = CreditControlSTDFactory.getLocalInstance((Context)this.getContext()).getCreditControlSTDCollection("select id where company.id = '" + companyId + "' and reimburseLV.id = '" + reimburseLevelId + "' and id <> '" + billId + "'");
            result.put("reimburseLevelId", con);
        }
        if (personIds != null && personIds.length() > 0) {
            con = null;
            CreditControlSTDEntryCollection entryCon = CreditControlSTDEntryFactory.getLocalInstance((Context)this.getContext()).getCreditControlSTDEntryCollection("select parent.id, parent.number, parent.company.id, parent.company.name , person.id, person.name where person in (" + personIds + ") and parent.isAllocPerson = 1 and parent.id <>" + billId + "'");
            if (entryCon != null && entryCon.size() > 0) {
                con = new CreditControlSTDCollection();
            }
            StringBuffer infos = new StringBuffer();
            for (CreditControlSTDEntryInfo entryInfo : entryCon) {
                CreditControlSTDInfo info = entryInfo.getParent();
                PersonInfo person = entryInfo.getPerson();
                CompanyOrgUnitInfo company = info.getCompany();
                infos.append(company.getName()).append("\u521b\u5efa\u7684\u7f16\u7801\u4e3a").append(info.getNumber()).append("\u7684\u4fe1\u7528\u63a7\u5236\u6807\u51c6\uff0c\u5df2\u7ecf\u6307\u5b9a\u4e86\u804c\u5458 ").append(person.getName()).append(";\n");
            }
            result.put("error", infos.toString());
        }
        return result;
    }

    @Override
    public Map<String, Object> checkCreditControl(String personId, int amount, String creditControlSTDId) throws BOSException, EASBizException, SQLException {
        Map checkMap = CreditControlUtil.checkPersonCredit((Context)this.getContext(), (String)personId, (BigDecimal)new BigDecimal(amount), (String)creditControlSTDId);
        return checkMap;
    }

    @Override
    public Map getCreditControlSTDByPersonIds(List personIds) throws BOSException, EASBizException {
        HashMap<String, Date> result = new HashMap<String, Date>();
        Date date = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        formatter.format(date);
        result.put("date", date);
        Iterator it = personIds.iterator();
        while (it.hasNext()) {
            String id = it.next().toString();
            CreditControlSTDInfo creditInfo = CreditControlUtil.getCreditControlSTDByPerson((Context)this.getContext(), (String)id);
            if (creditInfo == null) continue;
            result.put(id, (Date)creditInfo);
        }
        return result;
    }

    @Override
    public Map getPersonsUsedCredit(String userId) throws BOSException, EASBizException, SQLException {
        Domain cpbcDomain;
        String adminIds;
        if (userId == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("person.id"));
        UserInfo userInfo = UserFactory.getLocalInstance((Context)this.getContext()).getUserInfo((IObjectPK)new ObjectUuidPK(userId), selector);
        if (userInfo != null && userInfo.getPerson() != null && userInfo.getPerson().getId() != null) {
            Map usedCredit;
            String personId = userInfo.getPerson().getId().toString();
            AdminOrgUnitInfo adminOrg = PersonFactory.getLocalInstance((Context)this.getContext()).getPrimaryAdminOrgUnit(BOSUuid.read((String)personId));
            if (adminOrg != null) {
                result.put("adminOrgId", adminOrg.getId().toString());
                usedCredit = CreditControlUtil.getPersonsUsedCredit((Context)this.getContext(), (String)adminOrg.getId().toString());
                result.put("usedCredit", usedCredit);
            }
            result.put("personId", personId);
            if (result.get("usedCredit") == null) {
                usedCredit = CreditControlUtil.getPersonUsedCredit((Context)this.getContext(), (String)personId);
                result.put("usedCredit", usedCredit);
            }
        }
        if ((adminIds = (String)(cpbcDomain = Domain.getInstance((String)"cp_bc", null)).invokeService(this.getContext(), "ExpenseCommenFacadeService", "getSpecialData", new Object[]{userId})) != null) {
            FilterItemInfo filter = new FilterItemInfo("adminOrgUnitId", (Object)adminIds, CompareType.INCLUDE);
            result.put("adminIds", filter.toString());
        }
        return result;
    }

    @Override
    public ICommonDataObject getCurrencyInfo() throws EASBizException, BOSException {
        CurrencyInfo currencyInfo = null;
        ICurrency ic = CurrencyFactory.getLocalInstance((Context)this.getContext());
        CurrencyInfo baseCurrency = ContextUtil.getCurrentFIUnit((Context)this.getContext()).getBaseCurrency();
        if (baseCurrency != null) {
            currencyInfo = (CurrencyInfo)ic.getValue((IObjectPK)new ObjectUuidPK(baseCurrency.getId()));
        }
        return CDOUtils.convertObjectInfoToCDO((Context)this.getContext(), currencyInfo);
    }

    private Set<String> getListMapIds(List<Map<String, Object>> listMap) {
        HashSet<String> resultSet = new HashSet<String>();
        int is = listMap.size();
        for (int i = 0; i < is; ++i) {
            Object idObj = listMap.get(i).get("id");
            if (idObj == null) continue;
            resultSet.add(idObj.toString());
        }
        return resultSet;
    }
}

