/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.cdo.ICommonDataObject;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.CollectionAccountCollection;
import com.kingdee.eas.cp.bc.CollectionAccountFactory;
import com.kingdee.eas.cp.bc.CollectionAccountInfo;
import com.kingdee.eas.cp.bc.EnableStateEnum;
import com.kingdee.eas.cp.bc.ICollectionAccount;
import com.kingdee.eas.cp.bc.services.ICollectionAccountService;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.cp.bc.services.ICollectionAccountService"})
@Description(value="")
public class CollectionAccountService
extends BusinessServices
implements ICollectionAccountService {
    public CollectionAccountService(Context context) {
        super(context);
    }

    @Override
    public void changeState(List<String> ids, Boolean enable) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("state"));
        for (String id : ids) {
            CollectionAccountInfo collectionAccountInfo = new CollectionAccountInfo();
            collectionAccountInfo.setId(BOSUuid.read((String)id));
            collectionAccountInfo.setState(enable != false ? EnableStateEnum.ENABLE : EnableStateEnum.DISABLE);
            CollectionAccountFactory.getLocalInstance((Context)this.getContext()).updatePartial((CoreBaseInfo)collectionAccountInfo, sic);
        }
    }

    @Override
    public int saveCollectionAccount(CommonDataObject collectionAccount) throws BOSException, EASBizException {
        CollectionAccountInfo collectionAccountInfo = (CollectionAccountInfo)CDOUtils.convertCDOToObjectInfo((Context)this.getContext(), (ICommonDataObject)collectionAccount);
        Context context = this.getContext();
        UserInfo user = (UserInfo)context.get((Object)"UserInfo");
        String personId = user.getPerson().getId().toString();
        String id = (String)collectionAccount.get((Object)"id");
        PersonInfo personInfo = new PersonInfo();
        personInfo.setId(BOSUuid.read((String)personId));
        collectionAccountInfo.setApplier(personInfo);
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("bankAccount", (Object)collectionAccountInfo.getBankAccount()));
        filterInfo.getFilterItems().add(new FilterItemInfo("applier", (Object)personId));
        filterInfo.getFilterItems().add(new FilterItemInfo("id", (Object)id, CompareType.NOTEQUALS));
        filterInfo.setMaskString("#0 AND #1 AND #2");
        ICollectionAccount collectionAccountFactory = CollectionAccountFactory.getLocalInstance((Context)context);
        boolean ifExist = collectionAccountFactory.exists(filterInfo);
        if (ifExist) {
            return 1;
        }
        if (collectionAccountInfo.isIsDefault()) {
            EntityViewInfo entityViewInfo = new EntityViewInfo();
            FilterInfo defaultFilterInfo = new FilterInfo();
            defaultFilterInfo.getFilterItems().add(new FilterItemInfo("isDefault", (Object)true));
            defaultFilterInfo.getFilterItems().add(new FilterItemInfo("applier", (Object)personId));
            defaultFilterInfo.setMaskString("#0 AND #1");
            entityViewInfo.setFilter(defaultFilterInfo);
            CollectionAccountCollection collectionAccountCollection = collectionAccountFactory.getCollectionAccountCollection(entityViewInfo);
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("isDefault"));
            CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
            for (int i = 0; i < collectionAccountCollection.size(); ++i) {
                collectionAccountCollection.get(i).setIsDefault(false);
                coreBaseCollection.add((CoreBaseInfo)collectionAccountCollection.get(i));
            }
            collectionAccountFactory.updateBatchData(coreBaseCollection);
        }
        collectionAccountFactory.save((CoreBaseInfo)collectionAccountInfo);
        return 0;
    }

    @Override
    public CommonDataObject getDefaultCollectionAccount() throws BOSException, EASBizException {
        Context context = this.getContext();
        UserInfo user = (UserInfo)context.get((Object)"UserInfo");
        String personId = user.getPerson().getId().toString();
        StringBuffer oql = new StringBuffer();
        oql.append("select payee, bankAccount, openArea.id, ").append("openArea.name, Bebank.id, Bebank.name, BebankStr where applier.id = '").append(personId).append("' and isDefault = 1");
        CollectionAccountCollection collectionAccountCollection = CollectionAccountFactory.getLocalInstance((Context)context).getCollectionAccountCollection(oql.toString());
        if (collectionAccountCollection.size() > 0) {
            CommonDataObject collectionAccount = (CommonDataObject)CDOUtils.convertObjectInfoToCDO((Context)this.getContext(), (IObjectValue)collectionAccountCollection.getObject(0));
            return collectionAccount;
        }
        return null;
    }
}

