/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.cp.bc.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.bsf.annotation.Description;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.bc.EnableStateEnum;
import com.kingdee.eas.cp.bc.IReimburseLevel;
import com.kingdee.eas.cp.bc.IStaffReimburseLevelSetting;
import com.kingdee.eas.cp.bc.ReimburseLevelFactory;
import com.kingdee.eas.cp.bc.ReimburseLevelInfo;
import com.kingdee.eas.cp.bc.StaffReimburseLevelSettingFactory;
import com.kingdee.eas.cp.bc.StaffReimburseLevelSettingInfo;
import com.kingdee.eas.cp.bc.app.ReimburseLevelStateEnum;
import com.kingdee.eas.cp.bc.services.IReimburseStandardService;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.cp.bc.services.IReimburseStandardService"})
@Description(value="")
public class ReimburseStandardService
extends BusinessServices
implements IReimburseStandardService {
    public ReimburseStandardService(Context context) {
        super(context);
    }

    @Override
    public void enableReimburseLevel(List<String> reimburseLevelIds, boolean isEnable) throws EASBizException, BOSException {
        IReimburseLevel reiburseLevel = ReimburseLevelFactory.getLocalInstance((Context)this.getContext());
        CoreBaseCollection coreBaseCollection = new CoreBaseCollection();
        for (String reimburseLevelId : reimburseLevelIds) {
            ReimburseLevelInfo reimburseLevelInfo = new ReimburseLevelInfo();
            reimburseLevelInfo.setId(BOSUuid.read((String)reimburseLevelId));
            reimburseLevelInfo.setState(EnableStateEnum.getEnum((int)(isEnable ? 1 : 0)));
            coreBaseCollection.add((CoreBaseInfo)reimburseLevelInfo);
        }
        reiburseLevel.updateBatchData(coreBaseCollection);
    }

    @Override
    public List<Map<String, Object>> initCompanyOrgUnitTree() throws EASBizException, BOSException, SQLException {
        Context context = super.getContext();
        UserInfo user = (UserInfo)context.get((Object)"UserInfo");
        String userId = user.getId().toString();
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT FLONGNUMBER, TPOR.FORGID ").append("FROM T_PM_ORGRANGE TPOR INNER JOIN T_ORG_COMPANY TOC ON TPOR.FORGID = TOC.FID ").append("WHERE TPOR.FTYPE = ? AND TPOR.FUSERID = ? ");
        Object[] params = new Object[]{10, userId};
        IRowSet result = DbUtil.executeQuery((Context)context, (String)querySql.toString(), (Object[])params);
        if (result == null || result.size() == 0) {
            return null;
        }
        ArrayList<Map<String, Object>> treeList = new ArrayList();
        HashSet<String> numberSet = new HashSet<String>();
        ArrayList<String> idList = new ArrayList<String>();
        while (result.next()) {
            String id = result.getObject("FORGID").toString();
            idList.add(id);
            String longNumber = result.getObject("FLONGNUMBER").toString();
            String[] numbers = longNumber.split("!");
            for (int i = 0; i < numbers.length; ++i) {
                String number = numbers[i];
                numberSet.add(number);
            }
        }
        treeList = this.queryNodeByNumber(context, numberSet, idList);
        return treeList;
    }

    protected List<Map<String, Object>> queryNodeByNumber(Context context, Set<String> numbers, List<String> idList) throws BOSException, SQLException {
        StringBuffer querySql = new StringBuffer();
        StringBuffer numberSb = new StringBuffer("(");
        for (String str : numbers) {
            numberSb.append("'" + str + "',");
        }
        String numberStr = numberSb.toString().replaceAll(",$", ")");
        querySql.append("SELECT FID, FNUMBER, FNAME_L2, FPARENTID ").append("FROM T_ORG_COMPANY TOC ").append("WHERE TOC.FNUMBER IN ").append(numberStr);
        IRowSet result = DbUtil.executeQuery((Context)context, (String)querySql.toString());
        ArrayList<Map<String, Object>> resultMapList = new ArrayList<Map<String, Object>>();
        while (result.next()) {
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            HashMap dataMap = new HashMap();
            String id = (String)result.getObject("FID");
            String name = (String)result.getObject("FNAME_L2");
            String parentId = (String)result.getObject("FPARENTID");
            if (idList.contains(id)) {
                resultMap.put("isCompanyOrgUnit", true);
            }
            resultMap.put("open", true);
            resultMap.put("id", id);
            resultMap.put("data", dataMap);
            resultMap.put("name", name);
            resultMap.put("pId", parentId);
            resultMapList.add(resultMap);
        }
        return resultMapList;
    }

    @Override
    public void saveStaffReimburseLevel(String personId, String reimburseLevelId, int state) throws EASBizException, BOSException {
        IStaffReimburseLevelSetting staffReimburseLS = StaffReimburseLevelSettingFactory.getLocalInstance((Context)this.getContext());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person", (Object)personId));
        staffReimburseLS.delete(filterInfo);
        if (StringUtils.isNotEmpty((String)reimburseLevelId)) {
            StaffReimburseLevelSettingInfo staffReimburseLSInfo = new StaffReimburseLevelSettingInfo();
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personId));
            ReimburseLevelInfo reimburseLevelInfo = new ReimburseLevelInfo();
            reimburseLevelInfo.setId(BOSUuid.read((String)reimburseLevelId));
            staffReimburseLSInfo.setPerson(personInfo);
            staffReimburseLSInfo.setReimburseLevel(reimburseLevelInfo);
            staffReimburseLSInfo.setState(ReimburseLevelStateEnum.getEnum((int)state));
            staffReimburseLS.addnew(staffReimburseLSInfo);
        }
    }

    @Override
    public void saveStaffReimburseLevels(List<String> personIdList, String reimburseLevelId) throws EASBizException, BOSException {
        if (personIdList == null || personIdList.size() == 0) {
            return;
        }
        HashSet<String> personIdSet = new HashSet<String>(personIdList);
        IStaffReimburseLevelSetting staffReimburseLS = StaffReimburseLevelSettingFactory.getLocalInstance((Context)this.getContext());
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("person.id", personIdSet, CompareType.INCLUDE));
        staffReimburseLS.delete(filterInfo);
        if (StringUtils.isBlank((String)reimburseLevelId)) {
            return;
        }
        CoreBaseCollection staffReimburseCollection = new CoreBaseCollection();
        for (String personId : personIdList) {
            StaffReimburseLevelSettingInfo staffReimburseLSInfo = new StaffReimburseLevelSettingInfo();
            PersonInfo personInfo = new PersonInfo();
            personInfo.setId(BOSUuid.read((String)personId));
            ReimburseLevelInfo reimburseLevelInfo = new ReimburseLevelInfo();
            reimburseLevelInfo.setId(BOSUuid.read((String)reimburseLevelId));
            staffReimburseLSInfo.setPerson(personInfo);
            staffReimburseLSInfo.setReimburseLevel(reimburseLevelInfo);
            CtrlUnitInfo cu = ContextUtil.getCurrentCtrlUnit((Context)this.getContext());
            staffReimburseLSInfo.setCU(cu);
            staffReimburseLSInfo.setAdminCU(cu);
            staffReimburseCollection.add((CoreBaseInfo)staffReimburseLSInfo);
        }
        staffReimburseLS.addnewBatchData(staffReimburseCollection);
    }

    @Override
    public void auditStaffReimburseLevel(List<String> personIds, boolean isAudit) throws EASBizException, BOSException {
        StringBuffer idListStr = new StringBuffer();
        for (String personId : personIds) {
            idListStr.append("'").append(personId).append("',");
        }
        String idsStr = idListStr.toString().replaceAll(",$", "");
        String sql = "UPDATE T_BC_STAFFREIMBURSELEVELSET SET FSTATE = %s WHERE FPERSONID IN (%s)";
        sql = String.format(sql, isAudit ? 20 : 10, idsStr);
        DbUtil.execute((Context)this.getContext(), (String)sql);
    }

    @Override
    public List<Map<String, Object>> getGroupFilter() throws EASBizException, BOSException {
        ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>();
        CoreBaseCollection reimburseLevels = ReimburseLevelFactory.getLocalInstance((Context)this.getContext()).getCollection();
        HashMap<String, Object> reimburseLevelGroup = new HashMap<String, Object>();
        reimburseLevelGroup.put("field", "reimburseLevel");
        reimburseLevelGroup.put("dataType", "ObjectValue");
        reimburseLevelGroup.put("title", "\u62a5\u9500\u7ea7\u522b");
        reimburseLevelGroup.put("miltiSelect", false);
        reimburseLevelGroup.put("displayCount", 8);
        reimburseLevelGroup.put("unlimited", true);
        ArrayList filterItems = new ArrayList();
        reimburseLevelGroup.put("filterItems", filterItems);
        HashMap<String, Object> noReimburseLevelMap = new HashMap<String, Object>();
        noReimburseLevelMap.put("alias", "\u4e3a\u7a7a\uff08\u672a\u586b\u5199\uff09");
        noReimburseLevelMap.put("value", "");
        noReimburseLevelMap.put("isDefault", false);
        filterItems.add(noReimburseLevelMap);
        int is = reimburseLevels.size();
        for (int i = 0; i < is; ++i) {
            ReimburseLevelInfo reimburseLevelInfo = (ReimburseLevelInfo)reimburseLevels.get(i);
            HashMap<String, Object> filterMap = new HashMap<String, Object>();
            filterMap.put("alias", reimburseLevelInfo.getName());
            filterMap.put("value", reimburseLevelInfo.getId().toString());
            filterMap.put("isDefault", false);
            filterItems.add(filterMap);
        }
        resultList.add(reimburseLevelGroup);
        return resultList;
    }

    @Override
    public Map<String, Object> getAdminOrgUnitFilter(String companyOrgUnit) throws EASBizException, BOSException, SQLException {
        HashMap<String, Object> adminOrgUnitGroup = new HashMap<String, Object>();
        adminOrgUnitGroup.put("field", "adminOrgUnit.id");
        adminOrgUnitGroup.put("dataType", "ObjectValue");
        adminOrgUnitGroup.put("title", "\u90e8\u95e8");
        adminOrgUnitGroup.put("miltiSelect", false);
        adminOrgUnitGroup.put("displayCount", 8);
        adminOrgUnitGroup.put("unlimited", true);
        ArrayList filterItems = new ArrayList();
        StringBuffer querySql = new StringBuffer();
        querySql.append("SELECT DISTINCT ADMINORGUNIT.FID AS ADMINORGUNITID, ADMINORGUNIT.FNAME_L2 AS ADMINORGUNITNAME ").append("FROM T_BD_PERSON AS PERSON ").append("INNER JOIN T_ORG_POSITIONMEMBER AS POSITIONMEMBER ON PERSON.FID = POSITIONMEMBER.FPERSONID ").append("INNER JOIN T_ORG_POSITION AS POSITION ON POSITIONMEMBER.FPOSITIONID = POSITION.FID ").append("INNER JOIN T_ORG_ADMIN AS ADMINORGUNIT ON POSITION.FADMINORGUNITID = ADMINORGUNIT.FID ").append("INNER JOIN T_ORG_UNITRELATION AS ORGUNITRELATION ON ADMINORGUNIT.FID = ORGUNITRELATION.FFROMUNITID ").append("INNER JOIN T_ORG_COMPANY AS COMPANYORGUNIT ON ORGUNITRELATION.FTOUNITID = COMPANYORGUNIT.FID ").append("WHERE POSITIONMEMBER.FISPRIMARY = 1 AND COMPANYORGUNIT.FID = '").append(companyOrgUnit).append("'");
        IRowSet result = DbUtil.executeQuery((Context)this.getContext(), (String)querySql.toString());
        while (result.next()) {
            String adminOrgUnitId = result.getString("ADMINORGUNITID");
            String adminOrgUnitName = result.getString("ADMINORGUNITNAME");
            HashMap<String, String> filterMap = new HashMap<String, String>();
            filterMap.put("alias", adminOrgUnitName);
            filterMap.put("value", adminOrgUnitId);
            filterItems.add(filterMap);
        }
        adminOrgUnitGroup.put("filterItems", filterItems);
        return adminOrgUnitGroup;
    }
}

