/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.fi.ap.IWorkShopStatistic;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.ap.IWorkShopStatistic"})
public class APStatisticService
extends BusinessServices
implements IWorkShopStatistic {
    public APStatisticService(Context context) {
        super(context);
    }

    @Override
    public Map<String, Object> getStatisticData(String companyId, String startDate, String endDate) throws EASBizException, BOSException {
        Calendar startC = Calendar.getInstance();
        Calendar endC = Calendar.getInstance();
        this.parseDate(startDate, endDate, startC, endC);
        String pStartDate = APStatisticService.dateToString(startC.getTime());
        String pEndDate = APStatisticService.dateToString(endC.getTime());
        Map<java.util.Date, BigDecimal> paymentMap = this.calulatePayment(companyId, pStartDate, pEndDate);
        Map<java.util.Date, BigDecimal> payingMap = this.calulatePaying(companyId, pStartDate, pEndDate);
        Map<java.util.Date, BigDecimal> payedMap = this.calulatePayed(companyId, pStartDate, pEndDate);
        ArrayList dataset = new ArrayList();
        startC.set(14, 0);
        BigDecimal paymentSum = SysConstant.BIGZERO;
        BigDecimal payingSum = SysConstant.BIGZERO;
        BigDecimal payedSum = SysConstant.BIGZERO;
        BigDecimal payment = SysConstant.BIGZERO;
        BigDecimal paying = SysConstant.BIGZERO;
        BigDecimal payed = SysConstant.BIGZERO;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DecimalFormat df = new DecimalFormat("###,###,##0.00");
        int tM = 0;
        Date tDate = null;
        while (startC.compareTo(endC) <= 0) {
            tDate = new Date(startC.getTimeInMillis());
            LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
            payment = paymentMap.containsKey(tDate) ? paymentMap.get(tDate) : SysConstant.BIGZERO;
            paymentSum = paymentSum.add(payment);
            paying = payingMap.containsKey(tDate) ? payingMap.get(tDate) : SysConstant.BIGZERO;
            payingSum = payingSum.add(paying);
            payed = payedMap.containsKey(tDate) ? payedMap.get(tDate) : SysConstant.BIGZERO;
            payedSum = payedSum.add(payed);
            data.put("tDate", sdf.format(startC.getTime()));
            if (tM != startC.get(2)) {
                data.put("label", String.valueOf(startC.get(2) + 1) + "." + String.valueOf(startC.get(5)));
                tM = startC.get(2);
            } else {
                data.put("label", String.valueOf(startC.get(5)));
            }
            data.put("payment", payment.toPlainString());
            data.put("paying", paying.toPlainString());
            data.put("payed", payed.toPlainString());
            startC.add(5, 1);
            dataset.add(data);
        }
        LinkedHashMap<String, Object> statisticData = new LinkedHashMap<String, Object>();
        statisticData.put("satartvalue", "10000");
        statisticData.put("dataset", dataset);
        statisticData.put("waitPaySum", "0.00");
        statisticData.put("unInvoiceSum", "0.00");
        statisticData.put("paymentSum", df.format(paymentSum.doubleValue()));
        statisticData.put("payingSum", df.format(payingSum.doubleValue()));
        statisticData.put("payedSum", df.format(payedSum.doubleValue()));
        BigDecimal unPaymentSum = paymentSum.add(payingSum);
        statisticData.put("unPaymentSum", df.format(unPaymentSum.doubleValue()));
        return statisticData;
    }

    @Override
    public Map<String, Object> getStatisticDataNoDetail(String companyId, String startDate, String endDate, int bizType) throws EASBizException, BOSException {
        Calendar startC = Calendar.getInstance();
        Calendar endC = Calendar.getInstance();
        this.parseDate(startDate, endDate, startC, endC);
        String pStartDate = APStatisticService.dateToString(startC.getTime());
        String pEndDate = APStatisticService.dateToString(endC.getTime());
        BigDecimal payment_apbill = this.sumBill(this.builderSQL1("1,2,3", companyId, pStartDate, pEndDate, true));
        BigDecimal paying_reqbill = this.sumBill(this.builderSQL4("1,2,3", "+", companyId, pStartDate, pEndDate, true));
        BigDecimal paying_paybill = this.sumBill(this.builderSQL7("10,11,12", "+", companyId, pStartDate, pEndDate, true));
        BigDecimal payed_paybill = this.sumBill(this.builderSQL9("+", companyId, pStartDate, pEndDate, true));
        BigDecimal payed_otherbill = this.sumBill(this.builderSQL8(companyId, pStartDate, pEndDate, true));
        BigDecimal paymentSum = payment_apbill;
        BigDecimal payingSum = paying_reqbill.add(paying_paybill);
        BigDecimal payedSum = payed_paybill.add(payed_otherbill);
        DecimalFormat df = new DecimalFormat("###,###,##0.00");
        LinkedHashMap<String, Object> statisticData = new LinkedHashMap<String, Object>();
        statisticData.put("paymentSum", df.format(paymentSum.doubleValue()));
        statisticData.put("payment_apbill", df.format(payment_apbill.doubleValue()));
        statisticData.put("payingSum", df.format(payingSum.doubleValue()));
        statisticData.put("paying_reqbill", df.format(paying_reqbill.doubleValue()));
        statisticData.put("paying_paybill", df.format(paying_paybill.doubleValue()));
        statisticData.put("payedSum", df.format(payedSum.doubleValue()));
        statisticData.put("payed_paybill", df.format(payed_paybill.doubleValue()));
        statisticData.put("payed_otherbill", df.format(payed_otherbill.doubleValue()));
        return statisticData;
    }

    public void parseDate(String startDate, String endDate, Calendar startC, Calendar endC) throws BOSException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            startC.setTime(sdf.parse(startDate));
            startC.set(11, 0);
            startC.set(12, 0);
            startC.set(13, 0);
            startC.set(14, 1);
            endC.setTime(sdf.parse(endDate));
            endC.set(11, 0);
            endC.set(12, 0);
            endC.set(13, 0);
            endC.set(14, 1);
        }
        catch (ParseException e) {
            throw new BOSException("date parameter is error,format:yyyy-MM-dd!");
        }
    }

    public Map<java.util.Date, BigDecimal> convertMap(IRowSet rowdata) throws SQLDataException {
        HashMap<java.util.Date, BigDecimal> dataMap = new HashMap<java.util.Date, BigDecimal>();
        try {
            while (rowdata.next()) {
                dataMap.put(rowdata.getDate("FDate"), rowdata.getBigDecimal("FSumAmtL"));
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return dataMap;
    }

    public BigDecimal sumBill(String sql) throws EASBizException, BOSException {
        BigDecimal sum = SysConstant.BIGZERO;
        IRowSet rs = DbUtil.executeQueryNoTx((Context)this.getContext(), (String)sql);
        try {
            if (rs.next()) {
                sum = rs.getBigDecimal("FAmountL") != null ? rs.getBigDecimal("FAmountL") : SysConstant.BIGZERO;
            }
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        return sum;
    }

    public Map<java.util.Date, BigDecimal> calulatePayment(String companyId, String startDate, String endDate) throws EASBizException, BOSException {
        StringBuffer getDataSql = new StringBuffer();
        getDataSql.append("select FDate,sum(FAmountL) FSumAmtL from (").append(this.builderSQL1("1,2,3", companyId, startDate, endDate, false)).append(") ").append("Group by FDate ");
        return this.convertMap(DbUtil.executeQueryNoTx((Context)this.getContext(), (String)getDataSql.toString()));
    }

    public Map<java.util.Date, BigDecimal> sumPayment(String companyId, String startDate, String endDate) throws EASBizException, BOSException {
        StringBuffer getDataSql = new StringBuffer();
        getDataSql.append("select FDate,sum(FAmountL) FSumAmtL from (").append(this.builderSQL1("1,2,3", companyId, startDate, endDate, false)).append(") ").append("Group by FDate ");
        return this.convertMap(DbUtil.executeQueryNoTx((Context)this.getContext(), (String)getDataSql.toString()));
    }

    public Map<java.util.Date, BigDecimal> calulatePaying(String companyId, String startDate, String endDate) throws EASBizException, BOSException {
        StringBuffer getDataSql = new StringBuffer();
        getDataSql.append("select FDate,sum(FAmountL) FSumAmtL from (").append(this.builderSQL4("1,2,3", "+", companyId, startDate, endDate, false)).append(" union all ").append(this.builderSQL7("10,11,12", "+", companyId, startDate, endDate, false)).append(") ").append("Group by FDate ");
        return this.convertMap(DbUtil.executeQueryNoTx((Context)this.getContext(), (String)getDataSql.toString()));
    }

    public Map<java.util.Date, BigDecimal> calulatePayed(String companyId, String startDate, String endDate) throws EASBizException, BOSException {
        StringBuffer getDataSql = new StringBuffer();
        getDataSql.append("select FDate,sum(FAmountL) FSumAmtL from (").append(this.builderSQL8(companyId, startDate, endDate, false)).append(" union all ").append(this.builderSQL9("+", companyId, startDate, endDate, false)).append(") ").append("Group by FDate ");
        return this.convertMap(DbUtil.executeQueryNoTx((Context)this.getContext(), (String)getDataSql.toString()));
    }

    public String builderSQL1(String billStatus, String companyId, String startDate, String endDate, boolean isForSum) {
        StringBuffer sb = new StringBuffer();
        if (isForSum) {
            sb.append("select sum(t0.FRecievePayAmountLocal - t0.FlockAmountLoc) as FAmountL ");
        } else {
            sb.append("select t1.FID,to_date(to_char(t0.FRecievePayDate,'yyyy-mm-dd')||' 00:00:00') as FDate,").append("(t0.FRecievePayAmountLocal - t0.FlockAmountLoc) as FAmountL ");
        }
        sb.append("from T_AP_OtherBillPlan t0 ").append("inner join t_ap_otherbill t1 on t0.FParentID = t1.fid ").append("where t0.FRecievePayDate >= to_date('").append(startDate).append("') ").append("and t0.FRecievePayDate < to_date('").append(endDate).append("') ").append("and t1.FCompanyID = '").append(companyId).append("' ").append("and t1.FBillStatus in (").append(billStatus).append(")").append("and t1.FIsTransBill = 0");
        return sb.toString();
    }

    public String builderSQL4(String billStatus, String sign, String companyId, String startDate, String endDate, boolean isForSum) {
        StringBuffer sb = new StringBuffer();
        if (isForSum) {
            sb.append("select sum(0" + sign + "(t0.FAuditAmountLoc - t0.FLockAmountLoc)) as FAmountL ");
        } else {
            sb.append("select t1.FID,to_date(to_char(t0.FPayableDate,'yyyy-mm-dd')||' 00:00:00') as FDate,").append("(0" + sign + "(t0.FAuditAmountLoc - t0.FLockAmountLoc)) as FAmountL ");
        }
        sb.append("from T_AP_PayRequestBill t1 ").append("inner join T_AP_PayRequestBillEntry t0 on t0.FParentID = t1.fid ").append("where t0.FPayableDate >= to_date('").append(startDate).append("') ").append("and t0.FPayableDate < to_date('").append(endDate).append("') ").append("and t1.FCompanyID = '").append(companyId).append("' ").append("and t1.FBillStatus in (").append(billStatus).append(")");
        return sb.toString();
    }

    public String builderSQL7(String billStatus, String sign, String companyId, String startDate, String endDate, boolean isForSum) {
        StringBuffer sb = new StringBuffer();
        if (isForSum) {
            sb.append("select sum(0" + sign + "t0.FLocalAmount) as FAmountL ");
        } else {
            sb.append("select t1.FID,to_date(to_char(t0.FPayableDate,'yyyy-mm-dd')||' 00:00:00') as FDate,").append("0" + sign + "t0.FLocalAmount as FAmountL ");
        }
        sb.append("from T_CAS_PaymentBill t1 ").append("inner join T_CAS_PaymentBillEntry t0 on t0.FPaymentBillID = t1.fid ").append("where t0.FPayableDate >= to_date('").append(startDate).append("') ").append("and t0.FPayableDate < to_date('").append(endDate).append("') ").append("and t1.FCompanyID = '").append(companyId).append("' ").append("and t1.FBillStatus in (").append(billStatus).append(")");
        return sb.toString();
    }

    public String builderSQL8(String companyId, String startDate, String endDate, boolean isForSum) {
        StringBuffer sb = new StringBuffer();
        if (isForSum) {
            sb.append("select sum(t0.FSettlementAmountLoc) as FAmountL ");
        } else {
            sb.append("select t1.FID,to_date(to_char(t0.FPayableDate,'yyyy-mm-dd')||' 00:00:00') as FDate,").append("t0.FSettlementAmountLoc as FAmountL ");
        }
        sb.append("from T_AP_SettlementList t0 ").append("inner join t_ap_otherbill t1 on t0.FBillId = t1.fid ").append("where t0.FPayableDate >= to_date('").append(startDate).append("') ").append("and t0.FPayableDate < to_date('").append(endDate).append("') ").append("and t1.FCompanyID = '").append(companyId).append("' ").append("and t1.FBillStatus = 3 and t0.FSettlementAmountLoc <> 0 ").append("and t1.FIsTransPoint = 0 and t1.FIsAllowanceBill = 0 and t1.FIsReverseBill = 0 ");
        return sb.toString();
    }

    public String builderSQL9(String sign, String companyId, String startDate, String endDate, boolean isForSum) {
        StringBuffer sb = new StringBuffer();
        if (isForSum) {
            sb.append("select sum(0" + sign + "t0.FUnVcLocAmount) as FAmountL ");
        } else {
            sb.append("select t1.FID,to_date(to_char(t0.FPayableDate,'yyyy-mm-dd')||' 00:00:00') as FDate,").append("0" + sign + "t0.FUnVcLocAmount as FAmountL ");
        }
        sb.append("from T_CAS_PaymentBill t1 ").append("inner join T_CAS_PaymentBillEntry t0 on t0.FPaymentBillID = t1.fid ").append("where t1.FSourceBillID is null ").append("and t0.FPayableDate >= to_date('").append(startDate).append("') ").append("and t0.FPayableDate < to_date('").append(endDate).append("') ").append("and t1.FCompanyID = '").append(companyId).append("' ").append("and t1.FBillStatus = 15 ").append("and t0.FUnVcLocAmount > 0 ");
        return sb.toString();
    }

    public Map<String, Object> queryOtherPayedData(Map<String, Object> params) {
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        return data;
    }

    public static String dateToString(java.util.Date inDate) {
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sf.format(inDate);
    }
}

