/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.ap.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.ctrl.reportone.r1.form.engine.x.util.StringUtil;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultCollection;
import com.kingdee.eas.basedata.master.auxacct.AsstActTypeDefaultFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.ap.IPayRequestBillService;
import com.kingdee.eas.fi.ap.PayRequestBillEntryInfo;
import com.kingdee.eas.fi.ap.PayRequestBillInfo;
import com.kingdee.eas.fi.arap.ArApBillFacadeFactory;
import com.kingdee.eas.fi.arap.ArApSysParamInfo;
import com.kingdee.eas.fi.arap.impl.F7FilterService;
import com.kingdee.eas.framework.SystemEnum;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.ap.IPayRequestBillService"})
public class PayRequestBillService
extends BusinessServices
implements IPayRequestBillService {
    public static final String STATUS_ADDNEW = "ADDNEW";
    public static final String STATUS_EDIT = "EDIT";
    public static final String STATUS_VIEW = "VIEW";
    public static final String STATUS_FINDVIEW = "FINDVIEW";

    public PayRequestBillService(Context context) {
        super(context);
    }

    @Override
    public Map<String, Object> getExchange(String excTableid, String basecurrencyid, String currencyid, String billDate) throws EASBizException, BOSException {
        IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)this.getContext());
        ObjectUuidPK excTablepk = new ObjectUuidPK(excTableid);
        ObjectUuidPK sourceCurrpk = new ObjectUuidPK(currencyid);
        ObjectUuidPK destCurrpk = new ObjectUuidPK(basecurrencyid);
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date bizDate = null;
        try {
            bizDate = sf.parse(billDate);
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        ExchangeRateInfo exgRateInfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrpk, (IObjectPK)destCurrpk, bizDate);
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("exchangeRateInfo", exgRateInfo);
        int exchangeprecision = 2;
        if (exgRateInfo != null) {
            exchangeprecision = exgRateInfo.getPrecision();
            if (exgRateInfo.getExchangeAux() != null) {
                exchangeprecision = exgRateInfo.getExchangeAux().getPrecision();
            }
        }
        CurrencyInfo currency = CurrencyFactory.getLocalInstance((Context)this.getContext()).getCurrencyInfo((IObjectPK)new ObjectUuidPK(currencyid));
        result.put("precision", currency.getPrecision());
        result.put("exchangePrecision", exchangeprecision);
        boolean isDirectExchange = true;
        if (exgRateInfo != null && exgRateInfo.getExchangeAux() != null && exgRateInfo.getExchangeAux().getConvertMode().getValue() == 1) {
            isDirectExchange = false;
        }
        result.put("isDirectExchange", isDirectExchange);
        return result;
    }

    @Override
    public Map<String, Object> getUIcache(String companyid, String status) throws EASBizException, BOSException {
        PayRequestBillInfo info = new PayRequestBillInfo();
        info.getEntrys().add(new PayRequestBillEntryInfo());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("billInfo", info);
        map.put("permissionItem", this.getPermissionItem(status));
        map.put("sysEnum", SystemEnum.ACCOUNTSPAYABLE);
        map.put("bosType", new PayRequestBillInfo().getBOSType());
        CompanyOrgUnitInfo company = null;
        if (!StringUtil.isEmpty((String)companyid)) {
            ObjectUuidPK pk = new ObjectUuidPK(companyid);
            company = CompanyOrgUnitFactory.getLocalInstance((Context)this.getContext()).getCompanyOrgUnitInfo((IObjectPK)pk);
        }
        ArApSysParamInfo result = ArApBillFacadeFactory.getLocalInstance((Context)this.getContext()).getSysParams(company, map);
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("company", result.getCompany());
        params.put("cuid", result.getCUId());
        params.put("asstActTypeColl", result.getAsstActTypeColl().toArray());
        params.put("baseCurrency", result.getBaseCurrency());
        params.put("currentAccountTableID", result.getCurrentAccountTableID());
        params.put("purchaseOrgfilter", this.getOrgFilterByCompany(companyid, 3));
        params.put("adminfilter", this.getOrgFilterByCompany(companyid, 0));
        params.put("asstActTypefilter", this.getAsstActType(companyid));
        params.put("costCenterfilter", this.getOrgFilterByCompany(companyid, 5));
        params.put("projectfilter", this.getProjectFilter(companyid));
        params.put("tracknumberfilter", this.getTracknumberFilter(companyid));
        return params;
    }

    private String getProjectFilter(String companyid) throws EASBizException, BOSException {
        F7FilterService f7Service = new F7FilterService(this.getContext());
        return f7Service.getProjectF7Filer(companyid);
    }

    private String getTracknumberFilter(String companyid) throws EASBizException, BOSException {
        F7FilterService f7Service = new F7FilterService(this.getContext());
        return f7Service.getTrackNumberF7Filer(companyid, null);
    }

    public String getOrgFilterByCompany(String companyid, int orgType) throws EASBizException, BOSException {
        OrgUnitInfo info = null;
        StringBuffer filer = new StringBuffer();
        if (!StringUtil.isEmpty((String)companyid)) {
            IOrgUnitRelation iUtilRel = OrgUnitRelationFactory.getLocalInstance((Context)this.getContext());
            OrgUnitCollection toUnit = iUtilRel.getFromUnit(companyid, 1, orgType);
            if (toUnit.size() > 0) {
                filer.append(" id = ");
            } else {
                filer.append(" id = 'null'");
            }
            int size = toUnit.size();
            for (int i = 0; i < size; ++i) {
                info = toUnit.get(i);
                if (i == 0) {
                    filer.append("'");
                } else {
                    filer.append(" or id = '");
                }
                filer.append(info.getId().toString()).append("' ");
            }
        }
        return filer.toString();
    }

    private String getAsstActType(String companyid) throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemInfo filterItem1 = new FilterItemInfo("isAccountCussent", (Object)Boolean.TRUE);
        FilterItemInfo filterItem2 = new FilterItemInfo("company.id", (Object)companyid);
        filter.getFilterItems().add(filterItem1);
        filter.getFilterItems().add(filterItem2);
        ev.getSelector().add("asstActType.id");
        ev.setFilter(filter);
        AsstActTypeDefaultCollection asstActTypeColl = AsstActTypeDefaultFactory.getLocalInstance((Context)this.getContext()).getAsstActTypeDefaultCollection(ev);
        StringBuffer filers = new StringBuffer();
        if (asstActTypeColl.size() > 0) {
            filers.append(" id = ");
        }
        int size = asstActTypeColl.size();
        for (int i = 0; i < size; ++i) {
            if (i == 0) {
                filers.append("'");
            } else {
                filers.append(" or id = '");
            }
            filers.append(asstActTypeColl.get(i).getAsstActType().getId().toString()).append("' ");
        }
        return filers.toString();
    }

    protected String getPermissionItem(String status) {
        if (STATUS_ADDNEW.equals(status)) {
            return "PRBill_Addnew";
        }
        if (STATUS_EDIT.equals(status)) {
            return "PRBill_Edit";
        }
        if (STATUS_VIEW.equals(status) || STATUS_FINDVIEW.equals(status)) {
            return "PRBill_View";
        }
        return "PRBill_Addnew";
    }
}

