/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.cdo.ICommonDataObject;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.services.IFaBaseService;
import com.kingdee.eas.fi.fa.manage.services.impl.CompanyDataImpl;
import com.kingdee.eas.fi.fa.manage.services.impl.DataProvider;
import com.kingdee.eas.fi.fa.manage.services.impl.MainOrgFilterImpl;
import com.kingdee.eas.fi.fa.manage.services.model.IModelCreate;
import com.kingdee.eas.fi.fa.manage.services.model.ModelCreateContext;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

@Component(value={"com.kingdee.eas.fi.fa.manage.services.IFaBaseService"})
public class FaBaseService
implements IFaBaseService {
    private Context context;

    public FaBaseService(Context context) {
        this.context = context;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public ICommonDataObject getCompanyOrgData(String companyOrgUnitId, String selector, String permissionItem) throws BOSException, EASBizException {
        return new CompanyDataImpl(this.context).getCompanyOrgData(companyOrgUnitId, selector, permissionItem);
    }

    public ICommonDataObject getExchangeRate(String targetCurrencyId, String currencyId, String exchangeTableId, String date) throws EASBizException, BOSException {
        ExchangeRateInfo data = new ExchangeRateInfo();
        Date exDate = null;
        try {
            exDate = new SimpleDateFormat("yyyy-MM-dd").parse(date);
        }
        catch (ParseException e) {
            throw new BOSException((Throwable)e);
        }
        ExchangeRateInfo exchangeRate = ExchangeRateFactory.getLocalInstance((Context)this.context).getExchangeRate((IObjectPK)new ObjectUuidPK(exchangeTableId), (IObjectPK)new ObjectUuidPK(currencyId), (IObjectPK)new ObjectUuidPK(targetCurrencyId), exDate);
        data.put("exchangeRate", (Object)exchangeRate);
        return CDOUtils.convertObjectInfoToCDO((Context)this.context, (IObjectValue)data);
    }

    public ICommonDataObject getMainOrgFilter(String permissionItem) throws BOSException, EASBizException {
        return new MainOrgFilterImpl(this.context).getMainOrgFilter(permissionItem);
    }

    public ICommonDataObject createModel(String bosType, String mainOrgUnitId) throws BOSException, EASBizException {
        IModelCreate creator = ModelCreateContext.getModelCreator(bosType);
        return creator.createModel(bosType, mainOrgUnitId, this.context);
    }

    public ICommonDataObject getDataInfo(String bosType, String id, String selector) throws BOSException, EASBizException {
        IObjectValue obj = new DataProvider(this.context).getDataInfo(bosType, id, selector);
        return CDOUtils.convertObjectInfoToCDO((Context)this.context, (IObjectValue)obj);
    }

    public ICommonDataObject billCopy(CommonDataObject dataObject) throws BOSException, EASBizException {
        IModelCreate creator = ModelCreateContext.getModelCreator(dataObject.getBosType());
        return creator.copyModel((ICommonDataObject)dataObject);
    }

    public ICommonDataObject getCompanyAndParamsData(String companyOrgUnitId) throws BOSException, EASBizException {
        return new CompanyDataImpl(this.context).getCompanyAndParamsData(companyOrgUnitId);
    }

    public ICommonDataObject getDataCollection(String bosType, String oql) throws BOSException, EASBizException {
        IObjectValue obj = new DataProvider(this.context).getDataCollection(bosType, oql);
        return CDOUtils.convertObjectInfoToCDO((Context)this.context, (IObjectValue)obj);
    }
}

