/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.BOSObjectFactory;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.annotation.Component;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.IBizCtrl;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.batch.BatchExecuteResult;
import com.kingdee.bos.services.core.BusinessServices;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.manage.services.IFaBatchService;
import com.kingdee.eas.framework.BillBaseInfo;
import com.kingdee.eas.framework.batchaction.ActionResult;
import com.kingdee.eas.framework.batchaction.ActionResultEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.util.BaseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(value={"com.kingdee.eas.fi.fa.manage.services.IFaBatchService"})
public class FaBatchService
extends BusinessServices
implements IFaBatchService {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.fi.fa.bsf.manage.impl.FaBatchService");

    public FaBatchService(Context context) {
        super(context);
    }

    public Class[] getParameterTypes(String methodName) {
        if ("delete".equals(methodName)) {
            return new Class[]{IObjectPK.class};
        }
        return new Class[]{IObjectPK.class, BillBaseInfo.class};
    }

    public BatchExecuteParamsEntry[] getParameters(List<String> idList, String methodName) {
        BatchExecuteParamsEntry[] paramEntries = new BatchExecuteParamsEntry[idList.size()];
        BatchExecuteParamsEntry entry = null;
        Class[] paramTypes = this.getParameterTypes(methodName);
        for (int i = 0; i < idList.size(); ++i) {
            entry = new BatchExecuteParamsEntry(paramTypes);
            entry.add(0, (Object)new ObjectUuidPK(idList.get(i)));
            paramEntries[i] = entry;
        }
        return paramEntries;
    }

    public Object getId(BatchExecuteParamsEntry paramEntry) {
        return paramEntry.get(0);
    }

    @Override
    public Map<String, Object> batchOperation(String bosType, String methodName, String[] billIDs) throws BOSException, EASBizException {
        BatchExecuteResult exeResult;
        IBizCtrl bizCtrl = (IBizCtrl)BOSObjectFactory.createBOSObject((Context)this.getContext(), (BOSObjectType)BOSObjectType.create((String)bosType));
        HashMap<String, Object> result = new HashMap<String, Object>();
        ArrayList<String> idList = new ArrayList<String>(billIDs.length);
        for (int i = 0; i < billIDs.length; ++i) {
            idList.add(billIDs[i]);
        }
        BatchExecuteParamsEntry[] params = this.getParameters(idList, methodName);
        try {
            exeResult = bizCtrl.batchExecute(methodName, this.getParameterTypes(methodName), params);
        }
        catch (BaseException e) {
            logger.error((Object)e);
            if (e instanceof BOSException) {
                throw (BOSException)e;
            }
            if (e instanceof EASBizException) {
                throw (EASBizException)e;
            }
            throw new BOSException(e.getMessage());
        }
        if (exeResult.getBatchResult() == null) {
            Throwable[] exps = exeResult.getExceptions();
            int errorCount = result.size();
            for (int i = 0; i < exps.length; ++i) {
                if (exps[i] == null) continue;
                ++errorCount;
                result.put(this.getId(params[i]).toString(), exps[i].getMessage());
            }
            result.put("ERROR_COUNT", String.valueOf(errorCount));
        } else {
            int errorCount = result.size();
            BatchActionResults actionResults = (BatchActionResults)exeResult.getBatchResult();
            for (int i = 0; i < params.length; ++i) {
                Object id = this.getId(params[i]);
                ActionResult actionResult = actionResults.getActionResult(id);
                if (actionResult.getResult().equals((Object)ActionResultEnum.SUCCESS)) continue;
                result.put(id.toString(), actionResult.getMessage());
                ++errorCount;
            }
            result.put("ERROR_COUNT", String.valueOf(errorCount));
        }
        return result;
    }
}

