/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.fi.fa.manage.services.impl;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.cdo.CommonDataObject;
import com.kingdee.bos.cdo.ICommonDataObject;
import com.kingdee.bos.cdo.utils.CDOUtils;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.util.backport.Arrays;
import com.kingdee.eas.base.commonquery.CustomerParams;
import com.kingdee.eas.base.commonquery.XMLBean;
import com.kingdee.eas.base.commonquery.app.XmlTrans;
import com.kingdee.eas.basedata.master.account.AccountViewCollection;
import com.kingdee.eas.basedata.master.account.AccountViewFactory;
import com.kingdee.eas.basedata.master.account.AccountViewInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.fi.fa.basedata.FaCatCollection;
import com.kingdee.eas.fi.fa.basedata.FaCatFactory;
import com.kingdee.eas.fi.fa.basedata.FaCatInfo;
import com.kingdee.eas.fi.fa.manage.FaContrastCaclFactory;
import com.kingdee.eas.fi.fa.manage.FaContrastSolutionCollection;
import com.kingdee.eas.fi.fa.manage.FaContrastSolutionFactory;
import com.kingdee.eas.fi.fa.manage.FaContrastSolutionInfo;
import com.kingdee.eas.fi.fa.manage.IFaContrastCacl;
import com.kingdee.eas.fi.fa.manage.IFaContrastSolution;
import com.kingdee.eas.fi.fa.manage.app.FaLocalUtils;
import com.kingdee.eas.fi.fa.manage.services.impl.facontrast.FaContrastCollection;
import com.kingdee.eas.fi.fa.manage.services.impl.facontrast.FaContrastEntry;
import com.kingdee.eas.fi.fa.manage.services.impl.facontrast.FaContrastSolutionEntry;
import com.kingdee.eas.fi.fa.manage.services.util.FaServerUtil;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FaContrastCalculator {
    private static final String FA_CONTRAST_RESOUSE = "com.kingdee.eas.fi.fa.manage.FaContrastResource";
    private Context context = null;
    private int periodYear = 0;
    private int periodNumber = 0;
    private String isIncludeUnposted = null;
    private String isUseEvaValue = null;

    public FaContrastCalculator(Context context) {
        this.context = context;
    }

    public Map<String, Object> calculate(String solutionId, int periodYear, int periodNumber) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        FaContrastSolutionInfo solution = this.getContrastSolution(solutionId);
        String companyId = solution.getOrgID();
        Map<String, Object> parameter = this.getParamFromSolution(solution);
        CompanyOrgUnitInfo companyInfo = this.getCompanyOrgUnitInfo(companyId);
        boolean isIncludeUnposted = this.getBooleanFromSolution(parameter, "isIncludeUnposted");
        boolean isUseEvaValue = this.getBooleanFromSolution(parameter, "isUseEvaValue");
        boolean isUseCatNumber = this.getBooleanFromSolution(parameter, "isUseCatNumber");
        boolean isUseCardAcct = this.getBooleanFromSolution(parameter, "isUseCardAcct");
        HashMap accountMap = this.getAccountMap(solution);
        HashMap catMap = this.getCatMap(solution);
        IFaContrastCacl faContrast = FaContrastCaclFactory.getLocalInstance((Context)this.context);
        HashMap contrastMap = null;
        contrastMap = isUseCardAcct ? faContrast.faAcctDetail(companyId, accountMap, isIncludeUnposted, periodYear, periodNumber, isUseEvaValue) : faContrast.faAcct(companyId, accountMap, catMap, isIncludeUnposted, periodYear, periodNumber, isUseEvaValue, isUseCatNumber);
        this.periodYear = periodYear;
        this.periodNumber = periodNumber;
        this.isIncludeUnposted = String.valueOf(isIncludeUnposted);
        this.isUseEvaValue = String.valueOf(isUseEvaValue);
        if (isUseCatNumber) {
            this.setResultWithCat(result, contrastMap, companyInfo);
        } else if (isUseCardAcct) {
            this.setResultWithCardAcct(result, contrastMap, companyInfo);
        } else {
            this.setResult(result, contrastMap, companyInfo);
        }
        return result;
    }

    public Map<String, Object> contrast(String companyId, int periodYear, int periodNumber) throws EASBizException, BOSException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap parameter = this.getDefaultContrastSolution(this.getContrastSolutions(companyId));
        CompanyOrgUnitInfo companyInfo = this.getCompanyOrgUnitInfo(companyId);
        boolean isIncludeUnposted = this.getBooleanFromSolution(parameter, "isIncludeUnposted");
        boolean isUseEvaValue = this.getBooleanFromSolution(parameter, "isUseEvaValue");
        boolean isUseCatNumber = this.getBooleanFromSolution(parameter, "isUseCatNumber");
        boolean isUseCardAcct = this.getBooleanFromSolution(parameter, "isUseCardAcct");
        HashMap accountMap = parameter.get("AccountMap") != null ? (HashMap)parameter.get("AccountMap") : new HashMap();
        HashMap catMap = parameter.get("CatMap") != null ? (HashMap)parameter.get("CatMap") : new HashMap();
        IFaContrastCacl faContrast = FaContrastCaclFactory.getLocalInstance((Context)this.context);
        HashMap contrastMap = null;
        contrastMap = isUseCardAcct ? faContrast.faAcctDetail(companyId, accountMap, isIncludeUnposted, periodYear, periodNumber, isUseEvaValue) : faContrast.faAcct(companyId, accountMap, catMap, isIncludeUnposted, periodYear, periodNumber, isUseEvaValue, isUseCatNumber);
        this.periodYear = periodYear;
        this.periodNumber = periodNumber;
        this.isIncludeUnposted = String.valueOf(isIncludeUnposted);
        this.isUseEvaValue = String.valueOf(isUseEvaValue);
        if (isUseCatNumber) {
            this.setResultWithCat(result, contrastMap, companyInfo);
        } else if (isUseCardAcct) {
            this.setResultWithCardAcct(result, contrastMap, companyInfo);
        } else {
            this.setResult(result, contrastMap, companyInfo);
        }
        return result;
    }

    public HashMap getDefaultContrastSolution(FaContrastSolutionCollection collection) throws BOSException {
        if (collection == null) {
            return null;
        }
        for (int i = 0; i < collection.size(); ++i) {
            FaContrastSolutionInfo solutionInfo = collection.get(i);
            String params = solutionInfo.getParams();
            if (params == null) continue;
            try {
                boolean isDefaultSolution;
                HashMap loadInfo = XmlTrans.TransStrToCustParams((String)params);
                boolean bl = isDefaultSolution = loadInfo == null ? false : Boolean.valueOf((String)loadInfo.get("IsDefaultSolution"));
                if (!isDefaultSolution) continue;
                return loadInfo;
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
        }
        return null;
    }

    public FaContrastSolutionCollection getContrastSolutions(String companyID) throws BOSException, EASBizException {
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)companyID));
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        entityViewInfo.setFilter(filterInfo);
        IFaContrastSolution isolution = FaContrastSolutionFactory.getLocalInstance((Context)this.context);
        return isolution.getFaContrastSolutionCollection(entityViewInfo);
    }

    public FaContrastSolutionInfo getSolution(String solutionId) throws EASBizException, BOSException {
        FaContrastSolutionInfo solution = FaContrastSolutionFactory.getLocalInstance((Context)this.context).getFaContrastSolutionInfo((IObjectPK)new ObjectUuidPK(solutionId));
        HashMap<String, Serializable> info = new HashMap<String, Serializable>();
        Map<String, Object> parameter = this.getParamFromSolution(solution);
        HashMap accountMap = this.getAccountMap(solution);
        HashMap catMap = this.getCatMap(solution);
        String[] accountKeys = new String[]{"ASSET", "DEPRE", "DECVALUE"};
        HashMap<String, Object> accountFaCat = new HashMap<String, Object>();
        this.getAccountFaCatCol(accountFaCat, accountKeys, accountMap, catMap);
        AccountViewCollection accountCol = (AccountViewCollection)accountFaCat.get("accountCol");
        FaCatCollection catCol = (FaCatCollection)accountFaCat.get("catCol");
        ArrayList<FaContrastSolutionEntry> assetentry = new ArrayList<FaContrastSolutionEntry>();
        ArrayList<FaContrastSolutionEntry> depreentry = new ArrayList<FaContrastSolutionEntry>();
        ArrayList<FaContrastSolutionEntry> decvalueentry = new ArrayList<FaContrastSolutionEntry>();
        for (int i = 0; i < accountKeys.length; ++i) {
            String accountKey = accountKeys[i];
            Set keySet = ((Map)accountMap.get(accountKey)).keySet();
            List keyList = Arrays.asList((Object[])keySet.toArray());
            Collections.sort(keyList);
            ArrayList accountIdList = new ArrayList();
            for (int j = 0; j < keyList.size(); ++j) {
                accountIdList.add(((Map)accountMap.get(accountKey)).get(keyList.get(j)));
            }
            for (String accountId : accountIdList) {
                AccountViewInfo accountInfo = (AccountViewInfo)FaServerUtil.getInfoById((IObjectCollection)accountCol, accountId);
                ArrayList<FaCatInfo> assetCats = new ArrayList<FaCatInfo>();
                FaContrastSolutionEntry entry = new FaContrastSolutionEntry();
                entry.setAccount(accountInfo);
                Map catIdMap = (Map)catMap.get(accountKey + "_" + accountId);
                if (catIdMap != null) {
                    Iterator catIds = catIdMap.values().iterator();
                    while (catIds.hasNext()) {
                        FaCatInfo catInfo = (FaCatInfo)FaServerUtil.getInfoById((IObjectCollection)catCol, (String)catIds.next());
                        assetCats.add(catInfo);
                    }
                    entry.setAssetCats(assetCats);
                }
                if ("ASSET".equals(accountKey)) {
                    assetentry.add(entry);
                    continue;
                }
                if ("DEPRE".equals(accountKey)) {
                    depreentry.add(entry);
                    continue;
                }
                decvalueentry.add(entry);
            }
        }
        info.put("assetentry", assetentry);
        info.put("depreentry", depreentry);
        info.put("decvalueentry", decvalueentry);
        info.put("isIncludeUnposted", Boolean.valueOf(this.getBooleanFromSolution(parameter, "isIncludeUnposted")));
        info.put("isUseEvaValue", Boolean.valueOf(this.getBooleanFromSolution(parameter, "isUseEvaValue")));
        info.put("isUseCatNumber", Boolean.valueOf(this.getBooleanFromSolution(parameter, "isUseCatNumber")));
        info.put("isUseCardAcct", Boolean.valueOf(this.getBooleanFromSolution(parameter, "isUseCardAcct")));
        info.put("IsDefaultSolution", Boolean.valueOf(this.getBooleanFromSolution(parameter, "IsDefaultSolution")));
        solution.put("queryParams", info);
        solution.setParams(null);
        return solution;
    }

    public FaContrastSolutionInfo saveSolution(CommonDataObject solutionObj) throws EASBizException, BOSException {
        String solutionId;
        FaContrastSolutionInfo solution = (FaContrastSolutionInfo)CDOUtils.convertCDOToObjectInfo((Context)this.context, (ICommonDataObject)solutionObj);
        String string = solutionId = solution.getId() != null ? solution.getId().toString() : null;
        if (solution.getOwnerID() == null) {
            solution.setOwnerID(this.context.getCaller().toString());
        }
        IFaContrastSolution bizInterface = FaContrastSolutionFactory.getLocalInstance((Context)this.context);
        Map queryParams = (Map)solution.get("queryparams");
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("orgID", (Object)solution.getOrgID()));
        filterInfo.getFilterItems().add(new FilterItemInfo("name", (Object)solution.getName()));
        boolean isExists = bizInterface.exists(filterInfo);
        if (!isExists) {
            solution.setId(null);
        } else {
            FaContrastSolutionInfo existsInfo = bizInterface.getFaContrastSolutionInfo("select id where orgID = '" + solution.getOrgID() + "' and name = '" + solution.getName() + "'");
            solution.setId(existsInfo.getId());
        }
        boolean isDefault = (Boolean)queryParams.get("IsDefaultSolution");
        if (isDefault) {
            String oql = "select params where orgID='" + solution.getOrgID() + "' ";
            FaContrastSolutionCollection solutions = bizInterface.getFaContrastSolutionCollection(oql);
            for (int i = 0; i < solutions.size(); ++i) {
                FaContrastSolutionInfo existedInfo = solutions.get(i);
                Map<String, Object> parameter = this.getParamFromSolution(existedInfo);
                boolean isExistsDefault = this.getBooleanFromSolution(parameter, "IsDefaultSolution");
                if (!isExistsDefault || existedInfo.getId().equals((Object)solution.getId())) continue;
                throw new BOSException("\u5df2\u5b58\u5728\u9ed8\u8ba4\u65b9\u6848\uff01");
            }
        }
        List assetEntry = (List)queryParams.get("assetentry");
        List depreEntry = (List)queryParams.get("depreentry");
        List decvalueEntry = (List)queryParams.get("decvalueentry");
        CustomerParams assetAccount = new CustomerParams();
        CustomerParams depreAccount = new CustomerParams();
        CustomerParams decValueAccount = new CustomerParams();
        CustomerParams accountMap = new CustomerParams();
        CustomerParams catMap = new CustomerParams();
        this.setAccountCat(assetEntry, assetAccount, accountMap, catMap, "ASSET", queryParams);
        this.setAccountCat(depreEntry, depreAccount, accountMap, catMap, "DEPRE", queryParams);
        this.setAccountCat(decvalueEntry, decValueAccount, accountMap, catMap, "DECVALUE", queryParams);
        String params = this.createXMLParams(queryParams, accountMap, catMap);
        solution.setParams(params);
        if (isExists) {
            bizInterface.update((IObjectPK)new ObjectUuidPK(solution.getId()), solution);
        } else {
            IObjectPK id = bizInterface.addnew(solution);
            solutionId = id.toString();
        }
        return bizInterface.getFaContrastSolutionInfo("select name where id ='" + solutionId + "' ");
    }

    public FaContrastSolutionCollection getSolutions(String orgUnitId) throws BOSException, EASBizException {
        String oql = "select orgID,ownerID,name where orgID='" + orgUnitId + "' order by name";
        return FaContrastSolutionFactory.getLocalInstance((Context)this.context).getFaContrastSolutionCollection(oql);
    }

    public void deleteSolution(String solutionId) throws EASBizException, BOSException {
        FaContrastSolutionFactory.getLocalInstance((Context)this.context).delete((IObjectPK)new ObjectUuidPK(solutionId));
    }

    private String createXMLParams(Map<String, Object> queryParams, CustomerParams accountMap, CustomerParams catMap) throws BOSException {
        CustomerParams custParams = new CustomerParams();
        custParams.putMe("AccountMap", accountMap);
        custParams.putMe("CatMap", catMap);
        custParams.putBoolean("isIncludeUnposted", ((Boolean)queryParams.get("isIncludeUnposted")).booleanValue());
        custParams.putBoolean("IsDefaultSolution", ((Boolean)queryParams.get("IsDefaultSolution")).booleanValue());
        custParams.putBoolean("isUseEvaValue", ((Boolean)queryParams.get("isUseEvaValue")).booleanValue());
        custParams.putBoolean("isUseCatNumber", ((Boolean)queryParams.get("isUseCatNumber")).booleanValue());
        custParams.putBoolean("isUseCardAcct", ((Boolean)queryParams.get("isUseCardAcct")).booleanValue());
        String params = null;
        if (custParams != null) {
            Collection keys = custParams.getKeys();
            Collection values = custParams.getValues();
            if (keys.size() > 0) {
                try {
                    params = XMLBean.CreateXMLStrRecursion((Collection)keys, (Collection)values);
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
        return params;
    }

    private void setAccountCat(List<Map<String, Object>> assetCatEntry, CustomerParams assetAccount, CustomerParams accountMap, CustomerParams catMap, String preFix, Map<String, Object> queryParams) {
        boolean isUserCatNumber = (Boolean)queryParams.get("isUseCatNumber");
        for (int i = 0; i < assetCatEntry.size(); ++i) {
            Map<String, Object> entry = assetCatEntry.get(i);
            String accountId = "";
            if (entry.get("account") == null || entry.get("account") instanceof String) continue;
            Map accountInfo = (Map)entry.get("account");
            accountId = (String)accountInfo.get("id");
            assetAccount.addCustomerParam("account" + i, accountId);
            if (!isUserCatNumber) continue;
            CustomerParams assetCat = new CustomerParams();
            if (entry.get("assetCats") != null && !(entry.get("assetCats") instanceof String)) {
                List assetCatsEntry = (List)entry.get("assetCats");
                for (int j = 0; j < assetCatsEntry.size(); ++j) {
                    Map catInfo = (Map)assetCatsEntry.get(j);
                    assetCat.addCustomerParam("cat" + j, (String)catInfo.get("id"));
                }
            }
            if (assetCat.getValues().size() <= 0) continue;
            catMap.putMe(preFix + "_" + accountId, assetCat);
        }
        accountMap.putMe(preFix, assetAccount);
    }

    private CompanyOrgUnitInfo getCompanyOrgUnitInfo(String companyId) throws EASBizException, BOSException {
        String oql = "select baseCurrency.number,baseCurrency.name where id='" + companyId + "' ";
        return (CompanyOrgUnitInfo)CompanyOrgUnitFactory.getLocalInstance((Context)this.context).getValue(oql);
    }

    private FaContrastSolutionInfo getContrastSolution(String solutionId) throws EASBizException, BOSException {
        String oql = "select orgID,name,params where id='" + solutionId + "' ";
        return (FaContrastSolutionInfo)FaContrastSolutionFactory.getLocalInstance((Context)this.context).getValue(oql);
    }

    private Map<String, Object> getParamFromSolution(FaContrastSolutionInfo solution) throws BOSException {
        HashMap parameter = new HashMap();
        String params = solution.getParams();
        if (params == null || params.length() == 0) {
            return parameter;
        }
        try {
            parameter = XmlTrans.TransStrToCustParams((String)params);
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return parameter;
    }

    private boolean getBooleanFromSolution(Map<String, Object> parameter, String key) {
        return parameter.get(key) != null ? Boolean.valueOf((String)parameter.get(key)) : false;
    }

    private HashMap getAccountMap(FaContrastSolutionInfo solution) throws BOSException {
        HashMap cp;
        HashMap accounts = new HashMap();
        String params = solution.getParams();
        if (params == null || params.length() == 0) {
            return accounts;
        }
        try {
            cp = XmlTrans.TransStrToCustParams((String)solution.getParams());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        HashMap accountMap = (HashMap)cp.get("AccountMap");
        if (accountMap != null && accountMap.size() > 0) {
            return accountMap;
        }
        return accounts;
    }

    private HashMap getCatMap(FaContrastSolutionInfo solution) throws BOSException {
        HashMap cp;
        HashMap catMap = new HashMap();
        String params = solution.getParams();
        if (params == null || params.length() == 0) {
            return catMap;
        }
        try {
            cp = XmlTrans.TransStrToCustParams((String)solution.getParams());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        HashMap assetCats = (HashMap)cp.get("CatMap");
        if (assetCats != null && assetCats.size() > 0) {
            return assetCats;
        }
        return catMap;
    }

    private void setResult(Map<String, Object> result, Map<String, Object> contrastMap, CompanyOrgUnitInfo companyInfo) {
        String currencyName = companyInfo.getBaseCurrency() != null ? companyInfo.getBaseCurrency().getName() : null;
        String[] detaiItemKeys = new String[]{"sumBegin_ASSET", "sumDebit_ASSET", "sumCredit_ASSET", "sumEnd_ASSET", "sumBegin_DEPRE", "sumDebit_DEPRE", "sumCredit_DEPRE", "sumEnd_DEPRE", "sumBegin_DECVALUE", "sumDebit_DECVALUE", "sumCredit_DECVALUE", "sumEnd_DECVALUE"};
        FaContrastCollection col = new FaContrastCollection();
        for (int i = 0; i < detaiItemKeys.length; ++i) {
            FaContrastEntry entry = new FaContrastEntry();
            BigDecimal assetSum = (BigDecimal)contrastMap.get(detaiItemKeys[i] + "_ASSET");
            BigDecimal glSum = (BigDecimal)contrastMap.get(detaiItemKeys[i] + "_GL");
            entry.setAssetSum(assetSum);
            entry.setGlSum(glSum);
            entry.calcDifferent();
            String itemKeyRes = null;
            String accountType = null;
            String aspectDC = this.getAspectDC(detaiItemKeys[i]);
            if (detaiItemKeys[i].endsWith("_ASSET")) {
                itemKeyRes = "FixedAssets_OriginalValue";
                accountType = "ASSET";
            } else if (detaiItemKeys[i].endsWith("_DEPRE")) {
                itemKeyRes = "Accu_Depreciation";
                accountType = "DEPRE";
            } else {
                itemKeyRes = "DecValue";
                accountType = "DECVALUE";
            }
            String detailItemNameRes = detaiItemKeys[i].substring(0, detaiItemKeys[i].indexOf("_"));
            entry.setCurrency(currencyName);
            entry.setItem(FaLocalUtils.getResource((Context)this.context, (String)FA_CONTRAST_RESOUSE, (String)itemKeyRes));
            entry.setDetailItemName(FaLocalUtils.getResource((Context)this.context, (String)FA_CONTRAST_RESOUSE, (String)detailItemNameRes));
            entry.setAccountNumber("Nothing");
            entry.setAccountType(accountType);
            entry.setAspectDC(aspectDC);
            entry.setFaCatNumber("noCat");
            entry.setCompanyId(companyInfo.getId().toString());
            entry.setPeriodYear(this.periodYear);
            entry.setPeriodNumber(this.periodNumber);
            entry.setIsUseCatNumber("false");
            entry.setIsUseCardAcct("false");
            entry.setFid(BOSUuid.create((String)"00000000").toString());
            entry.setIsIncludeUnposted(this.isIncludeUnposted);
            entry.setIsUseEvaValue(this.isUseEvaValue);
            col.add(entry);
        }
        result.put("rows", col.getList());
    }

    private String getAspectDC(String detaiItemKey) {
        if (detaiItemKey.indexOf("Begin") > 0) {
            return "sumBegin";
        }
        if (detaiItemKey.indexOf("Credit") > 0) {
            return "sumCredit";
        }
        if (detaiItemKey.indexOf("Debit") > 0) {
            return "sumDebit";
        }
        return "sumEnd";
    }

    private void setResultWithCat(Map<String, Object> result, Map<String, Object> contrastMap, CompanyOrgUnitInfo companyInfo) throws BOSException {
        String currencyName = companyInfo.getBaseCurrency() != null ? companyInfo.getBaseCurrency().getName() : null;
        Map accountMap = (Map)contrastMap.get("AccountMap");
        Map catMap = (Map)contrastMap.get("CatMap");
        String[] accountKeys = new String[]{"ASSET", "DEPRE", "DECVALUE"};
        HashMap<String, Object> accountFaCat = new HashMap<String, Object>();
        this.getAccountFaCatCol(accountFaCat, accountKeys, accountMap, catMap);
        AccountViewCollection accountCol = (AccountViewCollection)accountFaCat.get("accountCol");
        FaCatCollection catCol = (FaCatCollection)accountFaCat.get("catCol");
        String[] detailItemKeys = new String[]{"sumBegin", "sumDebit", "sumCredit", "sumEnd"};
        FaContrastCollection col = new FaContrastCollection();
        for (int i = 0; i < accountKeys.length; ++i) {
            String accountKey = accountKeys[i];
            Set keySet = ((Map)accountMap.get(accountKey)).keySet();
            List keyList = Arrays.asList((Object[])keySet.toArray());
            Collections.sort(keyList);
            ArrayList accountIdList = new ArrayList();
            for (int j = 0; j < keyList.size(); ++j) {
                accountIdList.add(((Map)accountMap.get(accountKey)).get(keyList.get(j)));
            }
            for (String accountId : accountIdList) {
                AccountViewInfo accountInfo = (AccountViewInfo)FaServerUtil.getInfoById((IObjectCollection)accountCol, accountId);
                Map catIdMap = (Map)catMap.get(accountKey + "_" + accountId);
                for (int k = 0; k < 4; ++k) {
                    FaContrastEntry entry = new FaContrastEntry();
                    StringBuffer item = new StringBuffer();
                    if (catIdMap != null) {
                        Iterator catIds = catIdMap.values().iterator();
                        while (catIds.hasNext()) {
                            FaCatInfo catInfo = (FaCatInfo)FaServerUtil.getInfoById((IObjectCollection)catCol, (String)catIds.next());
                            if (item.length() > 0) {
                                item.append(";");
                            }
                            item.append(catInfo.getNumber()).append("(").append(catInfo.getName()).append(")");
                            entry.setFaCatNumber(catInfo.getNumber());
                        }
                    }
                    item.append("\n").append(accountInfo.getNumber()).append("(").append(accountInfo.getLongName()).append(")");
                    String assetSumKey = detailItemKeys[k] + "_" + accountKey + "_ASSET_" + accountInfo.getNumber();
                    String glSumKey = detailItemKeys[k] + "_GL_" + accountInfo.getNumber() + "_" + accountKey;
                    BigDecimal assetSum = (BigDecimal)contrastMap.get(assetSumKey);
                    BigDecimal glSum = (BigDecimal)contrastMap.get(glSumKey);
                    entry.setAssetSum(assetSum);
                    entry.setGlSum(glSum);
                    entry.calcDifferent();
                    entry.setCurrency(currencyName);
                    entry.setItem(item.toString());
                    entry.setDetailItemName(FaLocalUtils.getResource((Context)this.context, (String)FA_CONTRAST_RESOUSE, (String)detailItemKeys[k]));
                    entry.setAccountNumber(accountInfo.getNumber());
                    entry.setAccountType(accountKey);
                    entry.setAspectDC(detailItemKeys[k]);
                    entry.setCompanyId(companyInfo.getId().toString());
                    entry.setPeriodYear(this.periodYear);
                    entry.setPeriodNumber(this.periodNumber);
                    entry.setIsUseCatNumber("true");
                    entry.setIsUseCardAcct("false");
                    entry.setFid(BOSUuid.create((String)"00000000").toString());
                    entry.setIsIncludeUnposted(this.isIncludeUnposted);
                    entry.setIsUseEvaValue(this.isUseEvaValue);
                    col.add(entry);
                }
            }
        }
        result.put("rows", col.getList());
    }

    private void setResultWithCardAcct(Map<String, Object> result, Map<String, Object> contrastMap, CompanyOrgUnitInfo companyInfo) {
        String[] detailItemKeys = new String[]{"sumBegin", "sumDebit", "sumCredit", "sumEnd"};
        String[] itemKeys = new String[]{"ASSET", "DECVALUE", "DEPRE"};
        String currencyName = companyInfo.getBaseCurrency() != null ? companyInfo.getBaseCurrency().getName() : null;
        List accountList = (List)contrastMap.get("AccountMap");
        FaContrastCollection col = new FaContrastCollection();
        for (int i = 0; i < accountList.size(); ++i) {
            List accounts = (List)accountList.get(i);
            for (int j = 0; j < accounts.size(); ++j) {
                AccountViewInfo accountInfo = (AccountViewInfo)accounts.get(j);
                for (int k = 0; k < 4; ++k) {
                    FaContrastEntry entry = new FaContrastEntry();
                    String assetSumKey = itemKeys[i] + "_" + detailItemKeys[k] + "_ASSET_" + accountInfo.getNumber();
                    String glSumKey = itemKeys[i] + "_" + detailItemKeys[k] + "_GL_" + accountInfo.getNumber();
                    BigDecimal assetSum = (BigDecimal)contrastMap.get(assetSumKey);
                    BigDecimal glSum = (BigDecimal)contrastMap.get(glSumKey);
                    entry.setAssetSum(assetSum);
                    entry.setGlSum(glSum);
                    entry.calcDifferent();
                    entry.setCurrency(currencyName);
                    entry.setItem(accountInfo.getNumber() + "(" + accountInfo.getLongName() + ")");
                    entry.setDetailItemName(FaLocalUtils.getResource((Context)this.context, (String)FA_CONTRAST_RESOUSE, (String)detailItemKeys[k]));
                    entry.setAccountNumber(accountInfo.getNumber());
                    String accountType = null;
                    accountType = "DECVALUE".equals(itemKeys[i]) ? "DEPRE" : ("DEPRE".equals(itemKeys[i]) ? "DECVALUE" : "ASSET");
                    entry.setAccountType(accountType);
                    entry.setAspectDC(detailItemKeys[k]);
                    entry.setFaCatNumber("noCat");
                    entry.setCompanyId(companyInfo.getId().toString());
                    entry.setPeriodYear(this.periodYear);
                    entry.setPeriodNumber(this.periodNumber);
                    entry.setIsUseCatNumber("false");
                    entry.setIsUseCardAcct("true");
                    entry.setFid(BOSUuid.create((String)"00000000").toString());
                    entry.setIsIncludeUnposted(this.isIncludeUnposted);
                    entry.setIsUseEvaValue(this.isUseEvaValue);
                    col.add(entry);
                }
            }
        }
        result.put("rows", col.getList());
    }

    private void getAccountFaCatCol(Map<String, Object> accountFaCat, String[] accountKeys, Map<String, Map<String, String>> accountMap, Map<String, Map<String, String>> catMap) throws BOSException {
        StringBuffer accountIdStr = new StringBuffer("'null'");
        StringBuffer catIdStr = new StringBuffer("'null'");
        for (int i = 0; i < accountKeys.length; ++i) {
            String accountKey = accountKeys[i];
            for (String accountId : accountMap.get(accountKey).values()) {
                accountIdStr.append(",'").append(accountId).append("' ");
                Map<String, String> catIdMap = catMap.get(accountKey + "_" + accountId);
                if (catIdMap == null) continue;
                Iterator<String> catIds = catIdMap.values().iterator();
                while (catIds.hasNext()) {
                    catIdStr.append(",'").append(catIds.next()).append("' ");
                }
            }
        }
        String accountQql = "select number,name,longname where id in (" + accountIdStr + ") ";
        AccountViewCollection accountCol = AccountViewFactory.getLocalInstance((Context)this.context).getAccountViewCollection(accountQql);
        String catOql = "select number,name where id in (" + catIdStr + ") ";
        FaCatCollection catCol = FaCatFactory.getLocalInstance((Context)this.context).getFaCatCollection(catOql);
        accountFaCat.put("accountCol", accountCol);
        accountFaCat.put("catCol", catCol);
    }
}

